/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.io.CompressedAppendableFile;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.LimitedInputStream;
import org.jetbrains.kotlin.com.intellij.util.io.MappedFileInputStream;
import org.jetbrains.kotlin.com.intellij.util.io.NoDataException;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.ResizeableMappedFile;
import org.jetbrains.kotlin.com.intellij.util.io.UnsyncByteArrayInputStream;

public class AppendableStorageBackedByResizableMappedFile
extends ResizeableMappedFile {
    private final MyDataIS myReadStream = new MyDataIS(this);
    private byte[] myAppendBuffer;
    private volatile int myFileLength = (int)this.length();
    private volatile int myBufferPosition;
    private final CompressedAppendableFile myCompressedAppendableFile = null;

    public AppendableStorageBackedByResizableMappedFile(Path file2, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        super(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned);
    }

    private void flushKeyStoreBuffer() {
        if (this.myBufferPosition > 0) {
            this.put(this.myFileLength, this.myAppendBuffer, 0, this.myBufferPosition);
            this.myFileLength += this.myBufferPosition;
            this.myBufferPosition = 0;
        }
    }

    @Override
    public void force() {
        this.flushKeyStoreBuffer();
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.force();
        }
        super.force();
    }

    @Override
    public void close() {
        this.flushKeyStoreBuffer();
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.dispose();
        }
        super.close();
    }

    public <Data> Data read(int addr, KeyDescriptor<Data> descriptor2) throws IOException {
        Object tempData = null;
        if (this.myCompressedAppendableFile != null) {
            tempData = this.myCompressedAppendableFile.read(addr, descriptor2);
            return (Data)tempData;
        }
        if (this.myFileLength <= addr) {
            if (this.myAppendBuffer == null) {
                throw new NoDataException("requested address points to un-existed data");
            }
            int bufferOffset = addr - this.myFileLength;
            if (bufferOffset > this.myBufferPosition) {
                throw new NoDataException("requested address points to un-existed data");
            }
            Object data = descriptor2.read(new DataInputStream(new UnsyncByteArrayInputStream(this.myAppendBuffer, bufferOffset, this.myBufferPosition)));
            assert (tempData == null || descriptor2.isEqual(data, tempData));
            return (Data)data;
        }
        this.myReadStream.setup(addr, this.myFileLength);
        Object data = descriptor2.read(this.myReadStream);
        assert (tempData == null || descriptor2.isEqual(data, tempData));
        return (Data)data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Data> boolean processAll(@NotNull Processor<? super Data> processor2, @NotNull KeyDescriptor<Data> descriptor2) throws IOException {
        DataInputStream keysStream2;
        if (processor2 == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(1);
        }
        assert (!this.isDirty());
        DataInputStream dataInputStream = keysStream2 = this.myCompressedAppendableFile != null ? this.myCompressedAppendableFile.getStream(0L) : null;
        if (keysStream2 != null) {
            this.getPagedFileStorage().lock();
            try {
                while (true) {
                    Object key2222;
                    if (!processor2.process(key2222 = descriptor2.read(keysStream2))) {
                        boolean bl = false;
                        return bl;
                    }
                    continue;
                    break;
                }
            }
            catch (EOFException key2222) {
                boolean key2222 = true;
                return key2222;
            }
        }
        if (this.myFileLength == 0) {
            return true;
        }
        Throwable throwable = null;
        try (DataInputStream keysStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(Files.newInputStream(this.getPagedFileStorage().getFile(), new OpenOption[0]), this.myFileLength){

            @Override
            public int available() {
                return this.remainingLimit();
            }
        }, 32768));){
            while (true) {
                Object key = descriptor2.read(keysStream);
                if (keysStream2 != null) {
                    Object tempKey = descriptor2.read(keysStream2);
                    assert (descriptor2.isEqual(key, tempKey));
                }
                if (!processor2.process(key)) {
                    boolean bl = false;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (EOFException eOFException) {
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public int getCurrentLength() {
        int currentLength = this.myCompressedAppendableFile != null ? (int)this.myCompressedAppendableFile.length() : this.myBufferPosition + this.myFileLength;
        return currentLength;
    }

    public <Data> int append(Data value2, KeyDescriptor<Data> descriptor2) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        descriptor2.save(out, value2);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        int currentLength = this.getCurrentLength();
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.append(buffer, size);
            return currentLength;
        }
        if (size > 4096) {
            this.flushKeyStoreBuffer();
            this.put(currentLength, buffer, 0, size);
            this.myFileLength += size;
        } else {
            if (size > 4096 - this.myBufferPosition) {
                this.flushKeyStoreBuffer();
            }
            if (this.myAppendBuffer == null) {
                this.myAppendBuffer = new byte[4096];
            }
            System.arraycopy(buffer, 0, this.myAppendBuffer, this.myBufferPosition, size);
            this.myBufferPosition += size;
        }
        return currentLength;
    }

    <Data> boolean checkBytesAreTheSame(int addr, Data value2, KeyDescriptor<Data> descriptor2) throws IOException {
        OutputStream comparer;
        final boolean[] sameValue = new boolean[1];
        if (this.myCompressedAppendableFile != null) {
            final DataInputStream compressedStream = this.myCompressedAppendableFile.getStream(addr);
            comparer = new OutputStream(){
                boolean same = true;

                @Override
                public void write(int b) throws IOException {
                    if (this.same) {
                        this.same = compressedStream.readByte() == (byte)b;
                    }
                }

                @Override
                public void close() {
                    sameValue[0] = this.same;
                }
            };
        } else {
            comparer = this.buildOldComparerStream(addr, sameValue);
        }
        DataOutputStream out = new DataOutputStream(comparer);
        descriptor2.save(out, value2);
        comparer.close();
        return sameValue[0];
    }

    @NotNull
    private OutputStream buildOldComparerStream(final int addr, final boolean[] sameValue) {
        final PagedFileStorage storage2 = this.getPagedFileStorage();
        OutputStream comparer = this.myFileLength <= addr ? new OutputStream(){
            int address;
            boolean same;
            {
                this.address = addr - AppendableStorageBackedByResizableMappedFile.this.myFileLength;
                this.same = true;
            }

            @Override
            public void write(int b) {
                if (this.same) {
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myBufferPosition && AppendableStorageBackedByResizableMappedFile.this.myAppendBuffer[this.address++] == (byte)b;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        } : new OutputStream(){
            int base;
            int address;
            boolean same;
            ByteBuffer buffer;
            final int myPageSize;
            {
                this.base = addr;
                this.address = storage2.getOffsetInPage(addr);
                this.same = true;
                this.buffer = storage2.getByteBuffer(addr, false).getCachedBuffer();
                this.myPageSize = storage2.myPageSize;
            }

            @Override
            public void write(int b) {
                if (this.same) {
                    if (this.myPageSize == this.address && this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength) {
                        this.base += this.address;
                        this.buffer = storage2.getByteBuffer(this.base, false).getCachedBuffer();
                        this.address = 0;
                    }
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength && this.buffer.get(this.address++) == (byte)b;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        };
        OutputStream outputStream2 = comparer;
        if (outputStream2 == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(2);
        }
        return outputStream2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/AppendableStorageBackedByResizableMappedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/AppendableStorageBackedByResizableMappedFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOldComparerStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBufferedIS
    extends BufferedInputStream {
        MyBufferedIS(InputStream in) {
            super(in, 512);
        }

        public void setup(long pos, long limit) {
            this.pos = 0;
            this.count = 0;
            ((MappedFileInputStream)this.in).setup(pos, limit);
        }
    }

    private static class MyDataIS
    extends DataInputStream {
        private MyDataIS(ResizeableMappedFile raf) {
            super(new MyBufferedIS(new MappedFileInputStream(raf, 0L, 0L)));
        }

        public void setup(long pos, long limit) {
            ((MyBufferedIS)this.in).setup(pos, limit);
        }
    }
}

