/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0016\u001a\u00020\f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;)V", "areEquivalentTopLevelCallables", "", "first", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "firstCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "second", "secondCandidate", "chooseMaximallySpecificCandidates", "", "candidates", "discriminateGenerics", "discriminateAbstracts", "createFlatSignature", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "call", "declaration", "filterOutEquivalentCalls", "", "jvm"})
public final class ConeEquivalentCallConflictResolver
extends AbstractConeCallConflictResolver {
    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates2, boolean discriminateGenerics, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates2, (String)"candidates");
        return this.filterOutEquivalentCalls((Collection<Candidate>)candidates2);
    }

    private final Set<Candidate> filterOutEquivalentCalls(Collection<Candidate> candidates2) {
        boolean bl = false;
        Set result2 = new LinkedHashSet();
        block0: for (Candidate myCandidate : candidates2) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirCallableMemberDeclaration && ((FirCallableMemberDeclaration)me).getSymbol().getCallableId().getClassName() == null) {
                for (Candidate otherCandidate : result2) {
                    Object other = otherCandidate.getSymbol().getFir();
                    if (!(other instanceof FirCallableMemberDeclaration) || ((FirCallableMemberDeclaration)other).getSymbol().getCallableId().getClassName() != null || !this.areEquivalentTopLevelCallables((FirCallableMemberDeclaration)me, myCandidate, (FirCallableMemberDeclaration)other, otherCandidate)) continue;
                    continue block0;
                }
            }
            Collection collection = result2;
            boolean bl2 = false;
            collection.add(myCandidate);
        }
        return result2;
    }

    private final boolean areEquivalentTopLevelCallables(FirCallableMemberDeclaration<?> first, Candidate firstCandidate, FirCallableMemberDeclaration<?> second, Candidate secondCandidate) {
        FlatSignature<Candidate> secondSignature;
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2;
        boolean $i$f$coneTypeUnsafe;
        FirTypeRef $this$coneTypeUnsafe$iv$iv;
        boolean $i$f$getConeType;
        FirTypeRef $this$coneType$iv;
        if (Intrinsics.areEqual((Object)first.getSymbol().getCallableId(), (Object)second.getSymbol().getCallableId()) ^ true) {
            return false;
        }
        FirMemberDeclaration $this$isExpect$iv = first;
        boolean $i$f$isExpect = false;
        boolean bl = $this$isExpect$iv.getStatus().isExpect();
        $this$isExpect$iv = second;
        $i$f$isExpect = false;
        if (bl != $this$isExpect$iv.getStatus().isExpect()) {
            return false;
        }
        FirTypeRef firTypeRef = first.getReceiverTypeRef();
        if (firTypeRef != null) {
            $this$coneType$iv = firTypeRef;
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        } else {
            coneKotlinType2 = null;
        }
        FirTypeRef firTypeRef2 = second.getReceiverTypeRef();
        if (firTypeRef2 != null) {
            $this$coneType$iv = firTypeRef2;
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        } else {
            coneKotlinType = null;
        }
        if (Intrinsics.areEqual(coneKotlinType2, coneKotlinType) ^ true) {
            return false;
        }
        FlatSignature<Candidate> firstSignature = this.createFlatSignature(firstCandidate, first);
        return this.compareCallsByUsedArguments(firstSignature, secondSignature = this.createFlatSignature(secondCandidate, second), false) && this.compareCallsByUsedArguments(secondSignature, firstSignature, false);
    }

    private final FlatSignature<Candidate> createFlatSignature(Candidate call2, FirCallableMemberDeclaration<?> declaration2) {
        FlatSignature<Candidate> flatSignature;
        FirCallableMemberDeclaration<?> firCallableMemberDeclaration = declaration2;
        if (firCallableMemberDeclaration instanceof FirSimpleFunction) {
            flatSignature = this.createFlatSignature(call2, (FirSimpleFunction)declaration2);
        } else if (firCallableMemberDeclaration instanceof FirConstructor) {
            flatSignature = this.createFlatSignature(call2, (FirConstructor)declaration2);
        } else if (firCallableMemberDeclaration instanceof FirVariable) {
            FirCallableMemberDeclaration<?> firCallableMemberDeclaration2 = declaration2;
            if (firCallableMemberDeclaration2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirVariable<*>");
            }
            flatSignature = ((AbstractConeCallConflictResolver)this).createFlatSignature(call2, (FirVariable)((Object)firCallableMemberDeclaration2));
        } else {
            String string2 = "Not supported: " + declaration2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return flatSignature;
    }

    public ConeEquivalentCallConflictResolver(@NotNull TypeSpecificityComparator specificityComparator, @NotNull InferenceComponents inferenceComponents) {
        Intrinsics.checkNotNullParameter((Object)specificityComparator, (String)"specificityComparator");
        Intrinsics.checkNotNullParameter((Object)inferenceComponents, (String)"inferenceComponents");
        super(specificityComparator, inferenceComponents);
    }
}

