/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.time.Clock;

public class TestMainAction
implements Runnable {
    private final Runnable detector;
    private final TestClassProcessor processor;
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final Object rootTestSuiteId;
    private final String displayName;

    public TestMainAction(Runnable detector, TestClassProcessor processor, TestResultProcessor resultProcessor, Clock clock, Object rootTestSuiteId, String displayName) {
        this.detector = detector;
        this.processor = processor;
        this.resultProcessor = new AttachParentTestResultProcessor(resultProcessor);
        this.clock = clock;
        this.rootTestSuiteId = rootTestSuiteId;
        this.displayName = displayName;
    }

    @Override
    public void run() {
        RootTestSuiteDescriptor suite = new RootTestSuiteDescriptor(this.rootTestSuiteId, this.displayName);
        this.resultProcessor.started(suite, new TestStartEvent(this.clock.getCurrentTime()));
        try {
            this.processor.startProcessing(this.resultProcessor);
            try {
                this.detector.run();
            }
            finally {
                this.processor.stop();
            }
        }
        finally {
            this.resultProcessor.completed(suite.getId(), new TestCompleteEvent(this.clock.getCurrentTime()));
        }
    }

    private static final class RootTestSuiteDescriptor
    extends DefaultTestSuiteDescriptor {
        private RootTestSuiteDescriptor(Object id, String name) {
            super(id, name);
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

