/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.util.Optional;
import org.gradle.internal.execution.AfterPreviousExecutionContext;
import org.gradle.internal.execution.BeforeExecutionContext;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.ExecutionState;
import org.gradle.internal.execution.history.OverlappingOutputDetector;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.impl.DefaultBeforeExecutionState;
import org.gradle.internal.execution.impl.InputUtil;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureStateBeforeExecutionStep
extends BuildOperationStep<AfterPreviousExecutionContext, CachingResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureStateBeforeExecutionStep.class);
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final OutputSnapshotter outputSnapshotter;
    private final OverlappingOutputDetector overlappingOutputDetector;
    private final ValueSnapshotter valueSnapshotter;
    private final Step<? super BeforeExecutionContext, ? extends CachingResult> delegate;

    public CaptureStateBeforeExecutionStep(BuildOperationExecutor buildOperationExecutor, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, OutputSnapshotter outputSnapshotter, OverlappingOutputDetector overlappingOutputDetector, ValueSnapshotter valueSnapshotter, Step<? super BeforeExecutionContext, ? extends CachingResult> delegate) {
        super(buildOperationExecutor);
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.outputSnapshotter = outputSnapshotter;
        this.valueSnapshotter = valueSnapshotter;
        this.overlappingOutputDetector = overlappingOutputDetector;
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(UnitOfWork work, final AfterPreviousExecutionContext context) {
        final Optional<BeforeExecutionState> beforeExecutionState = context.getHistory().map(executionHistoryStore -> this.captureExecutionStateOp(work, context));
        return this.delegate.execute(work, new BeforeExecutionContext(){

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return beforeExecutionState;
            }

            @Override
            public Optional<String> getRebuildReason() {
                return context.getRebuildReason();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return this.getBeforeExecutionState().map(ExecutionState::getInputProperties).orElseGet(context::getInputProperties);
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return this.getBeforeExecutionState().map(BeforeExecutionState::getInputFileProperties).orElseGet(context::getInputFileProperties);
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return context.getIdentity();
            }

            @Override
            public File getWorkspace() {
                return context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return context.getHistory();
            }

            @Override
            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return context.getAfterPreviousExecutionState();
            }
        });
    }

    private BeforeExecutionState captureExecutionStateOp(UnitOfWork work, AfterPreviousExecutionContext executionContext) {
        return this.operation(operationContext -> {
            BeforeExecutionState beforeExecutionState = this.captureExecutionState(work, executionContext);
            operationContext.setResult((Object)Operation.Result.INSTANCE);
            return beforeExecutionState;
        }, BuildOperationDescriptor.displayName((String)("Snapshot inputs and outputs before executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE));
    }

    private BeforeExecutionState captureExecutionState(UnitOfWork work, AfterPreviousExecutionContext context) {
        OverlappingOutputs overlappingOutputs;
        Optional<AfterPreviousExecutionState> afterPreviousExecutionState = context.getAfterPreviousExecutionState();
        ImplementationsBuilder implementationsBuilder = new ImplementationsBuilder(this.classLoaderHierarchyHasher);
        work.visitImplementations(implementationsBuilder);
        ImplementationSnapshot implementation = implementationsBuilder.getImplementation();
        ImmutableList<ImplementationSnapshot> additionalImplementations = implementationsBuilder.getAdditionalImplementations();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)work.getDisplayName(), (Object)implementation);
            LOGGER.debug("Additional implementations for {}: {}", (Object)work.getDisplayName(), additionalImplementations);
        }
        ImmutableSortedMap previousInputProperties = afterPreviousExecutionState.map(ExecutionState::getInputProperties).orElse(ImmutableSortedMap.of());
        ImmutableSortedMap outputSnapshotsAfterPreviousExecution = afterPreviousExecutionState.map(AfterPreviousExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots = this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
        switch (work.getOverlappingOutputHandling()) {
            case DETECT_OVERLAPS: {
                overlappingOutputs = this.overlappingOutputDetector.detect((ImmutableSortedMap<String, FileSystemSnapshot>)outputSnapshotsAfterPreviousExecution, unfilteredOutputSnapshots);
                break;
            }
            case IGNORE_OVERLAPS: {
                overlappingOutputs = null;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        InputUtil.Result newInputs = InputUtil.fingerprintInputProperties(work, (ImmutableSortedMap<String, ValueSnapshot>)previousInputProperties, this.valueSnapshotter, context.getInputProperties(), context.getInputFileProperties(), (propertyName, type, identity) -> identity == UnitOfWork.IdentityKind.NON_IDENTITY);
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = InputUtil.union(context.getInputProperties(), newInputs.getValueSnapshots());
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileFingerprints = InputUtil.union(context.getInputFileProperties(), newInputs.getFileFingerprints());
        return new DefaultBeforeExecutionState(implementation, additionalImplementations, inputProperties, inputFileFingerprints, unfilteredOutputSnapshots, overlappingOutputs);
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }

    private static class ImplementationsBuilder
    implements UnitOfWork.ImplementationVisitor {
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
        private ImplementationSnapshot implementation;
        private final ImmutableList.Builder<ImplementationSnapshot> additionalImplementations = ImmutableList.builder();

        public ImplementationsBuilder(ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        }

        @Override
        public void visitImplementation(Class<?> implementation) {
            this.visitImplementation(ImplementationSnapshot.of(implementation, (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher));
        }

        @Override
        public void visitImplementation(ImplementationSnapshot implementation) {
            if (this.implementation == null) {
                this.implementation = implementation;
            } else {
                this.additionalImplementations.add((Object)implementation);
            }
        }

        public ImplementationSnapshot getImplementation() {
            if (this.implementation == null) {
                throw new IllegalStateException("No implementation is set");
            }
            return this.implementation;
        }

        public ImmutableList<ImplementationSnapshot> getAdditionalImplementations() {
            return this.additionalImplementations.build();
        }
    }
}

