/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.configurationcache.problems.DocumentationSection;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.UniquePropertyProblem;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u001a&\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0012\u001a\u00020\tH\u0002\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"maxConsoleProblems", "", "buildConsoleSummary", "", "cacheAction", "problems", "", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "reportFile", "Ljava/io/File;", "buildSummaryHeader", "totalProblemCount", "uniquePropertyProblems", "", "Lorg/gradle/configurationcache/problems/UniquePropertyProblem;", "buildSummaryReportLink", "clickableUrlFor", "kotlin.jvm.PlatformType", "file", "configuration-cache"})
public final class ProblemsSummaryKt {
    private static final int maxConsoleProblems = 15;

    @NotNull
    public static final String buildConsoleSummary(@NotNull String cacheAction, @NotNull List<PropertyProblem> problems, @NotNull File reportFile) {
        Intrinsics.checkNotNullParameter((Object)cacheAction, (String)"cacheAction");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)reportFile, (String)"reportFile");
        DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        Set<UniquePropertyProblem> uniquePropertyProblems = ProblemsSummaryKt.uniquePropertyProblems(problems);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        StringBuilder stringBuilder2 = $this$apply;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        stringBuilder2 = $this$apply;
        String string2 = ProblemsSummaryKt.buildSummaryHeader(cacheAction, problems.size(), uniquePropertyProblems);
        boolean bl5 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringBuilder stringBuilder4 = stringBuilder3;
        boolean bl6 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)uniquePropertyProblems, (int)15);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder5;
            UniquePropertyProblem problem = (UniquePropertyProblem)element$iv;
            boolean bl7 = false;
            $this$apply.append("- ");
            $this$apply.append(StringsKt.capitalize((String)problem.getUserCodeLocation()));
            $this$apply.append(": ");
            StringBuilder stringBuilder6 = $this$apply;
            Object object = problem.getMessage();
            boolean bl8 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append(object), (String)"append(value)");
            boolean bl9 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            if (problem.getDocumentationSection() == null) continue;
            stringBuilder6 = $this$apply;
            object = "  See " + documentationRegistry.getDocumentationFor("configuration_cache", problem.getDocumentationSection());
            bl8 = false;
            StringBuilder stringBuilder7 = stringBuilder6.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
            stringBuilder5 = stringBuilder7;
            bl9 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        }
        if (uniquePropertyProblems.size() > 15) {
            stringBuilder2 = $this$apply;
            String string3 = "plus " + (uniquePropertyProblems.size() - 15) + " more problems. Please see the report for details.";
            boolean bl10 = false;
            StringBuilder stringBuilder8 = stringBuilder2.append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
            stringBuilder4 = stringBuilder8;
            bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        }
        stringBuilder2 = $this$apply;
        boolean bl11 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        $this$apply.append(ProblemsSummaryKt.buildSummaryReportLink(reportFile));
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply {\n\u2026rtFile))\n    }.toString()");
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<UniquePropertyProblem> uniquePropertyProblems(List<PropertyProblem> problems) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = problems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PropertyProblem propertyProblem = (PropertyProblem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DocumentationSection documentationSection = it.getDocumentationSection();
            UniquePropertyProblem uniquePropertyProblem = new UniquePropertyProblem(it.getTrace().getContainingUserCode(), it.getMessage(), documentationSection != null ? documentationSection.getAnchor() : null);
            collection.add(uniquePropertyProblem);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.toSet((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                UniquePropertyProblem it = (UniquePropertyProblem)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getUserCodeLocation());
                it = (UniquePropertyProblem)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string2 = it.getUserCodeLocation();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
            }
        }));
    }

    private static final String buildSummaryHeader(String cacheAction, int totalProblemCount, Set<UniquePropertyProblem> uniquePropertyProblems) {
        StringBuilder result = new StringBuilder();
        result.append(totalProblemCount);
        result.append(totalProblemCount == 1 ? " problem was found " : " problems were found ");
        result.append(cacheAction);
        result.append(" the configuration cache");
        int uniqueProblemCount = uniquePropertyProblems.size();
        if (totalProblemCount != uniquePropertyProblems.size()) {
            result.append(", ");
            result.append(uniqueProblemCount);
            result.append(" of which ");
            result.append(uniqueProblemCount == 1 ? "seems unique" : "seem unique");
        }
        result.append(".");
        String string2 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.toString()");
        return string2;
    }

    private static final String buildSummaryReportLink(File reportFile) {
        return "See the complete report at " + ProblemsSummaryKt.clickableUrlFor(reportFile);
    }

    private static final String clickableUrlFor(File file) {
        return new ConsoleRenderer().asClickableFileUrl(file);
    }
}

