/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.codegen.server;

import com.google.gwt.codegen.server.PlainStringGenerator;
import com.google.gwt.codegen.server.SafeHtmlStringGenerator;

public abstract class StringGenerator {
    protected final StringBuilder buf;
    protected boolean inString;

    public static StringGenerator create(StringBuilder buf, boolean returnsSafeHtml) {
        if (returnsSafeHtml) {
            return new SafeHtmlStringGenerator(buf);
        }
        return new PlainStringGenerator(buf);
    }

    protected StringGenerator(StringBuilder buf) {
        this.buf = buf;
        this.inString = false;
    }

    public void appendExpression(String expression, boolean isSafeHtmlTyped, boolean isPrimitiveTyped, boolean needsConversionToString) {
        if (this.inString) {
            this.buf.append('\"');
            this.afterExpression(Type.LITERAL);
            this.inString = false;
        }
        Type type = isPrimitiveTyped ? Type.PRIMITIVE : (isSafeHtmlTyped ? Type.SAFE : Type.OTHER);
        this.beforeExpression(type);
        if (type == Type.OTHER && needsConversionToString) {
            this.forceStringPrefix();
        }
        this.buf.append(expression);
        if (type == Type.OTHER && needsConversionToString) {
            this.forceStringSuffix();
        }
        this.afterExpression(type);
    }

    public void appendStringLiteral(String str) {
        if (!this.inString) {
            this.beforeExpression(Type.LITERAL);
            this.buf.append('\"');
            this.inString = true;
        }
        this.buf.append(str);
    }

    public void appendStringValuedExpression(String expression) {
        this.appendExpression(expression, false, false, false);
    }

    public void completeString() {
        if (this.inString) {
            this.buf.append('\"');
            this.afterExpression(Type.LITERAL);
        }
        this.finishOutput();
    }

    protected abstract void afterExpression(Type var1);

    protected abstract void beforeExpression(Type var1);

    protected abstract void finishOutput();

    protected abstract void forceStringPrefix();

    protected abstract void forceStringSuffix();

    protected static enum Type {
        LITERAL,
        PRIMITIVE,
        SAFE,
        OTHER;

    }
}

