/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import com.martiansoftware.jsap.JSAPResult;
import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.GenomicRange;

public class AlignmentSliceHelper {
    private String startOffsetArgument;
    private String endOffsetArgument;
    private static final Log LOG = LogFactory.getLog(AlignmentSliceHelper.class);
    GenomicRange genomicRange = new GenomicRange();
    private long startOffset;
    private long endOffset;

    public void parseIncludeReferenceArgument(JSAPResult jsapResult, String[] inputFilenames) {
        if (!this.genomicRange.setTargetIds(inputFilenames)) {
            throw new IllegalArgumentException("Unable to obtain target reference identifiers from alignment files.");
        }
        this.startOffsetArgument = jsapResult.getString("start-position");
        this.endOffsetArgument = jsapResult.getString("end-position");
        if (this.startOffsetArgument != null && this.endOffsetArgument == null || this.endOffsetArgument != null && this.startOffsetArgument == null) {
            System.err.println("Start (-s) and end offset (-e) arguments must be specified together or not at all.");
            System.exit(1);
        }
        if (StringUtils.isEmpty((String)this.startOffsetArgument) && StringUtils.isEmpty((String)this.endOffsetArgument)) {
            this.startOffset = 0L;
            this.endOffset = Long.MAX_VALUE;
            this.genomicRange = null;
        } else {
            try {
                this.startOffset = Long.parseLong(this.startOffsetArgument);
            }
            catch (NumberFormatException e) {
                if (!this.hasDelimiter(this.startOffsetArgument)) {
                    System.err.println("start offset must contain a coma or semi-colon delimiter.");
                    System.exit(1);
                }
                this.genomicRange.startChromosome = this.getRefId(this.startOffsetArgument);
                this.genomicRange.startReferenceIndex = this.getRefIndex(this.startOffsetArgument, this.genomicRange.getTargetIds());
                this.genomicRange.startPosition = this.getPosition(this.startOffsetArgument);
            }
            try {
                this.endOffset = Long.parseLong(this.endOffsetArgument);
            }
            catch (NumberFormatException e) {
                if (!this.hasDelimiter(this.endOffsetArgument)) {
                    System.err.println("end offset must contain a coma or semi-colon delimiter.");
                    System.exit(1);
                }
                this.genomicRange.endChromosome = this.getRefId(this.endOffsetArgument);
                this.genomicRange.endReferenceIndex = this.getRefIndex(this.endOffsetArgument, this.genomicRange.getTargetIds());
                this.genomicRange.endPosition = this.getPosition(this.endOffsetArgument);
            }
        }
    }

    private boolean hasDelimiter(String startOffsetArgument) {
        if (startOffsetArgument.contains(",")) {
            return true;
        }
        return startOffsetArgument.contains(":");
    }

    private String getRefId(String offsetArgument) {
        String[] tokens = offsetArgument.split("[,]");
        return tokens[0];
    }

    private int getRefIndex(String offsetArgument, DoubleIndexedIdentifier referenceIds) {
        String[] tokens = offsetArgument.split("[,:]");
        int referenceIndex = referenceIds.getIndex(tokens[0]);
        if (referenceIndex == -1) {
            String message = String.format("One of the reference identifier specified for start and end limits does not exist %s. ", tokens[0]);
            LOG.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        return referenceIndex;
    }

    private int getPosition(String offsetArgument) {
        String[] tokens = offsetArgument.split("[,:]");
        int position = Integer.parseInt(tokens[1]);
        return position;
    }

    public GenomicRange getGenomicRange() {
        return this.genomicRange;
    }
}

