/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;

public class CertPathBuilder {
    private static final String CERT_PATH_BUILDER = "CertPathBuilder";
    private CertPathBuilderSpi cpbSpi;
    private Provider provider;
    private String algorithm;

    public static final String getDefaultType() {
        String string = Security.getProperty("certpathbuilder.type");
        if (string == null) {
            string = "PKIX";
        }
        return string;
    }

    public static CertPathBuilder getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            try {
                return CertPathBuilder.getInstance(string, providerArray[n]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static CertPathBuilder getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return CertPathBuilder.getInstance(string, provider);
    }

    public static CertPathBuilder getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("null provider");
        }
        try {
            return new CertPathBuilder((CertPathBuilderSpi)Engine.getInstance(CERT_PATH_BUILDER, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertPathBuilderResult build(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        return this.cpbSpi.engineBuild(certPathParameters);
    }

    protected CertPathBuilder(CertPathBuilderSpi certPathBuilderSpi, Provider provider, String string) {
        this.cpbSpi = certPathBuilderSpi;
        this.provider = provider;
        this.algorithm = string;
    }
}

