/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.mixer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TClip;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TSoftClip
extends TClip
implements Runnable {
    private static final Class[] CONTROL_CLASSES = new Class[0];
    private static final int BUFFER_SIZE = 16384;
    private Mixer m_mixer;
    private SourceDataLine m_line;
    private byte[] m_abClip;
    private int m_nRepeatCount;
    private Thread m_thread;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        AudioFormat audioFormat = audioInputStream.getFormat();
        this.setFormat(audioFormat);
        int n = audioFormat.getFrameSize();
        if (n < 1) {
            throw new IllegalArgumentException("frame size must be positive");
        }
        if (TDebug.TraceClip) {
            TDebug.out("TSoftClip.open(): format: " + audioFormat);
        }
        byte[] byArray = new byte[16384];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 != -1) {
            block6: {
                try {
                    n2 = audioInputStream.read(byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    if (!TDebug.TraceClip && !TDebug.TraceAllExceptions) break block6;
                    TDebug.out(iOException);
                }
            }
            if (n2 < 0) continue;
            if (TDebug.TraceClip) {
                TDebug.out("TSoftClip.open(): Trying to write: " + n2);
            }
            byteArrayOutputStream.write(byArray, 0, n2);
            if (!TDebug.TraceClip) continue;
            TDebug.out("TSoftClip.open(): Written: " + n2);
        }
        this.m_abClip = byteArrayOutputStream.toByteArray();
        this.setBufferSize(this.m_abClip.length);
        this.m_line.open(this.getFormat());
    }

    public int getFrameLength() {
        if (this.isOpen()) {
            return this.getBufferSize() / this.getFormat().getFrameSize();
        }
        return -1;
    }

    public long getMicrosecondLength() {
        if (this.isOpen()) {
            return (long)((float)this.getFrameLength() * this.getFormat().getFrameRate() * 1000000.0f);
        }
        return -1;
    }

    public void setFramePosition(int n) {
    }

    public void setMicrosecondPosition(long l) {
    }

    public int getFramePosition() {
        return -1;
    }

    public long getMicrosecondPosition() {
        return -1;
    }

    public void setLoopPoints(int n, int n2) {
    }

    public void loop(int n) {
        if (TDebug.TraceClip) {
            TDebug.out("TSoftClip.loop(int): called; count = " + n);
        }
        this.m_nRepeatCount = n;
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public void flush() {
    }

    public void drain() {
    }

    public void close() {
    }

    public void open() {
    }

    public void start() {
        if (TDebug.TraceClip) {
            TDebug.out("TSoftClip.start(): called");
        }
        if (TDebug.TraceClip) {
            TDebug.out("TSoftClip.start(): calling 'loop(0)' [hack]");
        }
        this.loop(0);
    }

    public void stop() {
    }

    public int available() {
        return -1;
    }

    public void run() {
        while (this.m_nRepeatCount >= 0) {
            this.m_line.write(this.m_abClip, 0, this.m_abClip.length);
            --this.m_nRepeatCount;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public TSoftClip(Mixer mixer, AudioFormat audioFormat) throws LineUnavailableException {
        super(null);
        this.m_mixer = mixer;
        Class clazz = class$javax$sound$sampled$SourceDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$SourceDataLine = TSoftClip.class("[Ljavax.sound.sampled.SourceDataLine;", false);
        }
        DataLine.Info info = new DataLine.Info(clazz, audioFormat);
        this.m_line = (SourceDataLine)AudioSystem.getLine(info);
    }
}

