import rox
from rox import g, OptionsBox
from rox.options import Option
from rcfile import Opt, OptionGroupRC, update_options


### TODO:
###
### A special widget for button layout? (drag and drop of symbols)
###

app_name = 'OroboROX'

def build_mytoggle(box, node, label, option):
	toggle = g.CheckButton(label)
	box.may_add_tip(toggle, node)
	def get():
		if toggle.get_active():
			return 'true'
		else:
			return 'false'
	def set():
		if option.value == 'true':
			toggle.set_active(True)
		else:
			toggle.set_active(False)
		
	box.handlers[option] = (get, set)
	toggle.connect('toggled', lambda w: box.check_widget(option))
	return [toggle]

def build_buttonfilter(box, node, label, option):
	hbox = g.HBox()
	hbox.set_border_width(8)
	
	toggles = {}
	for (char, label) in [
		('T',_('Sticky')),
		('S',_('Shade')),
		('H',_('Hide')),
		('M',_('Maximize')),
		('C',_('Close'))
		]:
		t = g.CheckButton(label)
		toggles[char]=t
		hbox.add(t)
		t.connect('toggled', lambda w: box.check_widget(option))
#		box.tips.set_tip(t,
#'Enable / disable the %s button on the titlebar.' % (label))

	def get():
		s = ''
		for (char,t) in toggles.iteritems():
			if not t.get_active(): s += char
		return s
		
	def set():
		for t in toggles.values(): t.set_active(True)
		for char in option.value: toggles[char].set_active(False)
		
	box.handlers[option] = (get, set)
	return [hbox]

#OptionsBox.widget_registry['keybutt'] = build_keybutt
OptionsBox.widget_registry['mytoggle'] = build_mytoggle
OptionsBox.widget_registry['buttonfilter'] = build_buttonfilter

rox.app_options = OptionGroupRC(app_name,'windowrc')

Option('title_alignment',' ') #NOTE: the space is needed...
Option('button_layout','')
Option('button_filter','')
Option('borderless_windows','')
Option('sticky_windows','')
Option('iconic_windows','')
Option('ontop_windows','')

Opt('buttons_show_state')
Opt('button_cursors')
Opt('font')
Opt('focus_policy')
Opt('raise_policy')
Opt('switch_to_active_win')
Opt('double_click_action')
Opt('box_move')
Opt('box_resize')
Opt('focus_new')
Opt('raise_delay')
Opt('window_placement')
Opt('snap_to_border')
Opt('snap_to_windows')
Opt('snap_width')
Opt('warp_mouse')
Opt('border_drag')
Opt('button2_frame_click')
Opt('button3_frame_click')
Opt('maximize_state')
Opt('button2_frame_drag')
Opt('button3_frame_drag')
Opt('cycle_infobox')
Opt('geometry_infobox')
Opt('warp_after_cycle')

rox.app_options.add_notify(update_options)
rox.app_options.notify()
rox.edit_options()
