/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FloatDHT_1D {
    private int n;
    private FloatFFT_1D fft;

    public FloatDHT_1D(int n) {
        this.n = n;
        this.fft = new FloatFFT_1D(n);
    }

    public FloatDHT_1D(int n, int[] nArray, float[] fArray) {
        this.n = n;
        this.fft = new FloatFFT_1D(n, nArray, fArray);
    }

    public void forward(float[] fArray) {
        this.forward(fArray, 0);
    }

    public void forward(final float[] fArray, final int n) {
        if (this.n == 1) {
            return;
        }
        this.fft.realForward(fArray, n);
        final float[] fArray2 = new float[this.n];
        System.arraycopy(fArray, n, fArray2, 0, this.n);
        int n2 = this.n / 2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > 1 && n2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5 = n2 / n3;
            Future[] futureArray = new Future[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = 1 + n4 * n5;
                final int n7 = n4 == n3 - 1 ? n2 : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            int n3 = 2 * i;
                            int n2 = n3 + 1;
                            fArray[n + i] = fArray2[n3] - fArray2[n2];
                            fArray[n + ((FloatDHT_1D)FloatDHT_1D.this).n - i] = fArray2[n3] + fArray2[n2];
                        }
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    futureArray[n4].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n8 = 2 * i;
                int n9 = n8 + 1;
                fArray[n + i] = fArray2[n8] - fArray2[n9];
                fArray[n + this.n - i] = fArray2[n8] + fArray2[n9];
            }
        }
        fArray[n + n2] = fArray2[1];
    }

    public void inverse(float[] fArray, boolean bl) {
        this.inverse(fArray, 0, bl);
    }

    public void inverse(float[] fArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        this.forward(fArray, n);
        if (bl) {
            this.scale(this.n, fArray, n, false);
        }
    }

    private void scale(final float f, final float[] fArray, int n, boolean bl) {
        int n2 = bl ? 2 * this.n : this.n;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            final int n5 = n2 / n3;
            Future[] futureArray = new Future[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n + n4 * n5;
                futureArray[n4] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n6 + n5; i += 2) {
                            int n = i;
                            fArray[n] = fArray[n] / f;
                            int n2 = i + 1;
                            fArray[n2] = fArray[n2] / f;
                        }
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    futureArray[n4].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = n; i < n + n2; i += 2) {
                int n7 = i;
                fArray[n7] = fArray[n7] / f;
                int n8 = i + 1;
                fArray[n8] = fArray[n8] / f;
            }
        }
    }
}

