/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.ValueColorizer;

public class GreyscaleLogColorizer
implements ValueColorizer {
    double multiplier = 6000.0;
    private final ClipPanel clipPanel;
    private final JComponent settingsPanel;

    GreyscaleLogColorizer(ClipPanel clipPanel) {
        this.clipPanel = clipPanel;
        final JSlider brightness = new JSlider(0, 5000000, (int)(this.multiplier * 100.0));
        brightness.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GreyscaleLogColorizer.this.setMultiplier((double)brightness.getValue() / 100.0);
            }
        });
        this.settingsPanel = Box.createVerticalBox();
        this.settingsPanel.add(new JLabel("Brightness"));
        this.settingsPanel.add(brightness);
    }

    public int colorFor(double val) {
        int greyVal = (int)(this.multiplier * Math.abs(val));
        if (greyVal < 0) {
            greyVal = 0;
        } else if (greyVal > 255) {
            greyVal = 255;
        }
        return greyVal << 16 | greyVal << 8 | greyVal;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
        this.clipPanel.updateImage(null);
        this.clipPanel.repaint();
    }

    public JComponent getSettingsPanel() {
        return this.settingsPanel;
    }
}

