/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.Cipher;

public final class IDEA
extends Cipher {
    protected int[] key_schedule = new int[52];
    protected int IV0 = 0;
    protected int IV1 = 0;

    public synchronized void encrypt(byte[] src, int srcOff, byte[] dest, int destOff, int len) {
        int[] out = new int[2];
        int iv0 = this.IV0;
        int iv1 = this.IV1;
        int end = srcOff + len;
        int si = srcOff;
        int di = destOff;
        while (si < end) {
            this.encrypt(iv0, iv1, out);
            iv0 = out[0];
            iv1 = out[1];
            iv0 ^= src[si + 3] & 0xFF | (src[si + 2] & 0xFF) << 8 | (src[si + 1] & 0xFF) << 16 | (src[si] & 0xFF) << 24;
            iv1 ^= src[si + 7] & 0xFF | (src[si + 6] & 0xFF) << 8 | (src[si + 5] & 0xFF) << 16 | (src[si + 4] & 0xFF) << 24;
            if (di + 8 <= end) {
                dest[di + 3] = (byte)(iv0 & 0xFF);
                dest[di + 2] = (byte)(iv0 >>> 8 & 0xFF);
                dest[di + 1] = (byte)(iv0 >>> 16 & 0xFF);
                dest[di] = (byte)(iv0 >>> 24 & 0xFF);
                dest[di + 7] = (byte)(iv1 & 0xFF);
                dest[di + 6] = (byte)(iv1 >>> 8 & 0xFF);
                dest[di + 5] = (byte)(iv1 >>> 16 & 0xFF);
                dest[di + 4] = (byte)(iv1 >>> 24 & 0xFF);
            } else {
                switch (end - di) {
                    case 7: {
                        dest[di + 6] = (byte)(iv1 >>> 8 & 0xFF);
                    }
                    case 6: {
                        dest[di + 5] = (byte)(iv1 >>> 16 & 0xFF);
                    }
                    case 5: {
                        dest[di + 4] = (byte)(iv1 >>> 24 & 0xFF);
                    }
                    case 4: {
                        dest[di + 3] = (byte)(iv0 & 0xFF);
                    }
                    case 3: {
                        dest[di + 2] = (byte)(iv0 >>> 8 & 0xFF);
                    }
                    case 2: {
                        dest[di + 1] = (byte)(iv0 >>> 16 & 0xFF);
                    }
                    case 1: {
                        dest[di] = (byte)(iv0 >>> 24 & 0xFF);
                    }
                }
            }
            si += 8;
            di += 8;
        }
        this.IV0 = iv0;
        this.IV1 = iv1;
    }

    public synchronized void decrypt(byte[] src, int srcOff, byte[] dest, int destOff, int len) {
        int[] out = new int[2];
        int iv0 = this.IV0;
        int iv1 = this.IV1;
        int end = srcOff + len;
        int si = srcOff;
        int di = destOff;
        while (si < end) {
            this.decrypt(iv0, iv1, out);
            iv0 = src[si + 3] & 0xFF | (src[si + 2] & 0xFF) << 8 | (src[si + 1] & 0xFF) << 16 | (src[si] & 0xFF) << 24;
            iv1 = src[si + 7] & 0xFF | (src[si + 6] & 0xFF) << 8 | (src[si + 5] & 0xFF) << 16 | (src[si + 4] & 0xFF) << 24;
            int plain0 = out[0] ^ iv0;
            int plain1 = out[1] ^ iv1;
            if (di + 8 <= end) {
                dest[di + 3] = (byte)(plain0 & 0xFF);
                dest[di + 2] = (byte)(plain0 >>> 8 & 0xFF);
                dest[di + 1] = (byte)(plain0 >>> 16 & 0xFF);
                dest[di] = (byte)(plain0 >>> 24 & 0xFF);
                dest[di + 7] = (byte)(plain1 & 0xFF);
                dest[di + 6] = (byte)(plain1 >>> 8 & 0xFF);
                dest[di + 5] = (byte)(plain1 >>> 16 & 0xFF);
                dest[di + 4] = (byte)(plain1 >>> 24 & 0xFF);
            } else {
                switch (end - di) {
                    case 7: {
                        dest[di + 6] = (byte)(plain1 >>> 8 & 0xFF);
                    }
                    case 6: {
                        dest[di + 5] = (byte)(plain1 >>> 16 & 0xFF);
                    }
                    case 5: {
                        dest[di + 4] = (byte)(plain1 >>> 24 & 0xFF);
                    }
                    case 4: {
                        dest[di + 3] = (byte)(plain0 & 0xFF);
                    }
                    case 3: {
                        dest[di + 2] = (byte)(plain0 >>> 8 & 0xFF);
                    }
                    case 2: {
                        dest[di + 1] = (byte)(plain0 >>> 16 & 0xFF);
                    }
                    case 1: {
                        dest[di] = (byte)(plain0 >>> 24 & 0xFF);
                    }
                }
            }
            si += 8;
            di += 8;
        }
        this.IV0 = iv0;
        this.IV1 = iv1;
    }

    public void setKey(byte[] key) {
        int i;
        int ki = 0;
        int j = 0;
        for (i = 0; i < 8; ++i) {
            this.key_schedule[i] = (key[2 * i] & 0xFF) << 8 | key[2 * i + 1] & 0xFF;
        }
        j = 0;
        for (i = 8; i < 52; ++i) {
            this.key_schedule[ki + ++j + 7] = (this.key_schedule[ki + (j & 7)] << 9 | this.key_schedule[ki + (j + 1 & 7)] >>> 7) & 0xFFFF;
            ki += j & 8;
            j &= 7;
        }
    }

    public final void encrypt(int l, int r, int[] out) {
        int t1 = 0;
        int t2 = 0;
        int ki = 0;
        int x1 = l >>> 16;
        int x2 = l & 0xFFFF;
        int x3 = r >>> 16;
        int x4 = r & 0xFFFF;
        for (int round = 0; round < 8; ++round) {
            x1 = IDEA.mulop(x1 & 0xFFFF, this.key_schedule[ki++]);
            int n = ki++;
            int n2 = ki++;
            x4 = IDEA.mulop(x4 & 0xFFFF, this.key_schedule[ki++]);
            t1 = x1 ^ (x3 += this.key_schedule[n2]);
            t2 = (x2 += this.key_schedule[n]) ^ x4;
            t1 = IDEA.mulop(t1 & 0xFFFF, this.key_schedule[ki++]);
            t2 = t1 + t2;
            t2 = IDEA.mulop(t2 & 0xFFFF, this.key_schedule[ki++]);
            x1 ^= t2;
            x4 ^= (t1 += t2);
            t1 ^= x2;
            x2 = t2 ^ x3;
            x3 = t1;
        }
        t2 = x2;
        x1 = IDEA.mulop(x1 & 0xFFFF, this.key_schedule[ki++]);
        x2 = t1 + this.key_schedule[ki++];
        x3 = t2 + this.key_schedule[ki++] & 0xFFFF;
        x4 = IDEA.mulop(x4 & 0xFFFF, this.key_schedule[ki]);
        out[0] = x1 << 16 | x2 & 0xFFFF;
        out[1] = x3 << 16 | x4 & 0xFFFF;
    }

    public final void decrypt(int l, int r, int[] out) {
        this.encrypt(l, r, out);
    }

    public static final int mulop(int a, int b) {
        int ab = a * b;
        if (ab != 0) {
            int hi;
            int lo;
            return lo - hi + ((lo = ab & 0xFFFF) < (hi = ab >>> 16 & 0xFFFF) ? 1 : 0);
        }
        if (a == 0) {
            return 1 - b;
        }
        return 1 - a;
    }
}

