package org.cdavies.applerecords.status;

import java.util.TimerTask;

import org.cdavies.applerecords.*;
import org.cdavies.itunes.*;

public class PlayerStatusTimerTask extends TimerTask {
	
	private AppleRecordsStatusPanel _status;
	private PlayerThread _thread;
	
	public PlayerStatusTimerTask(AppleRecordsStatusPanel status, PlayerThread thread) {
		
		_status = status;
		_thread = thread;
		
	}
	
	public void run() {
		
		int _remains = (_thread.getTrack().getLength() / 1000) - (_thread.getPosition() / 1000);
		int _minutes = _remains / 60;
		int _seconds = _remains % 60;
		
		_status.setText("Playing '" + _thread.getTrack().getTrackName() + "' " + _minutes + "m" 
			+ ((_seconds < 10) ? ("0" + _seconds) : ("" + _seconds)) + "s remaining" );
		
	}
	
}
