/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.tools.apichecker.ApiAbstractMethod;
import com.google.gwt.tools.apichecker.ApiChange;
import com.google.gwt.tools.apichecker.ApiClassDiffGenerator;
import com.google.gwt.tools.apichecker.ApiContainer;
import com.google.gwt.tools.apichecker.ApiElement;
import com.google.gwt.tools.apichecker.ApiField;
import com.google.gwt.tools.apichecker.ApiPackage;
import com.google.gwt.tools.apichecker.ApiPackageDiffGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ApiDiffGenerator {
    public static final String DELIMITER = " ";
    static final String HAY_API_CHANGE = "";
    Map<String, ApiPackageDiffGenerator> intersectingPackages = new HashMap<String, ApiPackageDiffGenerator>();
    Set<String> missingPackageNames;
    final ApiContainer newApi;
    final ApiContainer oldApi;

    static boolean isFirstTypeAssignableToSecond(JType firstType, JType secondType) {
        if (firstType.getJNISignature().equals(secondType.getJNISignature())) {
            return true;
        }
        JClassType classType1 = firstType.isClassOrInterface();
        JClassType classType2 = secondType.isClassOrInterface();
        if (classType1 == null || classType2 == null) {
            return false;
        }
        TypeOracle newApiTypeOracle = classType2.getOracle();
        JClassType firstClassType = newApiTypeOracle.findType(classType1.getQualifiedSourceName());
        JClassType secondClassType = newApiTypeOracle.findType(classType2.getQualifiedSourceName());
        if (firstClassType == null || secondClassType == null) {
            return false;
        }
        return firstClassType.isAssignableTo(secondClassType);
    }

    static Set<String> removeIntersection(Set<String> s1, Set<String> s2) {
        HashSet<String> intersection = new HashSet<String>(s1);
        intersection.retainAll(s2);
        s1.removeAll(intersection);
        s2.removeAll(intersection);
        return intersection;
    }

    ApiDiffGenerator(ApiContainer newApi, ApiContainer oldApi) {
        this.newApi = newApi;
        this.oldApi = oldApi;
    }

    ApiClassDiffGenerator findApiClassDiffGenerator(String className) {
        int i = className.length() - 1;
        while (i >= 0) {
            ApiClassDiffGenerator result;
            int dot = className.lastIndexOf(46, i);
            String pkgName = HAY_API_CHANGE;
            String typeName = className;
            if (dot != -1) {
                pkgName = className.substring(0, dot);
                typeName = className.substring(dot + 1);
                i = dot - 1;
            } else {
                i = -1;
            }
            if ((result = this.findApiClassDiffGenerator(pkgName, typeName)) == null) continue;
            return result;
        }
        return null;
    }

    ApiClassDiffGenerator findApiClassDiffGenerator(String pkgName, String typeName) {
        ApiClassDiffGenerator type;
        ApiPackageDiffGenerator pkg = this.findApiPackageDiffGenerator(pkgName);
        if (pkg != null && (type = pkg.findApiClassDiffGenerator(pkgName + "." + typeName)) != null) {
            return type;
        }
        return null;
    }

    ApiPackageDiffGenerator findApiPackageDiffGenerator(String key) {
        return this.intersectingPackages.get(key);
    }

    Collection<ApiChange> getApiDiff() throws NotFoundException {
        this.computeApiDiff();
        ArrayList<ApiChange> collection = new ArrayList<ApiChange>();
        Set<ApiPackage> missingPackages = this.oldApi.getApiPackagesBySet(this.missingPackageNames);
        for (ApiPackage missingPackage : missingPackages) {
            collection.add(new ApiChange(missingPackage, ApiChange.Status.MISSING));
        }
        for (ApiPackageDiffGenerator intersectingPackage : this.intersectingPackages.values()) {
            collection.addAll(intersectingPackage.getApiDiff());
        }
        return collection;
    }

    ApiContainer getNewApiContainer() {
        return this.newApi;
    }

    ApiContainer getOldApiContainer() {
        return this.oldApi;
    }

    Collection<ApiChange> removeDuplicates(Collection<ApiChange> originalCollection) {
        HashMap apiChangeMap = new HashMap();
        for (ApiChange apiChange : originalCollection) {
            String apiChangeStr = apiChange.getApiElement().getRelativeSignature();
            HashSet<ApiChange> apiChangesSameHashCode = (HashSet<ApiChange>)apiChangeMap.get(apiChange.hashCodeForDuplication());
            if (apiChangesSameHashCode == null) {
                apiChangesSameHashCode = new HashSet<ApiChange>();
                apiChangeMap.put(apiChange.hashCodeForDuplication(), apiChangesSameHashCode);
            }
            HashSet<ApiChange> apiChangesToRemove = new HashSet<ApiChange>();
            boolean addNewElement = true;
            for (ApiChange oldApiChange : apiChangesSameHashCode) {
                String oldApiChangeStr = oldApiChange.getApiElement().getRelativeSignature();
                Relation relation = this.getRelationOfApiClassOfFirstArgToThatOfSecond(apiChange.getApiElement(), oldApiChange.getApiElement());
                if (relation == Relation.SUPERCLASS) {
                    apiChangesToRemove.add(oldApiChange);
                    continue;
                }
                if (relation != Relation.SUBCLASS) continue;
                addNewElement = false;
            }
            apiChangesSameHashCode.removeAll(apiChangesToRemove);
            if (!addNewElement) continue;
            apiChangesSameHashCode.add(apiChange);
        }
        HashSet<ApiChange> prunedCollection = new HashSet<ApiChange>();
        for (Collection changes : apiChangeMap.values()) {
            prunedCollection.addAll(changes);
        }
        return prunedCollection;
    }

    private void computeApiDiff() throws NotFoundException {
        HashSet<String> newApiPackageNames = this.newApi.getApiPackageNames();
        this.missingPackageNames = this.oldApi.getApiPackageNames();
        Set<String> intersection = ApiDiffGenerator.removeIntersection(newApiPackageNames, this.missingPackageNames);
        for (String packageName : intersection) {
            ApiPackageDiffGenerator tempPackageDiffGenerator = new ApiPackageDiffGenerator(packageName, this);
            this.intersectingPackages.put(packageName, tempPackageDiffGenerator);
            tempPackageDiffGenerator.computeApiDiff();
        }
    }

    private Relation getRelationOfApiClassOfFirstArgToThatOfSecond(ApiElement firstApiElement, ApiElement secondApiElement) {
        JClassType firstClassType = null;
        JClassType secondClassType = null;
        if (firstApiElement instanceof ApiField) {
            firstClassType = ((ApiField)firstApiElement).getApiClass().getClassObject();
            secondClassType = ((ApiField)secondApiElement).getApiClass().getClassObject();
        }
        if (firstApiElement instanceof ApiAbstractMethod) {
            firstClassType = ((ApiAbstractMethod)firstApiElement).getApiClass().getClassObject();
            secondClassType = ((ApiAbstractMethod)secondApiElement).getApiClass().getClassObject();
        }
        if (firstClassType != null && secondClassType != null) {
            if (secondClassType.isAssignableTo(firstClassType)) {
                return Relation.SUPERCLASS;
            }
            if (firstClassType.isAssignableTo(secondClassType)) {
                return Relation.SUBCLASS;
            }
            return Relation.NONE;
        }
        throw new RuntimeException("Inconsistent types for ApiElements: newApiElement " + firstApiElement + ", oldApiElement : " + secondApiElement);
    }

    private static enum Relation {
        NONE,
        SUBCLASS,
        SUPERCLASS;

    }
}

