/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.examples;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.QualifiedSwitch;
import com.martiansoftware.jsap.UnflaggedOption;
import java.util.Iterator;

public class Manual_HelloWorld_8 {
    public static void main(String[] args) throws Exception {
        int i;
        JSAP jsap = new JSAP();
        FlaggedOption opt1 = new FlaggedOption("count").setStringParser(JSAP.INTEGER_PARSER).setDefault("1").setRequired(true).setShortFlag('n').setLongFlag(JSAP.NO_LONGFLAG);
        opt1.setHelp("The number of times to say hello.");
        jsap.registerParameter(opt1);
        QualifiedSwitch sw1 = (QualifiedSwitch)new QualifiedSwitch("verbose").setShortFlag('v').setLongFlag("verbose").setList(true).setListSeparator(',');
        sw1.setHelp("Requests verbose output.");
        jsap.registerParameter(sw1);
        UnflaggedOption opt2 = new UnflaggedOption("name").setStringParser(JSAP.STRING_PARSER).setDefault("World").setRequired(true).setGreedy(true);
        opt2.setHelp("One or more names of people you would like to greet.");
        jsap.registerParameter(opt2);
        JSAPResult config = jsap.parse(args);
        if (!config.success()) {
            System.err.println();
            Iterator errs = config.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
            System.err.println();
            System.err.println("Usage: java " + Manual_HelloWorld_8.class.getName());
            System.err.println("                " + jsap.getUsage());
            System.err.println();
            System.err.println(jsap.getHelp());
            System.exit(1);
        }
        String[] names = config.getStringArray("name");
        String[] languages = config.getStringArray("verbose");
        for (i = 0; i < languages.length; ++i) {
            System.out.println("language=" + languages[i]);
        }
        for (i = 0; i < config.getInt("count"); ++i) {
            for (int j = 0; j < names.length; ++j) {
                System.out.println((config.getBoolean("verbose") ? "Hello" : "Hi") + ", " + names[j] + "!");
            }
        }
    }
}

