/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.campagnelab.goby.counts.CountsAggregatorI;
import org.campagnelab.goby.counts.CountsReaderI;

public class UnionAlgorithmSkeleton
implements CountsAggregatorI {
    private int numReaders;
    private CountsReaderI[] readers;
    private boolean hasNextTransition;
    private int length;
    private int position = 0;
    private int first;
    private int second;
    private int[] positions;
    private int[] startPositions;
    private int[] endPositions;
    private boolean[] finished;
    private int previousPosition = -1;
    int[] counts;
    IntArraySet startAndEndPositions = new IntArraySet();

    public UnionAlgorithmSkeleton(CountsReaderI ... readers) {
        this.numReaders = readers.length;
        this.readers = readers;
        this.counts = new int[this.numReaders];
        this.positions = new int[this.numReaders];
        this.startPositions = new int[this.numReaders];
        this.endPositions = new int[this.numReaders];
        Arrays.fill(this.startPositions, Integer.MAX_VALUE);
        Arrays.fill(this.endPositions, Integer.MAX_VALUE);
        this.finished = new boolean[this.numReaders];
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean hasNextTransition() throws IOException {
        if (this.hasNextTransition) {
            return true;
        }
        this.hasNextTransition = false;
        this.position = this.first;
        this.first = this.first(this.startAndEndPositions);
        for (int readerIndex = 0; readerIndex < this.numReaders; ++readerIndex) {
            CountsReaderI reader = this.readers[readerIndex];
            if (!this.needsLoading(readerIndex)) continue;
            if (reader.hasNextTransition()) {
                reader.nextTransition();
                System.out.printf("loading transition for reader[%d] position=%d length=%d count=%d %n", readerIndex, reader.getPosition(), reader.getLength(), reader.getCount());
                int startPosition = reader.getPosition();
                int endPosition = startPosition + reader.getLength();
                this.startPositions[readerIndex] = startPosition;
                this.endPositions[readerIndex] = endPosition;
                this.startAndEndPositions.add(startPosition);
                this.startAndEndPositions.add(endPosition);
                this.counts[readerIndex] = reader.getCount();
                this.positions[readerIndex] = startPosition;
                continue;
            }
            this.finished[readerIndex] = true;
        }
        this.first = this.first(this.startAndEndPositions);
        this.second = this.second(this.startAndEndPositions, this.first);
        this.length = this.second - this.first;
        if (this.second == Integer.MAX_VALUE) {
            this.length = 0;
        }
        this.startAndEndPositions.rem(this.first);
        this.position = this.first;
        this.hasNextTransition = this.length > 0;
        this.previousPosition = this.position;
        return this.hasNextTransition;
    }

    private boolean needsLoading(int readerIndex) {
        if (!this.finished[readerIndex]) {
            return this.endPositions[readerIndex] == Integer.MAX_VALUE || this.first + 1 > this.endPositions[readerIndex];
        }
        return false;
    }

    private int second(IntArraySet array, int first) {
        int min = Integer.MAX_VALUE;
        IntIterator intIterator = array.iterator();
        while (intIterator.hasNext()) {
            int value = (Integer)intIterator.next();
            if (value == first) continue;
            min = Math.min(value, min);
        }
        return min;
    }

    private int first(IntArraySet array) {
        int min = Integer.MAX_VALUE;
        IntIterator intIterator = array.iterator();
        while (intIterator.hasNext()) {
            int value = (Integer)intIterator.next();
            min = Math.min(value, min);
        }
        return min;
    }

    @Override
    public void nextTransition() throws IOException {
        if (!this.hasNextTransition()) {
            throw new NoSuchElementException("no elements left in reader.");
        }
        this.hasNextTransition = false;
    }

    @Override
    public void skipTo(int position) {
        throw new UnsupportedOperationException("this implementation does not support this method.");
    }

    @Override
    public void reposition(int position) throws IOException {
        throw new UnsupportedOperationException("this implementation does not support this method.");
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void close() {
    }

    @Override
    public int getCount() {
        int count = 0;
        for (int i = 0; i < this.numReaders; ++i) {
            count += this.getCount(i);
        }
        return count;
    }

    public final CountsReaderI[] getReaders() {
        return this.readers;
    }

    @Override
    public final int getCount(int readerIndex) {
        return this.isReaderInRange(readerIndex) ? this.counts[readerIndex] : 0;
    }

    private boolean isReaderInRange(int readerIndex) {
        int readerStart = this.startPositions[readerIndex];
        int readerEnd = this.endPositions[readerIndex];
        if (readerStart == Integer.MAX_VALUE) {
            return false;
        }
        boolean result = readerStart == this.first || readerStart <= this.position && readerEnd > this.position;
        return result;
    }
}

