<?php

/**
 * BaseLeaveRequest
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                        $id                                              Type: integer(4), primary key
 * @property int                                        $leave_type_id                                   Type: integer(4)
 * @property string                                     $date_applied                                    Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property int                                        $emp_number                                      Type: integer(4)
 * @property string                                     $comments                                        Type: string(256)
 * @property LeaveType                                  $LeaveType                                       
 * @property Employee                                   $Employee                                        
 * @property Doctrine_Collection|Leave[]                $Leave                                           
 * @property Doctrine_Collection|LeaveRequestComment[]  $LeaveRequestComment                             
 *  
 * @method int                                          getId()                                          Type: integer(4), primary key
 * @method int                                          getLeaveTypeId()                                 Type: integer(4)
 * @method string                                       getDateApplied()                                 Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method int                                          getEmpNumber()                                   Type: integer(4)
 * @method string                                       getComments()                                    Type: string(256)
 * @method LeaveType                                    getLeaveType()                                   
 * @method Employee                                     getEmployee()                                    
 * @method Doctrine_Collection|Leave[]                  getLeave()                                       
 * @method Doctrine_Collection|LeaveRequestComment[]    getLeaveRequestComment()                         
 *  
 * @method LeaveRequest                                 setId(int $val)                                  Type: integer(4), primary key
 * @method LeaveRequest                                 setLeaveTypeId(int $val)                         Type: integer(4)
 * @method LeaveRequest                                 setDateApplied(string $val)                      Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method LeaveRequest                                 setEmpNumber(int $val)                           Type: integer(4)
 * @method LeaveRequest                                 setComments(string $val)                         Type: string(256)
 * @method LeaveRequest                                 setLeaveType(LeaveType $val)                     
 * @method LeaveRequest                                 setEmployee(Employee $val)                       
 * @method LeaveRequest                                 setLeave(Doctrine_Collection $val)               
 * @method LeaveRequest                                 setLeaveRequestComment(Doctrine_Collection $val) 
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseLeaveRequest extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_leave_request');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('leave_type_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('date_applied', 'date', 25, array(
             'type' => 'date',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('emp_number', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('comments', 'string', 256, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 256,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('LeaveType', array(
             'local' => 'leave_type_id',
             'foreign' => 'id'));

        $this->hasOne('Employee', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasMany('Leave', array(
             'local' => 'id',
             'foreign' => 'leave_request_id'));

        $this->hasMany('LeaveRequestComment', array(
             'local' => 'id',
             'foreign' => 'leave_request_id'));
    }
}