require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS_LOCORE_H)) {
    eval 'sub _MIPS_LOCORE_H () {1;}' unless defined(&_MIPS_LOCORE_H);
    if(!defined(&_MODULE)  && defined(&_KERNEL_OPT)) {
	require './mips/opt_cputype.ph';
    }
    unless(defined(&__ASSEMBLER__)) {
	require 'sys/cpu.ph';
	require 'mips/mutex.ph';
	require 'mips/cpuregs.ph';
	require 'mips/reg.ph';
	unless(defined(&__BSD_PTENTRY_T__)) {
	    eval 'sub __BSD_PTENTRY_T__ () {1;}' unless defined(&__BSD_PTENTRY_T__);
	    eval 'sub PRIxPTE () { &PRIx32;}' unless defined(&PRIxPTE);
	}
	require 'uvm/pmap/tlb.ph';
    }
    if(defined(&_KERNEL)) {
	if(defined(&_MODULE) || defined(&_STANDALONE)) {
	    if(!defined(&__mips_n32)  && !defined(&__mips_n64)) {
		eval 'sub MIPS1 () {1;}' unless defined(&MIPS1);
	    }
	    eval 'sub MIPS3 () {1;}' unless defined(&MIPS3);
	    eval 'sub MIPS4 () {1;}' unless defined(&MIPS4);
	    if(!defined(&__mips_n32)  && !defined(&__mips_n64)) {
		eval 'sub MIPS32 () {1;}' unless defined(&MIPS32);
		eval 'sub MIPS32R2 () {1;}' unless defined(&MIPS32R2);
	    }
	    eval 'sub MIPS64 () {1;}' unless defined(&MIPS64);
	    eval 'sub MIPS64R2 () {1;}' unless defined(&MIPS64R2);
	}
	if(((defined(&MIPS1) ? &MIPS1 : undef) + (defined(&MIPS3) ? &MIPS3 : undef) + (defined(&MIPS4) ? &MIPS4 : undef) + (defined(&MIPS32) ? &MIPS32 : undef) + (defined(&MIPS32R2) ? &MIPS32R2 : undef) + (defined(&MIPS64) ? &MIPS64 : undef) + (defined(&MIPS64R2) ? &MIPS64R2 : undef)) == 0) {
	    die("at\ least\ one\ of\ MIPS1\,\ MIPS3\,\ MIPS4\,\ MIPS32\,\ MIPS32R2\,\ MIPS64\,\ or\ MIPS64R2\ must\ be\ specified");
	}
	if(defined(&MIPS3) || defined(&MIPS4) || defined(&MIPS32) || defined(&MIPS32R2) || defined(&MIPS64) || defined(&MIPS64R2)) {
	    eval 'sub MIPS3_PLUS () {1;}' unless defined(&MIPS3_PLUS);
	    if(!defined(&MIPS32)  && !defined(&MIPS32R2)) {
		eval 'sub MIPS3_64BIT () {1;}' unless defined(&MIPS3_64BIT);
	    }
	    if(!defined(&MIPS3)  && !defined(&MIPS4)) {
		eval 'sub MIPSNN () {1;}' unless defined(&MIPSNN);
	    }
	    if(defined(&MIPS32R2) || defined(&MIPS64R2)) {
		eval 'sub MIPSNNR2 () {1;}' unless defined(&MIPSNNR2);
	    }
	} else {
	    undef(&MIPS3_PLUS) if defined(&MIPS3_PLUS);
	}
	if(defined(&MIPS1)  && ((defined(&ENABLE_MIPS_8KB_PAGE) ? &ENABLE_MIPS_8KB_PAGE : undef) + (defined(&ENABLE_MIPS_16KB_PAGE) ? &ENABLE_MIPS_16KB_PAGE : undef)) > 0) {
	    die("MIPS1\ only\ supports\ a\ 4kB\ page\ size\.");
	}
	unless(defined(&__ASSEMBLER__)) {
	    if(defined(&_KERNEL)) {
		if(defined(&MIPS3_PLUS)) {
		    unless(defined(&__mips_o32)) {
		    }
		}
	    }
	    eval 'sub CPU_ARCH_MIPSx () {0;}' unless defined(&CPU_ARCH_MIPSx);
	    eval 'sub CPU_ARCH_MIPS1 () {(1<< 0);}' unless defined(&CPU_ARCH_MIPS1);
	    eval 'sub CPU_ARCH_MIPS2 () {(1<< 1);}' unless defined(&CPU_ARCH_MIPS2);
	    eval 'sub CPU_ARCH_MIPS3 () {(1<< 2);}' unless defined(&CPU_ARCH_MIPS3);
	    eval 'sub CPU_ARCH_MIPS4 () {(1<< 3);}' unless defined(&CPU_ARCH_MIPS4);
	    eval 'sub CPU_ARCH_MIPS5 () {(1<< 4);}' unless defined(&CPU_ARCH_MIPS5);
	    eval 'sub CPU_ARCH_MIPS32 () {(1<< 5);}' unless defined(&CPU_ARCH_MIPS32);
	    eval 'sub CPU_ARCH_MIPS64 () {(1<< 6);}' unless defined(&CPU_ARCH_MIPS64);
	    eval 'sub CPU_ARCH_MIPS32R2 () {(1<< 7);}' unless defined(&CPU_ARCH_MIPS32R2);
	    eval 'sub CPU_ARCH_MIPS64R2 () {(1<< 8);}' unless defined(&CPU_ARCH_MIPS64R2);
	    eval 'sub CPU_MIPS_R4K_MMU () {0x1;}' unless defined(&CPU_MIPS_R4K_MMU);
	    eval 'sub CPU_MIPS_NO_LLSC () {0x2;}' unless defined(&CPU_MIPS_NO_LLSC);
	    eval 'sub CPU_MIPS_CAUSE_IV () {0x4;}' unless defined(&CPU_MIPS_CAUSE_IV);
	    eval 'sub CPU_MIPS_HAVE_SPECIAL_CCA () {0x8;}' unless defined(&CPU_MIPS_HAVE_SPECIAL_CCA);
	    eval 'sub CPU_MIPS_CACHED_CCA_MASK () {0x70;}' unless defined(&CPU_MIPS_CACHED_CCA_MASK);
	    eval 'sub CPU_MIPS_CACHED_CCA_SHIFT () {4;}' unless defined(&CPU_MIPS_CACHED_CCA_SHIFT);
	    eval 'sub CPU_MIPS_DOUBLE_COUNT () {0x80;}' unless defined(&CPU_MIPS_DOUBLE_COUNT);
	    eval 'sub CPU_MIPS_USE_WAIT () {0x100;}' unless defined(&CPU_MIPS_USE_WAIT);
	    eval 'sub CPU_MIPS_NO_WAIT () {0x200;}' unless defined(&CPU_MIPS_NO_WAIT);
	    eval 'sub CPU_MIPS_D_CACHE_COHERENT () {0x400;}' unless defined(&CPU_MIPS_D_CACHE_COHERENT);
	    eval 'sub CPU_MIPS_I_D_CACHE_COHERENT () {0x800;}' unless defined(&CPU_MIPS_I_D_CACHE_COHERENT);
	    eval 'sub CPU_MIPS_NO_LLADDR () {0x1000;}' unless defined(&CPU_MIPS_NO_LLADDR);
	    eval 'sub CPU_MIPS_HAVE_MxCR () {0x2000;}' unless defined(&CPU_MIPS_HAVE_MxCR);
	    eval 'sub CPU_MIPS_LOONGSON2 () {0x4000;}' unless defined(&CPU_MIPS_LOONGSON2);
	    eval 'sub MIPS_NOT_SUPP () {0x8000;}' unless defined(&MIPS_NOT_SUPP);
	    eval 'sub CPU_MIPS_HAVE_DSP () {0x10000;}' unless defined(&CPU_MIPS_HAVE_DSP);
	    eval 'sub CPU_MIPS_HAVE_USERLOCAL () {0x20000;}' unless defined(&CPU_MIPS_HAVE_USERLOCAL);
	}
	if((((defined(&MIPS1) ? &MIPS1 : undef) + (defined(&MIPS3) ? &MIPS3 : undef) + (defined(&MIPS4) ? &MIPS4 : undef) + (defined(&MIPS32) ? &MIPS32 : undef) + (defined(&MIPS32R2) ? &MIPS32R2 : undef) + (defined(&MIPS64) ? &MIPS64 : undef) + (defined(&MIPS64R2) ? &MIPS64R2 : undef)) == 1) || defined(&_LOCORE)) {
	    if(defined(&MIPS1)) {
		eval 'sub CPUISMIPS3 () {0;}' unless defined(&CPUISMIPS3);
		eval 'sub CPUIS64BITS () {0;}' unless defined(&CPUIS64BITS);
		eval 'sub CPUISMIPS32 () {0;}' unless defined(&CPUISMIPS32);
		eval 'sub CPUISMIPS32R2 () {0;}' unless defined(&CPUISMIPS32R2);
		eval 'sub CPUISMIPS64 () {0;}' unless defined(&CPUISMIPS64);
		eval 'sub CPUISMIPS64R2 () {0;}' unless defined(&CPUISMIPS64R2);
		eval 'sub CPUISMIPSNN () {0;}' unless defined(&CPUISMIPSNN);
		eval 'sub CPUISMIPSNNR2 () {0;}' unless defined(&CPUISMIPSNNR2);
		eval 'sub MIPS_HAS_R4K_MMU () {0;}' unless defined(&MIPS_HAS_R4K_MMU);
		eval 'sub MIPS_HAS_CLOCK () {0;}' unless defined(&MIPS_HAS_CLOCK);
		eval 'sub MIPS_HAS_LLSC () {0;}' unless defined(&MIPS_HAS_LLSC);
		eval 'sub MIPS_HAS_LLADDR () {0;}' unless defined(&MIPS_HAS_LLADDR);
		eval 'sub MIPS_HAS_LMMI () {0;}' unless defined(&MIPS_HAS_LMMI);
		eval 'sub MIPS_HAS_DSP () {0;}' unless defined(&MIPS_HAS_DSP);
		eval 'sub MIPS_HAS_USERLOCAL () {0;}' unless defined(&MIPS_HAS_USERLOCAL);
	    }
 elsif(defined(&MIPS3) || defined(&MIPS4)) {
		eval 'sub CPUISMIPS3 () {1;}' unless defined(&CPUISMIPS3);
		eval 'sub CPUIS64BITS () {1;}' unless defined(&CPUIS64BITS);
		eval 'sub CPUISMIPS32 () {0;}' unless defined(&CPUISMIPS32);
		eval 'sub CPUISMIPS32R2 () {0;}' unless defined(&CPUISMIPS32R2);
		eval 'sub CPUISMIPS64 () {0;}' unless defined(&CPUISMIPS64);
		eval 'sub CPUISMIPS64R2 () {0;}' unless defined(&CPUISMIPS64R2);
		eval 'sub CPUISMIPSNN () {0;}' unless defined(&CPUISMIPSNN);
		eval 'sub CPUISMIPSNNR2 () {0;}' unless defined(&CPUISMIPSNNR2);
		eval 'sub MIPS_HAS_R4K_MMU () {1;}' unless defined(&MIPS_HAS_R4K_MMU);
		eval 'sub MIPS_HAS_CLOCK () {1;}' unless defined(&MIPS_HAS_CLOCK);
		if(defined(&_LOCORE)) {
		    if(!defined(&MIPS3_4100)) {
			eval 'sub MIPS_HAS_LLSC () {1;}' unless defined(&MIPS_HAS_LLSC);
		    } else {
			eval 'sub MIPS_HAS_LLSC () {0;}' unless defined(&MIPS_HAS_LLSC);
		    }
		} else {
		    eval 'sub MIPS_HAS_LLSC () {( ($mips_options->{mips_has_llsc}));}' unless defined(&MIPS_HAS_LLSC);
		}
		eval 'sub MIPS_HAS_LLADDR () {(( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_NO_LLADDR) == 0);}' unless defined(&MIPS_HAS_LLADDR);
		if(defined(&MIPS3_LOONGSON2)) {
		    eval 'sub MIPS_HAS_LMMI () {(( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_LOONGSON2) != 0);}' unless defined(&MIPS_HAS_LMMI);
		} else {
		    eval 'sub MIPS_HAS_LMMI () {0;}' unless defined(&MIPS_HAS_LMMI);
		}
		eval 'sub MIPS_HAS_DSP () {0;}' unless defined(&MIPS_HAS_DSP);
		eval 'sub MIPS_HAS_USERLOCAL () {0;}' unless defined(&MIPS_HAS_USERLOCAL);
	    }
 elsif(defined(&MIPS32)) {
		eval 'sub CPUISMIPS3 () {1;}' unless defined(&CPUISMIPS3);
		eval 'sub CPUIS64BITS () {0;}' unless defined(&CPUIS64BITS);
		eval 'sub CPUISMIPS32 () {1;}' unless defined(&CPUISMIPS32);
		eval 'sub CPUISMIPS32R2 () {0;}' unless defined(&CPUISMIPS32R2);
		eval 'sub CPUISMIPS64 () {0;}' unless defined(&CPUISMIPS64);
		eval 'sub CPUISMIPS64R2 () {0;}' unless defined(&CPUISMIPS64R2);
		eval 'sub CPUISMIPSNN () {1;}' unless defined(&CPUISMIPSNN);
		eval 'sub CPUISMIPSNNR2 () {0;}' unless defined(&CPUISMIPSNNR2);
		eval 'sub MIPS_HAS_R4K_MMU () {1;}' unless defined(&MIPS_HAS_R4K_MMU);
		eval 'sub MIPS_HAS_CLOCK () {1;}' unless defined(&MIPS_HAS_CLOCK);
		eval 'sub MIPS_HAS_LLSC () {1;}' unless defined(&MIPS_HAS_LLSC);
		eval 'sub MIPS_HAS_LLADDR () {(( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_NO_LLADDR) == 0);}' unless defined(&MIPS_HAS_LLADDR);
		eval 'sub MIPS_HAS_LMMI () {0;}' unless defined(&MIPS_HAS_LMMI);
		eval 'sub MIPS_HAS_DSP () {0;}' unless defined(&MIPS_HAS_DSP);
		eval 'sub MIPS_HAS_USERLOCAL () {0;}' unless defined(&MIPS_HAS_USERLOCAL);
	    }
 elsif(defined(&MIPS32R2)) {
		eval 'sub CPUISMIPS3 () {1;}' unless defined(&CPUISMIPS3);
		eval 'sub CPUIS64BITS () {0;}' unless defined(&CPUIS64BITS);
		eval 'sub CPUISMIPS32 () {0;}' unless defined(&CPUISMIPS32);
		eval 'sub CPUISMIPS32R2 () {1;}' unless defined(&CPUISMIPS32R2);
		eval 'sub CPUISMIPS64 () {0;}' unless defined(&CPUISMIPS64);
		eval 'sub CPUISMIPS64R2 () {0;}' unless defined(&CPUISMIPS64R2);
		eval 'sub CPUISMIPSNN () {1;}' unless defined(&CPUISMIPSNN);
		eval 'sub CPUISMIPSNNR2 () {1;}' unless defined(&CPUISMIPSNNR2);
		eval 'sub MIPS_HAS_R4K_MMU () {1;}' unless defined(&MIPS_HAS_R4K_MMU);
		eval 'sub MIPS_HAS_CLOCK () {1;}' unless defined(&MIPS_HAS_CLOCK);
		eval 'sub MIPS_HAS_LLSC () {1;}' unless defined(&MIPS_HAS_LLSC);
		eval 'sub MIPS_HAS_LLADDR () {(( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_NO_LLADDR) == 0);}' unless defined(&MIPS_HAS_LLADDR);
		eval 'sub MIPS_HAS_LMMI () {0;}' unless defined(&MIPS_HAS_LMMI);
		eval 'sub MIPS_HAS_DSP () {( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_HAVE_DSP);}' unless defined(&MIPS_HAS_DSP);
		eval 'sub MIPS_HAS_USERLOCAL () {( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_HAVE_USERLOCAL);}' unless defined(&MIPS_HAS_USERLOCAL);
	    }
 elsif(defined(&MIPS64)) {
		eval 'sub CPUISMIPS3 () {1;}' unless defined(&CPUISMIPS3);
		eval 'sub CPUIS64BITS () {1;}' unless defined(&CPUIS64BITS);
		eval 'sub CPUISMIPS32 () {0;}' unless defined(&CPUISMIPS32);
		eval 'sub CPUISMIPS32R2 () {0;}' unless defined(&CPUISMIPS32R2);
		eval 'sub CPUISMIPS64 () {1;}' unless defined(&CPUISMIPS64);
		eval 'sub CPUISMIPS64R2 () {0;}' unless defined(&CPUISMIPS64R2);
		eval 'sub CPUISMIPSNN () {1;}' unless defined(&CPUISMIPSNN);
		eval 'sub CPUISMIPSNNR2 () {0;}' unless defined(&CPUISMIPSNNR2);
		eval 'sub MIPS_HAS_R4K_MMU () {1;}' unless defined(&MIPS_HAS_R4K_MMU);
		eval 'sub MIPS_HAS_CLOCK () {1;}' unless defined(&MIPS_HAS_CLOCK);
		eval 'sub MIPS_HAS_LLSC () {1;}' unless defined(&MIPS_HAS_LLSC);
		eval 'sub MIPS_HAS_LLADDR () {(( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_NO_LLADDR) == 0);}' unless defined(&MIPS_HAS_LLADDR);
		eval 'sub MIPS_HAS_LMMI () {0;}' unless defined(&MIPS_HAS_LMMI);
		eval 'sub MIPS_HAS_DSP () {0;}' unless defined(&MIPS_HAS_DSP);
		eval 'sub MIPS_HAS_USERLOCAL () {0;}' unless defined(&MIPS_HAS_USERLOCAL);
	    }
 elsif(defined(&MIPS64R2)) {
		eval 'sub CPUISMIPS3 () {1;}' unless defined(&CPUISMIPS3);
		eval 'sub CPUIS64BITS () {1;}' unless defined(&CPUIS64BITS);
		eval 'sub CPUISMIPS32 () {0;}' unless defined(&CPUISMIPS32);
		eval 'sub CPUISMIPS32R2 () {0;}' unless defined(&CPUISMIPS32R2);
		eval 'sub CPUISMIPS64 () {0;}' unless defined(&CPUISMIPS64);
		eval 'sub CPUISMIPS64R2 () {1;}' unless defined(&CPUISMIPS64R2);
		eval 'sub CPUISMIPSNN () {1;}' unless defined(&CPUISMIPSNN);
		eval 'sub CPUISMIPSNNR2 () {1;}' unless defined(&CPUISMIPSNNR2);
		eval 'sub MIPS_HAS_R4K_MMU () {1;}' unless defined(&MIPS_HAS_R4K_MMU);
		eval 'sub MIPS_HAS_CLOCK () {1;}' unless defined(&MIPS_HAS_CLOCK);
		eval 'sub MIPS_HAS_LLSC () {1;}' unless defined(&MIPS_HAS_LLSC);
		eval 'sub MIPS_HAS_LLADDR () {(( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_NO_LLADDR) == 0);}' unless defined(&MIPS_HAS_LLADDR);
		eval 'sub MIPS_HAS_LMMI () {0;}' unless defined(&MIPS_HAS_LMMI);
		eval 'sub MIPS_HAS_DSP () {( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_HAVE_DSP);}' unless defined(&MIPS_HAS_DSP);
		eval 'sub MIPS_HAS_USERLOCAL () {( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_HAVE_USERLOCAL);}' unless defined(&MIPS_HAS_USERLOCAL);
	    }
	} else {
	    if(defined(&MIPS1)) {
		eval 'sub MIPS_HAS_R4K_MMU () {( ($mips_options->{mips_has_r4k_mmu}));}' unless defined(&MIPS_HAS_R4K_MMU);
		eval 'sub MIPS_HAS_LLSC () {( ($mips_options->{mips_has_llsc}));}' unless defined(&MIPS_HAS_LLSC);
	    } else {
		eval 'sub MIPS_HAS_R4K_MMU () {1;}' unless defined(&MIPS_HAS_R4K_MMU);
		if(!defined(&MIPS3_4100)) {
		    eval 'sub MIPS_HAS_LLSC () {1;}' unless defined(&MIPS_HAS_LLSC);
		} else {
		    eval 'sub MIPS_HAS_LLSC () {( ($mips_options->{mips_has_llsc}));}' unless defined(&MIPS_HAS_LLSC);
		}
	    }
	    eval 'sub MIPS_HAS_LLADDR () {(( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_NO_LLADDR) == 0);}' unless defined(&MIPS_HAS_LLADDR);
	    eval 'sub MIPS_HAS_DSP () {( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_HAVE_DSP);}' unless defined(&MIPS_HAS_DSP);
	    eval 'sub MIPS_HAS_USERLOCAL () {( ($mips_options->{mips_cpu_flags}) &  &CPU_MIPS_HAVE_USERLOCAL);}' unless defined(&MIPS_HAS_USERLOCAL);
	    eval 'sub CPUISMIPS3 () {(( ($mips_options->{mips_cpu_arch}) & ( &CPU_ARCH_MIPS3 |  &CPU_ARCH_MIPS4 |  &CPU_ARCH_MIPS32 |  &CPU_ARCH_MIPS64)) != 0);}' unless defined(&CPUISMIPS3);
	    eval 'sub CPUISMIPS4 () {(( ($mips_options->{mips_cpu_arch}) &  &CPU_ARCH_MIPS4) != 0);}' unless defined(&CPUISMIPS4);
	    eval 'sub CPUISMIPS5 () {(( ($mips_options->{mips_cpu_arch}) &  &CPU_ARCH_MIPS5) != 0);}' unless defined(&CPUISMIPS5);
	    eval 'sub CPUISMIPS32 () {(( ($mips_options->{mips_cpu_arch}) &  &CPU_ARCH_MIPS32) != 0);}' unless defined(&CPUISMIPS32);
	    eval 'sub CPUISMIPS32R2 () {(( ($mips_options->{mips_cpu_arch}) &  &CPU_ARCH_MIPS32R2) != 0);}' unless defined(&CPUISMIPS32R2);
	    eval 'sub CPUISMIPS64 () {(( ($mips_options->{mips_cpu_arch}) &  &CPU_ARCH_MIPS64) != 0);}' unless defined(&CPUISMIPS64);
	    eval 'sub CPUISMIPS64R2 () {(( ($mips_options->{mips_cpu_arch}) &  &CPU_ARCH_MIPS64R2) != 0);}' unless defined(&CPUISMIPS64R2);
	    eval 'sub CPUISMIPSNN () {(( ($mips_options->{mips_cpu_arch}) & ( &CPU_ARCH_MIPS32 |  &CPU_ARCH_MIPS32R2 |  &CPU_ARCH_MIPS64 |  &CPU_ARCH_MIPS64R2)) != 0);}' unless defined(&CPUISMIPSNN);
	    eval 'sub CPUISMIPSNNR2 () {(( ($mips_options->{mips_cpu_arch}) & ( &CPU_ARCH_MIPS32R2 |  &CPU_ARCH_MIPS64R2)) != 0);}' unless defined(&CPUISMIPSNNR2);
	    eval 'sub CPUIS64BITS () {(( ($mips_options->{mips_cpu_arch}) & ( &CPU_ARCH_MIPS3 |  &CPU_ARCH_MIPS4 |  &CPU_ARCH_MIPS64 |  &CPU_ARCH_MIPS64R2)) != 0);}' unless defined(&CPUIS64BITS);
	    eval 'sub MIPS_HAS_CLOCK () {( ($mips_options->{mips_cpu_arch}) >=  &CPU_ARCH_MIPS3);}' unless defined(&MIPS_HAS_CLOCK);
	}
	unless(defined(&__ASSEMBLER__)) {
	    if(defined(&__mips_n32) || defined(&__mips_n64) || defined(&__mips_o64)) {
	    }
	    if(defined(&__mips_n32) || defined(&__mips_n64) || defined(&__mips_o64)) {
	    }
	    eval 'sub fixup_addr2offset {
	        my($x) = @_;
    		eval q((((( &uint32_t)( &uintptr_t)($x)) << 4) >> 6));
	    }' unless defined(&fixup_addr2offset);
	    if(defined(&MIPS1)) {
	    }
	    if(defined(&MIPS3_PLUS)) {
		if(defined(&MIPSNN)) {
		    if(defined(&MIPSNNR2)) {
		    }
		}
	    }
	    if(defined(&MIPS3_64BIT)) {
		if(defined(&__mips_o32)) {
		} else {
		}
	    }
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub mips_lbu {
	        my($addr) = @_;
    		eval q({  &uint8_t  &rv;  &rv; });
	    }' unless defined(&mips_lbu);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub mips_lhu {
	        my($addr) = @_;
    		eval q({  &uint16_t  &rv;  &rv; });
	    }' unless defined(&mips_lhu);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub mips_lwu {
	        my($addr) = @_;
    		eval q({  &uint32_t  &rv; ( &rv); });
	    }' unless defined(&mips_lwu);
	    if(defined(&MIPS3_64BIT)  && !defined(&__mips_o32)) {
# some #ifdef were dropped here -- fill in the blanks
		eval 'sub mips3_ld {
		    my($addr) = @_;
    		    eval q({  &uint64_t  &rv; ( &rv); });
		}' unless defined(&mips3_ld);
	    }
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub mips_sb {
	        my($addr,$val) = @_;
    		eval q({ });
	    }' unless defined(&mips_sb);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub mips_sh {
	        my($addr,$val) = @_;
    		eval q({ });
	    }' unless defined(&mips_sh);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub mips_sw {
	        my($addr,$val) = @_;
    		eval q({ });
	    }' unless defined(&mips_sw);
	    if(defined(&MIPS3_64BIT)  && !defined(&__mips_o32)) {
# some #ifdef were dropped here -- fill in the blanks
		eval 'sub mips3_sd {
		    my($addr,$val) = @_;
    		    eval q({ });
		}' unless defined(&mips3_sd);
	    }
	    if(defined(&MULTIPROCESSOR)) {
	    }
	    eval 'sub MIPS_PRID_REV {
	        my($x) = @_;
    		eval q(((($x) >> 0) & 0xff));
	    }' unless defined(&MIPS_PRID_REV);
	    eval 'sub MIPS_PRID_IMPL {
	        my($x) = @_;
    		eval q(((($x) >> 8) & 0xff));
	    }' unless defined(&MIPS_PRID_IMPL);
	    eval 'sub MIPS_PRID_RSVD {
	        my($x) = @_;
    		eval q(((($x) >> 16) & 0xffff));
	    }' unless defined(&MIPS_PRID_RSVD);
	    eval 'sub MIPS_PRID_REV_MIN {
	        my($x) = @_;
    		eval q((( &MIPS_PRID_REV($x) >> 0) & 0xf));
	    }' unless defined(&MIPS_PRID_REV_MIN);
	    eval 'sub MIPS_PRID_REV_MAJ {
	        my($x) = @_;
    		eval q((( &MIPS_PRID_REV($x) >> 4) & 0xf));
	    }' unless defined(&MIPS_PRID_REV_MAJ);
	    eval 'sub MIPS_PRID_CID {
	        my($x) = @_;
    		eval q(((($x) >> 16) & 0xff));
	    }' unless defined(&MIPS_PRID_CID);
	    eval 'sub MIPS_PRID_CID_PREHISTORIC () {0x;}' unless defined(&MIPS_PRID_CID_PREHISTORIC);
	    eval 'sub MIPS_PRID_CID_MTI () {0x1;}' unless defined(&MIPS_PRID_CID_MTI);
	    eval 'sub MIPS_PRID_CID_BROADCOM () {0x2;}' unless defined(&MIPS_PRID_CID_BROADCOM);
	    eval 'sub MIPS_PRID_CID_ALCHEMY () {0x3;}' unless defined(&MIPS_PRID_CID_ALCHEMY);
	    eval 'sub MIPS_PRID_CID_SIBYTE () {0x4;}' unless defined(&MIPS_PRID_CID_SIBYTE);
	    eval 'sub MIPS_PRID_CID_SANDCRAFT () {0x5;}' unless defined(&MIPS_PRID_CID_SANDCRAFT);
	    eval 'sub MIPS_PRID_CID_PHILIPS () {0x6;}' unless defined(&MIPS_PRID_CID_PHILIPS);
	    eval 'sub MIPS_PRID_CID_TOSHIBA () {0x7;}' unless defined(&MIPS_PRID_CID_TOSHIBA);
	    eval 'sub MIPS_PRID_CID_MICROSOFT () {0x7;}' unless defined(&MIPS_PRID_CID_MICROSOFT);
	    eval 'sub MIPS_PRID_CID_LSI () {0x8;}' unless defined(&MIPS_PRID_CID_LSI);
	    eval 'sub MIPS_PRID_CID_LEXRA () {0xb;}' unless defined(&MIPS_PRID_CID_LEXRA);
	    eval 'sub MIPS_PRID_CID_RMI () {0xc;}' unless defined(&MIPS_PRID_CID_RMI);
	    eval 'sub MIPS_PRID_CID_CAVIUM () {0xd;}' unless defined(&MIPS_PRID_CID_CAVIUM);
	    eval 'sub MIPS_PRID_CID_INGENIC () {0xe1;}' unless defined(&MIPS_PRID_CID_INGENIC);
	    eval 'sub MIPS_PRID_COPTS {
	        my($x) = @_;
    		eval q(((($x) >> 24) & 0xff));
	    }' unless defined(&MIPS_PRID_COPTS);
	    if(defined(&__HAVE_MIPS_MACHDEP_CACHE_CONFIG)) {
	    }
	    if(0) {
		eval 'sub TF_AST () {0;}' unless defined(&TF_AST);
		eval 'sub TF_V0 () { &_R_V0;}' unless defined(&TF_V0);
		eval 'sub TF_V1 () { &_R_V1;}' unless defined(&TF_V1);
		eval 'sub TF_A0 () { &_R_A0;}' unless defined(&TF_A0);
		eval 'sub TF_A1 () { &_R_A1;}' unless defined(&TF_A1);
		eval 'sub TF_A2 () { &_R_A2;}' unless defined(&TF_A2);
		eval 'sub TF_A3 () { &_R_A3;}' unless defined(&TF_A3);
		eval 'sub TF_T0 () { &_R_T0;}' unless defined(&TF_T0);
		eval 'sub TF_T1 () { &_R_T1;}' unless defined(&TF_T1);
		eval 'sub TF_T2 () { &_R_T2;}' unless defined(&TF_T2);
		eval 'sub TF_T3 () { &_R_T3;}' unless defined(&TF_T3);
		if(defined(&__mips_n32) || defined(&__mips_n64)) {
		    eval 'sub TF_A4 () { &_R_A4;}' unless defined(&TF_A4);
		    eval 'sub TF_A5 () { &_R_A5;}' unless defined(&TF_A5);
		    eval 'sub TF_A6 () { &_R_A6;}' unless defined(&TF_A6);
		    eval 'sub TF_A7 () { &_R_A7;}' unless defined(&TF_A7);
		} else {
		    eval 'sub TF_T4 () { &_R_T4;}' unless defined(&TF_T4);
		    eval 'sub TF_T5 () { &_R_T5;}' unless defined(&TF_T5);
		    eval 'sub TF_T6 () { &_R_T6;}' unless defined(&TF_T6);
		    eval 'sub TF_T7 () { &_R_T7;}' unless defined(&TF_T7);
		}
		eval 'sub TF_TA0 () { &_R_TA0;}' unless defined(&TF_TA0);
		eval 'sub TF_TA1 () { &_R_TA1;}' unless defined(&TF_TA1);
		eval 'sub TF_TA2 () { &_R_TA2;}' unless defined(&TF_TA2);
		eval 'sub TF_TA3 () { &_R_TA3;}' unless defined(&TF_TA3);
		eval 'sub TF_T8 () { &_R_T8;}' unless defined(&TF_T8);
		eval 'sub TF_T9 () { &_R_T9;}' unless defined(&TF_T9);
		eval 'sub TF_RA () { &_R_RA;}' unless defined(&TF_RA);
		eval 'sub TF_SR () { &_R_SR;}' unless defined(&TF_SR);
		eval 'sub TF_MULLO () { &_R_MULLO;}' unless defined(&TF_MULLO);
		eval 'sub TF_MULHI () { &_R_MULHI;}' unless defined(&TF_MULHI);
		eval 'sub TF_EPC () { &_R_PC;}' unless defined(&TF_EPC);
		eval 'sub TF_NREGS () {($sizeof{\'struct reg\'} / $sizeof{ &mips_reg_t});}' unless defined(&TF_NREGS);
	    }
	    eval 'sub tf_regs () { ($tf_registers->{r_regs});}' unless defined(&tf_regs);
	    if(defined(&__mips_o32) || defined(&__mips_o64)) {
		if(defined(&__mips_o32)) {
		}
	    }
	    if(defined(&__mips_n32) || defined(&__mips_n64)) {
	    }
	    eval 'sub MIPS_CP0FL_USE () { &__BIT(0);}' unless defined(&MIPS_CP0FL_USE);
	    eval 'sub MIPS_CP0FL_ECC () { &__BIT(1);}' unless defined(&MIPS_CP0FL_ECC);
	    eval 'sub MIPS_CP0FL_CACHE_ERR () { &__BIT(2);}' unless defined(&MIPS_CP0FL_CACHE_ERR);
	    eval 'sub MIPS_CP0FL_EIRR () { &__BIT(3);}' unless defined(&MIPS_CP0FL_EIRR);
	    eval 'sub MIPS_CP0FL_EIMR () { &__BIT(4);}' unless defined(&MIPS_CP0FL_EIMR);
	    eval 'sub MIPS_CP0FL_EBASE () { &__BIT(5);}' unless defined(&MIPS_CP0FL_EBASE);
	    eval 'sub MIPS_CP0FL_CONFIG () { &__BIT(6);}' unless defined(&MIPS_CP0FL_CONFIG);
	    eval 'sub MIPS_CP0FL_CONFIG1 () { &__BIT(7);}' unless defined(&MIPS_CP0FL_CONFIG1);
	    eval 'sub MIPS_CP0FL_CONFIG2 () { &__BIT(8);}' unless defined(&MIPS_CP0FL_CONFIG2);
	    eval 'sub MIPS_CP0FL_CONFIG3 () { &__BIT(9);}' unless defined(&MIPS_CP0FL_CONFIG3);
	    eval 'sub MIPS_CP0FL_CONFIG4 () { &__BIT(10);}' unless defined(&MIPS_CP0FL_CONFIG4);
	    eval 'sub MIPS_CP0FL_CONFIG5 () { &__BIT(11);}' unless defined(&MIPS_CP0FL_CONFIG5);
	    eval 'sub MIPS_CP0FL_CONFIG6 () { &__BIT(12);}' unless defined(&MIPS_CP0FL_CONFIG6);
	    eval 'sub MIPS_CP0FL_CONFIG7 () { &__BIT(13);}' unless defined(&MIPS_CP0FL_CONFIG7);
	    eval 'sub MIPS_CIDFL_RMI_TYPE () { &__BITS(2,0);}' unless defined(&MIPS_CIDFL_RMI_TYPE);
	    eval 'sub CIDFL_RMI_TYPE_XLR () {0;}' unless defined(&CIDFL_RMI_TYPE_XLR);
	    eval 'sub CIDFL_RMI_TYPE_XLS () {1;}' unless defined(&CIDFL_RMI_TYPE_XLS);
	    eval 'sub CIDFL_RMI_TYPE_XLP () {2;}' unless defined(&CIDFL_RMI_TYPE_XLP);
	    eval 'sub MIPS_CIDFL_RMI_THREADS_MASK () { &__BITS(6,3);}' unless defined(&MIPS_CIDFL_RMI_THREADS_MASK);
	    eval 'sub MIPS_CIDFL_RMI_THREADS_SHIFT () {3;}' unless defined(&MIPS_CIDFL_RMI_THREADS_SHIFT);
	    eval 'sub MIPS_CIDFL_RMI_CORES_MASK () { &__BITS(10,7);}' unless defined(&MIPS_CIDFL_RMI_CORES_MASK);
	    eval 'sub MIPS_CIDFL_RMI_CORES_SHIFT () {7;}' unless defined(&MIPS_CIDFL_RMI_CORES_SHIFT);
	    eval 'sub LOG2_1 () {0;}' unless defined(&LOG2_1);
	    eval 'sub LOG2_2 () {1;}' unless defined(&LOG2_2);
	    eval 'sub LOG2_4 () {2;}' unless defined(&LOG2_4);
	    eval 'sub LOG2_8 () {3;}' unless defined(&LOG2_8);
	    eval 'sub MIPS_CIDFL_RMI_CPUS {
	        my($ncores, $nthreads) = @_;
    		eval q((( &LOG2_  $ncores <<  &MIPS_CIDFL_RMI_CORES_SHIFT) |( &LOG2_  $nthreads <<  &MIPS_CIDFL_RMI_THREADS_SHIFT)));
	    }' unless defined(&MIPS_CIDFL_RMI_CPUS);
	    eval 'sub MIPS_CIDFL_RMI_NTHREADS {
	        my($cidfl) = @_;
    		eval q((1<< ((($cidfl) &  &MIPS_CIDFL_RMI_THREADS_MASK) >>  &MIPS_CIDFL_RMI_THREADS_SHIFT)));
	    }' unless defined(&MIPS_CIDFL_RMI_NTHREADS);
	    eval 'sub MIPS_CIDFL_RMI_NCORES {
	        my($cidfl) = @_;
    		eval q((1<< ((($cidfl) &  &MIPS_CIDFL_RMI_CORES_MASK) >>  &MIPS_CIDFL_RMI_CORES_SHIFT)));
	    }' unless defined(&MIPS_CIDFL_RMI_NCORES);
	    eval 'sub MIPS_CIDFL_RMI_L2SZ_MASK () { &__BITS(14,11);}' unless defined(&MIPS_CIDFL_RMI_L2SZ_MASK);
	    eval 'sub MIPS_CIDFL_RMI_L2SZ_SHIFT () {11;}' unless defined(&MIPS_CIDFL_RMI_L2SZ_SHIFT);
	    eval 'sub RMI_L2SZ_256KB () {0;}' unless defined(&RMI_L2SZ_256KB);
	    eval 'sub RMI_L2SZ_512KB () {1;}' unless defined(&RMI_L2SZ_512KB);
	    eval 'sub RMI_L2SZ_1MB () {2;}' unless defined(&RMI_L2SZ_1MB);
	    eval 'sub RMI_L2SZ_2MB () {3;}' unless defined(&RMI_L2SZ_2MB);
	    eval 'sub RMI_L2SZ_4MB () {4;}' unless defined(&RMI_L2SZ_4MB);
	    eval 'sub MIPS_CIDFL_RMI_L2 {
	        my($l2sz) = @_;
    		eval q(( &RMI_L2SZ_  $l2sz <<  &MIPS_CIDFL_RMI_L2SZ_SHIFT));
	    }' unless defined(&MIPS_CIDFL_RMI_L2);
	    eval 'sub MIPS_CIDFL_RMI_L2SZ {
	        my($cidfl) = @_;
    		eval q(((256*1024) << ((($cidfl) &  &MIPS_CIDFL_RMI_L2SZ_MASK) >>  &MIPS_CIDFL_RMI_L2SZ_SHIFT)));
	    }' unless defined(&MIPS_CIDFL_RMI_L2SZ);
	}
    }
}
1;
