require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__MIPS_PTE_H__)) {
    eval 'sub __MIPS_PTE_H__ () {1;}' unless defined(&__MIPS_PTE_H__);
    require 'mips/mips1_pte.ph';
    require 'mips/mips3_pte.ph';
    eval 'sub PG_ASID () {0xff;}' unless defined(&PG_ASID);
    unless(defined(&_LOCORE)) {
	unless(defined(&__BSD_PTENTRY_T__)) {
	    eval 'sub __BSD_PTENTRY_T__ () {1;}' unless defined(&__BSD_PTENTRY_T__);
	    eval 'sub PRIxPTE () { &PRIx32;}' unless defined(&PRIxPTE);
	}
	eval 'sub mips_pg_nv_bit () {
	    eval q(( &MIPS1_PG_NV));
	}' unless defined(&mips_pg_nv_bit);
	if(defined(&MIPS1)  && !defined(&MIPS3_PLUS)) {
	    eval 'sub mips_pg_v {
	        my($entry) = @_;
    		eval q((($entry) &  &MIPS1_PG_V));
	    }' unless defined(&mips_pg_v);
	    eval 'sub mips_pg_wired {
	        my($entry) = @_;
    		eval q((($entry) &  &MIPS1_PG_WIRED));
	    }' unless defined(&mips_pg_wired);
	    eval 'sub mips_pg_m_bit () {
	        eval q(( &MIPS1_PG_D));
	    }' unless defined(&mips_pg_m_bit);
	    eval 'sub mips_pg_rw_bit () {
	        eval q(( &MIPS1_PG_RW));
	    }' unless defined(&mips_pg_rw_bit);
	    eval 'sub mips_pg_ro_bit () {
	        eval q(( &MIPS1_PG_RO));
	    }' unless defined(&mips_pg_ro_bit);
	    eval 'sub mips_pg_ropage_bit () {
	        eval q(( &MIPS1_PG_RO));
	    }' unless defined(&mips_pg_ropage_bit);
	    eval 'sub mips_pg_rwpage_bit () {
	        eval q(( &MIPS1_PG_RWPAGE));
	    }' unless defined(&mips_pg_rwpage_bit);
	    eval 'sub mips_pg_rwncpage_bit () {
	        eval q(( &MIPS1_PG_RWNCPAGE));
	    }' unless defined(&mips_pg_rwncpage_bit);
	    eval 'sub mips_pg_cwpage_bit () {
	        eval q(( &MIPS1_PG_CWPAGE));
	    }' unless defined(&mips_pg_cwpage_bit);
	    eval 'sub mips_pg_cwncpage_bit () {
	        eval q(( &MIPS1_PG_CWNCPAGE));
	    }' unless defined(&mips_pg_cwncpage_bit);
	    eval 'sub mips_pg_global_bit () {
	        eval q(( &MIPS1_PG_G));
	    }' unless defined(&mips_pg_global_bit);
	    eval 'sub mips_pg_wired_bit () {
	        eval q(( &MIPS1_PG_WIRED));
	    }' unless defined(&mips_pg_wired_bit);
	    eval 'sub pte_to_paddr {
	        my($pte) = @_;
    		eval q( &MIPS1_PTE_TO_PADDR(($pte)));
	    }' unless defined(&pte_to_paddr);
	    eval 'sub PAGE_IS_RDONLY {
	        my($pte, $va) = @_;
    		eval q( &MIPS1_PAGE_IS_RDONLY(($pte), ($va)));
	    }' unless defined(&PAGE_IS_RDONLY);
	    eval 'sub mips_tlbpfn_to_paddr {
	        my($x) = @_;
    		eval q( &mips1_tlbpfn_to_paddr(( &vaddr_t)($x)));
	    }' unless defined(&mips_tlbpfn_to_paddr);
	    eval 'sub mips_paddr_to_tlbpfn {
	        my($x) = @_;
    		eval q( &mips1_paddr_to_tlbpfn(($x)));
	    }' unless defined(&mips_paddr_to_tlbpfn);
	}
	if(!defined(&MIPS1)  && defined(&MIPS3_PLUS)) {
	    eval 'sub mips_pg_v {
	        my($entry) = @_;
    		eval q((($entry) &  &MIPS3_PG_V));
	    }' unless defined(&mips_pg_v);
	    eval 'sub mips_pg_wired {
	        my($entry) = @_;
    		eval q((($entry) &  &MIPS3_PG_WIRED));
	    }' unless defined(&mips_pg_wired);
	    eval 'sub mips_pg_m_bit () {
	        eval q(( &MIPS3_PG_D));
	    }' unless defined(&mips_pg_m_bit);
	    eval 'sub mips_pg_rw_bit () {
	        eval q(( &MIPS3_PG_D));
	    }' unless defined(&mips_pg_rw_bit);
	    eval 'sub mips_pg_ro_bit () {
	        eval q(( &MIPS3_PG_RO));
	    }' unless defined(&mips_pg_ro_bit);
	    eval 'sub mips_pg_ropage_bit () {
	        eval q(( &MIPS3_PG_ROPAGE));
	    }' unless defined(&mips_pg_ropage_bit);
	    eval 'sub mips_pg_rwpage_bit () {
	        eval q(( &MIPS3_PG_RWPAGE));
	    }' unless defined(&mips_pg_rwpage_bit);
	    eval 'sub mips_pg_rwncpage_bit () {
	        eval q(( &MIPS3_PG_RWNCPAGE));
	    }' unless defined(&mips_pg_rwncpage_bit);
	    eval 'sub mips_pg_cwpage_bit () {
	        eval q(( &MIPS3_PG_CWPAGE));
	    }' unless defined(&mips_pg_cwpage_bit);
	    eval 'sub mips_pg_cwncpage_bit () {
	        eval q(( &MIPS3_PG_CWNCPAGE));
	    }' unless defined(&mips_pg_cwncpage_bit);
	    eval 'sub mips_pg_global_bit () {
	        eval q(( &MIPS3_PG_G));
	    }' unless defined(&mips_pg_global_bit);
	    eval 'sub mips_pg_wired_bit () {
	        eval q(( &MIPS3_PG_WIRED));
	    }' unless defined(&mips_pg_wired_bit);
	    eval 'sub pte_to_paddr {
	        my($pte) = @_;
    		eval q( &MIPS3_PTE_TO_PADDR(($pte)));
	    }' unless defined(&pte_to_paddr);
	    eval 'sub PAGE_IS_RDONLY {
	        my($pte, $va) = @_;
    		eval q( &MIPS3_PAGE_IS_RDONLY(($pte), ($va)));
	    }' unless defined(&PAGE_IS_RDONLY);
	    eval 'sub mips_tlbpfn_to_paddr {
	        my($x) = @_;
    		eval q( &mips3_tlbpfn_to_paddr(( &vaddr_t)($x)));
	    }' unless defined(&mips_tlbpfn_to_paddr);
	    eval 'sub mips_paddr_to_tlbpfn {
	        my($x) = @_;
    		eval q( &mips3_paddr_to_tlbpfn(($x)));
	    }' unless defined(&mips_paddr_to_tlbpfn);
	}
	if(defined(&MIPS1)  && defined(&MIPS3_PLUS)) {
	    eval 'sub mips_pg_v {
	        my($entry) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ($entry &  &MIPS3_PG_V) != 0; ($entry &  &MIPS1_PG_V) != 0; });
	    }' unless defined(&mips_pg_v);
	    eval 'sub mips_pg_wired {
	        my($entry) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ($entry &  &MIPS3_PG_WIRED) != 0; ($entry &  &MIPS1_PG_WIRED) != 0; });
	    }' unless defined(&mips_pg_wired);
	    eval 'sub mips_pg_m_bit {
	        my($void) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PG_D); ( &MIPS1_PG_D); });
	    }' unless defined(&mips_pg_m_bit);
	    eval 'sub mips_pg_ro_bit {
	        my($void) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PG_RO); ( &MIPS1_PG_RO); });
	    }' unless defined(&mips_pg_ro_bit);
	    eval 'sub mips_pg_rw_bit {
	        my($void) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PG_D); ( &MIPS1_PG_RW); });
	    }' unless defined(&mips_pg_rw_bit);
	    eval 'sub mips_pg_ropage_bit {
	        my($void) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PG_ROPAGE); ( &MIPS1_PG_RO); });
	    }' unless defined(&mips_pg_ropage_bit);
	    eval 'sub mips_pg_rwpage_bit {
	        my($void) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PG_RWPAGE); ( &MIPS1_PG_RWPAGE); });
	    }' unless defined(&mips_pg_rwpage_bit);
	    eval 'sub mips_pg_cwpage_bit {
	        my($void) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PG_CWPAGE); ( &MIPS1_PG_CWPAGE); });
	    }' unless defined(&mips_pg_cwpage_bit);
	    eval 'sub mips_pg_global_bit {
	        my($void) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PG_G); ( &MIPS1_PG_G); });
	    }' unless defined(&mips_pg_global_bit);
	    eval 'sub mips_pg_wired_bit {
	        my($void) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PG_WIRED); ( &MIPS1_PG_WIRED); });
	    }' unless defined(&mips_pg_wired_bit);
	    eval 'sub pte_to_paddr {
	        my($pte) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PTE_TO_PADDR($pte)); ( &MIPS1_PTE_TO_PADDR($pte)); });
	    }' unless defined(&pte_to_paddr);
	    eval 'sub PAGE_IS_RDONLY {
	        my($pte,$va) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &MIPS3_PAGE_IS_RDONLY($pte, $va)); ( &MIPS1_PAGE_IS_RDONLY($pte, $va)); });
	    }' unless defined(&PAGE_IS_RDONLY);
	    eval 'sub mips_tlbpfn_to_paddr {
	        my($pfn) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &mips3_tlbpfn_to_paddr($pfn)); ( &mips1_tlbpfn_to_paddr($pfn)); });
	    }' unless defined(&mips_tlbpfn_to_paddr);
	    eval 'sub mips_paddr_to_tlbpfn {
	        my($pa) = @_;
    		eval q({  &if ( &MIPS_HAS_R4K_MMU) ( &mips3_paddr_to_tlbpfn($pa)); ( &mips1_paddr_to_tlbpfn($pa)); });
	    }' unless defined(&mips_paddr_to_tlbpfn);
	}
    }
    if(defined(&_KERNEL)  && !defined(&_LOCORE)) {
	eval 'sub MIPS_MMU {
	    my($X) = @_;
    	    eval q(( &MIPS_HAS_R4K_MMU ?  &MIPS3_$X :  &MIPS1_$X));
	}' unless defined(&MIPS_MMU);
	eval 'sub pte_valid_p {
	    my($pte) = @_;
    	    eval q({ ($pte &  &MIPS_MMU( &PG_V)) != 0; });
	}' unless defined(&pte_valid_p);
	eval 'sub pte_modified_p {
	    my($pte) = @_;
    	    eval q({ ($pte &  &MIPS_MMU( &PG_D)) != 0; });
	}' unless defined(&pte_modified_p);
	eval 'sub pte_global_p {
	    my($pte) = @_;
    	    eval q({ ($pte &  &MIPS_MMU( &PG_G)) != 0; });
	}' unless defined(&pte_global_p);
	eval 'sub pte_wired_p {
	    my($pte) = @_;
    	    eval q({ ($pte &  &MIPS_MMU( &PG_WIRED)) != 0; });
	}' unless defined(&pte_wired_p);
	eval 'sub pte_wire_entry {
	    my($pte) = @_;
    	    eval q({ $pte |  &MIPS_MMU( &PG_WIRED); });
	}' unless defined(&pte_wire_entry);
	eval 'sub pte_unwire_entry {
	    my($pte) = @_;
    	    eval q({ $pte & ~ &MIPS_MMU( &PG_WIRED); });
	}' unless defined(&pte_unwire_entry);
	eval 'sub pte_value {
	    my($pte) = @_;
    	    eval q({ $pte; });
	}' unless defined(&pte_value);
	eval 'sub pte_readonly_p {
	    my($pte) = @_;
    	    eval q({ ($pte &  &MIPS_MMU( &PG_RO)) != 0; });
	}' unless defined(&pte_readonly_p);
	eval 'sub pte_cached_p {
	    my($pte) = @_;
    	    eval q({  &if ( &MIPS_HAS_R4K_MMU) {  &MIPS3_PG_TO_CCA($pte) ==  &MIPS3_PG_TO_CCA( ($mips_options->{mips3_pg_cached})); }  &else { ($pte &  &MIPS1_PG_N) == 0; } });
	}' unless defined(&pte_cached_p);
	eval 'sub pte_deferred_exec_p {
	    my($pte) = @_;
    	    eval q({  &false; });
	}' unless defined(&pte_deferred_exec_p);
	eval 'sub pte_nv_entry {
	    my($kernel_p) = @_;
    	    eval q({  &__CTASSERT( &MIPS1_PG_NV ==  &MIPS3_PG_NV);  &__CTASSERT( &MIPS1_PG_NV == 0); ($kernel_p  &&  &MIPS_HAS_R4K_MMU) ?  &MIPS3_PG_G : 0; });
	}' unless defined(&pte_nv_entry);
	eval 'sub pte_prot_downgrade {
	    my($pte,$prot) = @_;
    	    eval q({  &const  &uint32_t  &ro_bit =  &MIPS_MMU( &PG_RO);  &const  &uint32_t  &rw_bit =  &MIPS_MMU( &PG_D); ($pte & ~( &ro_bit| &rw_bit)) | (($prot &  &VM_PROT_WRITE) ?  &rw_bit :  &ro_bit); });
	}' unless defined(&pte_prot_downgrade);
	eval 'sub pte_prot_nowrite {
	    my($pte) = @_;
    	    eval q({ $pte & ~ &MIPS_MMU( &PG_D); });
	}' unless defined(&pte_prot_nowrite);
	eval 'sub pte_cached_change {
	    my($pte,$cached) = @_;
    	    eval q({  &if ( &MIPS_HAS_R4K_MMU) { $pte &= ~ &MIPS3_PG_CACHEMODE; $pte |= ($cached ?  &MIPS3_PG_CACHED :  &MIPS3_PG_UNCACHED); } $pte; });
	}' unless defined(&pte_cached_change);
	eval 'sub pte_set {
	    my($ptep,$pte) = @_;
    	    eval q({ *$ptep = $pte; });
	}' unless defined(&pte_set);
	if(defined(&__PMAP_PRIVATE)) {
	    eval 'sub pte_make_kenter_pa {
	        my($pa,$mdpg,$prot,$flags) = @_;
    		eval q({  &pt_entry_t  &pte;  &if ( &MIPS_HAS_R4K_MMU) {  &pte =  &mips3_paddr_to_tlbpfn($pa) | (($prot &  &VM_PROT_WRITE) ?  &MIPS3_PG_D :  &MIPS3_PG_RO) | (($flags &  &PMAP_NOCACHE) ?  &MIPS3_PG_UNCACHED :  &MIPS3_PG_CACHED) |  &MIPS3_PG_WIRED |  &MIPS3_PG_V |  &MIPS3_PG_G; }  &else {  &pte =  &mips1_paddr_to_tlbpfn($pa) | (($prot &  &VM_PROT_WRITE) ?  &MIPS1_PG_D :  &MIPS1_PG_RO) | (($flags &  &PMAP_NOCACHE) ?  &MIPS1_PG_N : 0) |  &MIPS1_PG_WIRED |  &MIPS1_PG_V |  &MIPS1_PG_G; }  &pte; });
	    }' unless defined(&pte_make_kenter_pa);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub pte_make_enter {
	        my($pa,$mdpg,$prot,$flags,$is_kernel_pmap_p) = @_;
    		eval q({  &pt_entry_t  &pte;  &if ($mdpg !=  &NULL) {  &if (($prot &  &VM_PROT_WRITE) == 0) {  &pte =  &mips_pg_ropage_bit(); }  &else {  &if ( &VM_PAGEMD_MODIFIED_P($mdpg)) {  &pte =  &mips_pg_rwpage_bit(); }  &else {  &pte =  &mips_pg_cwpage_bit(); } } }  &else  &if ( &MIPS_HAS_R4K_MMU) { \'u_int\'  &cca =  &PMAP_CCA_FOR_PA($pa);  &pte =  &MIPS3_PG_IOPAGE( &cca) & ~ &MIPS3_PG_G; }  &else  &if ($prot &  &VM_PROT_WRITE) {  &pte =  &MIPS1_PG_N |  &MIPS1_PG_D; }  &else {  &pte =  &MIPS1_PG_N |  &MIPS1_PG_RO; }  &if ( &MIPS_HAS_R4K_MMU) {  &pte |=  &mips3_paddr_to_tlbpfn($pa) | ($is_kernel_pmap_p ?  &MIPS3_PG_G : 0); }  &else {  &pte |=  &mips1_paddr_to_tlbpfn($pa) |  &MIPS1_PG_V | ($is_kernel_pmap_p ?  &MIPS1_PG_G : 0); }  &pte; });
	    }' unless defined(&pte_make_enter);
	}
    }
}
1;
