require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_BN_H)) {
    eval 'sub OPENSSL_BN_H () {1;}' unless defined(&OPENSSL_BN_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_BN_H () {1;}' unless defined(&HEADER_BN_H);
    }
    require 'openssl/e_os2.ph';
    unless(defined(&OPENSSL_NO_STDIO)) {
	require 'stdio.ph';
    }
    require 'openssl/opensslconf.ph';
    require 'openssl/types.ph';
    require 'openssl/crypto.ph';
    require 'openssl/bnerr.ph';
    if(defined(&__cplusplus)) {
    }
    if(defined(&SIXTY_FOUR_BIT_LONG)) {
	eval 'sub BN_ULONG () {\'unsigned long\';}' unless defined(&BN_ULONG);
	eval 'sub BN_BYTES () {8;}' unless defined(&BN_BYTES);
    }
    if(defined(&SIXTY_FOUR_BIT)) {
	eval 'sub BN_ULONG () {\'unsigned long long\';}' unless defined(&BN_ULONG);
	eval 'sub BN_BYTES () {8;}' unless defined(&BN_BYTES);
    }
    if(defined(&THIRTY_TWO_BIT)) {
	eval 'sub BN_ULONG () {\'unsigned int\';}' unless defined(&BN_ULONG);
	eval 'sub BN_BYTES () {4;}' unless defined(&BN_BYTES);
    }
    eval 'sub BN_BITS2 () {( &BN_BYTES * 8);}' unless defined(&BN_BITS2);
    eval 'sub BN_BITS () {( &BN_BITS2 * 2);}' unless defined(&BN_BITS);
    eval 'sub BN_TBIT () {(( &BN_ULONG)1<< ( &BN_BITS2 - 1));}' unless defined(&BN_TBIT);
    eval 'sub BN_FLG_MALLOCED () {0x1;}' unless defined(&BN_FLG_MALLOCED);
    eval 'sub BN_FLG_STATIC_DATA () {0x2;}' unless defined(&BN_FLG_STATIC_DATA);
    eval 'sub BN_FLG_CONSTTIME () {0x4;}' unless defined(&BN_FLG_CONSTTIME);
    eval 'sub BN_FLG_SECURE () {0x8;}' unless defined(&BN_FLG_SECURE);
    unless(defined(&OPENSSL_NO_DEPRECATED_0_9_8)) {
	eval 'sub BN_FLG_EXP_CONSTTIME () { &BN_FLG_CONSTTIME;}' unless defined(&BN_FLG_EXP_CONSTTIME);
	eval 'sub BN_FLG_FREE () {0x8000;}' unless defined(&BN_FLG_FREE);
    }
    eval 'sub BN_RAND_TOP_ANY () {-1;}' unless defined(&BN_RAND_TOP_ANY);
    eval 'sub BN_RAND_TOP_ONE () {0;}' unless defined(&BN_RAND_TOP_ONE);
    eval 'sub BN_RAND_TOP_TWO () {1;}' unless defined(&BN_RAND_TOP_TWO);
    eval 'sub BN_RAND_BOTTOM_ANY () {0;}' unless defined(&BN_RAND_BOTTOM_ANY);
    eval 'sub BN_RAND_BOTTOM_ODD () {1;}' unless defined(&BN_RAND_BOTTOM_ODD);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub BN_prime_checks () {0;}' unless defined(&BN_prime_checks);
	eval 'sub BN_prime_checks_for_size {
	    my($b) = @_;
    	    eval q((($b) >= 3747? 3: ($b) >= 1345? 4: ($b) >= 476? 5: ($b) >= 400? 6: ($b) >= 347? 7: ($b) >= 308? 8: ($b) >= 55? 27: 34));
	}' unless defined(&BN_prime_checks_for_size);
    }
    eval 'sub BN_num_bytes {
        my($a) = @_;
	    eval q((( &BN_num_bits($a)+7)/8));
    }' unless defined(&BN_num_bytes);
    eval 'sub BN_one {
        my($a) = @_;
	    eval q(( &BN_set_word(($a),1)));
    }' unless defined(&BN_one);
    if((defined(&OPENSSL_API_LEVEL) ? &OPENSSL_API_LEVEL : undef) > 908) {
	eval 'sub BN_zero {
	    my($a) = @_;
    	    eval q( &BN_zero_ex($a));
	}' unless defined(&BN_zero);
    } else {
	eval 'sub BN_zero {
	    my($a) = @_;
    	    eval q(( &BN_set_word(($a),0)));
	}' unless defined(&BN_zero);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub BN_mod {
        my($rem,$m,$d,$ctx) = @_;
	    eval q( &BN_div( &NULL,($rem),($m),($d),($ctx)));
    }' unless defined(&BN_mod);
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_0_9_8)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub BN_BLINDING_NO_UPDATE () {0x1;}' unless defined(&BN_BLINDING_NO_UPDATE);
    eval 'sub BN_BLINDING_NO_RECREATE () {0x2;}' unless defined(&BN_BLINDING_NO_RECREATE);
    unless(defined(&OPENSSL_NO_DEPRECATED_0_9_8)) {
    }
    unless(defined(&OPENSSL_NO_EC2M)) {
	eval 'sub BN_GF2m_sub {
	    my($r, $a, $b) = @_;
    	    eval q( &BN_GF2m_add($r, $a, $b));
	}' unless defined(&BN_GF2m_sub);
	eval 'sub BN_GF2m_cmp {
	    my($a, $b) = @_;
    	    eval q( &BN_ucmp(($a), ($b)));
	}' unless defined(&BN_GF2m_cmp);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub get_rfc2409_prime_768 () { &BN_get_rfc2409_prime_768;}' unless defined(&get_rfc2409_prime_768);
	eval 'sub get_rfc2409_prime_1024 () { &BN_get_rfc2409_prime_1024;}' unless defined(&get_rfc2409_prime_1024);
	eval 'sub get_rfc3526_prime_1536 () { &BN_get_rfc3526_prime_1536;}' unless defined(&get_rfc3526_prime_1536);
	eval 'sub get_rfc3526_prime_2048 () { &BN_get_rfc3526_prime_2048;}' unless defined(&get_rfc3526_prime_2048);
	eval 'sub get_rfc3526_prime_3072 () { &BN_get_rfc3526_prime_3072;}' unless defined(&get_rfc3526_prime_3072);
	eval 'sub get_rfc3526_prime_4096 () { &BN_get_rfc3526_prime_4096;}' unless defined(&get_rfc3526_prime_4096);
	eval 'sub get_rfc3526_prime_6144 () { &BN_get_rfc3526_prime_6144;}' unless defined(&get_rfc3526_prime_6144);
	eval 'sub get_rfc3526_prime_8192 () { &BN_get_rfc3526_prime_8192;}' unless defined(&get_rfc3526_prime_8192);
    }
    if(defined(&__cplusplus)) {
    }
}
1;
