require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS_VMPARAM_H_)) {
    eval 'sub _MIPS_VMPARAM_H_ () {1;}' unless defined(&_MIPS_VMPARAM_H_);
    if(defined(&_KERNEL_OPT)) {
	require './mips/opt_cputype.ph';
	require './mips/opt_multiprocessor.ph';
	require './mips/opt_modular.ph';
    }
    if(defined(&ENABLE_MIPS_16KB_PAGE)) {
	eval 'sub PAGE_SHIFT () {14;}' unless defined(&PAGE_SHIFT);
    }
 elsif(defined(&ENABLE_MIPS_8KB_PAGE) || (!defined(&ENABLE_MIPS_4KB_PAGE)  && (defined(&__mips) ? &__mips : undef) >= 3)) {
	eval 'sub PAGE_SHIFT () {13;}' unless defined(&PAGE_SHIFT);
    } else {
	eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    }
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub MIN_PAGE_SHIFT () {12;}' unless defined(&MIN_PAGE_SHIFT);
    eval 'sub MAX_PAGE_SHIFT () {14;}' unless defined(&MAX_PAGE_SHIFT);
    eval 'sub MAX_PAGE_SIZE () {(1<<  &MAX_PAGE_SHIFT);}' unless defined(&MAX_PAGE_SIZE);
    eval 'sub MIN_PAGE_SIZE () {(1<<  &MIN_PAGE_SHIFT);}' unless defined(&MIN_PAGE_SIZE);
    eval 'sub USRSTACK () {( &VM_MAXUSER_ADDRESS-0x8000);}' unless defined(&USRSTACK);
    eval 'sub USRSTACK32 () {(( &uint32_t) &VM_MAXUSER_ADDRESS32-0x8000);}' unless defined(&USRSTACK32);
    if(defined(&__mips_o32)) {
	unless(defined(&MAXTSIZ)) {
	    eval 'sub MAXTSIZ () {(128*1024*1024);}' unless defined(&MAXTSIZ);
	}
	unless(defined(&DFLDSIZ)) {
	    eval 'sub DFLDSIZ () {(128*1024*1024);}' unless defined(&DFLDSIZ);
	}
	unless(defined(&MAXDSIZ)) {
	    eval 'sub MAXDSIZ () {(512*1024*1024);}' unless defined(&MAXDSIZ);
	}
	unless(defined(&DFLSSIZ)) {
	    eval 'sub DFLSSIZ () {(4*1024*1024);}' unless defined(&DFLSSIZ);
	}
	unless(defined(&MAXSSIZ)) {
	    eval 'sub MAXSSIZ () {(32*1024*1024);}' unless defined(&MAXSSIZ);
	}
    } else {
	unless(defined(&MAXTSIZ)) {
	    eval 'sub MAXTSIZ () {(128*1024*1024);}' unless defined(&MAXTSIZ);
	}
	unless(defined(&DFLDSIZ)) {
	    eval 'sub DFLDSIZ () {(256*1024*1024);}' unless defined(&DFLDSIZ);
	}
	unless(defined(&MAXDSIZ)) {
	    eval 'sub MAXDSIZ () {(1536*1024*1024);}' unless defined(&MAXDSIZ);
	}
	unless(defined(&DFLSSIZ)) {
	    eval 'sub DFLSSIZ () {(4*1024*1024);}' unless defined(&DFLSSIZ);
	}
	unless(defined(&MAXSSIZ)) {
	    eval 'sub MAXSSIZ () {(120*1024*1024);}' unless defined(&MAXSSIZ);
	}
    }
    unless(defined(&DFLDSIZ32)) {
	eval 'sub DFLDSIZ32 () { &DFLDSIZ;}' unless defined(&DFLDSIZ32);
    }
    unless(defined(&MAXDSIZ32)) {
	eval 'sub MAXDSIZ32 () { &MAXDSIZ;}' unless defined(&MAXDSIZ32);
    }
    unless(defined(&DFLSSIZ32)) {
	eval 'sub DFLSSIZ32 () { &DFLTSIZ;}' unless defined(&DFLSSIZ32);
    }
    unless(defined(&MAXSSIZ32)) {
	eval 'sub MAXSSIZ32 () { &MAXSSIZ;}' unless defined(&MAXSSIZ32);
    }
    unless(defined(&USRIOSIZE)) {
	eval 'sub USRIOSIZE () {( &MAXBSIZE/ &PAGE_SIZE * 8);}' unless defined(&USRIOSIZE);
    }
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)0x);}' unless defined(&VM_MIN_ADDRESS);
    if(defined(&_LP64)) {
	eval 'sub MIPS_VM_MAXUSER_ADDRESS () {(( &vaddr_t) 1 << 40);}' unless defined(&MIPS_VM_MAXUSER_ADDRESS);
	if(defined(&ENABLE_MIPS_16KB_PAGE)) {
	    eval 'sub VM_MAXUSER_ADDRESS () { &mips_vm_maxuser_address;}' unless defined(&VM_MAXUSER_ADDRESS);
	} else {
	    eval 'sub VM_MAXUSER_ADDRESS () { &MIPS_VM_MAXUSER_ADDRESS;}' unless defined(&VM_MAXUSER_ADDRESS);
	}
	eval 'sub VM_MAX_ADDRESS () { &VM_MAXUSER_ADDRESS;}' unless defined(&VM_MAX_ADDRESS);
	eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t) 3 << 62);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
	eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t) -1 << 31);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    } else {
	eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)-0x7fffffff-1);}' unless defined(&VM_MAXUSER_ADDRESS);
	eval 'sub VM_MAX_ADDRESS () {(( &vaddr_t)-0x7fffffff-1);}' unless defined(&VM_MAX_ADDRESS);
	eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)-0x40000000);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
	if(defined(&ENABLE_MIPS_TX3900)) {
	    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)-0x1000000);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
	} else {
	    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)-0x4000);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
	}
    }
    eval 'sub VM_MAXUSER_ADDRESS32 () {(( &vaddr_t)(1 << 31));}' unless defined(&VM_MAXUSER_ADDRESS32);
    eval 'sub __USE_TOPDOWN_VM () {1;}' unless defined(&__USE_TOPDOWN_VM);
    eval 'sub VM_DEFAULT_ADDRESS_TOPDOWN {
        my($da, $sz) = @_;
	    eval q( &trunc_page( &USRSTACK -  &MAXSSIZ - ($sz) -  &user_stack_guard_size));
    }' unless defined(&VM_DEFAULT_ADDRESS_TOPDOWN);
    eval 'sub VM_DEFAULT_ADDRESS_BOTTOMUP {
        my($da, $sz) = @_;
	    eval q( &round_page(( &vaddr_t)($da) + ( &vsize_t) &maxdmap));
    }' unless defined(&VM_DEFAULT_ADDRESS_BOTTOMUP);
    eval 'sub VM_DEFAULT_ADDRESS32_TOPDOWN {
        my($da, $sz) = @_;
	    eval q( &trunc_page( &USRSTACK32 -  &MAXSSIZ32 - ($sz) -  &user_stack_guard_size));
    }' unless defined(&VM_DEFAULT_ADDRESS32_TOPDOWN);
    eval 'sub VM_DEFAULT_ADDRESS32_BOTTOMUP {
        my($da, $sz) = @_;
	    eval q( &round_page(( &vaddr_t)($da) + ( &vsize_t) &MAXDSIZ32));
    }' unless defined(&VM_DEFAULT_ADDRESS32_BOTTOMUP);
    eval 'sub VM_PHYS_SIZE () {( &USRIOSIZE* &PAGE_SIZE);}' unless defined(&VM_PHYS_SIZE);
    eval 'sub VM_PHYSSEG_STRAT () { &VM_PSTRAT_BSEARCH;}' unless defined(&VM_PHYSSEG_STRAT);
    unless(defined(&VM_NFREELIST)) {
	eval 'sub VM_NFREELIST () {16;}' unless defined(&VM_NFREELIST);
	eval 'sub VM_FREELIST_DEFAULT () {0;}' unless defined(&VM_FREELIST_DEFAULT);
	eval 'sub VM_FREELIST_MAX () {1;}' unless defined(&VM_FREELIST_MAX);
    }
    if(defined(&_KERNEL)) {
	if(defined(&ENABLE_MIPS_16KB_PAGE)) {
	}
    }
}
1;
