require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_CPU_H_)) {
    eval 'sub _CPU_H_ () {1;}' unless defined(&_CPU_H_);
    if(defined(&_LOCORE)) {
	die("Use\ assym\.h\ to\ get\ definitions\ from\ \<mips\/cpu\.h\>");
    }
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	if(defined(&_KERNEL_OPT)) {
	    require './mips/opt_cputype.ph';
	    require './mips/opt_gprof.ph';
	    require './mips/opt_lockdebug.ph';
	    require './mips/opt_multiprocessor.ph';
	}
	require 'mips/frame.ph';
	require 'sys/cpu_data.ph';
	require 'sys/device_if.ph';
	require 'sys/evcnt.ph';
	require 'sys/kcpuset.ph';
	require 'sys/intr.ph';
	eval 'sub CPUWATCH_WRITE () { &__BIT(0);}' unless defined(&CPUWATCH_WRITE);
	eval 'sub CPUWATCH_READ () { &__BIT(1);}' unless defined(&CPUWATCH_READ);
	eval 'sub CPUWATCH_EXEC () { &__BIT(2);}' unless defined(&CPUWATCH_EXEC);
	eval 'sub CPUWATCH_MASK () { &__BIT(3);}' unless defined(&CPUWATCH_MASK);
	eval 'sub CPUWATCH_ASID () { &__BIT(4);}' unless defined(&CPUWATCH_ASID);
	eval 'sub CPUWATCH_RWX () {( &CPUWATCH_EXEC| &CPUWATCH_READ| &CPUWATCH_WRITE);}' unless defined(&CPUWATCH_RWX);
	eval 'sub CPUWATCH_MAX () {8;}' unless defined(&CPUWATCH_MAX);
	eval 'sub ci_pmap_user_segtab () { $ci_pmap_segtabs[0];}' unless defined(&ci_pmap_user_segtab);
	eval 'sub ci_pmap_kern_segtab () { $ci_pmap_segtabs[1];}' unless defined(&ci_pmap_kern_segtab);
	if(defined(&_LP64)) {
	    eval 'sub ci_pmap_user_seg0tab () { $ci_pmap_seg0tabs[0];}' unless defined(&ci_pmap_user_seg0tab);
	    eval 'sub ci_pmap_kern_seg0tab () { $ci_pmap_seg0tabs[1];}' unless defined(&ci_pmap_kern_seg0tab);
	}
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub CPUF_PRIMARY () { &__BIT(0);}' unless defined(&CPUF_PRIMARY);
	    eval 'sub CPUF_PRESENT () { &__BIT(1);}' unless defined(&CPUF_PRESENT);
	    eval 'sub CPUF_RUNNING () { &__BIT(2);}' unless defined(&CPUF_RUNNING);
	    eval 'sub CPUF_PAUSED () { &__BIT(3);}' unless defined(&CPUF_PAUSED);
	    eval 'sub CPUF_USERPMAP () { &__BIT(5);}' unless defined(&CPUF_USERPMAP);
	}
	if(defined(&GPROF)  && defined(&MULTIPROCESSOR)) {
	}
    }
    if(defined(&_KERNEL)) {
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q($cii = 0, $ci =  &cpu_info_store; $ci !=  &NULL; $cii++,  &ncpu ? ($ci =  $cpu_infos[$cii]) : ($ci =  &NULL));
	    }' unless defined(&CPU_INFO_FOREACH);
	} else {
	    eval 'sub CPU_INFO_ITERATOR () {\'int\'  &__unused;}' unless defined(&CPU_INFO_ITERATOR);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q($ci =  &cpu_info_store; $ci !=  &NULL; $ci =  &NULL);
	    }' unless defined(&CPU_INFO_FOREACH);
	}
	eval 'sub MIPS_CURLWP_QUOTED () {"$24";}' unless defined(&MIPS_CURLWP_QUOTED);
	eval 'sub MIPS_CURLWP_LABEL () { &_L_T8;}' unless defined(&MIPS_CURLWP_LABEL);
	eval 'sub MIPS_CURLWP_REG () { &_R_T8;}' unless defined(&MIPS_CURLWP_REG);
	if(defined(&MULTIPROCESSOR)) {
	}
	eval 'sub curlwp () { &mips_curlwp;}' unless defined(&curlwp);
	eval 'sub curcpu () {
	    eval q( &lwp_getcpu( &curlwp));
	}' unless defined(&curcpu);
	eval 'sub curpcb () {( &lwp_getpcb( &curlwp));}' unless defined(&curpcb);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub cpu_number () {
	        eval q(( &curcpu()-> &ci_index));
	    }' unless defined(&cpu_number);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_flags &  &CPUF_PRIMARY));
	    }' unless defined(&CPU_IS_PRIMARY);
	} else {
	    eval 'sub cpu_number () {
	        eval q((0));
	    }' unless defined(&cpu_number);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q(( &true));
	    }' unless defined(&CPU_IS_PRIMARY);
	}
	eval 'sub CLKF_USERMODE {
	    my($framep) = @_;
    	    eval q((($framep)-> &sr &  &cpu_clkf_usermode_mask()));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($framep) = @_;
    	    eval q((($framep)-> &pc + 0));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($framep) = @_;
    	    eval q((($framep)-> &intr + 0));
	}' unless defined(&CLKF_INTR);
	eval 'sub LWP_PC {
	    my($l) = @_;
    	    eval q( &cpu_lwp_pc($l));
	}' unless defined(&LWP_PC);
	if(defined(&_LP64)) {
	}
    }
    eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_BOOTED_KERNEL () {2;}' unless defined(&CPU_BOOTED_KERNEL);
    eval 'sub CPU_ROOT_DEVICE () {3;}' unless defined(&CPU_ROOT_DEVICE);
    eval 'sub CPU_LLSC () {4;}' unless defined(&CPU_LLSC);
    eval 'sub CPU_LMMI () {5;}' unless defined(&CPU_LMMI);
}
1;
