require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_X509_H)) {
    eval 'sub OPENSSL_X509_H () {1;}' unless defined(&OPENSSL_X509_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_X509_H () {1;}' unless defined(&HEADER_X509_H);
    }
    require 'openssl/e_os2.ph';
    require 'openssl/types.ph';
    require 'openssl/symhacks.ph';
    require 'openssl/buffer.ph';
    require 'openssl/evp.ph';
    require 'openssl/bio.ph';
    require 'openssl/asn1.ph';
    require 'openssl/safestack.ph';
    require 'openssl/ec.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	require 'openssl/rsa.ph';
	require 'openssl/dsa.ph';
	require 'openssl/dh.ph';
    }
    require 'openssl/sha.ph';
    require 'openssl/x509err.ph';
    unless(defined(&OPENSSL_NO_STDIO)) {
	require 'stdio.ph';
    }
    if(defined(&__cplusplus)) {
    }
    eval 'sub sk_X509_NAME_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_NAME_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_num);
    eval 'sub sk_X509_NAME_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_NAME *) &OPENSSL_sk_value( &ossl_check_const_X509_NAME_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_NAME_value);
    eval 'sub sk_X509_NAME_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_NAME) *) &OPENSSL_sk_new( &ossl_check_X509_NAME_compfunc_type($cmp))));
    }' unless defined(&sk_X509_NAME_new);
    eval 'sub sk_X509_NAME_new_null () {
        eval q((( &STACK_OF( &X509_NAME) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_NAME_new_null);
    eval 'sub sk_X509_NAME_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_NAME) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_NAME_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_NAME_new_reserve);
    eval 'sub sk_X509_NAME_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_NAME_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_NAME_reserve);
    eval 'sub sk_X509_NAME_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_NAME_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_free);
    eval 'sub sk_X509_NAME_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_NAME_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_zero);
    eval 'sub sk_X509_NAME_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_NAME *) &OPENSSL_sk_delete( &ossl_check_X509_NAME_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_NAME_delete);
    eval 'sub sk_X509_NAME_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_NAME *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_NAME_sk_type($sk),  &ossl_check_X509_NAME_type($ptr))));
    }' unless defined(&sk_X509_NAME_delete_ptr);
    eval 'sub sk_X509_NAME_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_NAME_sk_type($sk),  &ossl_check_X509_NAME_type($ptr)));
    }' unless defined(&sk_X509_NAME_push);
    eval 'sub sk_X509_NAME_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_NAME_sk_type($sk),  &ossl_check_X509_NAME_type($ptr)));
    }' unless defined(&sk_X509_NAME_unshift);
    eval 'sub sk_X509_NAME_pop {
        my($sk) = @_;
	    eval q((( &X509_NAME *) &OPENSSL_sk_pop( &ossl_check_X509_NAME_sk_type($sk))));
    }' unless defined(&sk_X509_NAME_pop);
    eval 'sub sk_X509_NAME_shift {
        my($sk) = @_;
	    eval q((( &X509_NAME *) &OPENSSL_sk_shift( &ossl_check_X509_NAME_sk_type($sk))));
    }' unless defined(&sk_X509_NAME_shift);
    eval 'sub sk_X509_NAME_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_NAME_sk_type($sk), &ossl_check_X509_NAME_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_NAME_pop_free);
    eval 'sub sk_X509_NAME_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_NAME_sk_type($sk),  &ossl_check_X509_NAME_type($ptr), ($idx)));
    }' unless defined(&sk_X509_NAME_insert);
    eval 'sub sk_X509_NAME_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_NAME *) &OPENSSL_sk_set( &ossl_check_X509_NAME_sk_type($sk), ($idx),  &ossl_check_X509_NAME_type($ptr))));
    }' unless defined(&sk_X509_NAME_set);
    eval 'sub sk_X509_NAME_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_NAME_sk_type($sk),  &ossl_check_X509_NAME_type($ptr)));
    }' unless defined(&sk_X509_NAME_find);
    eval 'sub sk_X509_NAME_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_NAME_sk_type($sk),  &ossl_check_X509_NAME_type($ptr)));
    }' unless defined(&sk_X509_NAME_find_ex);
    eval 'sub sk_X509_NAME_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_NAME_sk_type($sk),  &ossl_check_X509_NAME_type($ptr), $pnum));
    }' unless defined(&sk_X509_NAME_find_all);
    eval 'sub sk_X509_NAME_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_NAME_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_sort);
    eval 'sub sk_X509_NAME_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_NAME_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_is_sorted);
    eval 'sub sk_X509_NAME_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_NAME) *) &OPENSSL_sk_dup( &ossl_check_const_X509_NAME_sk_type($sk))));
    }' unless defined(&sk_X509_NAME_dup);
    eval 'sub sk_X509_NAME_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_NAME) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_NAME_sk_type($sk),  &ossl_check_X509_NAME_copyfunc_type($copyfunc),  &ossl_check_X509_NAME_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_NAME_deep_copy);
    eval 'sub sk_X509_NAME_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_NAME_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_NAME_sk_type($sk),  &ossl_check_X509_NAME_compfunc_type($cmp))));
    }' unless defined(&sk_X509_NAME_set_cmp_func);
    eval 'sub sk_X509_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_sk_type($sk)));
    }' unless defined(&sk_X509_num);
    eval 'sub sk_X509_value {
        my($sk, $idx) = @_;
	    eval q((( &X509 *) &OPENSSL_sk_value( &ossl_check_const_X509_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_value);
    eval 'sub sk_X509_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509) *) &OPENSSL_sk_new( &ossl_check_X509_compfunc_type($cmp))));
    }' unless defined(&sk_X509_new);
    eval 'sub sk_X509_new_null () {
        eval q((( &STACK_OF( &X509) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_new_null);
    eval 'sub sk_X509_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_new_reserve);
    eval 'sub sk_X509_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_reserve);
    eval 'sub sk_X509_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_sk_type($sk)));
    }' unless defined(&sk_X509_free);
    eval 'sub sk_X509_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_sk_type($sk)));
    }' unless defined(&sk_X509_zero);
    eval 'sub sk_X509_delete {
        my($sk, $i) = @_;
	    eval q((( &X509 *) &OPENSSL_sk_delete( &ossl_check_X509_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_delete);
    eval 'sub sk_X509_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509 *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_sk_type($sk),  &ossl_check_X509_type($ptr))));
    }' unless defined(&sk_X509_delete_ptr);
    eval 'sub sk_X509_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_sk_type($sk),  &ossl_check_X509_type($ptr)));
    }' unless defined(&sk_X509_push);
    eval 'sub sk_X509_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_sk_type($sk),  &ossl_check_X509_type($ptr)));
    }' unless defined(&sk_X509_unshift);
    eval 'sub sk_X509_pop {
        my($sk) = @_;
	    eval q((( &X509 *) &OPENSSL_sk_pop( &ossl_check_X509_sk_type($sk))));
    }' unless defined(&sk_X509_pop);
    eval 'sub sk_X509_shift {
        my($sk) = @_;
	    eval q((( &X509 *) &OPENSSL_sk_shift( &ossl_check_X509_sk_type($sk))));
    }' unless defined(&sk_X509_shift);
    eval 'sub sk_X509_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_sk_type($sk), &ossl_check_X509_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_pop_free);
    eval 'sub sk_X509_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_sk_type($sk),  &ossl_check_X509_type($ptr), ($idx)));
    }' unless defined(&sk_X509_insert);
    eval 'sub sk_X509_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509 *) &OPENSSL_sk_set( &ossl_check_X509_sk_type($sk), ($idx),  &ossl_check_X509_type($ptr))));
    }' unless defined(&sk_X509_set);
    eval 'sub sk_X509_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_sk_type($sk),  &ossl_check_X509_type($ptr)));
    }' unless defined(&sk_X509_find);
    eval 'sub sk_X509_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_sk_type($sk),  &ossl_check_X509_type($ptr)));
    }' unless defined(&sk_X509_find_ex);
    eval 'sub sk_X509_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_sk_type($sk),  &ossl_check_X509_type($ptr), $pnum));
    }' unless defined(&sk_X509_find_all);
    eval 'sub sk_X509_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_sk_type($sk)));
    }' unless defined(&sk_X509_sort);
    eval 'sub sk_X509_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_sk_type($sk)));
    }' unless defined(&sk_X509_is_sorted);
    eval 'sub sk_X509_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509) *) &OPENSSL_sk_dup( &ossl_check_const_X509_sk_type($sk))));
    }' unless defined(&sk_X509_dup);
    eval 'sub sk_X509_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_sk_type($sk),  &ossl_check_X509_copyfunc_type($copyfunc),  &ossl_check_X509_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_deep_copy);
    eval 'sub sk_X509_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_sk_type($sk),  &ossl_check_X509_compfunc_type($cmp))));
    }' unless defined(&sk_X509_set_cmp_func);
    eval 'sub sk_X509_REVOKED_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_REVOKED_sk_type($sk)));
    }' unless defined(&sk_X509_REVOKED_num);
    eval 'sub sk_X509_REVOKED_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_REVOKED *) &OPENSSL_sk_value( &ossl_check_const_X509_REVOKED_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_REVOKED_value);
    eval 'sub sk_X509_REVOKED_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_REVOKED) *) &OPENSSL_sk_new( &ossl_check_X509_REVOKED_compfunc_type($cmp))));
    }' unless defined(&sk_X509_REVOKED_new);
    eval 'sub sk_X509_REVOKED_new_null () {
        eval q((( &STACK_OF( &X509_REVOKED) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_REVOKED_new_null);
    eval 'sub sk_X509_REVOKED_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_REVOKED) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_REVOKED_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_REVOKED_new_reserve);
    eval 'sub sk_X509_REVOKED_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_REVOKED_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_REVOKED_reserve);
    eval 'sub sk_X509_REVOKED_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_REVOKED_sk_type($sk)));
    }' unless defined(&sk_X509_REVOKED_free);
    eval 'sub sk_X509_REVOKED_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_REVOKED_sk_type($sk)));
    }' unless defined(&sk_X509_REVOKED_zero);
    eval 'sub sk_X509_REVOKED_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_REVOKED *) &OPENSSL_sk_delete( &ossl_check_X509_REVOKED_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_REVOKED_delete);
    eval 'sub sk_X509_REVOKED_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_REVOKED *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_REVOKED_sk_type($sk),  &ossl_check_X509_REVOKED_type($ptr))));
    }' unless defined(&sk_X509_REVOKED_delete_ptr);
    eval 'sub sk_X509_REVOKED_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_REVOKED_sk_type($sk),  &ossl_check_X509_REVOKED_type($ptr)));
    }' unless defined(&sk_X509_REVOKED_push);
    eval 'sub sk_X509_REVOKED_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_REVOKED_sk_type($sk),  &ossl_check_X509_REVOKED_type($ptr)));
    }' unless defined(&sk_X509_REVOKED_unshift);
    eval 'sub sk_X509_REVOKED_pop {
        my($sk) = @_;
	    eval q((( &X509_REVOKED *) &OPENSSL_sk_pop( &ossl_check_X509_REVOKED_sk_type($sk))));
    }' unless defined(&sk_X509_REVOKED_pop);
    eval 'sub sk_X509_REVOKED_shift {
        my($sk) = @_;
	    eval q((( &X509_REVOKED *) &OPENSSL_sk_shift( &ossl_check_X509_REVOKED_sk_type($sk))));
    }' unless defined(&sk_X509_REVOKED_shift);
    eval 'sub sk_X509_REVOKED_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_REVOKED_sk_type($sk), &ossl_check_X509_REVOKED_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_REVOKED_pop_free);
    eval 'sub sk_X509_REVOKED_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_REVOKED_sk_type($sk),  &ossl_check_X509_REVOKED_type($ptr), ($idx)));
    }' unless defined(&sk_X509_REVOKED_insert);
    eval 'sub sk_X509_REVOKED_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_REVOKED *) &OPENSSL_sk_set( &ossl_check_X509_REVOKED_sk_type($sk), ($idx),  &ossl_check_X509_REVOKED_type($ptr))));
    }' unless defined(&sk_X509_REVOKED_set);
    eval 'sub sk_X509_REVOKED_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_REVOKED_sk_type($sk),  &ossl_check_X509_REVOKED_type($ptr)));
    }' unless defined(&sk_X509_REVOKED_find);
    eval 'sub sk_X509_REVOKED_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_REVOKED_sk_type($sk),  &ossl_check_X509_REVOKED_type($ptr)));
    }' unless defined(&sk_X509_REVOKED_find_ex);
    eval 'sub sk_X509_REVOKED_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_REVOKED_sk_type($sk),  &ossl_check_X509_REVOKED_type($ptr), $pnum));
    }' unless defined(&sk_X509_REVOKED_find_all);
    eval 'sub sk_X509_REVOKED_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_REVOKED_sk_type($sk)));
    }' unless defined(&sk_X509_REVOKED_sort);
    eval 'sub sk_X509_REVOKED_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_REVOKED_sk_type($sk)));
    }' unless defined(&sk_X509_REVOKED_is_sorted);
    eval 'sub sk_X509_REVOKED_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_REVOKED) *) &OPENSSL_sk_dup( &ossl_check_const_X509_REVOKED_sk_type($sk))));
    }' unless defined(&sk_X509_REVOKED_dup);
    eval 'sub sk_X509_REVOKED_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_REVOKED) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_REVOKED_sk_type($sk),  &ossl_check_X509_REVOKED_copyfunc_type($copyfunc),  &ossl_check_X509_REVOKED_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_REVOKED_deep_copy);
    eval 'sub sk_X509_REVOKED_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_REVOKED_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_REVOKED_sk_type($sk),  &ossl_check_X509_REVOKED_compfunc_type($cmp))));
    }' unless defined(&sk_X509_REVOKED_set_cmp_func);
    eval 'sub sk_X509_CRL_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_CRL_sk_type($sk)));
    }' unless defined(&sk_X509_CRL_num);
    eval 'sub sk_X509_CRL_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_CRL *) &OPENSSL_sk_value( &ossl_check_const_X509_CRL_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_CRL_value);
    eval 'sub sk_X509_CRL_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_CRL) *) &OPENSSL_sk_new( &ossl_check_X509_CRL_compfunc_type($cmp))));
    }' unless defined(&sk_X509_CRL_new);
    eval 'sub sk_X509_CRL_new_null () {
        eval q((( &STACK_OF( &X509_CRL) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_CRL_new_null);
    eval 'sub sk_X509_CRL_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_CRL) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_CRL_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_CRL_new_reserve);
    eval 'sub sk_X509_CRL_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_CRL_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_CRL_reserve);
    eval 'sub sk_X509_CRL_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_CRL_sk_type($sk)));
    }' unless defined(&sk_X509_CRL_free);
    eval 'sub sk_X509_CRL_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_CRL_sk_type($sk)));
    }' unless defined(&sk_X509_CRL_zero);
    eval 'sub sk_X509_CRL_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_CRL *) &OPENSSL_sk_delete( &ossl_check_X509_CRL_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_CRL_delete);
    eval 'sub sk_X509_CRL_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_CRL *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_CRL_sk_type($sk),  &ossl_check_X509_CRL_type($ptr))));
    }' unless defined(&sk_X509_CRL_delete_ptr);
    eval 'sub sk_X509_CRL_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_CRL_sk_type($sk),  &ossl_check_X509_CRL_type($ptr)));
    }' unless defined(&sk_X509_CRL_push);
    eval 'sub sk_X509_CRL_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_CRL_sk_type($sk),  &ossl_check_X509_CRL_type($ptr)));
    }' unless defined(&sk_X509_CRL_unshift);
    eval 'sub sk_X509_CRL_pop {
        my($sk) = @_;
	    eval q((( &X509_CRL *) &OPENSSL_sk_pop( &ossl_check_X509_CRL_sk_type($sk))));
    }' unless defined(&sk_X509_CRL_pop);
    eval 'sub sk_X509_CRL_shift {
        my($sk) = @_;
	    eval q((( &X509_CRL *) &OPENSSL_sk_shift( &ossl_check_X509_CRL_sk_type($sk))));
    }' unless defined(&sk_X509_CRL_shift);
    eval 'sub sk_X509_CRL_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_CRL_sk_type($sk), &ossl_check_X509_CRL_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_CRL_pop_free);
    eval 'sub sk_X509_CRL_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_CRL_sk_type($sk),  &ossl_check_X509_CRL_type($ptr), ($idx)));
    }' unless defined(&sk_X509_CRL_insert);
    eval 'sub sk_X509_CRL_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_CRL *) &OPENSSL_sk_set( &ossl_check_X509_CRL_sk_type($sk), ($idx),  &ossl_check_X509_CRL_type($ptr))));
    }' unless defined(&sk_X509_CRL_set);
    eval 'sub sk_X509_CRL_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_CRL_sk_type($sk),  &ossl_check_X509_CRL_type($ptr)));
    }' unless defined(&sk_X509_CRL_find);
    eval 'sub sk_X509_CRL_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_CRL_sk_type($sk),  &ossl_check_X509_CRL_type($ptr)));
    }' unless defined(&sk_X509_CRL_find_ex);
    eval 'sub sk_X509_CRL_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_CRL_sk_type($sk),  &ossl_check_X509_CRL_type($ptr), $pnum));
    }' unless defined(&sk_X509_CRL_find_all);
    eval 'sub sk_X509_CRL_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_CRL_sk_type($sk)));
    }' unless defined(&sk_X509_CRL_sort);
    eval 'sub sk_X509_CRL_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_CRL_sk_type($sk)));
    }' unless defined(&sk_X509_CRL_is_sorted);
    eval 'sub sk_X509_CRL_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_CRL) *) &OPENSSL_sk_dup( &ossl_check_const_X509_CRL_sk_type($sk))));
    }' unless defined(&sk_X509_CRL_dup);
    eval 'sub sk_X509_CRL_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_CRL) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_CRL_sk_type($sk),  &ossl_check_X509_CRL_copyfunc_type($copyfunc),  &ossl_check_X509_CRL_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_CRL_deep_copy);
    eval 'sub sk_X509_CRL_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_CRL_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_CRL_sk_type($sk),  &ossl_check_X509_CRL_compfunc_type($cmp))));
    }' unless defined(&sk_X509_CRL_set_cmp_func);
    eval 'sub X509_SIG_INFO_VALID () {0x1;}' unless defined(&X509_SIG_INFO_VALID);
    eval 'sub X509_SIG_INFO_TLS () {0x2;}' unless defined(&X509_SIG_INFO_TLS);
    eval 'sub X509_FILETYPE_PEM () {1;}' unless defined(&X509_FILETYPE_PEM);
    eval 'sub X509_FILETYPE_ASN1 () {2;}' unless defined(&X509_FILETYPE_ASN1);
    eval 'sub X509_FILETYPE_DEFAULT () {3;}' unless defined(&X509_FILETYPE_DEFAULT);
    eval 'sub X509v3_KU_DIGITAL_SIGNATURE () {0x80;}' unless defined(&X509v3_KU_DIGITAL_SIGNATURE);
    eval 'sub X509v3_KU_NON_REPUDIATION () {0x40;}' unless defined(&X509v3_KU_NON_REPUDIATION);
    eval 'sub X509v3_KU_KEY_ENCIPHERMENT () {0x20;}' unless defined(&X509v3_KU_KEY_ENCIPHERMENT);
    eval 'sub X509v3_KU_DATA_ENCIPHERMENT () {0x10;}' unless defined(&X509v3_KU_DATA_ENCIPHERMENT);
    eval 'sub X509v3_KU_KEY_AGREEMENT () {0x8;}' unless defined(&X509v3_KU_KEY_AGREEMENT);
    eval 'sub X509v3_KU_KEY_CERT_SIGN () {0x4;}' unless defined(&X509v3_KU_KEY_CERT_SIGN);
    eval 'sub X509v3_KU_CRL_SIGN () {0x2;}' unless defined(&X509v3_KU_CRL_SIGN);
    eval 'sub X509v3_KU_ENCIPHER_ONLY () {0x1;}' unless defined(&X509v3_KU_ENCIPHER_ONLY);
    eval 'sub X509v3_KU_DECIPHER_ONLY () {0x8000;}' unless defined(&X509v3_KU_DECIPHER_ONLY);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_4)) {
	eval 'sub X509v3_KU_UNDEF () {0xffff;}' unless defined(&X509v3_KU_UNDEF);
    }
    eval 'sub sk_X509_NAME_ENTRY_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_NAME_ENTRY_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_ENTRY_num);
    eval 'sub sk_X509_NAME_ENTRY_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_NAME_ENTRY *) &OPENSSL_sk_value( &ossl_check_const_X509_NAME_ENTRY_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_NAME_ENTRY_value);
    eval 'sub sk_X509_NAME_ENTRY_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_NAME_ENTRY) *) &OPENSSL_sk_new( &ossl_check_X509_NAME_ENTRY_compfunc_type($cmp))));
    }' unless defined(&sk_X509_NAME_ENTRY_new);
    eval 'sub sk_X509_NAME_ENTRY_new_null () {
        eval q((( &STACK_OF( &X509_NAME_ENTRY) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_NAME_ENTRY_new_null);
    eval 'sub sk_X509_NAME_ENTRY_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_NAME_ENTRY) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_NAME_ENTRY_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_NAME_ENTRY_new_reserve);
    eval 'sub sk_X509_NAME_ENTRY_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_NAME_ENTRY_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_NAME_ENTRY_reserve);
    eval 'sub sk_X509_NAME_ENTRY_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_NAME_ENTRY_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_ENTRY_free);
    eval 'sub sk_X509_NAME_ENTRY_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_NAME_ENTRY_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_ENTRY_zero);
    eval 'sub sk_X509_NAME_ENTRY_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_NAME_ENTRY *) &OPENSSL_sk_delete( &ossl_check_X509_NAME_ENTRY_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_NAME_ENTRY_delete);
    eval 'sub sk_X509_NAME_ENTRY_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_NAME_ENTRY *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_NAME_ENTRY_sk_type($sk),  &ossl_check_X509_NAME_ENTRY_type($ptr))));
    }' unless defined(&sk_X509_NAME_ENTRY_delete_ptr);
    eval 'sub sk_X509_NAME_ENTRY_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_NAME_ENTRY_sk_type($sk),  &ossl_check_X509_NAME_ENTRY_type($ptr)));
    }' unless defined(&sk_X509_NAME_ENTRY_push);
    eval 'sub sk_X509_NAME_ENTRY_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_NAME_ENTRY_sk_type($sk),  &ossl_check_X509_NAME_ENTRY_type($ptr)));
    }' unless defined(&sk_X509_NAME_ENTRY_unshift);
    eval 'sub sk_X509_NAME_ENTRY_pop {
        my($sk) = @_;
	    eval q((( &X509_NAME_ENTRY *) &OPENSSL_sk_pop( &ossl_check_X509_NAME_ENTRY_sk_type($sk))));
    }' unless defined(&sk_X509_NAME_ENTRY_pop);
    eval 'sub sk_X509_NAME_ENTRY_shift {
        my($sk) = @_;
	    eval q((( &X509_NAME_ENTRY *) &OPENSSL_sk_shift( &ossl_check_X509_NAME_ENTRY_sk_type($sk))));
    }' unless defined(&sk_X509_NAME_ENTRY_shift);
    eval 'sub sk_X509_NAME_ENTRY_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_NAME_ENTRY_sk_type($sk), &ossl_check_X509_NAME_ENTRY_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_NAME_ENTRY_pop_free);
    eval 'sub sk_X509_NAME_ENTRY_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_NAME_ENTRY_sk_type($sk),  &ossl_check_X509_NAME_ENTRY_type($ptr), ($idx)));
    }' unless defined(&sk_X509_NAME_ENTRY_insert);
    eval 'sub sk_X509_NAME_ENTRY_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_NAME_ENTRY *) &OPENSSL_sk_set( &ossl_check_X509_NAME_ENTRY_sk_type($sk), ($idx),  &ossl_check_X509_NAME_ENTRY_type($ptr))));
    }' unless defined(&sk_X509_NAME_ENTRY_set);
    eval 'sub sk_X509_NAME_ENTRY_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_NAME_ENTRY_sk_type($sk),  &ossl_check_X509_NAME_ENTRY_type($ptr)));
    }' unless defined(&sk_X509_NAME_ENTRY_find);
    eval 'sub sk_X509_NAME_ENTRY_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_NAME_ENTRY_sk_type($sk),  &ossl_check_X509_NAME_ENTRY_type($ptr)));
    }' unless defined(&sk_X509_NAME_ENTRY_find_ex);
    eval 'sub sk_X509_NAME_ENTRY_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_NAME_ENTRY_sk_type($sk),  &ossl_check_X509_NAME_ENTRY_type($ptr), $pnum));
    }' unless defined(&sk_X509_NAME_ENTRY_find_all);
    eval 'sub sk_X509_NAME_ENTRY_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_NAME_ENTRY_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_ENTRY_sort);
    eval 'sub sk_X509_NAME_ENTRY_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_NAME_ENTRY_sk_type($sk)));
    }' unless defined(&sk_X509_NAME_ENTRY_is_sorted);
    eval 'sub sk_X509_NAME_ENTRY_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_NAME_ENTRY) *) &OPENSSL_sk_dup( &ossl_check_const_X509_NAME_ENTRY_sk_type($sk))));
    }' unless defined(&sk_X509_NAME_ENTRY_dup);
    eval 'sub sk_X509_NAME_ENTRY_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_NAME_ENTRY) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_NAME_ENTRY_sk_type($sk),  &ossl_check_X509_NAME_ENTRY_copyfunc_type($copyfunc),  &ossl_check_X509_NAME_ENTRY_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_NAME_ENTRY_deep_copy);
    eval 'sub sk_X509_NAME_ENTRY_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_NAME_ENTRY_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_NAME_ENTRY_sk_type($sk),  &ossl_check_X509_NAME_ENTRY_compfunc_type($cmp))));
    }' unless defined(&sk_X509_NAME_ENTRY_set_cmp_func);
    eval 'sub X509_EX_V_NETSCAPE_HACK () {0x8000;}' unless defined(&X509_EX_V_NETSCAPE_HACK);
    eval 'sub X509_EX_V_INIT () {0x1;}' unless defined(&X509_EX_V_INIT);
    eval 'sub sk_X509_EXTENSION_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_EXTENSION_sk_type($sk)));
    }' unless defined(&sk_X509_EXTENSION_num);
    eval 'sub sk_X509_EXTENSION_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_EXTENSION *) &OPENSSL_sk_value( &ossl_check_const_X509_EXTENSION_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_EXTENSION_value);
    eval 'sub sk_X509_EXTENSION_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_EXTENSION) *) &OPENSSL_sk_new( &ossl_check_X509_EXTENSION_compfunc_type($cmp))));
    }' unless defined(&sk_X509_EXTENSION_new);
    eval 'sub sk_X509_EXTENSION_new_null () {
        eval q((( &STACK_OF( &X509_EXTENSION) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_EXTENSION_new_null);
    eval 'sub sk_X509_EXTENSION_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_EXTENSION) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_EXTENSION_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_EXTENSION_new_reserve);
    eval 'sub sk_X509_EXTENSION_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_EXTENSION_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_EXTENSION_reserve);
    eval 'sub sk_X509_EXTENSION_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_EXTENSION_sk_type($sk)));
    }' unless defined(&sk_X509_EXTENSION_free);
    eval 'sub sk_X509_EXTENSION_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_EXTENSION_sk_type($sk)));
    }' unless defined(&sk_X509_EXTENSION_zero);
    eval 'sub sk_X509_EXTENSION_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_EXTENSION *) &OPENSSL_sk_delete( &ossl_check_X509_EXTENSION_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_EXTENSION_delete);
    eval 'sub sk_X509_EXTENSION_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_EXTENSION *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_EXTENSION_sk_type($sk),  &ossl_check_X509_EXTENSION_type($ptr))));
    }' unless defined(&sk_X509_EXTENSION_delete_ptr);
    eval 'sub sk_X509_EXTENSION_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_EXTENSION_sk_type($sk),  &ossl_check_X509_EXTENSION_type($ptr)));
    }' unless defined(&sk_X509_EXTENSION_push);
    eval 'sub sk_X509_EXTENSION_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_EXTENSION_sk_type($sk),  &ossl_check_X509_EXTENSION_type($ptr)));
    }' unless defined(&sk_X509_EXTENSION_unshift);
    eval 'sub sk_X509_EXTENSION_pop {
        my($sk) = @_;
	    eval q((( &X509_EXTENSION *) &OPENSSL_sk_pop( &ossl_check_X509_EXTENSION_sk_type($sk))));
    }' unless defined(&sk_X509_EXTENSION_pop);
    eval 'sub sk_X509_EXTENSION_shift {
        my($sk) = @_;
	    eval q((( &X509_EXTENSION *) &OPENSSL_sk_shift( &ossl_check_X509_EXTENSION_sk_type($sk))));
    }' unless defined(&sk_X509_EXTENSION_shift);
    eval 'sub sk_X509_EXTENSION_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_EXTENSION_sk_type($sk), &ossl_check_X509_EXTENSION_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_EXTENSION_pop_free);
    eval 'sub sk_X509_EXTENSION_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_EXTENSION_sk_type($sk),  &ossl_check_X509_EXTENSION_type($ptr), ($idx)));
    }' unless defined(&sk_X509_EXTENSION_insert);
    eval 'sub sk_X509_EXTENSION_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_EXTENSION *) &OPENSSL_sk_set( &ossl_check_X509_EXTENSION_sk_type($sk), ($idx),  &ossl_check_X509_EXTENSION_type($ptr))));
    }' unless defined(&sk_X509_EXTENSION_set);
    eval 'sub sk_X509_EXTENSION_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_EXTENSION_sk_type($sk),  &ossl_check_X509_EXTENSION_type($ptr)));
    }' unless defined(&sk_X509_EXTENSION_find);
    eval 'sub sk_X509_EXTENSION_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_EXTENSION_sk_type($sk),  &ossl_check_X509_EXTENSION_type($ptr)));
    }' unless defined(&sk_X509_EXTENSION_find_ex);
    eval 'sub sk_X509_EXTENSION_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_EXTENSION_sk_type($sk),  &ossl_check_X509_EXTENSION_type($ptr), $pnum));
    }' unless defined(&sk_X509_EXTENSION_find_all);
    eval 'sub sk_X509_EXTENSION_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_EXTENSION_sk_type($sk)));
    }' unless defined(&sk_X509_EXTENSION_sort);
    eval 'sub sk_X509_EXTENSION_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_EXTENSION_sk_type($sk)));
    }' unless defined(&sk_X509_EXTENSION_is_sorted);
    eval 'sub sk_X509_EXTENSION_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_EXTENSION) *) &OPENSSL_sk_dup( &ossl_check_const_X509_EXTENSION_sk_type($sk))));
    }' unless defined(&sk_X509_EXTENSION_dup);
    eval 'sub sk_X509_EXTENSION_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_EXTENSION) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_EXTENSION_sk_type($sk),  &ossl_check_X509_EXTENSION_copyfunc_type($copyfunc),  &ossl_check_X509_EXTENSION_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_EXTENSION_deep_copy);
    eval 'sub sk_X509_EXTENSION_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_EXTENSION_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_EXTENSION_sk_type($sk),  &ossl_check_X509_EXTENSION_compfunc_type($cmp))));
    }' unless defined(&sk_X509_EXTENSION_set_cmp_func);
    eval 'sub sk_X509_ATTRIBUTE_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_ATTRIBUTE_sk_type($sk)));
    }' unless defined(&sk_X509_ATTRIBUTE_num);
    eval 'sub sk_X509_ATTRIBUTE_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_ATTRIBUTE *) &OPENSSL_sk_value( &ossl_check_const_X509_ATTRIBUTE_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_ATTRIBUTE_value);
    eval 'sub sk_X509_ATTRIBUTE_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_ATTRIBUTE) *) &OPENSSL_sk_new( &ossl_check_X509_ATTRIBUTE_compfunc_type($cmp))));
    }' unless defined(&sk_X509_ATTRIBUTE_new);
    eval 'sub sk_X509_ATTRIBUTE_new_null () {
        eval q((( &STACK_OF( &X509_ATTRIBUTE) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_ATTRIBUTE_new_null);
    eval 'sub sk_X509_ATTRIBUTE_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_ATTRIBUTE) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_ATTRIBUTE_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_ATTRIBUTE_new_reserve);
    eval 'sub sk_X509_ATTRIBUTE_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_ATTRIBUTE_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_ATTRIBUTE_reserve);
    eval 'sub sk_X509_ATTRIBUTE_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_ATTRIBUTE_sk_type($sk)));
    }' unless defined(&sk_X509_ATTRIBUTE_free);
    eval 'sub sk_X509_ATTRIBUTE_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_ATTRIBUTE_sk_type($sk)));
    }' unless defined(&sk_X509_ATTRIBUTE_zero);
    eval 'sub sk_X509_ATTRIBUTE_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_ATTRIBUTE *) &OPENSSL_sk_delete( &ossl_check_X509_ATTRIBUTE_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_ATTRIBUTE_delete);
    eval 'sub sk_X509_ATTRIBUTE_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_ATTRIBUTE *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_ATTRIBUTE_sk_type($sk),  &ossl_check_X509_ATTRIBUTE_type($ptr))));
    }' unless defined(&sk_X509_ATTRIBUTE_delete_ptr);
    eval 'sub sk_X509_ATTRIBUTE_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_ATTRIBUTE_sk_type($sk),  &ossl_check_X509_ATTRIBUTE_type($ptr)));
    }' unless defined(&sk_X509_ATTRIBUTE_push);
    eval 'sub sk_X509_ATTRIBUTE_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_ATTRIBUTE_sk_type($sk),  &ossl_check_X509_ATTRIBUTE_type($ptr)));
    }' unless defined(&sk_X509_ATTRIBUTE_unshift);
    eval 'sub sk_X509_ATTRIBUTE_pop {
        my($sk) = @_;
	    eval q((( &X509_ATTRIBUTE *) &OPENSSL_sk_pop( &ossl_check_X509_ATTRIBUTE_sk_type($sk))));
    }' unless defined(&sk_X509_ATTRIBUTE_pop);
    eval 'sub sk_X509_ATTRIBUTE_shift {
        my($sk) = @_;
	    eval q((( &X509_ATTRIBUTE *) &OPENSSL_sk_shift( &ossl_check_X509_ATTRIBUTE_sk_type($sk))));
    }' unless defined(&sk_X509_ATTRIBUTE_shift);
    eval 'sub sk_X509_ATTRIBUTE_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_ATTRIBUTE_sk_type($sk), &ossl_check_X509_ATTRIBUTE_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_ATTRIBUTE_pop_free);
    eval 'sub sk_X509_ATTRIBUTE_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_ATTRIBUTE_sk_type($sk),  &ossl_check_X509_ATTRIBUTE_type($ptr), ($idx)));
    }' unless defined(&sk_X509_ATTRIBUTE_insert);
    eval 'sub sk_X509_ATTRIBUTE_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_ATTRIBUTE *) &OPENSSL_sk_set( &ossl_check_X509_ATTRIBUTE_sk_type($sk), ($idx),  &ossl_check_X509_ATTRIBUTE_type($ptr))));
    }' unless defined(&sk_X509_ATTRIBUTE_set);
    eval 'sub sk_X509_ATTRIBUTE_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_ATTRIBUTE_sk_type($sk),  &ossl_check_X509_ATTRIBUTE_type($ptr)));
    }' unless defined(&sk_X509_ATTRIBUTE_find);
    eval 'sub sk_X509_ATTRIBUTE_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_ATTRIBUTE_sk_type($sk),  &ossl_check_X509_ATTRIBUTE_type($ptr)));
    }' unless defined(&sk_X509_ATTRIBUTE_find_ex);
    eval 'sub sk_X509_ATTRIBUTE_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_ATTRIBUTE_sk_type($sk),  &ossl_check_X509_ATTRIBUTE_type($ptr), $pnum));
    }' unless defined(&sk_X509_ATTRIBUTE_find_all);
    eval 'sub sk_X509_ATTRIBUTE_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_ATTRIBUTE_sk_type($sk)));
    }' unless defined(&sk_X509_ATTRIBUTE_sort);
    eval 'sub sk_X509_ATTRIBUTE_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_ATTRIBUTE_sk_type($sk)));
    }' unless defined(&sk_X509_ATTRIBUTE_is_sorted);
    eval 'sub sk_X509_ATTRIBUTE_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_ATTRIBUTE) *) &OPENSSL_sk_dup( &ossl_check_const_X509_ATTRIBUTE_sk_type($sk))));
    }' unless defined(&sk_X509_ATTRIBUTE_dup);
    eval 'sub sk_X509_ATTRIBUTE_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_ATTRIBUTE) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_ATTRIBUTE_sk_type($sk),  &ossl_check_X509_ATTRIBUTE_copyfunc_type($copyfunc),  &ossl_check_X509_ATTRIBUTE_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_ATTRIBUTE_deep_copy);
    eval 'sub sk_X509_ATTRIBUTE_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_ATTRIBUTE_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_ATTRIBUTE_sk_type($sk),  &ossl_check_X509_ATTRIBUTE_compfunc_type($cmp))));
    }' unless defined(&sk_X509_ATTRIBUTE_set_cmp_func);
    eval 'sub X509_FLAG_COMPAT () {0;}' unless defined(&X509_FLAG_COMPAT);
    eval 'sub X509_FLAG_NO_HEADER () {1;}' unless defined(&X509_FLAG_NO_HEADER);
    eval 'sub X509_FLAG_NO_VERSION () {(1 << 1);}' unless defined(&X509_FLAG_NO_VERSION);
    eval 'sub X509_FLAG_NO_SERIAL () {(1 << 2);}' unless defined(&X509_FLAG_NO_SERIAL);
    eval 'sub X509_FLAG_NO_SIGNAME () {(1 << 3);}' unless defined(&X509_FLAG_NO_SIGNAME);
    eval 'sub X509_FLAG_NO_ISSUER () {(1 << 4);}' unless defined(&X509_FLAG_NO_ISSUER);
    eval 'sub X509_FLAG_NO_VALIDITY () {(1 << 5);}' unless defined(&X509_FLAG_NO_VALIDITY);
    eval 'sub X509_FLAG_NO_SUBJECT () {(1 << 6);}' unless defined(&X509_FLAG_NO_SUBJECT);
    eval 'sub X509_FLAG_NO_PUBKEY () {(1 << 7);}' unless defined(&X509_FLAG_NO_PUBKEY);
    eval 'sub X509_FLAG_NO_EXTENSIONS () {(1 << 8);}' unless defined(&X509_FLAG_NO_EXTENSIONS);
    eval 'sub X509_FLAG_NO_SIGDUMP () {(1 << 9);}' unless defined(&X509_FLAG_NO_SIGDUMP);
    eval 'sub X509_FLAG_NO_AUX () {(1 << 10);}' unless defined(&X509_FLAG_NO_AUX);
    eval 'sub X509_FLAG_NO_ATTRIBUTES () {(1 << 11);}' unless defined(&X509_FLAG_NO_ATTRIBUTES);
    eval 'sub X509_FLAG_NO_IDS () {(1 << 12);}' unless defined(&X509_FLAG_NO_IDS);
    eval 'sub X509_FLAG_EXTENSIONS_ONLY_KID () {(1 << 13);}' unless defined(&X509_FLAG_EXTENSIONS_ONLY_KID);
    eval 'sub XN_FLAG_SEP_MASK () {(0xf << 16);}' unless defined(&XN_FLAG_SEP_MASK);
    eval 'sub XN_FLAG_COMPAT () {0;}' unless defined(&XN_FLAG_COMPAT);
    eval 'sub XN_FLAG_SEP_COMMA_PLUS () {(1<< 16);}' unless defined(&XN_FLAG_SEP_COMMA_PLUS);
    eval 'sub XN_FLAG_SEP_CPLUS_SPC () {(2<< 16);}' unless defined(&XN_FLAG_SEP_CPLUS_SPC);
    eval 'sub XN_FLAG_SEP_SPLUS_SPC () {(3<< 16);}' unless defined(&XN_FLAG_SEP_SPLUS_SPC);
    eval 'sub XN_FLAG_SEP_MULTILINE () {(4<< 16);}' unless defined(&XN_FLAG_SEP_MULTILINE);
    eval 'sub XN_FLAG_DN_REV () {(1<< 20);}' unless defined(&XN_FLAG_DN_REV);
    eval 'sub XN_FLAG_FN_MASK () {(0x3 << 21);}' unless defined(&XN_FLAG_FN_MASK);
    eval 'sub XN_FLAG_FN_SN () {0;}' unless defined(&XN_FLAG_FN_SN);
    eval 'sub XN_FLAG_FN_LN () {(1<< 21);}' unless defined(&XN_FLAG_FN_LN);
    eval 'sub XN_FLAG_FN_OID () {(2<< 21);}' unless defined(&XN_FLAG_FN_OID);
    eval 'sub XN_FLAG_FN_NONE () {(3<< 21);}' unless defined(&XN_FLAG_FN_NONE);
    eval 'sub XN_FLAG_SPC_EQ () {(1<< 23);}' unless defined(&XN_FLAG_SPC_EQ);
    eval 'sub XN_FLAG_DUMP_UNKNOWN_FIELDS () {(1<< 24);}' unless defined(&XN_FLAG_DUMP_UNKNOWN_FIELDS);
    eval 'sub XN_FLAG_FN_ALIGN () {(1<< 25);}' unless defined(&XN_FLAG_FN_ALIGN);
    eval 'sub XN_FLAG_RFC2253 () {( &ASN1_STRFLGS_RFC2253 |  &XN_FLAG_SEP_COMMA_PLUS |  &XN_FLAG_DN_REV |  &XN_FLAG_FN_SN |  &XN_FLAG_DUMP_UNKNOWN_FIELDS);}' unless defined(&XN_FLAG_RFC2253);
    eval 'sub XN_FLAG_ONELINE () {( &ASN1_STRFLGS_RFC2253 |  &ASN1_STRFLGS_ESC_QUOTE |  &XN_FLAG_SEP_CPLUS_SPC |  &XN_FLAG_SPC_EQ |  &XN_FLAG_FN_SN);}' unless defined(&XN_FLAG_ONELINE);
    eval 'sub XN_FLAG_MULTILINE () {( &ASN1_STRFLGS_ESC_CTRL |  &ASN1_STRFLGS_ESC_MSB |  &XN_FLAG_SEP_MULTILINE |  &XN_FLAG_SPC_EQ |  &XN_FLAG_FN_LN |  &XN_FLAG_FN_ALIGN);}' unless defined(&XN_FLAG_MULTILINE);
    eval 'sub sk_X509_INFO_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_INFO_sk_type($sk)));
    }' unless defined(&sk_X509_INFO_num);
    eval 'sub sk_X509_INFO_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_INFO *) &OPENSSL_sk_value( &ossl_check_const_X509_INFO_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_INFO_value);
    eval 'sub sk_X509_INFO_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_INFO) *) &OPENSSL_sk_new( &ossl_check_X509_INFO_compfunc_type($cmp))));
    }' unless defined(&sk_X509_INFO_new);
    eval 'sub sk_X509_INFO_new_null () {
        eval q((( &STACK_OF( &X509_INFO) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_INFO_new_null);
    eval 'sub sk_X509_INFO_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_INFO) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_INFO_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_INFO_new_reserve);
    eval 'sub sk_X509_INFO_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_INFO_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_INFO_reserve);
    eval 'sub sk_X509_INFO_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_INFO_sk_type($sk)));
    }' unless defined(&sk_X509_INFO_free);
    eval 'sub sk_X509_INFO_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_INFO_sk_type($sk)));
    }' unless defined(&sk_X509_INFO_zero);
    eval 'sub sk_X509_INFO_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_INFO *) &OPENSSL_sk_delete( &ossl_check_X509_INFO_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_INFO_delete);
    eval 'sub sk_X509_INFO_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_INFO *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_INFO_sk_type($sk),  &ossl_check_X509_INFO_type($ptr))));
    }' unless defined(&sk_X509_INFO_delete_ptr);
    eval 'sub sk_X509_INFO_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_INFO_sk_type($sk),  &ossl_check_X509_INFO_type($ptr)));
    }' unless defined(&sk_X509_INFO_push);
    eval 'sub sk_X509_INFO_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_INFO_sk_type($sk),  &ossl_check_X509_INFO_type($ptr)));
    }' unless defined(&sk_X509_INFO_unshift);
    eval 'sub sk_X509_INFO_pop {
        my($sk) = @_;
	    eval q((( &X509_INFO *) &OPENSSL_sk_pop( &ossl_check_X509_INFO_sk_type($sk))));
    }' unless defined(&sk_X509_INFO_pop);
    eval 'sub sk_X509_INFO_shift {
        my($sk) = @_;
	    eval q((( &X509_INFO *) &OPENSSL_sk_shift( &ossl_check_X509_INFO_sk_type($sk))));
    }' unless defined(&sk_X509_INFO_shift);
    eval 'sub sk_X509_INFO_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_INFO_sk_type($sk), &ossl_check_X509_INFO_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_INFO_pop_free);
    eval 'sub sk_X509_INFO_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_INFO_sk_type($sk),  &ossl_check_X509_INFO_type($ptr), ($idx)));
    }' unless defined(&sk_X509_INFO_insert);
    eval 'sub sk_X509_INFO_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_INFO *) &OPENSSL_sk_set( &ossl_check_X509_INFO_sk_type($sk), ($idx),  &ossl_check_X509_INFO_type($ptr))));
    }' unless defined(&sk_X509_INFO_set);
    eval 'sub sk_X509_INFO_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_INFO_sk_type($sk),  &ossl_check_X509_INFO_type($ptr)));
    }' unless defined(&sk_X509_INFO_find);
    eval 'sub sk_X509_INFO_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_INFO_sk_type($sk),  &ossl_check_X509_INFO_type($ptr)));
    }' unless defined(&sk_X509_INFO_find_ex);
    eval 'sub sk_X509_INFO_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_INFO_sk_type($sk),  &ossl_check_X509_INFO_type($ptr), $pnum));
    }' unless defined(&sk_X509_INFO_find_all);
    eval 'sub sk_X509_INFO_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_INFO_sk_type($sk)));
    }' unless defined(&sk_X509_INFO_sort);
    eval 'sub sk_X509_INFO_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_INFO_sk_type($sk)));
    }' unless defined(&sk_X509_INFO_is_sorted);
    eval 'sub sk_X509_INFO_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_INFO) *) &OPENSSL_sk_dup( &ossl_check_const_X509_INFO_sk_type($sk))));
    }' unless defined(&sk_X509_INFO_dup);
    eval 'sub sk_X509_INFO_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_INFO) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_INFO_sk_type($sk),  &ossl_check_X509_INFO_copyfunc_type($copyfunc),  &ossl_check_X509_INFO_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_INFO_deep_copy);
    eval 'sub sk_X509_INFO_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_INFO_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_INFO_sk_type($sk),  &ossl_check_X509_INFO_compfunc_type($cmp))));
    }' unless defined(&sk_X509_INFO_set_cmp_func);
    unless(defined(&OPENSSL_NO_SCRYPT)) {
    }
    if(defined(&__cplusplus)) {
    }
    require 'openssl/x509_vfy.ph';
    require 'openssl/pkcs7.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub X509_EXT_PACK_UNKNOWN () {1;}' unless defined(&X509_EXT_PACK_UNKNOWN);
    eval 'sub X509_EXT_PACK_STRING () {2;}' unless defined(&X509_EXT_PACK_STRING);
    eval 'sub X509_extract_key {
        my($x) = @_;
	    eval q( &X509_get_pubkey($x));
    }' unless defined(&X509_extract_key);
    eval 'sub X509_REQ_extract_key {
        my($a) = @_;
	    eval q( &X509_REQ_get_pubkey($a));
    }' unless defined(&X509_REQ_extract_key);
    eval 'sub X509_name_cmp {
        my($a,$b) = @_;
	    eval q( &X509_NAME_cmp(($a),($b)));
    }' unless defined(&X509_name_cmp);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	require 'openssl/http.ph';
	eval 'sub X509_http_nbio {
	    my($rctx, $pcert) = @_;
    	    eval q( &OSSL_HTTP_REQ_CTX_nbio_d2i($rctx, $pcert,  &ASN1_ITEM_rptr( &X509)));
	}' unless defined(&X509_http_nbio);
	eval 'sub X509_CRL_http_nbio {
	    my($rctx, $pcrl) = @_;
    	    eval q( &OSSL_HTTP_REQ_CTX_nbio_d2i($rctx, $pcrl,  &ASN1_ITEM_rptr( &X509_CRL)));
	}' unless defined(&X509_CRL_http_nbio);
    }
    unless(defined(&OPENSSL_NO_STDIO)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	}
	unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	    unless(defined(&OPENSSL_NO_DSA)) {
	    }
	}
	unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	    unless(defined(&OPENSSL_NO_EC)) {
	    }
	}
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	unless(defined(&OPENSSL_NO_DSA)) {
	}
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	unless(defined(&OPENSSL_NO_EC)) {
	}
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	unless(defined(&OPENSSL_NO_DSA)) {
	}
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	unless(defined(&OPENSSL_NO_EC)) {
	}
    }
    eval 'sub X509_get_ex_new_index {
        my($l, $p, $newf, $dupf, $freef) = @_;
	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_X509, $l, $p, $newf, $dupf, $freef));
    }' unless defined(&X509_get_ex_new_index);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub X509_VERSION_1 () {0;}' unless defined(&X509_VERSION_1);
    eval 'sub X509_VERSION_2 () {1;}' unless defined(&X509_VERSION_2);
    eval 'sub X509_VERSION_3 () {2;}' unless defined(&X509_VERSION_3);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub X509_get_notBefore () { &X509_getm_notBefore;}' unless defined(&X509_get_notBefore);
	eval 'sub X509_get_notAfter () { &X509_getm_notAfter;}' unless defined(&X509_get_notAfter);
	eval 'sub X509_set_notBefore () { &X509_set1_notBefore;}' unless defined(&X509_set_notBefore);
	eval 'sub X509_set_notAfter () { &X509_set1_notAfter;}' unless defined(&X509_set_notAfter);
    }
    eval 'sub X509_REQ_VERSION_1 () {0;}' unless defined(&X509_REQ_VERSION_1);
    eval 'sub X509_CRL_VERSION_1 () {0;}' unless defined(&X509_CRL_VERSION_1);
    eval 'sub X509_CRL_VERSION_2 () {1;}' unless defined(&X509_CRL_VERSION_2);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub X509_CRL_set_lastUpdate () { &X509_CRL_set1_lastUpdate;}' unless defined(&X509_CRL_set_lastUpdate);
	eval 'sub X509_CRL_set_nextUpdate () { &X509_CRL_set1_nextUpdate;}' unless defined(&X509_CRL_set_nextUpdate);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
    }
    unless(defined(&OPENSSL_NO_MD5)) {
    }
    eval 'sub X509_ADD_FLAG_DEFAULT () {0;}' unless defined(&X509_ADD_FLAG_DEFAULT);
    eval 'sub X509_ADD_FLAG_UP_REF () {0x1;}' unless defined(&X509_ADD_FLAG_UP_REF);
    eval 'sub X509_ADD_FLAG_PREPEND () {0x2;}' unless defined(&X509_ADD_FLAG_PREPEND);
    eval 'sub X509_ADD_FLAG_NO_DUP () {0x4;}' unless defined(&X509_ADD_FLAG_NO_DUP);
    eval 'sub X509_ADD_FLAG_NO_SS () {0x8;}' unless defined(&X509_ADD_FLAG_NO_SS);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub X509_NAME_hash {
	    my($x) = @_;
    	    eval q( &X509_NAME_hash_ex($x,  &NULL,  &NULL,  &NULL));
	}' unless defined(&X509_NAME_hash);
    }
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    unless(defined(&OPENSSL_NO_SCRYPT)) {
    }
    unless(defined(&OPENSSL_NO_SCRYPT)) {
    }
    if(defined(&__cplusplus)) {
    }
}
1;
