package TDS::Navigator::Topic;
# $Id: Topic.pm,v 1.6 2000/12/08 02:02:33 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $Template $HrefTemplateDynamic $HrefTemplateStatic);

use DateTime::Date;

use TDS;
use TDS::Navigator::Base;

@ISA = qw(TDS::Navigator::Base);

attributes qw();

{
    $HrefTemplateDynamic = "TsDiary.cgi?%year%0m%0d-%new" unless defined $HrefTemplateDynamic;
    $HrefTemplateStatic = "d%year%0m%part.%suffix\#%0d-%new" unless defined $HrefTemplateStatic;
}

################################################################
sub initialize($)
{
    my $self = shift;
    $self->use_accesskey(1);
    $self->SUPER::initialize;
}
sub AsPrev ($$)
{
    my ($self, $label) = @_;

    my $params = $self->GetParams;
    $params->{new} = $TDS::Status->topic - 1;
    $params->{accesskey} = "1";

    my $nohref = $params->{new} <= 0;
    return $self->AsHTML($label, $params, $nohref);
}
sub AsNext ($$)
{
    my ($self, $label) = @_;

    my $params = $self->GetParams;
    $params->{new} = $TDS::Status->topic + 1;
    $params->{accesskey} = "3";

    my $nohref = $params->{new} > $TDS::Status->num_topic;
    return $self->AsHTML($label, $params, $nohref);
}
sub AsThis ($$)
{
    undef;                 # not yet implemented
}


1;
