/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryFile {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private final int initBufSize;
    private byte[] data = null;
    private volatile int size = 0;
    private OutputStream out = null;

    public MemoryFile() {
        this(null, 2048);
    }

    public MemoryFile(int n) {
        this(null, n);
    }

    public MemoryFile(byte[] byArray) {
        this(byArray, 2048);
    }

    public MemoryFile(byte[] byArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The buffer size must be a positive integer");
        }
        this.initBufSize = n;
        if (byArray != null) {
            this.data = new byte[n > byArray.length ? n : byArray.length];
            System.arraycopy(byArray, 0, this.data, 0, byArray.length);
            this.size = byArray.length;
        }
    }

    public int getSize() {
        return this.size;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.out != null) {
            throw new IOException("MemoryFile already open for writing");
        }
        this.size = 0;
        this.data = new byte[this.initBufSize];
        this.out = new InternalOutputStream();
        return this.out;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data, 0, this.getSize());
    }

    public synchronized void clear() throws IOException {
        if (this.out != null) {
            throw new IOException("MemoryFile open for writing");
        }
        this.size = 0;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.data, 0, this.getSize());
    }

    private void growBuf(int n) {
        int n2 = n < this.data.length ? this.data.length : n;
        byte[] byArray = new byte[this.data.length + n2];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
    }

    private synchronized void write(int n) {
        if (this.data.length - this.size == 0) {
            this.growBuf(1);
        }
        this.data[this.size++] = (byte)(n & 0xFF);
    }

    private synchronized void write(byte[] byArray, int n, int n2) {
        if (this.data.length - this.size < byArray.length) {
            this.growBuf(byArray.length + this.size - this.data.length);
        }
        System.arraycopy(byArray, n, this.data, this.size, n2);
        this.size += n2;
    }

    private synchronized void closeOutputStream() throws IOException {
        if (this.out == null) {
            throw new IOException("OutputStream already closed");
        }
        this.out = null;
    }

    private class InternalOutputStream
    extends OutputStream {
        private InternalOutputStream() {
        }

        public void write(int n) {
            MemoryFile.this.write(n);
        }

        public void write(byte[] byArray, int n, int n2) {
            MemoryFile.this.write(byArray, n, n2);
        }

        public void close() throws IOException {
            MemoryFile.this.closeOutputStream();
        }
    }
}

