/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import"bootstrap";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Modal from"@typo3/backend/modal.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import{InfoBox}from"@typo3/install/renderable/info-box.js";import Severity from"@typo3/install/renderable/severity.js";import Router from"@typo3/install/router.js";import RegularEvent from"@typo3/core/event/regular-event.js";var Identifiers;!function(e){e.outputContainer=".t3js-folderStructure-output",e.errorContainer=".t3js-folderStructure-errors",e.errorList=".t3js-folderStructure-errors-list",e.errorFixTrigger=".t3js-folderStructure-errors-fix",e.okContainer=".t3js-folderStructure-ok",e.okList=".t3js-folderStructure-ok-list",e.permissionContainer=".t3js-folderStructure-permissions"}(Identifiers||(Identifiers={}));class FolderStructure extends AbstractInteractableModule{static removeLoadingMessage(e){e.querySelector("typo3-backend-progress-bar").remove()}initialize(e){super.initialize(e),this.loadModuleFrameAgnostic("@typo3/install/renderable/info-box.js").then((()=>{this.getStatus()})),new RegularEvent("click",(e=>{e.preventDefault(),this.fix()})).delegateTo(e,Identifiers.errorFixTrigger)}getStatus(){const e=this.getModalBody();new AjaxRequest(Router.getUrl("folderStructureGetStatus")).get({cache:"no-cache"}).then((async t=>{const r=await t.resolve();e.innerHTML=r.html,Modal.setButtons(r.buttons),!0===r.success&&Array.isArray(r.errorStatus)&&(r.errorStatus.length>0?(e.querySelector(Identifiers.errorContainer).style.display="block",e.querySelector(Identifiers.errorList).innerHTML="",r.errorStatus.forEach((t=>{e.querySelector(Identifiers.errorList).appendChild(InfoBox.create(t.severity,t.title,t.message))}))):e.querySelector(Identifiers.errorContainer).style.display="none"),!0===r.success&&Array.isArray(r.okStatus)&&(r.okStatus.length>0?(e.querySelector(Identifiers.okContainer).style.display="block",e.querySelector(Identifiers.okList).innerHTML="",r.okStatus.forEach((t=>{e.querySelector(Identifiers.okList).appendChild(InfoBox.create(t.severity,t.title,t.message))}))):e.querySelector(Identifiers.okContainer).style.display="none");let o=r.folderStructureFilePermissionStatus;const s=e.querySelector(Identifiers.permissionContainer);s.replaceChildren(InfoBox.create(o.severity,o.title,o.message)),o=r.folderStructureDirectoryPermissionStatus,s.appendChild(InfoBox.create(o.severity,o.title,o.message))}),(t=>{Router.handleAjaxError(t,e)}))}fix(){this.setModalButtonsState(!1);const e=this.getModalBody(),t=this.findInModal(Identifiers.outputContainer);this.renderProgressBar(t),new AjaxRequest(Router.getUrl("folderStructureFix")).get({cache:"no-cache"}).then((async e=>{const r=await e.resolve();FolderStructure.removeLoadingMessage(t),!0===r.success&&Array.isArray(r.fixedStatus)?(r.fixedStatus.length>0?r.fixedStatus.forEach((e=>{t.append(InfoBox.create(e.severity,e.title,e.message))})):t.append(InfoBox.create(Severity.warning,"Nothing fixed")),this.getStatus()):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(t=>{Router.handleAjaxError(t,e)})).finally((()=>{this.setModalButtonsState(!0)}))}}export default new FolderStructure;