<?php
/**
 * These are just the language codes, not regions. This means it only lists en, not en-US, en-CA etc.
 * @see http://www.iana.org/assignments/language-subtag-registry
 */
$global['langs_codes'] = [
    ['value' => 'af_NA','label' => 'Afrikaans (Namibia)', 'flag' => 'na'],
    ['value' => 'af_ZA','label' => 'Afrikaans (South Africa)', 'flag' => 'za'],
    ['value' => 'af','label' => 'Afrikaans', 'flag' => 'af'],
    ['value' => 'ak_GH','label' => 'Akan (Ghana)', 'flag' => 'gh'],
    ['value' => 'ak','label' => 'Akan', 'flag' => 'ak'],
    ['value' => 'sq_AL','label' => 'Albanian (Albania)', 'flag' => 'al'],
    ['value' => 'sq','label' => 'Albanian', 'flag' => 'sq'],
    ['value' => 'am_ET','label' => 'Amharic (Ethiopia)', 'flag' => 'et'],
    ['value' => 'am','label' => 'Amharic', 'flag' => 'am'],
    ['value' => 'ar_DZ','label' => 'Arabic (Algeria)', 'flag' => 'dz'],
    ['value' => 'ar_BH','label' => 'Arabic (Bahrain)', 'flag' => 'bh'],
    ['value' => 'ar_EG','label' => 'Arabic (Egypt)', 'flag' => 'eg'],
    ['value' => 'ar_IQ','label' => 'Arabic (Iraq)', 'flag' => 'iq'],
    ['value' => 'ar_JO','label' => 'Arabic (Jordan)', 'flag' => 'jo'],
    ['value' => 'ar_KW','label' => 'Arabic (Kuwait)', 'flag' => 'kw'],
    ['value' => 'ar_LB','label' => 'Arabic (Lebanon)', 'flag' => 'lb'],
    ['value' => 'ar_LY','label' => 'Arabic (Libya)', 'flag' => 'ly'],
    ['value' => 'ar_MA','label' => 'Arabic (Morocco)', 'flag' => 'ma'],
    ['value' => 'ar_OM','label' => 'Arabic (Oman)', 'flag' => 'om'],
    ['value' => 'ar_QA','label' => 'Arabic (Qatar)', 'flag' => 'qa'],
    ['value' => 'ar_SA','label' => 'Arabic (Saudi Arabia)', 'flag' => 'sa'],
    ['value' => 'ar_SD','label' => 'Arabic (Sudan)', 'flag' => 'sd'],
    ['value' => 'ar_SY','label' => 'Arabic (Syria)', 'flag' => 'sy'],
    ['value' => 'ar_TN','label' => 'Arabic (Tunisia)', 'flag' => 'tn'],
    ['value' => 'ar_AE','label' => 'Arabic (United Arab Emirates)', 'flag' => 'ae'],
    ['value' => 'ar_YE','label' => 'Arabic (Yemen)', 'flag' => 'ye'],
    ['value' => 'ar','label' => 'Arabic', 'flag' => 'ar'],
    ['value' => 'hy_AM','label' => 'Armenian (Armenia)', 'flag' => 'am'],
    ['value' => 'hy','label' => 'Armenian', 'flag' => 'hy'],
    ['value' => 'as_IN','label' => 'Assamese (India)', 'flag' => 'in'],
    ['value' => 'as','label' => 'Assamese', 'flag' => 'as'],
    ['value' => 'asa_TZ','label' => 'Asu (Tanzania)', 'flag' => 'tz'],
    ['value' => 'asa','label' => 'Asu', 'flag' => 'asa'],
    ['value' => 'az_Cyrl','label' => 'Azerbaijani (Cyrillic)', 'flag' => 'cyrl'],
    ['value' => 'az_Cyrl_AZ','label' => 'Azerbaijani (Cyrillic, Azerbaijan)', 'flag' => 'az'],
    ['value' => 'az_Latn','label' => 'Azerbaijani (Latin)', 'flag' => 'latn'],
    ['value' => 'az_Latn_AZ','label' => 'Azerbaijani (Latin, Azerbaijan)', 'flag' => 'az'],
    ['value' => 'az','label' => 'Azerbaijani', 'flag' => 'az'],
    ['value' => 'bm_ML','label' => 'Bambara (Mali)', 'flag' => 'ml'],
    ['value' => 'bm','label' => 'Bambara', 'flag' => 'bm'],
    ['value' => 'eu_ES','label' => 'Basque (Spain)', 'flag' => 'es'],
    ['value' => 'eu','label' => 'Basque', 'flag' => 'eu'],
    ['value' => 'be_BY','label' => 'Belarusian (Belarus)', 'flag' => 'by'],
    ['value' => 'be','label' => 'Belarusian', 'flag' => 'be'],
    ['value' => 'bem_ZM','label' => 'Bemba (Zambia)', 'flag' => 'zm'],
    ['value' => 'bem','label' => 'Bemba', 'flag' => 'bem'],
    ['value' => 'bez_TZ','label' => 'Bena (Tanzania)', 'flag' => 'tz'],
    ['value' => 'bez','label' => 'Bena', 'flag' => 'bez'],
    ['value' => 'bn_BD','label' => 'Bengali (Bangladesh)', 'flag' => 'bd'],
    ['value' => 'bn_IN','label' => 'Bengali (India)', 'flag' => 'in'],
    ['value' => 'bn','label' => 'Bengali', 'flag' => 'bn'],
    ['value' => 'bs_BA','label' => 'Bosnian (Bosnia and Herzegovina)', 'flag' => 'ba'],
    ['value' => 'bs','label' => 'Bosnian', 'flag' => 'bs'],
    ['value' => 'bg_BG','label' => 'Bulgarian (Bulgaria)', 'flag' => 'bg'],
    ['value' => 'bg','label' => 'Bulgarian', 'flag' => 'bg'],
    ['value' => 'my_MM','label' => 'Burmese (Myanmar [Burma])', 'flag' => 'mm'],
    ['value' => 'my','label' => 'Burmese', 'flag' => 'my'],
    ['value' => 'yue_Hant_HK','label' => 'Cantonese (Traditional, Hong Kong SAR China)', 'flag' => 'hk'],
    ['value' => 'ca_ES','label' => 'Catalan (Spain)', 'flag' => 'es'],
    ['value' => 'ca','label' => 'Catalan', 'flag' => 'ca'],
    ['value' => 'tzm_Latn','label' => 'Central Morocco Tamazight (Latin)', 'flag' => 'latn'],
    ['value' => 'tzm_Latn_MA','label' => 'Central Morocco Tamazight (Latin, Morocco)', 'flag' => 'ma'],
    ['value' => 'tzm','label' => 'Central Morocco Tamazight', 'flag' => 'tzm'],
    ['value' => 'chr_US','label' => 'Cherokee (United States)', 'flag' => 'us'],
    ['value' => 'chr','label' => 'Cherokee', 'flag' => 'chr'],
    ['value' => 'cgg_UG','label' => 'Chiga (Uganda)', 'flag' => 'ug'],
    ['value' => 'cgg','label' => 'Chiga', 'flag' => 'cgg'],
    ['value' => 'zh_Hans','label' => 'Chinese (Simplified Han)', 'flag' => 'hans'],
    ['value' => 'zh_Hans_CN','label' => 'Chinese (Simplified Han, China)', 'flag' => 'cn'],
    ['value' => 'zh_Hans_HK','label' => 'Chinese (Simplified Han, Hong Kong SAR China)', 'flag' => 'hk'],
    ['value' => 'zh_Hans_MO','label' => 'Chinese (Simplified Han, Macau SAR China)', 'flag' => 'mo'],
    ['value' => 'zh_Hans_SG','label' => 'Chinese (Simplified Han, Singapore)', 'flag' => 'sg'],
    ['value' => 'zh_Hant','label' => 'Chinese (Traditional Han)', 'flag' => 'hant'],
    ['value' => 'zh_Hant_HK','label' => 'Chinese (Traditional Han, Hong Kong SAR China)', 'flag' => 'hk'],
    ['value' => 'zh_Hant_MO','label' => 'Chinese (Traditional Han, Macau SAR China)', 'flag' => 'mo'],
    ['value' => 'zh_Hant_TW','label' => 'Chinese (Traditional Han, Taiwan)', 'flag' => 'tw'],
    ['value' => 'zh','label' => 'Chinese', 'flag' => 'cn'],
    ['value' => 'kw_GB','label' => 'Cornish (United Kingdom)', 'flag' => 'gb'],
    ['value' => 'kw','label' => 'Cornish', 'flag' => 'kw'],
    ['value' => 'hr_HR','label' => 'Croatian (Croatia)', 'flag' => 'hr'],
    ['value' => 'hr','label' => 'Croatian', 'flag' => 'hr'],
    ['value' => 'cs_CZ','label' => 'Czech (Czech Republic)', 'flag' => 'cz'],
    ['value' => 'cs','label' => 'Czech', 'flag' => 'cz'],
    ['value' => 'da_DK','label' => 'Danish (Denmark)', 'flag' => 'dk'],
    ['value' => 'da','label' => 'Danish', 'flag' => 'da'],
    ['value' => 'nl_BE','label' => 'Dutch (Belgium)', 'flag' => 'be'],
    ['value' => 'nl_NL','label' => 'Dutch (Netherlands)', 'flag' => 'nl'],
    ['value' => 'nl','label' => 'Dutch', 'flag' => 'nl'],
    ['value' => 'ebu_KE','label' => 'Embu (Kenya)', 'flag' => 'ke'],
    ['value' => 'ebu','label' => 'Embu', 'flag' => 'ebu'],
    ['value' => 'en_US','label' => 'English (United States)', 'flag' => 'us'],
    ['value' => 'en_GB','label' => 'English (United Kingdom)', 'flag' => 'gb'],
    ['value' => 'en_AS','label' => 'English (American Samoa)', 'flag' => 'as'],
    ['value' => 'en_AU','label' => 'English (Australia)', 'flag' => 'au'],
    ['value' => 'en_BE','label' => 'English (Belgium)', 'flag' => 'be'],
    ['value' => 'en_BZ','label' => 'English (Belize)', 'flag' => 'bz'],
    ['value' => 'en_BW','label' => 'English (Botswana)', 'flag' => 'bw'],
    ['value' => 'en_CA','label' => 'English (Canada)', 'flag' => 'ca'],
    ['value' => 'en_GU','label' => 'English (Guam)', 'flag' => 'gu'],
    ['value' => 'en_HK','label' => 'English (Hong Kong SAR China)', 'flag' => 'hk'],
    ['value' => 'en_IN','label' => 'English (India)', 'flag' => 'in'],
    ['value' => 'en_IE','label' => 'English (Ireland)', 'flag' => 'ie'],
    ['value' => 'en_IL','label' => 'English (Israel)', 'flag' => 'il'],
    ['value' => 'en_JM','label' => 'English (Jamaica)', 'flag' => 'jm'],
    ['value' => 'en_MT','label' => 'English (Malta)', 'flag' => 'mt'],
    ['value' => 'en_MH','label' => 'English (Marshall Islands)', 'flag' => 'mh'],
    ['value' => 'en_MU','label' => 'English (Mauritius)', 'flag' => 'mu'],
    ['value' => 'en_NA','label' => 'English (Namibia)', 'flag' => 'na'],
    ['value' => 'en_NZ','label' => 'English (New Zealand)', 'flag' => 'nz'],
    ['value' => 'en_MP','label' => 'English (Northern Mariana Islands)', 'flag' => 'mp'],
    ['value' => 'en_PK','label' => 'English (Pakistan)', 'flag' => 'pk'],
    ['value' => 'en_PH','label' => 'English (Philippines)', 'flag' => 'ph'],
    ['value' => 'en_SG','label' => 'English (Singapore)', 'flag' => 'sg'],
    ['value' => 'en_ZA','label' => 'English (South Africa)', 'flag' => 'za'],
    ['value' => 'en_TT','label' => 'English (Trinidad and Tobago)', 'flag' => 'tt'],
    ['value' => 'en_UM','label' => 'English (U.S. Minor Outlying Islands)', 'flag' => 'um'],
    ['value' => 'en_VI','label' => 'English (U.S. Virgin Islands)', 'flag' => 'vi'],
    ['value' => 'en_ZW','label' => 'English (Zimbabwe)', 'flag' => 'zw'],
    ['value' => 'en','label' => 'English', 'flag' => 'us'],
    ['value' => 'eo','label' => 'Esperanto', 'flag' => 'eo'],
    ['value' => 'et_EE','label' => 'Estonian (Estonia)', 'flag' => 'ee'],
    ['value' => 'et','label' => 'Estonian', 'flag' => 'et'],
    ['value' => 'ee_GH','label' => 'Ewe (Ghana)', 'flag' => 'gh'],
    ['value' => 'ee_TG','label' => 'Ewe (Togo)', 'flag' => 'tg'],
    ['value' => 'ee','label' => 'Ewe', 'flag' => 'ee'],
    ['value' => 'fo_FO','label' => 'Faroese (Faroe Islands)', 'flag' => 'fo'],
    ['value' => 'fo','label' => 'Faroese', 'flag' => 'fo'],
    ['value' => 'fil_PH','label' => 'Filipino (Philippines)', 'flag' => 'ph'],
    ['value' => 'fil','label' => 'Filipino', 'flag' => 'fil'],
    ['value' => 'fi_FI','label' => 'Finnish (Finland)', 'flag' => 'fi'],
    ['value' => 'fi','label' => 'Finnish', 'flag' => 'fi'],
    ['value' => 'fr_BE','label' => 'French (Belgium)', 'flag' => 'be'],
    ['value' => 'fr_BJ','label' => 'French (Benin)', 'flag' => 'bj'],
    ['value' => 'fr_BF','label' => 'French (Burkina Faso)', 'flag' => 'bf'],
    ['value' => 'fr_BI','label' => 'French (Burundi)', 'flag' => 'bi'],
    ['value' => 'fr_CM','label' => 'French (Cameroon)', 'flag' => 'cm'],
    ['value' => 'fr_CA','label' => 'French (Canada)', 'flag' => 'ca'],
    ['value' => 'fr_CF','label' => 'French (Central African Republic)', 'flag' => 'cf'],
    ['value' => 'fr_TD','label' => 'French (Chad)', 'flag' => 'td'],
    ['value' => 'fr_KM','label' => 'French (Comoros)', 'flag' => 'km'],
    ['value' => 'fr_CG','label' => 'French (Congo - Brazzaville)', 'flag' => 'cg'],
    ['value' => 'fr_CD','label' => 'French (Congo - Kinshasa)', 'flag' => 'cd'],
    ['value' => 'fr_CI','label' => 'French (Côte d’Ivoire)', 'flag' => 'ci'],
    ['value' => 'fr_DJ','label' => 'French (Djibouti)', 'flag' => 'dj'],
    ['value' => 'fr_GQ','label' => 'French (Equatorial Guinea)', 'flag' => 'gq'],
    ['value' => 'fr_FR','label' => 'French (France)', 'flag' => 'fr'],
    ['value' => 'fr_GA','label' => 'French (Gabon)', 'flag' => 'ga'],
    ['value' => 'fr_GP','label' => 'French (Guadeloupe)', 'flag' => 'gp'],
    ['value' => 'fr_GN','label' => 'French (Guinea)', 'flag' => 'gn'],
    ['value' => 'fr_LU','label' => 'French (Luxembourg)', 'flag' => 'lu'],
    ['value' => 'fr_MG','label' => 'French (Madagascar)', 'flag' => 'mg'],
    ['value' => 'fr_ML','label' => 'French (Mali)', 'flag' => 'ml'],
    ['value' => 'fr_MQ','label' => 'French (Martinique)', 'flag' => 'mq'],
    ['value' => 'fr_MC','label' => 'French (Monaco)', 'flag' => 'mc'],
    ['value' => 'fr_NE','label' => 'French (Niger)', 'flag' => 'ne'],
    ['value' => 'fr_RW','label' => 'French (Rwanda)', 'flag' => 'rw'],
    ['value' => 'fr_RE','label' => 'French (Réunion)', 'flag' => 're'],
    ['value' => 'fr_BL','label' => 'French (Saint Barthélemy)', 'flag' => 'bl'],
    ['value' => 'fr_MF','label' => 'French (Saint Martin)', 'flag' => 'mf'],
    ['value' => 'fr_SN','label' => 'French (Senegal)', 'flag' => 'sn'],
    ['value' => 'fr_CH','label' => 'French (Switzerland)', 'flag' => 'ch'],
    ['value' => 'fr_TG','label' => 'French (Togo)', 'flag' => 'tg'],
    ['value' => 'fr','label' => 'French', 'flag' => 'fr'],
    ['value' => 'ff_SN','label' => 'Fulah (Senegal)', 'flag' => 'sn'],
    ['value' => 'ff','label' => 'Fulah', 'flag' => 'ff'],
    ['value' => 'gl_ES','label' => 'Galician (Spain)', 'flag' => 'es'],
    ['value' => 'gl','label' => 'Galician', 'flag' => 'gl'],
    ['value' => 'lg_UG','label' => 'Ganda (Uganda)', 'flag' => 'ug'],
    ['value' => 'lg','label' => 'Ganda', 'flag' => 'lg'],
    ['value' => 'ka_GE','label' => 'Georgian (Georgia)', 'flag' => 'ge'],
    ['value' => 'ka','label' => 'Georgian', 'flag' => 'ka'],
    ['value' => 'de_AT','label' => 'German (Austria)', 'flag' => 'at'],
    ['value' => 'de_BE','label' => 'German (Belgium)', 'flag' => 'be'],
    ['value' => 'de_DE','label' => 'German (Germany)', 'flag' => 'de'],
    ['value' => 'de_LI','label' => 'German (Liechtenstein)', 'flag' => 'li'],
    ['value' => 'de_LU','label' => 'German (Luxembourg)', 'flag' => 'lu'],
    ['value' => 'de_CH','label' => 'German (Switzerland)', 'flag' => 'ch'],
    ['value' => 'de','label' => 'German', 'flag' => 'de'],
    ['value' => 'el_CY','label' => 'Greek (Cyprus)', 'flag' => 'cy'],
    ['value' => 'el_GR','label' => 'Greek (Greece)', 'flag' => 'gr'],
    ['value' => 'el','label' => 'Greek', 'flag' => 'gr'],
    ['value' => 'gu_IN','label' => 'Gujarati (India)', 'flag' => 'in'],
    ['value' => 'gu','label' => 'Gujarati', 'flag' => 'gu'],
    ['value' => 'guz_KE','label' => 'Gusii (Kenya)', 'flag' => 'ke'],
    ['value' => 'guz','label' => 'Gusii', 'flag' => 'guz'],
    ['value' => 'ha_Latn','label' => 'Hausa (Latin)', 'flag' => 'latn'],
    ['value' => 'ha_Latn_GH','label' => 'Hausa (Latin, Ghana)', 'flag' => 'gh'],
    ['value' => 'ha_Latn_NE','label' => 'Hausa (Latin, Niger)', 'flag' => 'ne'],
    ['value' => 'ha_Latn_NG','label' => 'Hausa (Latin, Nigeria)', 'flag' => 'ng'],
    ['value' => 'ha','label' => 'Hausa', 'flag' => 'ha'],
    ['value' => 'haw_US','label' => 'Hawaiian (United States)', 'flag' => 'us'],
    ['value' => 'haw','label' => 'Hawaiian', 'flag' => 'haw'],
    ['value' => 'he_IL','label' => 'Hebrew (Israel)', 'flag' => 'il'],
    ['value' => 'he','label' => 'Hebrew', 'flag' => 'il'],
    ['value' => 'hi_IN','label' => 'Hindi (India)', 'flag' => 'in'],
    ['value' => 'hi','label' => 'Hindi', 'flag' => 'hi'],
    ['value' => 'hu_HU','label' => 'Hungarian (Hungary)', 'flag' => 'hu'],
    ['value' => 'hu','label' => 'Hungarian', 'flag' => 'hu'],
    ['value' => 'is_IS','label' => 'Icelandic (Iceland)', 'flag' => 'is'],
    ['value' => 'is','label' => 'Icelandic', 'flag' => 'is'],
    ['value' => 'ig_NG','label' => 'Igbo (Nigeria)', 'flag' => 'ng'],
    ['value' => 'ig','label' => 'Igbo', 'flag' => 'ig'],
    ['value' => 'id_ID','label' => 'Indonesian (Indonesia)', 'flag' => 'id'],
    ['value' => 'id','label' => 'Indonesian', 'flag' => 'id'],
    ['value' => 'ga_IE','label' => 'Irish (Ireland)', 'flag' => 'ie'],
    ['value' => 'ga','label' => 'Irish', 'flag' => 'ga'],
    ['value' => 'it_IT','label' => 'Italian (Italy)', 'flag' => 'it'],
    ['value' => 'it_CH','label' => 'Italian (Switzerland)', 'flag' => 'ch'],
    ['value' => 'it','label' => 'Italian', 'flag' => 'it'],
    ['value' => 'ja_JP','label' => 'Japanese (Japan)', 'flag' => 'jp'],
    ['value' => 'ja','label' => 'Japanese', 'flag' => 'ja'],
    ['value' => 'kea_CV','label' => 'Kabuverdianu (Cape Verde)', 'flag' => 'cv'],
    ['value' => 'kea','label' => 'Kabuverdianu', 'flag' => 'kea'],
    ['value' => 'kab_DZ','label' => 'Kabyle (Algeria)', 'flag' => 'dz'],
    ['value' => 'kab','label' => 'Kabyle', 'flag' => 'kab'],
    ['value' => 'kl_GL','label' => 'Kalaallisut (Greenland)', 'flag' => 'gl'],
    ['value' => 'kl','label' => 'Kalaallisut', 'flag' => 'kl'],
    ['value' => 'kln_KE','label' => 'Kalenjin (Kenya)', 'flag' => 'ke'],
    ['value' => 'kln','label' => 'Kalenjin', 'flag' => 'kln'],
    ['value' => 'kam_KE','label' => 'Kamba (Kenya)', 'flag' => 'ke'],
    ['value' => 'kam','label' => 'Kamba', 'flag' => 'kam'],
    ['value' => 'kn_IN','label' => 'Kannada (India)', 'flag' => 'in'],
    ['value' => 'kn','label' => 'Kannada', 'flag' => 'kn'],
    ['value' => 'kk_Cyrl','label' => 'Kazakh (Cyrillic)', 'flag' => 'cyrl'],
    ['value' => 'kk_Cyrl_KZ','label' => 'Kazakh (Cyrillic, Kazakhstan)', 'flag' => 'kz'],
    ['value' => 'kk','label' => 'Kazakh', 'flag' => 'kk'],
    ['value' => 'km_KH','label' => 'Khmer (Cambodia)', 'flag' => 'kh'],
    ['value' => 'km','label' => 'Khmer', 'flag' => 'km'],
    ['value' => 'ki_KE','label' => 'Kikuyu (Kenya)', 'flag' => 'ke'],
    ['value' => 'ki','label' => 'Kikuyu', 'flag' => 'ki'],
    ['value' => 'rw_RW','label' => 'Kinyarwanda (Rwanda)', 'flag' => 'rw'],
    ['value' => 'rw','label' => 'Kinyarwanda', 'flag' => 'rw'],
    ['value' => 'kok_IN','label' => 'Konkani (India)', 'flag' => 'in'],
    ['value' => 'kok','label' => 'Konkani', 'flag' => 'kok'],
    ['value' => 'ko_KR','label' => 'Korean (South Korea)', 'flag' => 'kr'],
    ['value' => 'ko','label' => 'Korean', 'flag' => 'ko'],
    ['value' => 'khq_ML','label' => 'Koyra Chiini (Mali)', 'flag' => 'ml'],
    ['value' => 'khq','label' => 'Koyra Chiini', 'flag' => 'khq'],
    ['value' => 'ses_ML','label' => 'Koyraboro Senni (Mali)', 'flag' => 'ml'],
    ['value' => 'ses','label' => 'Koyraboro Senni', 'flag' => 'ses'],
    ['value' => 'lag_TZ','label' => 'Langi (Tanzania)', 'flag' => 'tz'],
    ['value' => 'lag','label' => 'Langi', 'flag' => 'lag'],
    ['value' => 'lv_LV','label' => 'Latvian (Latvia)', 'flag' => 'lv'],
    ['value' => 'lv','label' => 'Latvian', 'flag' => 'lv'],
    ['value' => 'lt_LT','label' => 'Lithuanian (Lithuania)', 'flag' => 'lt'],
    ['value' => 'lt','label' => 'Lithuanian', 'flag' => 'lt'],
    ['value' => 'luo_KE','label' => 'Luo (Kenya)', 'flag' => 'ke'],
    ['value' => 'luo','label' => 'Luo', 'flag' => 'luo'],
    ['value' => 'luy_KE','label' => 'Luyia (Kenya)', 'flag' => 'ke'],
    ['value' => 'luy','label' => 'Luyia', 'flag' => 'luy'],
    ['value' => 'mk_MK','label' => 'Macedonian (Macedonia)', 'flag' => 'mk'],
    ['value' => 'mk','label' => 'Macedonian', 'flag' => 'mk'],
    ['value' => 'jmc_TZ','label' => 'Machame (Tanzania)', 'flag' => 'tz'],
    ['value' => 'jmc','label' => 'Machame', 'flag' => 'jmc'],
    ['value' => 'kde_TZ','label' => 'Makonde (Tanzania)', 'flag' => 'tz'],
    ['value' => 'kde','label' => 'Makonde', 'flag' => 'kde'],
    ['value' => 'mg_MG','label' => 'Malagasy (Madagascar)', 'flag' => 'mg'],
    ['value' => 'mg','label' => 'Malagasy', 'flag' => 'mg'],
    ['value' => 'ms_BN','label' => 'Malay (Brunei)', 'flag' => 'bn'],
    ['value' => 'ms_MY','label' => 'Malay (Malaysia)', 'flag' => 'my'],
    ['value' => 'ms','label' => 'Malay', 'flag' => 'ms'],
    ['value' => 'ml_IN','label' => 'Malayalam (India)', 'flag' => 'in'],
    ['value' => 'ml','label' => 'Malayalam', 'flag' => 'ml'],
    ['value' => 'mt_MT','label' => 'Maltese (Malta)', 'flag' => 'mt'],
    ['value' => 'mt','label' => 'Maltese', 'flag' => 'mt'],
    ['value' => 'gv_GB','label' => 'Manx (United Kingdom)', 'flag' => 'gb'],
    ['value' => 'gv','label' => 'Manx', 'flag' => 'gv'],
    ['value' => 'mr_IN','label' => 'Marathi (India)', 'flag' => 'in'],
    ['value' => 'mr','label' => 'Marathi', 'flag' => 'mr'],
    ['value' => 'mas_KE','label' => 'Masai (Kenya)', 'flag' => 'ke'],
    ['value' => 'mas_TZ','label' => 'Masai (Tanzania)', 'flag' => 'tz'],
    ['value' => 'mas','label' => 'Masai', 'flag' => 'mas'],
    ['value' => 'mer_KE','label' => 'Meru (Kenya)', 'flag' => 'ke'],
    ['value' => 'mer','label' => 'Meru', 'flag' => 'mer'],
    ['value' => 'mfe_MU','label' => 'Morisyen (Mauritius)', 'flag' => 'mu'],
    ['value' => 'mfe','label' => 'Morisyen', 'flag' => 'mfe'],
    ['value' => 'naq_NA','label' => 'Nama (Namibia)', 'flag' => 'na'],
    ['value' => 'naq','label' => 'Nama', 'flag' => 'naq'],
    ['value' => 'ne_IN','label' => 'Nepali (India)', 'flag' => 'in'],
    ['value' => 'ne_NP','label' => 'Nepali (Nepal)', 'flag' => 'np'],
    ['value' => 'ne','label' => 'Nepali', 'flag' => 'ne'],
    ['value' => 'nd_ZW','label' => 'North Ndebele (Zimbabwe)', 'flag' => 'zw'],
    ['value' => 'nd','label' => 'North Ndebele', 'flag' => 'nd'],
    ['value' => 'nb_NO','label' => 'Norwegian Bokmål (Norway)', 'flag' => 'no'],
    ['value' => 'nb','label' => 'Norwegian Bokmål', 'flag' => 'nb'],
    ['value' => 'nn_NO','label' => 'Norwegian Nynorsk (Norway)', 'flag' => 'no'],
    ['value' => 'nn','label' => 'Norwegian Nynorsk', 'flag' => 'nn'],
    ['value' => 'nyn_UG','label' => 'Nyankole (Uganda)', 'flag' => 'ug'],
    ['value' => 'nyn','label' => 'Nyankole', 'flag' => 'nyn'],
    ['value' => 'or_IN','label' => 'Oriya (India)', 'flag' => 'in'],
    ['value' => 'or','label' => 'Oriya', 'flag' => 'or'],
    ['value' => 'om_ET','label' => 'Oromo (Ethiopia)', 'flag' => 'et'],
    ['value' => 'om_KE','label' => 'Oromo (Kenya)', 'flag' => 'ke'],
    ['value' => 'om','label' => 'Oromo', 'flag' => 'om'],
    ['value' => 'ps_AF','label' => 'Pashto (Afghanistan)', 'flag' => 'af'],
    ['value' => 'ps','label' => 'Pashto', 'flag' => 'ps'],
    ['value' => 'fa_AF','label' => 'Persian (Afghanistan)', 'flag' => 'af'],
    ['value' => 'fa_IR','label' => 'Persian (Iran)', 'flag' => 'ir'],
    ['value' => 'fa','label' => 'Persian', 'flag' => 'fa'],
    ['value' => 'pl_PL','label' => 'Polish (Poland)', 'flag' => 'pl'],
    ['value' => 'pl','label' => 'Polish', 'flag' => 'pl'],
    ['value' => 'pt_BR','label' => 'Portuguese (Brazil)', 'flag' => 'br'],
    ['value' => 'pt_GW','label' => 'Portuguese (Guinea-Bissau)', 'flag' => 'gw'],
    ['value' => 'pt_MZ','label' => 'Portuguese (Mozambique)', 'flag' => 'mz'],
    ['value' => 'pt_PT','label' => 'Portuguese (Portugal)', 'flag' => 'pt'],
    ['value' => 'pt','label' => 'Portuguese', 'flag' => 'pt'],
    ['value' => 'pa_Arab','label' => 'Punjabi (Arabic)', 'flag' => 'arab'],
    ['value' => 'pa_Arab_PK','label' => 'Punjabi (Arabic, Pakistan)', 'flag' => 'pk'],
    ['value' => 'pa_Guru','label' => 'Punjabi (Gurmukhi)', 'flag' => 'guru'],
    ['value' => 'pa_Guru_IN','label' => 'Punjabi (Gurmukhi, India)', 'flag' => 'in'],
    ['value' => 'pa','label' => 'Punjabi', 'flag' => 'pa'],
    ['value' => 'ro_MD','label' => 'Romanian (Moldova)', 'flag' => 'md'],
    ['value' => 'ro_RO','label' => 'Romanian (Romania)', 'flag' => 'ro'],
    ['value' => 'ro','label' => 'Romanian', 'flag' => 'ro'],
    ['value' => 'rm_CH','label' => 'Romansh (Switzerland)', 'flag' => 'ch'],
    ['value' => 'rm','label' => 'Romansh', 'flag' => 'rm'],
    ['value' => 'rof_TZ','label' => 'Rombo (Tanzania)', 'flag' => 'tz'],
    ['value' => 'rof','label' => 'Rombo', 'flag' => 'rof'],
    ['value' => 'ru_MD','label' => 'Russian (Moldova)', 'flag' => 'md'],
    ['value' => 'ru_RU','label' => 'Russian (Russia)', 'flag' => 'ru'],
    ['value' => 'ru_UA','label' => 'Russian (Ukraine)', 'flag' => 'ua'],
    ['value' => 'ru','label' => 'Russian', 'flag' => 'ru'],
    ['value' => 'rwk_TZ','label' => 'Rwa (Tanzania)', 'flag' => 'tz'],
    ['value' => 'rwk','label' => 'Rwa', 'flag' => 'rwk'],
    ['value' => 'saq_KE','label' => 'Samburu (Kenya)', 'flag' => 'ke'],
    ['value' => 'saq','label' => 'Samburu', 'flag' => 'saq'],
    ['value' => 'sg_CF','label' => 'Sango (Central African Republic)', 'flag' => 'cf'],
    ['value' => 'sg','label' => 'Sango', 'flag' => 'sg'],
    ['value' => 'seh_MZ','label' => 'Sena (Mozambique)', 'flag' => 'mz'],
    ['value' => 'seh','label' => 'Sena', 'flag' => 'seh'],
    ['value' => 'sr_Cyrl','label' => 'Serbian (Cyrillic)', 'flag' => 'cyrl'],
    ['value' => 'sr_Cyrl_BA','label' => 'Serbian (Cyrillic, Bosnia and Herzegovina)', 'flag' => 'ba'],
    ['value' => 'sr_Cyrl_ME','label' => 'Serbian (Cyrillic, Montenegro)', 'flag' => 'me'],
    ['value' => 'sr_Cyrl_RS','label' => 'Serbian (Cyrillic, Serbia)', 'flag' => 'rs'],
    ['value' => 'sr_Latn','label' => 'Serbian (Latin)', 'flag' => 'latn'],
    ['value' => 'sr_Latn_BA','label' => 'Serbian (Latin, Bosnia and Herzegovina)', 'flag' => 'ba'],
    ['value' => 'sr_Latn_ME','label' => 'Serbian (Latin, Montenegro)', 'flag' => 'me'],
    ['value' => 'sr_Latn_RS','label' => 'Serbian (Latin, Serbia)', 'flag' => 'rs'],
    ['value' => 'sr','label' => 'Serbian', 'flag' => 'sr'],
    ['value' => 'sn_ZW','label' => 'Shona (Zimbabwe)', 'flag' => 'zw'],
    ['value' => 'sn','label' => 'Shona', 'flag' => 'sn'],
    ['value' => 'ii_CN','label' => 'Sichuan Yi (China)', 'flag' => 'cn'],
    ['value' => 'ii','label' => 'Sichuan Yi', 'flag' => 'ii'],
    ['value' => 'si_LK','label' => 'Sinhala (Sri Lanka)', 'flag' => 'lk'],
    ['value' => 'si','label' => 'Sinhala', 'flag' => 'si'],
    ['value' => 'sk_SK','label' => 'Slovak (Slovakia)', 'flag' => 'sk'],
    ['value' => 'sk','label' => 'Slovak', 'flag' => 'sk'],
    ['value' => 'sl_SI','label' => 'Slovenian (Slovenia)', 'flag' => 'si'],
    ['value' => 'sl','label' => 'Slovenian', 'flag' => 'sl'],
    ['value' => 'xog_UG','label' => 'Soga (Uganda)', 'flag' => 'ug'],
    ['value' => 'xog','label' => 'Soga', 'flag' => 'xog'],
    ['value' => 'so_DJ','label' => 'Somali (Djibouti)', 'flag' => 'dj'],
    ['value' => 'so_ET','label' => 'Somali (Ethiopia)', 'flag' => 'et'],
    ['value' => 'so_KE','label' => 'Somali (Kenya)', 'flag' => 'ke'],
    ['value' => 'so_SO','label' => 'Somali (Somalia)', 'flag' => 'so'],
    ['value' => 'so','label' => 'Somali', 'flag' => 'so'],
    ['value' => 'es_AR','label' => 'Spanish (Argentina)', 'flag' => 'ar'],
    ['value' => 'es_BO','label' => 'Spanish (Bolivia)', 'flag' => 'bo'],
    ['value' => 'es_CL','label' => 'Spanish (Chile)', 'flag' => 'cl'],
    ['value' => 'es_CO','label' => 'Spanish (Colombia)', 'flag' => 'co'],
    ['value' => 'es_CR','label' => 'Spanish (Costa Rica)', 'flag' => 'cr'],
    ['value' => 'es_DO','label' => 'Spanish (Dominican Republic)', 'flag' => 'do'],
    ['value' => 'es_EC','label' => 'Spanish (Ecuador)', 'flag' => 'ec'],
    ['value' => 'es_SV','label' => 'Spanish (El Salvador)', 'flag' => 'sv'],
    ['value' => 'es_GQ','label' => 'Spanish (Equatorial Guinea)', 'flag' => 'gq'],
    ['value' => 'es_GT','label' => 'Spanish (Guatemala)', 'flag' => 'gt'],
    ['value' => 'es_HN','label' => 'Spanish (Honduras)', 'flag' => 'hn'],
    ['value' => 'es_419','label' => 'Spanish (Latin America)', 'flag' => '419'],
    ['value' => 'es_MX','label' => 'Spanish (Mexico)', 'flag' => 'mx'],
    ['value' => 'es_NI','label' => 'Spanish (Nicaragua)', 'flag' => 'ni'],
    ['value' => 'es_PA','label' => 'Spanish (Panama)', 'flag' => 'pa'],
    ['value' => 'es_PY','label' => 'Spanish (Paraguay)', 'flag' => 'py'],
    ['value' => 'es_PE','label' => 'Spanish (Peru)', 'flag' => 'pe'],
    ['value' => 'es_PR','label' => 'Spanish (Puerto Rico)', 'flag' => 'pr'],
    ['value' => 'es_ES','label' => 'Spanish (Spain)', 'flag' => 'es'],
    //array('value' => 'es_US','label' => 'Spanish (United States)', 'flag' => 'us'),
    ['value' => 'es_UY','label' => 'Spanish (Uruguay)', 'flag' => 'uy'],
    ['value' => 'es_VE','label' => 'Spanish (Venezuela)', 'flag' => 've'],
    ['value' => 'es','label' => 'Spanish', 'flag' => 'es'],
    ['value' => 'sw_KE','label' => 'Swahili (Kenya)', 'flag' => 'ke'],
    ['value' => 'sw_TZ','label' => 'Swahili (Tanzania)', 'flag' => 'tz'],
    ['value' => 'sw','label' => 'Swahili', 'flag' => 'sw'],
    ['value' => 'sv_FI','label' => 'Swedish (Finland)', 'flag' => 'fi'],
    ['value' => 'sv_SE','label' => 'Swedish (Sweden)', 'flag' => 'se'],
    ['value' => 'sv','label' => 'Swedish', 'flag' => 'sv'],
    ['value' => 'gsw_CH','label' => 'Swiss German (Switzerland)', 'flag' => 'ch'],
    ['value' => 'gsw','label' => 'Swiss German', 'flag' => 'gsw'],
    ['value' => 'shi_Latn','label' => 'Tachelhit (Latin)', 'flag' => 'latn'],
    ['value' => 'shi_Latn_MA','label' => 'Tachelhit (Latin, Morocco)', 'flag' => 'ma'],
    ['value' => 'shi_Tfng','label' => 'Tachelhit (Tifinagh)', 'flag' => 'tfng'],
    ['value' => 'shi_Tfng_MA','label' => 'Tachelhit (Tifinagh, Morocco)', 'flag' => 'ma'],
    ['value' => 'shi','label' => 'Tachelhit', 'flag' => 'shi'],
    ['value' => 'dav_KE','label' => 'Taita (Kenya)', 'flag' => 'ke'],
    ['value' => 'dav','label' => 'Taita', 'flag' => 'dav'],
    ['value' => 'ta_IN','label' => 'Tamil (India)', 'flag' => 'in'],
    ['value' => 'ta_LK','label' => 'Tamil (Sri Lanka)', 'flag' => 'lk'],
    ['value' => 'ta','label' => 'Tamil', 'flag' => 'ta'],
    ['value' => 'te_IN','label' => 'Telugu (India)', 'flag' => 'in'],
    ['value' => 'te','label' => 'Telugu', 'flag' => 'te'],
    ['value' => 'teo_KE','label' => 'Teso (Kenya)', 'flag' => 'ke'],
    ['value' => 'teo_UG','label' => 'Teso (Uganda)', 'flag' => 'ug'],
    ['value' => 'teo','label' => 'Teso', 'flag' => 'teo'],
    ['value' => 'th_TH','label' => 'Thai (Thailand)', 'flag' => 'th'],
    ['value' => 'th','label' => 'Thai', 'flag' => 'th'],
    ['value' => 'bo_CN','label' => 'Tibetan (China)', 'flag' => 'cn'],
    ['value' => 'bo_IN','label' => 'Tibetan (India)', 'flag' => 'in'],
    ['value' => 'bo','label' => 'Tibetan', 'flag' => 'bo'],
    ['value' => 'ti_ER','label' => 'Tigrinya (Eritrea)', 'flag' => 'er'],
    ['value' => 'ti_ET','label' => 'Tigrinya (Ethiopia)', 'flag' => 'et'],
    ['value' => 'ti','label' => 'Tigrinya', 'flag' => 'ti'],
    ['value' => 'to_TO','label' => 'Tonga (Tonga)', 'flag' => 'to'],
    ['value' => 'to','label' => 'Tonga', 'flag' => 'to'],
    ['value' => 'tr_TR','label' => 'Turkish (Turkey)', 'flag' => 'tr'],
    ['value' => 'tr','label' => 'Turkish', 'flag' => 'tr'],
    ['value' => 'uk_UA','label' => 'Ukrainian (Ukraine)', 'flag' => 'ua'],
    ['value' => 'uk','label' => 'Ukrainian', 'flag' => 'uk'],
    ['value' => 'ur_IN','label' => 'Urdu (India)', 'flag' => 'in'],
    ['value' => 'ur_PK','label' => 'Urdu (Pakistan)', 'flag' => 'pk'],
    ['value' => 'ur','label' => 'Urdu', 'flag' => 'ur'],
    ['value' => 'uz_Arab','label' => 'Uzbek (Arabic)', 'flag' => 'arab'],
    ['value' => 'uz_Arab_AF','label' => 'Uzbek (Arabic, Afghanistan)', 'flag' => 'af'],
    ['value' => 'uz_Cyrl','label' => 'Uzbek (Cyrillic)', 'flag' => 'cyrl'],
    ['value' => 'uz_Cyrl_UZ','label' => 'Uzbek (Cyrillic, Uzbekistan)', 'flag' => 'uz'],
    ['value' => 'uz_Latn','label' => 'Uzbek (Latin)', 'flag' => 'latn'],
    ['value' => 'uz_Latn_UZ','label' => 'Uzbek (Latin, Uzbekistan)', 'flag' => 'uz'],
    ['value' => 'uz','label' => 'Uzbek', 'flag' => 'uz'],
    ['value' => 'vi_VN','label' => 'Vietnamese (Vietnam)', 'flag' => 'vn'],
    ['value' => 'vi','label' => 'Vietnamese', 'flag' => 'vi'],
    ['value' => 'vun_TZ','label' => 'Vunjo (Tanzania)', 'flag' => 'tz'],
    ['value' => 'vun','label' => 'Vunjo', 'flag' => 'vun'],
    ['value' => 'cy_GB','label' => 'Welsh (United Kingdom)', 'flag' => 'gb'],
    ['value' => 'cy','label' => 'Welsh', 'flag' => 'cy'],
    ['value' => 'yo_NG','label' => 'Yoruba (Nigeria)', 'flag' => 'ng'],
    ['value' => 'yo','label' => 'Yoruba', 'flag' => 'yo'],
    ['value' => 'zu_ZA','label' => 'Zulu (South Africa)', 'flag' => 'za'],
    ['value' => 'zu','label' => 'Zulu', 'flag' => 'zu']
];

$global['bcp47'] = [];
$global['langs_codes_values'] = [];
$global['langs_codes_values_withdot'] = [];


foreach ($global['langs_codes'] as $value) {
    $global['bcp47'][$value['value']] = $value;
    $global['flag2Lang'][$value['flag']] = $value['value'];
    $global['langs_codes_values'][] = $value['value'];
    $global['langs_codes_values_withdot'][] = '.' . $value['value'];
}
$global['flag2Lang']['en'] = 'en_US';
$global['flag2Lang']['us'] = 'en_US';

$global['js_availableLangs'] = 'var availableLangs = ' . json_encode($global['langs_codes']) . ';';
