/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.SmartClip;

public class AutomatchStartWindow
extends AFrame
implements ActionListener {
    private static final SmartClip chime = new SmartClip("/org/igoweb/igoweb/client/swing/sounds/automatchStart.wav");
    private Timer timer;
    private JLabel countdownLabel;
    private int showTime;
    private NumberFormat nf = NumberFormat.getInstance();

    public AutomatchStartWindow(JFrame parent, int timeout) {
        super(Defs.getString(-903340566, parent));
        this.showTime = (timeout + 999) / 1000;
        this.timer = new Timer(1000, this);
        if ((timeout %= 1000) != 0) {
            this.timer.setInitialDelay(timeout);
        }
        this.timer.start();
        JPanel panel = AutomatchStartWindow.createBorderedPanel(new GCLayout());
        this.getContentPane().add(panel);
        panel.add(new JLabel(Defs.getString(-903340565), 0));
        this.countdownLabel = new JLabel(this.nf.format(this.showTime), 0);
        panel.add("x=0", this.countdownLabel);
        Font font = this.countdownLabel.getFont();
        this.countdownLabel.setFont(new Font(font.getName(), 1, font.getSize() * 4));
        panel.add("x=0", new JLabel(Defs.getString(-903340564), 0));
        this.pack();
        try {
            this.getClass().getMethod("setAlwaysOnTop", Boolean.TYPE).invoke((Object)this, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setVisible(true);
        if (Defs.isSoundEnabled()) {
            chime.play();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (Defs.isSoundEnabled() && !chime.isRunning()) {
            chime.play();
        }
        if (--this.showTime == 0) {
            this.dispose();
        } else {
            this.countdownLabel.setText(this.nf.format(this.showTime));
        }
    }

    @Override
    public void dispose() {
        this.timer.stop();
        super.dispose();
    }
}

