/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.animation.parse;

import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.ic.doc.natutil.MacroException;
import uk.ac.ic.doc.natutil.MacroExpander;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.Input;
import uk.ac.ic.doc.scenebeans.Layered;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.Transform;
import uk.ac.ic.doc.scenebeans.activity.Activity;
import uk.ac.ic.doc.scenebeans.activity.ActivityRunner;
import uk.ac.ic.doc.scenebeans.activity.CompositeActivity;
import uk.ac.ic.doc.scenebeans.activity.ConcurrentActivity;
import uk.ac.ic.doc.scenebeans.activity.SequentialActivity;
import uk.ac.ic.doc.scenebeans.animation.Animation;
import uk.ac.ic.doc.scenebeans.animation.AnnounceCommand;
import uk.ac.ic.doc.scenebeans.animation.Command;
import uk.ac.ic.doc.scenebeans.animation.CompositeCommand;
import uk.ac.ic.doc.scenebeans.animation.EventInvoker;
import uk.ac.ic.doc.scenebeans.animation.ResetActivityCommand;
import uk.ac.ic.doc.scenebeans.animation.SetParameterCommand;
import uk.ac.ic.doc.scenebeans.animation.StartActivityCommand;
import uk.ac.ic.doc.scenebeans.animation.StopActivityCommand;
import uk.ac.ic.doc.scenebeans.animation.parse.AnimationParseException;
import uk.ac.ic.doc.scenebeans.animation.parse.BeanFactory;
import uk.ac.ic.doc.scenebeans.animation.parse.BeanUtil;
import uk.ac.ic.doc.scenebeans.animation.parse.BehaviourLink;
import uk.ac.ic.doc.scenebeans.animation.parse.EventLink;
import uk.ac.ic.doc.scenebeans.animation.parse.ExprUtil;
import uk.ac.ic.doc.scenebeans.animation.parse.ValueParser;
import uk.ac.ic.doc.scenebeans.animation.parse.XMLUtil;

public class XMLAnimationParser {
    private BeanFactory _factory = new BeanFactory();
    private Map _symbol_table = new HashMap();
    private List _behaviour_links = new ArrayList();
    private List _event_links = new ArrayList();
    private MacroExpander _macro_table = new MacroExpander();
    ValueParser _value_parser;
    private URL _doc_url;
    private Component _component;
    private Animation _anim = null;
    private static final String PROPERTY_ACTIVITY_NAME = "activityName";
    private static final String PI_TARGET = "scenebeans";
    private static final String PI_CODEBASE = "codebase";
    private static final String PI_CATEGORY = "category";
    private static final String PI_PACKAGE = "package";
    private static final String CATEGORY_SCENE = "scene";
    private static final String PKG_SCENE = "uk.ac.ic.doc.scenebeans";
    private static final String CATEGORY_BEHAVIOUR = "behaviour";
    private static final String PKG_BEHAVIOUR = "uk.ac.ic.doc.scenebeans.behaviour";

    public XMLAnimationParser(URL uRL, Component component) {
        this._doc_url = uRL;
        this._value_parser = new ValueParser(uRL);
        this._component = component;
        this._factory.addCategory(CATEGORY_SCENE, "", "", true);
        this._factory.addPackage(CATEGORY_SCENE, PKG_SCENE);
        this._factory.addCategory(CATEGORY_BEHAVIOUR, "", "", true);
        this._factory.addPackage(CATEGORY_BEHAVIOUR, PKG_BEHAVIOUR);
    }

    public XMLAnimationParser(File file, Component component) throws MalformedURLException {
        this(file.toURL(), component);
    }

    public URL getDocumentURL() {
        return this._doc_url;
    }

    public Component getViewComponent() {
        return this._component;
    }

    public void addScenePackage(String string) {
        this._factory.addPackage(CATEGORY_SCENE, string);
    }

    public void addScenePackage(ClassLoader classLoader, String string) {
        this._factory.addPackage(CATEGORY_SCENE, classLoader, string);
    }

    public void addBehaviourPackage(String string) {
        this._factory.addPackage(CATEGORY_BEHAVIOUR, string);
    }

    public void addBehaviourPackage(ClassLoader classLoader, String string) {
        this._factory.addPackage(CATEGORY_BEHAVIOUR, string);
    }

    public Animation parseAnimation() throws IOException, AnimationParseException {
        try {
            InputSource inputSource = Resolver.createInputSource(this._doc_url, false);
            Parser parser = new Parser();
            XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
            parser.setDocumentHandler(xmlDocumentBuilder);
            parser.parse(inputSource);
            XmlDocument xmlDocument = xmlDocumentBuilder.getDocument();
            xmlDocument.getDocumentElement().normalize();
            return this.translateDocument(xmlDocument);
        }
        catch (SAXParseException sAXParseException) {
            throw new AnimationParseException(sAXParseException.getSystemId() + " line  " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new AnimationParseException("failed to parse XML: " + sAXException.getMessage());
        }
    }

    Animation translateDocument(Document document) throws AnimationParseException {
        Object object;
        this.translateProcessingInstructions(document);
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("animation")) {
            throw new AnimationParseException("invalid document type");
        }
        this._anim = new Animation();
        this.setAnimationDimensions(element, this._anim);
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object instanceof Element) {
                this.translateElement((Element)object);
            }
            ++n;
        }
        object = this._anim;
        this._anim = null;
        return object;
    }

    void translateProcessingInstructions(Document document) throws AnimationParseException {
        NodeList nodeList = document.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof ProcessingInstruction) {
                this.translateProcessingInstruction((ProcessingInstruction)node);
            }
            ++n;
        }
    }

    void translateProcessingInstruction(ProcessingInstruction processingInstruction) throws AnimationParseException {
        Closeable closeable;
        if (!processingInstruction.getTarget().equals(PI_TARGET)) {
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            closeable = new PushbackReader(new StringReader(processingInstruction.getData()));
            while (this.trim((PushbackReader)closeable)) {
                String string4 = this.parseTag((PushbackReader)closeable);
                String string5 = this.parseValue((PushbackReader)closeable);
                if (string4.equals(PI_CODEBASE)) {
                    string = string5;
                    continue;
                }
                if (string4.equals(PI_CATEGORY)) {
                    string2 = string5;
                    continue;
                }
                if (string4.equals(PI_PACKAGE)) {
                    string3 = string5;
                    continue;
                }
                throw new AnimationParseException("unknown element \"" + string4 + "\" in processing instruction");
            }
        }
        catch (IOException iOException) {
            throw new AnimationParseException("failed to parse processing instruction: " + iOException.getMessage());
        }
        if (string2 == null) {
            throw new AnimationParseException("category not specified in processing instruction");
        }
        if (string3 == null) {
            throw new AnimationParseException("package not specified in processing instruction");
        }
        if (string == null) {
            this._factory.addPackage(string2, string3);
        } else {
            try {
                closeable = new URLClassLoader(new URL[]{new URL(this._doc_url, string)});
                this._factory.addPackage(string2, (ClassLoader)((Object)closeable), string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new AnimationParseException("malformed URL in codebase of processing instruction: " + malformedURLException.getMessage());
            }
        }
    }

    private String parseTag(PushbackReader pushbackReader) throws AnimationParseException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = pushbackReader.read()) == -1) {
                throw new AnimationParseException("malformed processing instruction");
            }
            if (n == 61) {
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
    }

    private String parseValue(PushbackReader pushbackReader) throws AnimationParseException, IOException {
        this.expect(pushbackReader, '\"');
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = pushbackReader.read()) == -1) {
                throw new AnimationParseException("malformed processing instruction");
            }
            if (n == 34) {
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
    }

    private boolean trim(PushbackReader pushbackReader) throws IOException {
        int n;
        do {
            if ((n = pushbackReader.read()) != -1) continue;
            return false;
        } while (Character.isWhitespace((char)n));
        pushbackReader.unread(n);
        return true;
    }

    private void expect(PushbackReader pushbackReader, char c) throws AnimationParseException, IOException {
        int n = pushbackReader.read();
        if (n != c) {
            throw new AnimationParseException("malformed processing exception");
        }
    }

    private void setAnimationDimensions(Element element, Animation animation) throws AnimationParseException {
        try {
            String string = this.getOptionalAttribute(element, "width");
            String string2 = this.getOptionalAttribute(element, "height");
            this._anim.setWidth(ExprUtil.evaluate(string));
            this._anim.setHeight(ExprUtil.evaluate(string2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new AnimationParseException("invalid dimension: " + numberFormatException.getMessage());
        }
    }

    void translateElement(Element element) throws AnimationParseException {
        String string = element.getTagName();
        if (string.equals(CATEGORY_BEHAVIOUR)) {
            this.translateBehaviour(element);
        } else if (string.equals("seq")) {
            this.translateSeq(element);
        } else if (string.equals("co")) {
            this.translateCo(element);
        } else if (string.equals("command")) {
            this.translateCommand(element);
        } else if (string.equals("event")) {
            this.translateEvent(element);
        } else if (string.equals("define")) {
            this.translateDefine(element);
        } else if (string.equals("draw")) {
            this.translateDraw(element);
        } else if (string.equals("forall")) {
            this.parseForall(element, new ForallParser(){

                public void parse(Element element) throws AnimationParseException {
                    XMLAnimationParser.this.translateElement(element);
                }
            });
        } else {
            throw new AnimationParseException("invalid element \"" + string + "\"");
        }
    }

    void parseForall(Element element, ForallParser forallParser) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, "var");
        String string2 = this.getRequiredAttribute(element, "values");
        String string3 = this.getOptionalAttribute(element, "sep");
        if (string3 == null) {
            string3 = " \n\t";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            this.addMacro(string, stringTokenizer.nextToken());
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element) {
                    Element element2 = (Element)node;
                    if (element2.getTagName().equals("forall")) {
                        this.parseForall(element2, forallParser);
                    } else {
                        forallParser.parse(element2);
                    }
                }
                ++n;
            }
            this.removeMacro(string);
        }
    }

    void translateBehaviour(Element element) throws AnimationParseException {
        Object object = this.createBehaviour(element);
        if (object instanceof Activity) {
            this.optionalStartActivity(element, (Activity)object);
        }
    }

    void translateSeq(Element element) throws AnimationParseException {
        SequentialActivity sequentialActivity = this.createSequentialActivity(element);
        this.optionalStartActivity(element, sequentialActivity);
    }

    void translateCo(Element element) throws AnimationParseException {
        ConcurrentActivity concurrentActivity = this.createConcurrentActivity(element);
        this.optionalStartActivity(element, concurrentActivity);
    }

    SequentialActivity createSequentialActivity(Element element) throws AnimationParseException {
        SequentialActivity sequentialActivity = new SequentialActivity();
        String string = this.getOptionalAttribute(element, "event");
        if (string != null) {
            sequentialActivity.setActivityName(string);
        }
        this.createSubActivities(sequentialActivity, element);
        this.putOptionalSymbol(element, sequentialActivity);
        return sequentialActivity;
    }

    ConcurrentActivity createConcurrentActivity(Element element) throws AnimationParseException {
        ConcurrentActivity concurrentActivity = new ConcurrentActivity();
        String string = this.getOptionalAttribute(element, "event");
        if (string != null) {
            concurrentActivity.setActivityName(string);
        }
        this.createSubActivities(concurrentActivity, element);
        this.putOptionalSymbol(element, concurrentActivity);
        return concurrentActivity;
    }

    void createSubActivities(CompositeActivity compositeActivity, Element element) throws AnimationParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                this.createSubActivity(compositeActivity, (Element)node);
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void createSubActivity(final CompositeActivity compositeActivity, Element element) throws AnimationParseException {
        String string = element.getTagName();
        if (string.equals("forall")) {
            this.parseForall(element, new ForallParser(){

                public void parse(Element element) throws AnimationParseException {
                    XMLAnimationParser.this.createSubActivity(compositeActivity, element);
                }
            });
            return;
        } else if (string.equals(CATEGORY_BEHAVIOUR)) {
            Object object = this.createBehaviour(element);
            if (!(object instanceof Activity) || !((Activity)object).isFinite()) throw new AnimationParseException(element.getTagName() + " elements can only contain finite behaviours");
            compositeActivity.addActivity((Activity)object);
            return;
        } else if (string.equals("co")) {
            compositeActivity.addActivity(this.createConcurrentActivity(element));
            return;
        } else {
            if (!string.equals("seq")) throw new AnimationParseException("invalid element " + string);
            compositeActivity.addActivity(this.createSequentialActivity(element));
        }
    }

    Object createBehaviour(Element element) throws AnimationParseException {
        try {
            String string = this.getRequiredAttribute(element, "algorithm");
            String string2 = this.getOptionalAttribute(element, "event");
            Object object = this._factory.newBean(CATEGORY_BEHAVIOUR, string);
            BeanInfo beanInfo = BeanUtil.getBeanInfo(object);
            if (string2 != null) {
                if (object instanceof Activity) {
                    BeanUtil.setProperty(object, beanInfo, PROPERTY_ACTIVITY_NAME, string2, this._value_parser);
                } else {
                    throw new AnimationParseException("only activities report completion events");
                }
            }
            this.initialiseParameters(object, beanInfo, element);
            this.putOptionalSymbol(element, object);
            return object;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new AnimationParseException("could not create behaviour: " + exception.getMessage());
        }
    }

    void optionalStartActivity(Element element, Activity activity) throws AnimationParseException {
        String string = this.getOptionalAttribute(element, "state");
        if (string != null && string.equals("started")) {
            this._anim.addActivity(activity);
        }
    }

    void translateCommand(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, "name");
        if (this._anim.getCommand(string) != null) {
            throw new AnimationParseException("a command named \"" + string + "\" has already been defined");
        }
        Command command = this.createCompositeCommand(element);
        this._anim.addCommand(string, command);
    }

    void translateEvent(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, "object");
        String string2 = this.getRequiredAttribute(element, "event");
        Object object = this.getSymbol(string);
        Command command = this.createCompositeCommand(element);
        EventInvoker eventInvoker = new EventInvoker(string2, command);
        BeanUtil.bindEventListener(eventInvoker, object);
        this._event_links.add(new EventLink(object, string, eventInvoker));
    }

    Command createCompositeCommand(Element element) throws AnimationParseException {
        NodeList nodeList = element.getChildNodes();
        final CompositeCommand compositeCommand = new CompositeCommand();
        if (nodeList.getLength() == 0) {
            throw new AnimationParseException("empty command body");
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (element2.getTagName().equals("forall")) {
                    this.parseForall(element2, new ForallParser(){

                        public void parse(Element element) throws AnimationParseException {
                            compositeCommand.addCommand(XMLAnimationParser.this.createSubCommand(element));
                        }
                    });
                } else {
                    compositeCommand.addCommand(this.createSubCommand(element2));
                }
            }
            ++n;
        }
        if (compositeCommand.getCommandCount() == 1) {
            return compositeCommand.getCommand(0);
        }
        return compositeCommand;
    }

    Command createSubCommand(Element element) throws AnimationParseException {
        String string = element.getTagName();
        if (string.equals("start")) {
            return this.createStartCommand(element);
        }
        if (string.equals("stop")) {
            return this.createStopCommand(element);
        }
        if (string.equals("reset")) {
            return this.createResetCommand(element);
        }
        if (string.equals("set")) {
            return this.createSetCommand(element);
        }
        if (string.equals("invoke")) {
            return this.createInvokeCommand(element);
        }
        if (string.equals("announce")) {
            return this.createAnnounceCommand(element);
        }
        throw new AnimationParseException("unexpected element type \"" + string + "\"");
    }

    Command createStartCommand(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, CATEGORY_BEHAVIOUR);
        Object object = this.getSymbol(string);
        if (object instanceof Activity) {
            Activity activity = (Activity)object;
            ActivityRunner activityRunner = activity.getActivityRunner();
            if (activityRunner == null) {
                activityRunner = this._anim;
            }
            return new StartActivityCommand(activity, activityRunner);
        }
        throw new AnimationParseException("symbol \"" + string + "\" does not refer to an activity");
    }

    Command createStopCommand(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, CATEGORY_BEHAVIOUR);
        Object object = this.getSymbol(string);
        if (object instanceof Activity) {
            return new StopActivityCommand((Activity)object);
        }
        throw new AnimationParseException("symbol \"" + string + "\" does not refer to an activity");
    }

    Command createResetCommand(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, CATEGORY_BEHAVIOUR);
        Object object = this.getSymbol(string);
        if (object instanceof Activity) {
            return new ResetActivityCommand((Activity)object);
        }
        throw new AnimationParseException("symbol \"" + string + "\" does not refer to an activity");
    }

    Command createSetCommand(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, "object");
        String string2 = this.getRequiredAttribute(element, "param");
        String string3 = this.getRequiredAttribute(element, "value");
        Object object = this.getSymbol(string);
        BeanInfo beanInfo = BeanUtil.getBeanInfo(object);
        PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(beanInfo, string2);
        Object object2 = this._value_parser.newObject(propertyDescriptor.getPropertyType(), string3);
        Method method = propertyDescriptor.getWriteMethod();
        return new SetParameterCommand(object, method, object2);
    }

    Command createInvokeCommand(Element element) throws AnimationParseException {
        Object object;
        Animation animation;
        String string = this.getRequiredAttribute(element, "command");
        String string2 = this.getOptionalAttribute(element, "object");
        if (string2 == null) {
            animation = this._anim;
        } else {
            object = this.getSymbol(string2);
            if (object instanceof Animation) {
                animation = (Animation)object;
            } else {
                throw new AnimationParseException("symbol \"" + string2 + "\" does not refer to an animation");
            }
        }
        object = animation.getCommand(string);
        if (object != null) {
            return object;
        }
        throw new AnimationParseException("command \"" + string + "\" not supported by animation");
    }

    Command createAnnounceCommand(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, "event");
        this._anim.addEventName(string);
        return new AnnounceCommand(this._anim, string);
    }

    void translateDefine(Element element) throws AnimationParseException {
        SceneGraph sceneGraph = this.createDrawNode(element);
        this.putOptionalSymbol(element, sceneGraph);
    }

    void translateDraw(Element element) throws AnimationParseException {
        SceneGraph sceneGraph = this.createDrawNode(element);
        this.putOptionalSymbol(element, sceneGraph);
        this._anim.addSubgraph(sceneGraph);
    }

    SceneGraph createDrawNode(Element element) throws AnimationParseException {
        return this.minimise(this.createChildren(element));
    }

    SceneGraph createSceneGraph(Element element) throws AnimationParseException {
        String string = element.getTagName();
        SceneGraph sceneGraph = null;
        if (string.equals("draw")) {
            sceneGraph = this.createDrawNode(element);
        } else if (string.equals("transform")) {
            sceneGraph = this.createTransformNode(element);
        } else if (string.equals("style")) {
            sceneGraph = this.createStyleNode(element);
        } else if (string.equals("input")) {
            sceneGraph = this.createInputNode(element);
        } else if (string.equals("compose")) {
            sceneGraph = this.createComposeNode(element);
        } else if (string.equals("paste")) {
            sceneGraph = this.createInstNode(element);
        } else if (string.equals("include")) {
            sceneGraph = this.createIncludeNode(element);
        } else if (string.equals("primitive")) {
            sceneGraph = this.createPrimitiveNode(element);
        } else {
            throw new AnimationParseException("unknown scene-graph type \"" + string + "\"");
        }
        return sceneGraph;
    }

    Layered createChildren(Element element) throws AnimationParseException {
        Layered layered = new Layered();
        this.createChildren(layered, element);
        return layered;
    }

    CompositeNode createChildren(final CompositeNode compositeNode, Element element) throws AnimationParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)nodeList.item(n);
                String string = element2.getTagName();
                if (string.equals("forall")) {
                    this.parseForall(element2, new ForallParser(){

                        public void parse(Element element) throws AnimationParseException {
                            compositeNode.addSubgraph(XMLAnimationParser.this.createSceneGraph(element));
                        }
                    });
                } else if (!string.equals("param") && !string.equals("animate")) {
                    compositeNode.addSubgraph(this.createSceneGraph(element2));
                }
            }
            ++n;
        }
        if (compositeNode.getSubgraphCount() == 0) {
            throw new AnimationParseException("no layers in composite");
        }
        return compositeNode;
    }

    SceneGraph minimise(CompositeNode compositeNode) throws AnimationParseException {
        if (compositeNode.getSubgraphCount() == 0) {
            throw new AnimationParseException("no layers in composite");
        }
        if (compositeNode.getSubgraphCount() == 1) {
            return compositeNode.getSubgraph(0);
        }
        return compositeNode;
    }

    SceneGraph createTransformNode(Element element) throws AnimationParseException {
        Transform transform;
        String string = this.getRequiredAttribute(element, "type");
        try {
            transform = (Transform)this.newSceneBean(string);
        }
        catch (ClassCastException classCastException) {
            throw new AnimationParseException(string + " is not a transform node");
        }
        this.putOptionalSymbol(element, transform);
        SceneGraph sceneGraph = this.minimise(this.createChildren(element));
        transform.setTransformedGraph(sceneGraph);
        this.initialiseParameters(transform, BeanUtil.getBeanInfo(transform), element);
        return transform;
    }

    SceneGraph createStyleNode(Element element) throws AnimationParseException {
        Style style;
        String string = this.getRequiredAttribute(element, "type");
        try {
            style = (Style)this.newSceneBean(string);
        }
        catch (ClassCastException classCastException) {
            throw new AnimationParseException(string + " is not a style node");
        }
        this.putOptionalSymbol(element, style);
        SceneGraph sceneGraph = this.minimise(this.createChildren(element));
        style.setStyledGraph(sceneGraph);
        this.initialiseParameters(style, BeanUtil.getBeanInfo(style), element);
        return style;
    }

    SceneGraph createInputNode(Element element) throws AnimationParseException {
        Input input;
        String string = this.getRequiredAttribute(element, "type");
        try {
            input = (Input)this.newSceneBean(string);
        }
        catch (ClassCastException classCastException) {
            throw new AnimationParseException(string + " is not an input node");
        }
        this.putOptionalSymbol(element, input);
        SceneGraph sceneGraph = this.minimise(this.createChildren(element));
        input.setSensitiveGraph(sceneGraph);
        this.initialiseParameters(input, BeanUtil.getBeanInfo(input), element);
        return input;
    }

    SceneGraph createComposeNode(Element element) throws AnimationParseException {
        CompositeNode compositeNode;
        String string = this.getRequiredAttribute(element, "type");
        try {
            compositeNode = (CompositeNode)this.newSceneBean(string);
        }
        catch (ClassCastException classCastException) {
            throw new AnimationParseException(string + " is not a composite node");
        }
        this.putOptionalSymbol(element, compositeNode);
        this.createChildren(compositeNode, element);
        this.initialiseParameters(compositeNode, BeanUtil.getBeanInfo(compositeNode), element);
        return compositeNode;
    }

    SceneGraph createInstNode(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, "object");
        Object object = this.getSymbol(string);
        if (object instanceof SceneGraph) {
            return (SceneGraph)object;
        }
        throw new AnimationParseException("link target \"" + string + "\" does not refer to a " + "scene-graph node");
    }

    SceneGraph createIncludeNode(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, "src");
        try {
            Object object;
            URL uRL = new URL(this._doc_url, string);
            XMLAnimationParser xMLAnimationParser = new XMLAnimationParser(uRL, this.getViewComponent());
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                object = nodeList.item(n);
                if (object instanceof Element) {
                    Element element2 = (Element)nodeList.item(n);
                    if (!element2.getTagName().equals("param")) {
                        throw new AnimationParseException("only param tags are allowed in a " + element.getTagName() + " node");
                    }
                    String string2 = this.getRequiredAttribute(element2, "name");
                    String string3 = this.getRequiredAttribute(element2, "value");
                    xMLAnimationParser.addMacro(string2, string3);
                }
                ++n;
            }
            object = xMLAnimationParser.parseAnimation();
            this._anim.addActivity((Activity)object);
            this.putOptionalSymbol(element, object);
            return object;
        }
        catch (MalformedURLException malformedURLException) {
            throw new AnimationParseException("invalid URL " + string + ": " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new AnimationParseException("failed to include animation " + string + ": " + iOException.getMessage());
        }
    }

    SceneGraph createPrimitiveNode(Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, "type");
        String string2 = this.getOptionalAttribute(element, "drawn");
        Object object = this.newSceneBean(string);
        if (!(object instanceof SceneGraph)) {
            throw new AnimationParseException("type \"" + string + "\" is not a SceneGraph class");
        }
        BeanInfo beanInfo = BeanUtil.getBeanInfo(object);
        this.initialiseParameters(object, beanInfo, element);
        this.putOptionalSymbol(element, object);
        return (SceneGraph)object;
    }

    Object newSceneBean(String string) throws AnimationParseException {
        try {
            return this._factory.newBean(CATEGORY_SCENE, string);
        }
        catch (Exception exception) {
            throw new AnimationParseException("failed to create scene bean: " + exception.getMessage());
        }
    }

    void initialiseParameters(Object object, Element element) throws AnimationParseException {
        this.initialiseParameters(object, BeanUtil.getBeanInfo(object), element);
    }

    void initialiseParameters(Object object, BeanInfo beanInfo, Element element) throws AnimationParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                this.initialiseParameter(object, beanInfo, (Element)node);
            }
            ++n;
        }
    }

    void initialiseParameter(final Object object, final BeanInfo beanInfo, Element element) throws AnimationParseException {
        if (element.getTagName().equals("param")) {
            this.setParameter(object, beanInfo, element);
        } else if (element.getTagName().equals("animate")) {
            this.animateParameter(object, element);
        } else if (element.getTagName().equals("forall")) {
            this.parseForall(element, new ForallParser(){

                public void parse(Element element) throws AnimationParseException {
                    XMLAnimationParser.this.initialiseParameter(object, beanInfo, element);
                }
            });
        }
    }

    void setParameter(Object object, BeanInfo beanInfo, Element element) throws AnimationParseException {
        String string = this.getRequiredAttribute(element, "name");
        String string2 = this.getOptionalAttribute(element, "index");
        String string3 = this.getRequiredAttribute(element, "value");
        if (string2 == null) {
            BeanUtil.setProperty(object, beanInfo, string, string3, this._value_parser);
        } else {
            int n;
            try {
                n = (int)Math.floor(ExprUtil.evaluate(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AnimationParseException("invalid property index: " + illegalArgumentException.getMessage());
            }
            BeanUtil.setIndexedProperty(object, beanInfo, string, n, string3, this._value_parser);
        }
    }

    void animateParameter(Object object, Element element) throws AnimationParseException {
        Object object2;
        Object object3;
        String string = this.getRequiredAttribute(element, "param");
        String string2 = this.getOptionalAttribute(element, "index");
        String string3 = this.getRequiredAttribute(element, CATEGORY_BEHAVIOUR);
        String string4 = this.getOptionalAttribute(element, "facet");
        if (string2 == null) {
            object3 = this.newBehaviourAdapter(object, string);
        } else {
            int n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AnimationParseException("invalid property index: " + numberFormatException.getMessage());
            }
            object3 = this.newIndexedBehaviourAdapter(object, string, n);
        }
        Object object4 = this.getSymbol(string3);
        if (string4 != null) {
            string4 = string4 + "Facet";
            object2 = BeanUtil.getProperty(object4, string4);
        } else {
            object2 = object4;
        }
        BeanUtil.bindEventListener(object3, object2);
        this._behaviour_links.add(new BehaviourLink(object4, string3, object2, string4, object, object3, string));
    }

    Object newBehaviourAdapter(Object object, String string) throws AnimationParseException {
        Class<?> clazz = object.getClass();
        String string2 = this.adapterMethodName(string);
        try {
            Method method = clazz.getMethod(string2, new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new AnimationParseException("could not create adapter for parameter \"" + string + "\": " + exception.getMessage());
        }
    }

    Object newIndexedBehaviourAdapter(Object object, String string, int n) throws AnimationParseException {
        Class<?> clazz = object.getClass();
        String string2 = "new" + Character.toUpperCase(string.charAt(0)) + string.substring(1) + "Adapter";
        try {
            Method method = clazz.getMethod(string2, Integer.TYPE);
            return method.invoke(object, new Integer(n));
        }
        catch (Exception exception) {
            throw new AnimationParseException("could not create adapter for parameter \"" + string + "\": " + exception.getMessage());
        }
    }

    String adapterMethodName(String string) throws AnimationParseException {
        return "new" + Character.toUpperCase(string.charAt(0)) + string.substring(1) + "Adapter";
    }

    void putOptionalSymbol(Element element, Object object) throws AnimationParseException {
        String string = this.getOptionalAttribute(element, "id");
        if (string != null) {
            this.putSymbol(string, object);
        }
    }

    public void putSymbol(String string, Object object) throws AnimationParseException {
        if (this._symbol_table.containsKey(string)) {
            throw new AnimationParseException("duplicate definition of symbol \"" + string + "\"");
        }
        this._symbol_table.put(string, object);
    }

    public Object getSymbol(String string) throws AnimationParseException {
        if (this._symbol_table.containsKey(string)) {
            return this._symbol_table.get(string);
        }
        throw new AnimationParseException("symbol \"" + string + "\" has not been defined");
    }

    public Map getSymbols() {
        return Collections.unmodifiableMap(this._symbol_table);
    }

    public Collection getBehaviourLinks() {
        return Collections.unmodifiableList(this._behaviour_links);
    }

    public Collection getEventLinks() {
        return Collections.unmodifiableList(this._event_links);
    }

    String getRequiredAttribute(Element element, String string) throws AnimationParseException {
        try {
            String string2 = XMLUtil.getRequiredAttribute(element, string);
            return this._macro_table.expandMacros(string2);
        }
        catch (MacroException macroException) {
            throw new AnimationParseException(macroException.getMessage());
        }
    }

    String getOptionalAttribute(Element element, String string) throws AnimationParseException {
        try {
            String string2 = XMLUtil.getOptionalAttribute(element, string);
            if (string2 != null) {
                string2 = this._macro_table.expandMacros(string2);
            }
            return string2;
        }
        catch (MacroException macroException) {
            throw new AnimationParseException(macroException.getMessage());
        }
    }

    public void addMacro(String string, String string2) throws AnimationParseException {
        try {
            this._macro_table.addMacro(string, string2);
        }
        catch (MacroException macroException) {
            throw new AnimationParseException(macroException.getMessage());
        }
    }

    public void removeMacro(String string) {
        this._macro_table.removeMacro(string);
    }

    private static interface ForallParser {
        public void parse(Element var1) throws AnimationParseException;
    }
}

