/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.remoteLogger;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.igoweb.igoweb.Config;
import org.igoweb.util.DatedFileHandler;

public class RemoteLogger {
    public static final int PORT = 13840;
    private ServerSocket serverSocket;
    private Logger logger = Logger.getAnonymousLogger();
    private DatedFileHandler handler;

    public RemoteLogger(int port) throws IOException {
        this.logger.setUseParentHandlers(false);
        this.handler = new DatedFileHandler(Config.get("logDir") + "/warnings-" + "{0,date,yyyy-MM-dd}" + ".log");
        this.logger.addHandler(this.handler);
        this.serverSocket = new ServerSocket(port);
    }

    public void go() {
        try {
            while (true) {
                final Socket sock = this.serverSocket.accept();
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        RemoteLogger.this.processSocket(sock);
                    }
                }, "Socket reader");
                thread.start();
            }
        }
        catch (Throwable thrown) {
            this.logger.log(Level.SEVERE, "Got fatal error handling inbound connections", thrown);
            System.exit(1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSocket(Socket sock) {
        ObjectInputStream in = null;
        String name = "<UNKNOWN>";
        try {
            in = new ObjectInputStream(new BufferedInputStream(sock.getInputStream()));
            name = (String)in.readObject();
            this.logger.info("Starting warning logs for service " + name);
            while (true) {
                this.handler.publish((LogRecord)in.readObject());
            }
        }
        catch (EOFException excep2) {
            this.logger.info("Got EOF on socket from service " + name);
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException excep2) {}
            }
        }
        catch (Throwable thrown) {
            try {
                this.logger.log(Level.WARNING, "Got error from log " + name, thrown);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        RemoteLogger rl = new RemoteLogger(13840);
        rl.go();
        System.exit(1);
    }
}

