/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.appframework.undo;

import java.awt.event.ActionEvent;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.diylc.appframework.images.IconLoader;
import org.diylc.appframework.undo.IUndoListener;

public class UndoHandler<T> {
    private static final Logger LOG = Logger.getLogger(UndoHandler.class);
    public static final int MAX_STACK_SIZE = 32;
    private Stack<Change> undoStack;
    private Stack<Change> redoStack;
    private IUndoListener<T> listener;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public UndoHandler(IUndoListener<T> listener) {
        this.listener = listener;
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.refreshActions();
    }

    public UndoAction getUndoAction() {
        if (this.undoAction == null) {
            this.undoAction = new UndoAction();
        }
        return this.undoAction;
    }

    public RedoAction getRedoAction() {
        if (this.redoAction == null) {
            this.redoAction = new RedoAction();
        }
        return this.redoAction;
    }

    public void reset() {
        LOG.info((Object)"Resetting undo/redo");
        this.undoStack.clear();
        this.redoStack.clear();
        this.refreshActions();
    }

    public void stateChanged(T previousState, T currentState, String changeDescription) {
        LOG.info((Object)"Undo state changed");
        this.undoStack.push(new Change(previousState, currentState, changeDescription));
        this.redoStack.clear();
        this.refreshActions();
    }

    private void refreshActions() {
        this.getUndoAction().setEnabled(!this.undoStack.isEmpty());
        if (this.undoStack.isEmpty()) {
            this.getUndoAction().putValue("Name", "Undo");
        } else {
            this.getUndoAction().putValue("Name", "Undo " + this.undoStack.peek().changeDescription);
        }
        this.getRedoAction().setEnabled(!this.redoStack.isEmpty());
        if (this.redoStack.isEmpty()) {
            this.getRedoAction().putValue("Name", "Redo");
        } else {
            this.getRedoAction().putValue("Name", "Redo " + this.redoStack.peek().changeDescription);
        }
        while (this.undoStack.size() > 32) {
            this.undoStack.remove(0);
        }
        while (this.redoStack.size() > 32) {
            this.redoStack.remove(0);
        }
    }

    class Change {
        T before;
        T after;
        String changeDescription;

        public Change(T before, T after, String changeDescription) {
            this.before = before;
            this.after = after;
            this.changeDescription = changeDescription;
        }
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RedoAction() {
            this.putValue("Name", "Redo");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
            this.putValue("SmallIcon", IconLoader.Redo.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UndoHandler.this.redoStack.isEmpty()) {
                LOG.info((Object)"Performing redo");
                Change currentState = (Change)UndoHandler.this.redoStack.pop();
                UndoHandler.this.undoStack.push(currentState);
                UndoHandler.this.listener.actionPerformed(currentState.after);
                UndoHandler.this.refreshActions();
            } else {
                LOG.warn((Object)"Could not perform undo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            this.putValue("Name", "Undo");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
            this.putValue("SmallIcon", IconLoader.Undo.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UndoHandler.this.undoStack.isEmpty()) {
                LOG.info((Object)"Performing undo");
                Change currentState = (Change)UndoHandler.this.undoStack.pop();
                UndoHandler.this.redoStack.push(currentState);
                UndoHandler.this.listener.actionPerformed(currentState.before);
                UndoHandler.this.refreshActions();
            } else {
                LOG.warn((Object)"Could not perform undo");
            }
        }
    }
}

