/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.structure.EncodingDescriptor;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;

public abstract class CRAMEncoding<T> {
    private final EncodingID encodingId;

    protected CRAMEncoding(EncodingID encodingId) {
        this.encodingId = encodingId;
    }

    public EncodingID id() {
        return this.encodingId;
    }

    public EncodingDescriptor toEncodingDescriptor() {
        return new EncodingDescriptor(this.id(), this.toSerializedEncodingParams());
    }

    public abstract byte[] toSerializedEncodingParams();

    public abstract CRAMCodec<T> buildCodec(SliceBlocksReadStreams var1, SliceBlocksWriteStreams var2);

    public CRAMCodec<T> buildReadCodec(SliceBlocksReadStreams sliceBlocksReadStreams) {
        return this.buildCodec(sliceBlocksReadStreams, null);
    }

    public CRAMCodec<T> buildWriteCodec(SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        return this.buildCodec(null, sliceBlocksWriteStreams);
    }
}

