;;;
;;; $Id: irchat-inlines.el,v 1.2 1993/10/06 16:18:28 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

;; modified by simm@irc.fan.gr.jp, Wed, 05 Jan 2000 02:51:10 +0900
(or (fboundp 'defsubst)
    (fset 'defsubst 'defun))

(provide 'irchat-inlines)

(defsubst string-list-ci-memberp (thing list)
  "returns t if thing is member of list, not funcallable"
  (let ((item (car list))
	(uthing (upcase thing)))
    (while (and item (not (string-equal uthing (upcase item))))
      (setq item (car list)
	    list (cdr list)))
    item))

(defsubst string-list-memberp (thing list)
  "returns t if thing is member of list, not funcallable"
  (let ((item (car list)))
    (while (and item (not (string-equal thing item)))
      (setq item (car list)
	    list (cdr list)))
    item))

(defsubst string-list-ci-delete (thing list)
  (let ((uthing (upcase thing))
	(item (car list))
	(result nil))
    (while item
      (if (not (string-equal (upcase item) uthing))
	  (setq result (nconc result (list item))))
      (setq list (cdr list)
	    item (car list)))
    result))

(defsubst string-list-delete (thing list)
  (let ((item (car list))
	(result nil))
    (while item
      (if (not (string-equal item thing))
	  (setq result (nconc result (list item))))
      (setq list (cdr list)
	    item (car list)))
    result))

(defsubst list-to-assoclist (list)
  (let ((result nil) (item (car list)))
    (while item
      (setq result (cons (list item) result)
	    list (cdr list)
	    item (car list)))
    result))

(defsubst matching-substring (string arg)
  (substring string (match-beginning arg) (match-end arg)))

(defsubst string-ci-equal (s1 s2)
  (string-equal (upcase s1) (upcase s2)))

(defsubst nth1 (nn str)
  (nth (- nn 1) str))

(defsubst nth1cdr (nn str)
  (nthcdr (- nn 1) str))

(defsubst add-space (length string)
  (if (< (length string) length)
      (format "%s%s" string (make-string (- length (length string)) 32))
    string))

(defsubst irchat-next-line (&optional n)
  (if (= (point) (point-max))
      (newline))
  (forward-line n))
