/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public abstract class AbstractChessClock
extends JComponent {
    public static final int HOUR_MINUTE_DISPLAY_MODE = 0;
    public static final int MINUTE_SECOND_DISPLAY_MODE = 1;
    public static final int SECOND_TENTHS_DISPLAY_MODE = 2;
    public static final int TIME_DEPENDENT_DISPLAY_MODE = 3;
    private int time;
    private int secondTenthsThreshold = 10000;
    private int minutesSecondsThreshold = 1200000;
    private final Timer repaintTimer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractChessClock.this.repaint();
        }
    });
    private long runStart = -1L;
    private int displayMode = 3;
    private boolean isActive = false;

    public AbstractChessClock(int n) {
        this.time = n;
    }

    public void setTime(int n) {
        this.time = n;
        if (this.isRunning()) {
            this.runStart = System.currentTimeMillis();
        }
        this.repaint();
    }

    public int getTime() {
        if (this.isRunning()) {
            return this.time - (int)(System.currentTimeMillis() - this.runStart);
        }
        return this.time;
    }

    public boolean isRunning() {
        return this.runStart >= 0L;
    }

    public void setRunning(boolean bl) {
        if (bl == this.isRunning()) {
            return;
        }
        if (bl) {
            this.runStart = System.currentTimeMillis();
            this.repaintTimer.start();
        } else {
            this.time -= (int)(System.currentTimeMillis() - this.runStart);
            this.runStart = -1L;
            this.repaintTimer.stop();
        }
    }

    public void setTimeDependentDisplayModeThresholds(int n, int n2) {
        this.minutesSecondsThreshold = n;
        this.secondTenthsThreshold = n2;
        this.repaint();
    }

    public void setRepaintDelay(int n) {
        this.repaintTimer.setDelay(n);
    }

    public int getRepaintDelay() {
        return this.repaintTimer.getDelay();
    }

    public void setDisplayMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized display mode value: " + n);
            }
        }
        this.displayMode = n;
        this.repaint();
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    protected int getActualDisplayMode() {
        int n = this.getDisplayMode();
        if (n != 3) {
            return n;
        }
        int n2 = Math.abs(this.getTime());
        if (n2 < this.secondTenthsThreshold) {
            return 2;
        }
        if (n2 < this.minutesSecondsThreshold) {
            return 1;
        }
        return 0;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
        this.repaint();
    }

    public boolean isActive() {
        return this.isActive;
    }
}

