/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import javax.sound.sampled.AudioFormat;
import org.tritonus.share.sampled.Encodings;

public class AiffTool {
    public static final int AIFF_FORM_MAGIC = 1179603533;
    public static final int AIFF_AIFF_MAGIC = 1095321158;
    public static final int AIFF_AIFC_MAGIC = 1095321155;
    public static final int AIFF_COMM_MAGIC = 1129270605;
    public static final int AIFF_SSND_MAGIC = 1397968452;
    public static final int AIFF_FVER_MAGIC = 1180058962;
    public static final int AIFF_COMM_UNSPECIFIED = 0;
    public static final int AIFF_COMM_PCM = 1313820229;
    public static final int AIFF_COMM_ULAW = 1970037111;
    public static final int AIFF_COMM_IMA_ADPCM = 1768775988;
    public static final int AIFF_FVER_TIME_STAMP = -1568648896;

    public static int getFormatCode(AudioFormat audioFormat) {
        boolean bl;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int n = audioFormat.getSampleSizeInBits();
        boolean bl2 = audioFormat.isBigEndian();
        boolean bl3 = false;
        if (audioFormat.getFrameSize() == -1 || audioFormat.getChannels() != -1 || audioFormat.getFrameSize() == n / 8 * audioFormat.getChannels()) {
            bl3 = bl = true;
        }
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && (bl2 && n >= 16 && n <= 32 || n == 8) && bl) {
            return 1313820229;
        }
        if (encoding.equals(AudioFormat.Encoding.ULAW) && n == 8 && bl) {
            return 1970037111;
        }
        if (encoding.equals(Encodings.getEncoding("IMA_ADPCM")) && n == 4) {
            return 1768775988;
        }
        return 0;
    }
}

