<?php
/***
 * ASP版の色々
 */
class UserInfoUtil implements IUserInfoUtil{

	/**
	 * ログアウトする
	 */
	public static function logout(){
		SOY2ActionSession::getUserSession()->setAuthenticated(false);
		SOY2ActionSession::getUserSession()->clearAttributes();
	}


	/**
	 * 現在ログインしているかどうかを返す
	 * SOY2Actionを利用
	 */
    public static function isLoggined(){
		if(defined("SOYCMS_LOGIN_LIFETIME") && SOYCMS_LOGIN_LIFETIME > 0){
			//一定時間アクセスがなかったらログアウトする
			$lastAccessTime = SOY2ActionSession::getUserSession()->getAttribute("lastAccessTime");
			if($lastAccessTime + SOYCMS_LOGIN_LIFETIME < time()){
				self::logout();
			}
		}
		SOY2ActionSession::getUserSession()->setAttribute("lastAccessTime",time());

    	//apacheのログにサイトIDを出力する
    	if(SOY2ActionSession::getUserSession()->getAuthenticated()){
			if(function_exists("apache_note")){
		    	apache_note("soycms_asp_user", self::getSite()->getSiteId());
			}
    	}

    	$isAuth = SOY2ActionSession::getUserSession()->getAuthenticated();
    	if($isAuth){
			return true;
    	}else{
    		self::logout();
    		return false;
    	}
    }

    /**
     * 現在ログインユーザがデフォルトユーザであるかどうか
     */
    public static function isDefaultUser(){
    	return SOY2ActionSession::getUserSession()->getAttribute("isdefault");
    }

    /**
     * 現在ログインしているユーザが一般管理者権限を持っているか
     * ASP版では使わない
     */
    public static function hasSiteAdminRole(){
    	return true;
    }

     /**
     * 現在ログインしているユーザがエントリー公開権限を持っているか
     * ASP版では使わない
     */
    public static function hasEntryPublisherRole(){
    	return true;
    }

	/**
	 * 現在ログインしているユーザが自動ログインしたユーザかどうか
	 * （１つのサイト/アプリにしかログイン権限がないということ）
	 */
    public static function hasOnlyOneRole(){
    	return true;
    }

    public static function hasEntryAdministor(){
    	return true;
    }

    public static function hasPublishAdministrator(){
    	return true;
    }

    /**
     * 現在ログインしているユーザのIDを返す
     */
    public static function getUserId(){
    	return SOY2ActionSession::getUserSession()->getAttribute("userid");
    }

    /**
     * 現在ログインしているユーザのログインID（User.UserId）を返す
     * ASP版にはログインIDはない
     */
    public static function getLoginId(){
    	return "";
    }

    /**
     * 現在ログインしているユーザ名を返す
     */
     public static function getUserName(){
    	return htmlspecialchars(SOY2ActionSession::getUserSession()->getAttribute("username"));
    }

    /**
     * 現在ログインしているサイトの情報を返す
     */
    public static function getSite(){
    	$obj = SOY2ActionSession::getUserSession()->getAttribute("Site");
    	return (is_null($obj)) ? new Site() : $obj;
    }

    /**
     * 現在ログインしているサイトのIDを返す
     */
    public static function getSiteId(){
    	return self::getSite()->getId();
    }

    /**
     * サイトの情報を更新する（セッション内部）
     */
    public static function updateSite(Site $site){
    	SOY2ActionSession::getUserSession()->setAttribute("Site",$site);
    }

    /**
     * 現在ログインしているサイトのディレクトリを返す
     *
     * @param isRealpath(=false) trueならば場所を返す
     */
    public static function getSiteDirectory($realpath = false){
    	return self::getSite()->getPath();
    }

    /**
     * サイトのURLを取得
     */
    public static function getSiteURL(){
    	return self::getSite()->getUrl();
    }

    /**
     * サイトの公開URLを取得（ルート設定ならルート設定のURLを返す）
     * ASPではルート設定を無視する。
     */
    public static function getSitePublishURL(){
    	return self::getSite()->getUrl();
    }

    /**
     * 現在ログインしているサイトがルート設定されているかどうか
     */
    public static function getSiteIsDomainRoot(){
		return self::getSite()->getIsDomainRoot();
    }

    /**
     * URLからサーバーのパスを取得する
     * @mock
     */
    public static function url2serverpath($address){
    	$address = self::getSiteDirectory() . str_replace(self::getsiteURL(),"",$address);
    	return $address;
    }

    public static function getSiteConfig(){
    	return SOY2DAOFactory::create("cms.SiteConfigDAO")->get();
    }

    /**
     * サイトのIDからサイトのURLを取得
     */
    public static function getSiteURLBySiteId($siteId = null){
    	if(is_null($siteId)) $siteId = self::getSite()->getSiteId();

    	$http = (isset($_SERVER["HTTPS"]) || defined("SOY2_HTTPS") && SOY2_HTTPS) ? "https" : "http";
    	$host = $_SERVER['HTTP_HOST'];
    	if($_SERVER['SERVER_PORT'] != 80 && strstr($host,":") === false){
    		$host .= ":".$_SERVER['SERVER_PORT'];
    	}

    	if(preg_match('/^register\.*/',$host)){
    		$host = str_replace("register",$siteId,$host);
    	}else if(preg_match('/^admin\.*/',$host)){
    		$host = str_replace("admin",$siteId,$host);
    	}else if(preg_match('/^'.$siteId.'\..*/',$host)){
    		$host = $host;
    	}else if(preg_match('/^www\.*/',$host)){
    		$host = str_replace("www",$siteId,$host);
    	}else{
    		$host = $siteId .".". $host;
    	}

    	$host = preg_replace('/\//',"",$host);

    	return $http ."://". $host . "/";
    }
}
?>