
(define-library (srfi 160 c64)
  (export
   make-c64vector
   c64?
   c64vector?
   c64vector-ref
   c64vector-set!
   c64vector-length
   (rename uvector-unfold c64vector-unfold)
   (rename uvector-unfold-right c64vector-unfold-right)
   (rename vector-copy c64vector-copy)
   (rename vector-reverse-copy c64vector-reverse-copy)
   (rename vector-append c64vector-append)
   (rename vector-concatenate c64vector-concatenate)
   (rename vector-append-subvectors c64vector-append-subvectors)
   (rename vector-empty? c64vector-empty?)
   (rename vector= c64vector=)
   (rename vector-take c64vector-take)
   (rename vector-take-right c64vector-take-right)
   (rename vector-drop c64vector-drop)
   (rename vector-drop-right c64vector-drop-right)
   (rename vector-segment c64vector-segment)
   (rename vector-fold c64vector-fold)
   (rename vector-fold-right c64vector-fold-right)
   (rename vector-map c64vector-map)
   (rename vector-map! c64vector-map!)
   (rename vector-for-each c64vector-for-each)
   (rename vector-count c64vector-count)
   (rename vector-cumulate c64vector-cumulate)
   (rename vector-take-while c64vector-take-while)
   (rename vector-take-while-right c64vector-take-while-right)
   (rename vector-drop-while c64vector-drop-while)
   (rename vector-drop-while-right c64vector-drop-while-right)
   (rename vector-index c64vector-index)
   (rename vector-index-right c64vector-index-right)
   (rename vector-skip c64vector-skip)
   (rename vector-skip-right c64vector-skip-right)
   (rename vector-binary-search c64vector-binary-search)
   (rename vector-any c64vector-any)
   (rename vector-every c64vector-every)
   (rename vector-partition c64vector-partition)
   (rename vector-filter c64vector-filter)
   (rename vector-remove c64vector-remove)
   (rename vector-swap! c64vector-swap!)
   (rename vector-fill! c64vector-fill!)
   (rename vector-reverse! c64vector-reverse!)
   (rename vector-copy! c64vector-copy!)
   (rename vector-reverse-copy! c64vector-reverse-copy!)
   (rename reverse-vector->list reverse-c64vector->list)
   (rename reverse-list->vector reverse-list->c64vector)
   (rename uvector->vector c64vector->vector)
   (rename vector->uvector vector->c64vector)
   (rename make-vector-generator make-c64vector-generator)
   (rename write-vector write-c64vector))
  (import (except (scheme base)
                  vector-append vector-copy vector-copy!
                  vector-map vector-for-each)
          (scheme write)
          (srfi 160 base))
  (begin
    (define uvector? c64vector?)
    (define make-uvector make-c64vector)
    (define vector c64vector)
    (define uvector->list c64vector->list)
    (define list->uvector list->c64vector)
    (define uvector-length c64vector-length)
    (define uvector-ref c64vector-ref)
    (define uvector-set! c64vector-set!))
  (include "uvector.scm"))
