/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_LAYER_H__
#define __SG_PLUGIN_LAYER_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"

#define SG_PLUGIN_LAYER(obj)        GTK_CHECK_CAST (obj, sg_plugin_layer_get_type (), SGpluginLayer)
#define GTK_TYPE_SG_PLUGIN_LAYER   (sg_plugin_layer_get_type ())

#define SG_PLUGIN_LAYER_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plugin_layer_get_type(), SGpluginLayerClass)
#define GTK_IS_SG_PLUGIN_LAYER(obj)     GTK_CHECK_TYPE (obj, sg_plugin_layer_get_type ())


typedef struct _SGpluginLayer   SGpluginLayer;
typedef struct _SGpluginLayerClass   SGpluginLayerClass;

struct _SGpluginLayer
{
  SGplugin plugin;

  GtkPixmap *pixmap;
  gint dim_mask;
  
  GtkPlot* (*construct) 			(void);
  void (*property_dialog) 			(SGpluginLayer *plugin, 
						 GtkWidget *layer_control,
						 GtkCTreeNode *root_item,
						 GObject *layer,
						 const gchar *name);
  GtkWidget *(*toolbox)				(SGpluginLayer *plugin,
						 GObject *layer);
};

struct _SGpluginLayerClass
{
  SGpluginClass parent_class;
};

GType		sg_plugin_layer_get_type	();
SGpluginLayer *	sg_plugin_layer_new		();
GtkPlot *   	sg_plugin_layer_construct	(SGpluginLayer *plugin);
GtkWidget *   	sg_plugin_layer_toolbox		(SGpluginLayer *plugin,
						 GObject *layer);
void     	sg_plugin_layer_dialog          (SGpluginLayer *plugin,
						 GtkWidget *layer_control,
						 GtkCTreeNode *root_item,
						 GObject *layer,
						 const gchar *name);
SGpluginLayer * sg_plugin_layer_get		(const gchar *name);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLUGIN_LAYER_H__ */

