/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.activity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.ic.doc.scenebeans.activity.Activity;
import uk.ac.ic.doc.scenebeans.activity.ActivityRunner;
import uk.ac.ic.doc.scenebeans.event.AnimationEvent;
import uk.ac.ic.doc.scenebeans.event.AnimationListener;

public abstract class ActivityBase
implements Activity {
    private ActivityRunner _runner = null;
    private List _animation_listeners = null;

    protected ActivityBase() {
    }

    public ActivityRunner getActivityRunner() {
        return this._runner;
    }

    public void setActivityRunner(ActivityRunner activityRunner) {
        if (this._runner != null && activityRunner != null) {
            throw new IllegalStateException("activity already has a runner");
        }
        this._runner = activityRunner;
    }

    public synchronized void addAnimationListener(AnimationListener animationListener) {
        if (this._animation_listeners == null) {
            this._animation_listeners = new ArrayList();
        }
        this._animation_listeners.add(animationListener);
    }

    public synchronized void removeAnimationListener(AnimationListener animationListener) {
        if (this._animation_listeners != null) {
            this._animation_listeners.remove(animationListener);
        }
    }

    protected synchronized void postActivityComplete(String string) {
        if (this._animation_listeners != null) {
            AnimationEvent animationEvent = new AnimationEvent(this, string);
            Iterator iterator = this._animation_listeners.iterator();
            while (iterator.hasNext()) {
                ((AnimationListener)iterator.next()).animationEvent(animationEvent);
            }
        }
    }

    public abstract void performActivity(double var1);

    public abstract void reset();

    public abstract boolean isFinite();
}

