/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.reloading;

import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public class FileChangedReloadingStrategy
implements ReloadingStrategy {
    protected FileConfiguration configuration;
    protected long lastModified;
    protected long lastChecked;
    protected long refreshDelay = 5000L;

    public void setConfiguration(FileConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        this.updateLastModified();
    }

    public boolean reloadingRequired() {
        boolean reloading = false;
        long now = System.currentTimeMillis();
        if (now > this.lastChecked + this.refreshDelay && this.hasChanged()) {
            this.lastChecked = now;
            reloading = true;
        }
        return reloading;
    }

    public void reloadingPerformed() {
        this.updateLastModified();
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(long refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    protected void updateLastModified() {
        this.lastModified = this.configuration.getFile().lastModified();
    }

    protected boolean hasChanged() {
        if (!this.configuration.getFile().exists()) {
            return false;
        }
        return this.configuration.getFile().lastModified() > this.lastModified;
    }
}

