/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.ietf.jgss.GSSException;

public class Oid {
    private static final int OBJECT_IDENTIFIER = 6;
    private static final int RELATIVE_OID = 13;
    private final int[] components;
    private byte[] derOid;
    private String strOid;
    private boolean relative;

    public String toString() {
        if (this.strOid == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.components.length) {
                stringBuffer.append(this.components[n]);
                if (n < this.components.length - 1) {
                    stringBuffer.append('.');
                }
                ++n;
            }
            this.strOid = stringBuffer.toString();
        }
        return this.strOid;
    }

    public byte[] getDER() throws GSSException {
        if (this.derOid == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            try {
                int n = 0;
                if (!this.relative) {
                    int n2 = this.components[n++] * 40;
                    int n3 = 0;
                    if (this.components.length > 1) {
                        n3 = this.components[n++];
                    }
                    int n4 = n2 + n3;
                    Oid.encodeSubId(byteArrayOutputStream, n4);
                }
                while (n < this.components.length) {
                    Oid.encodeSubId(byteArrayOutputStream, this.components[n]);
                    ++n;
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
                if (this.relative) {
                    byteArrayOutputStream.write(13);
                } else {
                    byteArrayOutputStream.write(6);
                }
                if (byArray.length < 128) {
                    byteArrayOutputStream.write(byArray.length);
                } else if (byArray.length < 256) {
                    byteArrayOutputStream.write(129);
                    byteArrayOutputStream.write(byArray.length);
                } else if (byArray.length < 65536) {
                    byteArrayOutputStream.write(130);
                    byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
                    byteArrayOutputStream.write(byArray.length & 0xFF);
                } else if (byArray.length < 0x1000000) {
                    byteArrayOutputStream.write(131);
                    byteArrayOutputStream.write(byArray.length >>> 16 & 0xFF);
                    byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
                    byteArrayOutputStream.write(byArray.length & 0xFF);
                } else {
                    byteArrayOutputStream.write(132);
                    byteArrayOutputStream.write(byArray.length >>> 24 & 0xFF);
                    byteArrayOutputStream.write(byArray.length >>> 16 & 0xFF);
                    byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
                    byteArrayOutputStream.write(byArray.length & 0xFF);
                }
                byteArrayOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new GSSException(11);
            }
            this.derOid = byteArrayOutputStream.toByteArray();
        }
        return (byte[])this.derOid.clone();
    }

    public boolean containedIn(Oid[] oidArray) {
        int n = 0;
        while (n < oidArray.length) {
            if (this.equals(oidArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Oid)) {
            return false;
        }
        Oid oid = (Oid)object;
        return Arrays.equals(this.components, oid.components);
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.components.length) {
            n += this.components[n2];
            ++n2;
        }
        return n;
    }

    private static final void encodeSubId(OutputStream outputStream, int n) throws IOException {
        if (n < 128) {
            outputStream.write(n);
        } else if (n < 16384) {
            outputStream.write(n >>> 7 | 0x80);
            outputStream.write(n & 0x7F);
        } else if (n < 0x200000) {
            outputStream.write(n >>> 14 | 0x80);
            outputStream.write((n >>> 7 | 0x80) & 0xFF);
            outputStream.write(n & 0x7F);
        } else if (n < 0x10000000) {
            outputStream.write(n >>> 21 | 0x80);
            outputStream.write((n >>> 14 | 0x80) & 0xFF);
            outputStream.write((n >>> 7 | 0x80) & 0xFF);
            outputStream.write(n & 0x7F);
        }
    }

    public Oid(String string) throws GSSException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.strOid = string;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            this.components = new int[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens() && n < this.components.length) {
                this.components[n++] = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            throw new GSSException(11);
        }
        this.relative = false;
    }

    public Oid(InputStream inputStream) throws GSSException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n;
            byte[] byArray;
            int n2 = dataInputStream.read() & 0x1F;
            if (n2 != 6 && n2 != 13) {
                throw new IOException();
            }
            int n3 = dataInputStream.read();
            if ((n3 & 0xFFFFFF80) != 0) {
                byArray = new byte[n3 & 0x7F];
                dataInputStream.readFully(byArray);
                n3 = new BigInteger(1, byArray).intValue();
            }
            if (n3 < 0) {
                throw new IOException();
            }
            byArray = new byte[n3];
            dataInputStream.readFully(byArray);
            int[] nArray = new int[n3 + 1];
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            if (n2 == 13) {
                bl = this.relative = true;
            }
            if (!this.relative && n5 < n3) {
                n = byArray[n5] & 0xFF;
                nArray[n4++] = n / 40;
                nArray[n4++] = n % 40;
                ++n5;
            }
            while (n5 < n3) {
                n = 0;
                do {
                    n = byArray[n5++] & 0xFF;
                    int n6 = n4;
                    nArray[n6] = nArray[n6] << 7;
                    int n7 = n4;
                    nArray[n7] = nArray[n7] | n & 0x7F;
                    if (n5 < n3 || (n & 0x80) == 0) continue;
                    throw new IOException();
                } while ((n & 0x80) != 0);
                ++n4;
            }
            if (n4 == n3) {
                this.components = nArray;
            } else {
                this.components = new int[n4];
                System.arraycopy(nArray, 0, this.components, 0, n4);
            }
        }
        catch (IOException iOException) {
            throw new GSSException(11);
        }
    }

    public Oid(byte[] byArray) throws GSSException {
        this(new ByteArrayInputStream(byArray));
        this.derOid = (byte[])byArray.clone();
    }

    Oid(int[] nArray) {
        this.components = nArray;
        this.relative = false;
    }
}

