/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.Cipher;
import de.mud.ssh.SshMisc;
import java.math.BigInteger;

public class SshCrypto {
    private Cipher sndCipher;
    private Cipher rcvCipher;

    public SshCrypto(String type, byte[] key) {
        this.sndCipher = Cipher.getInstance(type);
        this.rcvCipher = Cipher.getInstance(type);
        this.sndCipher.setKey(key);
        this.rcvCipher.setKey(key);
    }

    public byte[] encrypt(byte[] block) {
        return this.sndCipher.encrypt(block);
    }

    public byte[] decrypt(byte[] block) {
        return this.rcvCipher.decrypt(block);
    }

    public static byte[] encrypteRSAPkcs1Twice(byte[] clearData, byte[] server_key_public_exponent, byte[] server_key_public_modulus, byte[] host_key_public_exponent, byte[] host_key_public_modulus) {
        int i;
        int i2;
        byte[] key2mod;
        byte[] key2exp;
        byte[] key1mod;
        byte[] key1exp;
        if (server_key_public_modulus.length < host_key_public_modulus.length) {
            key1exp = server_key_public_exponent;
            key1mod = server_key_public_modulus;
            key2exp = host_key_public_exponent;
            key2mod = host_key_public_modulus;
        } else {
            key1exp = host_key_public_exponent;
            key1mod = host_key_public_modulus;
            key2exp = server_key_public_exponent;
            key2mod = server_key_public_modulus;
        }
        int offset = 0;
        byte[] EncryptionBlock = new byte[key1mod.length];
        EncryptionBlock[0] = 0;
        EncryptionBlock[1] = 2;
        offset = 2;
        for (i2 = 2; i2 < EncryptionBlock.length - clearData.length - 1; ++i2) {
            EncryptionBlock[offset++] = SshMisc.getNotZeroRandomByte();
        }
        EncryptionBlock[offset++] = 0;
        for (i2 = 0; i2 < clearData.length; ++i2) {
            EncryptionBlock[offset++] = clearData[i2];
        }
        BigInteger m = new BigInteger(1, key1mod);
        BigInteger e = new BigInteger(1, key1exp);
        BigInteger message = new BigInteger(1, EncryptionBlock);
        message = message.modPow(e, m);
        byte[] messageByteTemp = message.toByteArray();
        byte[] messageByte = new byte[key1mod.length];
        int tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        for (i = messageByte.length - messageByteTemp.length + tempOffset; i < messageByte.length; ++i) {
            messageByte[i] = messageByteTemp[tempOffset++];
        }
        clearData = messageByte;
        offset = 0;
        EncryptionBlock = new byte[key2mod.length];
        EncryptionBlock[0] = 0;
        EncryptionBlock[1] = 2;
        offset = 2;
        for (i = 2; i < EncryptionBlock.length - clearData.length - 1; ++i) {
            EncryptionBlock[offset++] = SshMisc.getNotZeroRandomByte();
        }
        EncryptionBlock[offset++] = 0;
        for (i = 0; i < clearData.length; ++i) {
            EncryptionBlock[offset++] = clearData[i];
        }
        m = new BigInteger(1, key2mod);
        e = new BigInteger(1, key2exp);
        message = new BigInteger(1, EncryptionBlock);
        message = message.modPow(e, m);
        messageByteTemp = message.toByteArray();
        messageByte = new byte[key2mod.length];
        tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        for (i = messageByte.length - messageByteTemp.length + tempOffset; i < messageByte.length; ++i) {
            messageByte[i] = messageByteTemp[tempOffset++];
        }
        byte[] encrypted_session_key = new byte[key2mod.length + 2];
        encrypted_session_key[1] = (byte)(8 * key2mod.length & 0xFF);
        encrypted_session_key[0] = (byte)(8 * key2mod.length >> 8 & 0xFF);
        for (int i3 = 0; i3 < key2mod.length; ++i3) {
            encrypted_session_key[i3 + 2] = messageByte[i3];
        }
        return encrypted_session_key;
    }
}

