/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.metal.MetalButtonListener;
import javax.swing.plaf.metal.MetalUtils;

public class MetalButtonUI
extends BasicButtonUI {
    protected Color focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
    protected Color selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
    protected Color disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalButtonUI();
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setRolloverEnabled(UIManager.getBoolean(this.getPropertyPrefix() + "rollover"));
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        abstractButton.setRolloverEnabled(false);
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new MetalButtonListener(abstractButton);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            Rectangle rectangle = abstractButton.getVisibleRect();
            graphics.setColor(this.selectColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.isEnabled() && abstractButton.hasFocus() && abstractButton.isFocusPainted()) {
            Color color = graphics.getColor();
            graphics.setColor(this.getFocusColor());
            Rectangle rectangle4 = rectangle3.union(rectangle2);
            graphics.drawRect(rectangle4.x - 1, rectangle4.y, rectangle4.width + 1, rectangle4.height);
            graphics.setColor(color);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Font font = abstractButton.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (abstractButton.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            graphics.setColor(this.getDisabledTextColor());
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton.isContentAreaFilled() && UIManager.get(this.getPropertyPrefix() + "gradient") != null && !abstractButton.getModel().isPressed() && abstractButton.isEnabled()) {
            MetalUtils.paintGradient(graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), 1, this.getPropertyPrefix() + "gradient");
            this.paint(graphics, jComponent);
        } else {
            super.update(graphics, jComponent);
        }
    }
}

