/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.BaseCipher;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Serpent
extends BaseCipher {
    private static final int DEFAULT_KEY_SIZE = 16;
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int ROUNDS = 32;
    private static final int PHI = -1640531527;
    private static final byte[] KAT_KEY = Util.toReversedBytesFromString("008000000000000000000000000000000000000000000000");
    private static final byte[] KAT_CT = Util.toReversedBytesFromString("5587B5BCB9EE5A28BA2BACC418005240");
    private static Boolean valid;
    private int x0;
    private int x1;
    private int x2;
    private int x3;
    private int x4;

    public Object clone() {
        Serpent serpent = new Serpent();
        serpent.currentBlockSize = this.currentBlockSize;
        return serpent;
    }

    public Iterator blockSizes() {
        return Collections.singleton(new Integer(16)).iterator();
    }

    public Iterator keySizes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(16));
        arrayList.add(new Integer(24));
        arrayList.add(new Integer(32));
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        int n2;
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("Key length is not 16, 24, or 32 bytes");
        }
        Key key = new Key();
        int[] nArray = new int[132];
        int n3 = 0;
        int n4 = 0;
        while (n3 < 8 && n4 < byArray.length) {
            nArray[n3] = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 24;
            ++n3;
        }
        if (n3 != 8) {
            nArray[n3] = 1;
        }
        n3 = 8;
        n4 = 0;
        while (n3 < 16) {
            n2 = nArray[n4] ^ nArray[n3 - 5] ^ nArray[n3 - 3] ^ nArray[n3 - 1] ^ 0x9E3779B9 ^ n4++;
            nArray[n3] = n2 << 11 | n2 >>> 21;
            ++n3;
        }
        n3 = 0;
        while (n3 < 8) {
            nArray[n3] = nArray[n3 + 8];
            ++n3;
        }
        while (n3 < nArray.length) {
            n2 = nArray[n3 - 8] ^ nArray[n3 - 5] ^ nArray[n3 - 3] ^ nArray[n3 - 1] ^ 0x9E3779B9 ^ n3;
            nArray[n3] = n2 << 11 | n2 >>> 21;
            ++n3;
        }
        this.sbox3(nArray[0], nArray[1], nArray[2], nArray[3]);
        key.k0 = this.x0;
        key.k1 = this.x1;
        key.k2 = this.x2;
        key.k3 = this.x3;
        this.sbox2(nArray[4], nArray[5], nArray[6], nArray[7]);
        key.k4 = this.x0;
        key.k5 = this.x1;
        key.k6 = this.x2;
        key.k7 = this.x3;
        this.sbox1(nArray[8], nArray[9], nArray[10], nArray[11]);
        key.k8 = this.x0;
        key.k9 = this.x1;
        key.k10 = this.x2;
        key.k11 = this.x3;
        this.sbox0(nArray[12], nArray[13], nArray[14], nArray[15]);
        key.k12 = this.x0;
        key.k13 = this.x1;
        key.k14 = this.x2;
        key.k15 = this.x3;
        this.sbox7(nArray[16], nArray[17], nArray[18], nArray[19]);
        key.k16 = this.x0;
        key.k17 = this.x1;
        key.k18 = this.x2;
        key.k19 = this.x3;
        this.sbox6(nArray[20], nArray[21], nArray[22], nArray[23]);
        key.k20 = this.x0;
        key.k21 = this.x1;
        key.k22 = this.x2;
        key.k23 = this.x3;
        this.sbox5(nArray[24], nArray[25], nArray[26], nArray[27]);
        key.k24 = this.x0;
        key.k25 = this.x1;
        key.k26 = this.x2;
        key.k27 = this.x3;
        this.sbox4(nArray[28], nArray[29], nArray[30], nArray[31]);
        key.k28 = this.x0;
        key.k29 = this.x1;
        key.k30 = this.x2;
        key.k31 = this.x3;
        this.sbox3(nArray[32], nArray[33], nArray[34], nArray[35]);
        key.k32 = this.x0;
        key.k33 = this.x1;
        key.k34 = this.x2;
        key.k35 = this.x3;
        this.sbox2(nArray[36], nArray[37], nArray[38], nArray[39]);
        key.k36 = this.x0;
        key.k37 = this.x1;
        key.k38 = this.x2;
        key.k39 = this.x3;
        this.sbox1(nArray[40], nArray[41], nArray[42], nArray[43]);
        key.k40 = this.x0;
        key.k41 = this.x1;
        key.k42 = this.x2;
        key.k43 = this.x3;
        this.sbox0(nArray[44], nArray[45], nArray[46], nArray[47]);
        key.k44 = this.x0;
        key.k45 = this.x1;
        key.k46 = this.x2;
        key.k47 = this.x3;
        this.sbox7(nArray[48], nArray[49], nArray[50], nArray[51]);
        key.k48 = this.x0;
        key.k49 = this.x1;
        key.k50 = this.x2;
        key.k51 = this.x3;
        this.sbox6(nArray[52], nArray[53], nArray[54], nArray[55]);
        key.k52 = this.x0;
        key.k53 = this.x1;
        key.k54 = this.x2;
        key.k55 = this.x3;
        this.sbox5(nArray[56], nArray[57], nArray[58], nArray[59]);
        key.k56 = this.x0;
        key.k57 = this.x1;
        key.k58 = this.x2;
        key.k59 = this.x3;
        this.sbox4(nArray[60], nArray[61], nArray[62], nArray[63]);
        key.k60 = this.x0;
        key.k61 = this.x1;
        key.k62 = this.x2;
        key.k63 = this.x3;
        this.sbox3(nArray[64], nArray[65], nArray[66], nArray[67]);
        key.k64 = this.x0;
        key.k65 = this.x1;
        key.k66 = this.x2;
        key.k67 = this.x3;
        this.sbox2(nArray[68], nArray[69], nArray[70], nArray[71]);
        key.k68 = this.x0;
        key.k69 = this.x1;
        key.k70 = this.x2;
        key.k71 = this.x3;
        this.sbox1(nArray[72], nArray[73], nArray[74], nArray[75]);
        key.k72 = this.x0;
        key.k73 = this.x1;
        key.k74 = this.x2;
        key.k75 = this.x3;
        this.sbox0(nArray[76], nArray[77], nArray[78], nArray[79]);
        key.k76 = this.x0;
        key.k77 = this.x1;
        key.k78 = this.x2;
        key.k79 = this.x3;
        this.sbox7(nArray[80], nArray[81], nArray[82], nArray[83]);
        key.k80 = this.x0;
        key.k81 = this.x1;
        key.k82 = this.x2;
        key.k83 = this.x3;
        this.sbox6(nArray[84], nArray[85], nArray[86], nArray[87]);
        key.k84 = this.x0;
        key.k85 = this.x1;
        key.k86 = this.x2;
        key.k87 = this.x3;
        this.sbox5(nArray[88], nArray[89], nArray[90], nArray[91]);
        key.k88 = this.x0;
        key.k89 = this.x1;
        key.k90 = this.x2;
        key.k91 = this.x3;
        this.sbox4(nArray[92], nArray[93], nArray[94], nArray[95]);
        key.k92 = this.x0;
        key.k93 = this.x1;
        key.k94 = this.x2;
        key.k95 = this.x3;
        this.sbox3(nArray[96], nArray[97], nArray[98], nArray[99]);
        key.k96 = this.x0;
        key.k97 = this.x1;
        key.k98 = this.x2;
        key.k99 = this.x3;
        this.sbox2(nArray[100], nArray[101], nArray[102], nArray[103]);
        key.k100 = this.x0;
        key.k101 = this.x1;
        key.k102 = this.x2;
        key.k103 = this.x3;
        this.sbox1(nArray[104], nArray[105], nArray[106], nArray[107]);
        key.k104 = this.x0;
        key.k105 = this.x1;
        key.k106 = this.x2;
        key.k107 = this.x3;
        this.sbox0(nArray[108], nArray[109], nArray[110], nArray[111]);
        key.k108 = this.x0;
        key.k109 = this.x1;
        key.k110 = this.x2;
        key.k111 = this.x3;
        this.sbox7(nArray[112], nArray[113], nArray[114], nArray[115]);
        key.k112 = this.x0;
        key.k113 = this.x1;
        key.k114 = this.x2;
        key.k115 = this.x3;
        this.sbox6(nArray[116], nArray[117], nArray[118], nArray[119]);
        key.k116 = this.x0;
        key.k117 = this.x1;
        key.k118 = this.x2;
        key.k119 = this.x3;
        this.sbox5(nArray[120], nArray[121], nArray[122], nArray[123]);
        key.k120 = this.x0;
        key.k121 = this.x1;
        key.k122 = this.x2;
        key.k123 = this.x3;
        this.sbox4(nArray[124], nArray[125], nArray[126], nArray[127]);
        key.k124 = this.x0;
        key.k125 = this.x1;
        key.k126 = this.x2;
        key.k127 = this.x3;
        this.sbox3(nArray[128], nArray[129], nArray[130], nArray[131]);
        key.k128 = this.x0;
        key.k129 = this.x1;
        key.k130 = this.x2;
        key.k131 = this.x3;
        return key;
    }

    public synchronized void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        Key key = (Key)object;
        this.x0 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        this.x1 = byArray[n + 4] & 0xFF | (byArray[n + 5] & 0xFF) << 8 | (byArray[n + 6] & 0xFF) << 16 | (byArray[n + 7] & 0xFF) << 24;
        this.x2 = byArray[n + 8] & 0xFF | (byArray[n + 9] & 0xFF) << 8 | (byArray[n + 10] & 0xFF) << 16 | (byArray[n + 11] & 0xFF) << 24;
        this.x3 = byArray[n + 12] & 0xFF | (byArray[n + 13] & 0xFF) << 8 | (byArray[n + 14] & 0xFF) << 16 | (byArray[n + 15] & 0xFF) << 24;
        this.x0 ^= key.k0;
        this.x1 ^= key.k1;
        this.x2 ^= key.k2;
        this.x3 ^= key.k3;
        this.sbox0();
        this.x1 ^= key.k4;
        this.x4 ^= key.k5;
        this.x2 ^= key.k6;
        this.x0 ^= key.k7;
        this.sbox1();
        this.x0 ^= key.k8;
        this.x4 ^= key.k9;
        this.x2 ^= key.k10;
        this.x1 ^= key.k11;
        this.sbox2();
        this.x2 ^= key.k12;
        this.x1 ^= key.k13;
        this.x4 ^= key.k14;
        this.x3 ^= key.k15;
        this.sbox3();
        this.x1 ^= key.k16;
        this.x4 ^= key.k17;
        this.x3 ^= key.k18;
        this.x0 ^= key.k19;
        this.sbox4();
        this.x4 ^= key.k20;
        this.x2 ^= key.k21;
        this.x1 ^= key.k22;
        this.x0 ^= key.k23;
        this.sbox5();
        this.x2 ^= key.k24;
        this.x0 ^= key.k25;
        this.x4 ^= key.k26;
        this.x1 ^= key.k27;
        this.sbox6();
        this.x2 ^= key.k28;
        this.x0 ^= key.k29;
        this.x3 ^= key.k30;
        this.x4 ^= key.k31;
        this.sbox7();
        this.x0 = this.x3;
        this.x3 = this.x2;
        this.x2 = this.x4;
        this.x0 ^= key.k32;
        this.x1 ^= key.k33;
        this.x2 ^= key.k34;
        this.x3 ^= key.k35;
        this.sbox0();
        this.x1 ^= key.k36;
        this.x4 ^= key.k37;
        this.x2 ^= key.k38;
        this.x0 ^= key.k39;
        this.sbox1();
        this.x0 ^= key.k40;
        this.x4 ^= key.k41;
        this.x2 ^= key.k42;
        this.x1 ^= key.k43;
        this.sbox2();
        this.x2 ^= key.k44;
        this.x1 ^= key.k45;
        this.x4 ^= key.k46;
        this.x3 ^= key.k47;
        this.sbox3();
        this.x1 ^= key.k48;
        this.x4 ^= key.k49;
        this.x3 ^= key.k50;
        this.x0 ^= key.k51;
        this.sbox4();
        this.x4 ^= key.k52;
        this.x2 ^= key.k53;
        this.x1 ^= key.k54;
        this.x0 ^= key.k55;
        this.sbox5();
        this.x2 ^= key.k56;
        this.x0 ^= key.k57;
        this.x4 ^= key.k58;
        this.x1 ^= key.k59;
        this.sbox6();
        this.x2 ^= key.k60;
        this.x0 ^= key.k61;
        this.x3 ^= key.k62;
        this.x4 ^= key.k63;
        this.sbox7();
        this.x0 = this.x3;
        this.x3 = this.x2;
        this.x2 = this.x4;
        this.x0 ^= key.k64;
        this.x1 ^= key.k65;
        this.x2 ^= key.k66;
        this.x3 ^= key.k67;
        this.sbox0();
        this.x1 ^= key.k68;
        this.x4 ^= key.k69;
        this.x2 ^= key.k70;
        this.x0 ^= key.k71;
        this.sbox1();
        this.x0 ^= key.k72;
        this.x4 ^= key.k73;
        this.x2 ^= key.k74;
        this.x1 ^= key.k75;
        this.sbox2();
        this.x2 ^= key.k76;
        this.x1 ^= key.k77;
        this.x4 ^= key.k78;
        this.x3 ^= key.k79;
        this.sbox3();
        this.x1 ^= key.k80;
        this.x4 ^= key.k81;
        this.x3 ^= key.k82;
        this.x0 ^= key.k83;
        this.sbox4();
        this.x4 ^= key.k84;
        this.x2 ^= key.k85;
        this.x1 ^= key.k86;
        this.x0 ^= key.k87;
        this.sbox5();
        this.x2 ^= key.k88;
        this.x0 ^= key.k89;
        this.x4 ^= key.k90;
        this.x1 ^= key.k91;
        this.sbox6();
        this.x2 ^= key.k92;
        this.x0 ^= key.k93;
        this.x3 ^= key.k94;
        this.x4 ^= key.k95;
        this.sbox7();
        this.x0 = this.x3;
        this.x3 = this.x2;
        this.x2 = this.x4;
        this.x0 ^= key.k96;
        this.x1 ^= key.k97;
        this.x2 ^= key.k98;
        this.x3 ^= key.k99;
        this.sbox0();
        this.x1 ^= key.k100;
        this.x4 ^= key.k101;
        this.x2 ^= key.k102;
        this.x0 ^= key.k103;
        this.sbox1();
        this.x0 ^= key.k104;
        this.x4 ^= key.k105;
        this.x2 ^= key.k106;
        this.x1 ^= key.k107;
        this.sbox2();
        this.x2 ^= key.k108;
        this.x1 ^= key.k109;
        this.x4 ^= key.k110;
        this.x3 ^= key.k111;
        this.sbox3();
        this.x1 ^= key.k112;
        this.x4 ^= key.k113;
        this.x3 ^= key.k114;
        this.x0 ^= key.k115;
        this.sbox4();
        this.x4 ^= key.k116;
        this.x2 ^= key.k117;
        this.x1 ^= key.k118;
        this.x0 ^= key.k119;
        this.sbox5();
        this.x2 ^= key.k120;
        this.x0 ^= key.k121;
        this.x4 ^= key.k122;
        this.x1 ^= key.k123;
        this.sbox6();
        this.x2 ^= key.k124;
        this.x0 ^= key.k125;
        this.x3 ^= key.k126;
        this.x4 ^= key.k127;
        this.sbox7noLT();
        this.x0 = this.x3;
        this.x3 = this.x2;
        this.x2 = this.x4;
        this.x0 ^= key.k128;
        this.x1 ^= key.k129;
        this.x2 ^= key.k130;
        this.x3 ^= key.k131;
        byArray2[n2] = (byte)this.x0;
        byArray2[n2 + 1] = (byte)(this.x0 >>> 8);
        byArray2[n2 + 2] = (byte)(this.x0 >>> 16);
        byArray2[n2 + 3] = (byte)(this.x0 >>> 24);
        byArray2[n2 + 4] = (byte)this.x1;
        byArray2[n2 + 5] = (byte)(this.x1 >>> 8);
        byArray2[n2 + 6] = (byte)(this.x1 >>> 16);
        byArray2[n2 + 7] = (byte)(this.x1 >>> 24);
        byArray2[n2 + 8] = (byte)this.x2;
        byArray2[n2 + 9] = (byte)(this.x2 >>> 8);
        byArray2[n2 + 10] = (byte)(this.x2 >>> 16);
        byArray2[n2 + 11] = (byte)(this.x2 >>> 24);
        byArray2[n2 + 12] = (byte)this.x3;
        byArray2[n2 + 13] = (byte)(this.x3 >>> 8);
        byArray2[n2 + 14] = (byte)(this.x3 >>> 16);
        byArray2[n2 + 15] = (byte)(this.x3 >>> 24);
    }

    public synchronized void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        Key key = (Key)object;
        this.x0 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        this.x1 = byArray[n + 4] & 0xFF | (byArray[n + 5] & 0xFF) << 8 | (byArray[n + 6] & 0xFF) << 16 | (byArray[n + 7] & 0xFF) << 24;
        this.x2 = byArray[n + 8] & 0xFF | (byArray[n + 9] & 0xFF) << 8 | (byArray[n + 10] & 0xFF) << 16 | (byArray[n + 11] & 0xFF) << 24;
        this.x3 = byArray[n + 12] & 0xFF | (byArray[n + 13] & 0xFF) << 8 | (byArray[n + 14] & 0xFF) << 16 | (byArray[n + 15] & 0xFF) << 24;
        this.x0 ^= key.k128;
        this.x1 ^= key.k129;
        this.x2 ^= key.k130;
        this.x3 ^= key.k131;
        this.sboxI7noLT();
        this.x3 ^= key.k124;
        this.x0 ^= key.k125;
        this.x1 ^= key.k126;
        this.x4 ^= key.k127;
        this.sboxI6();
        this.x0 ^= key.k120;
        this.x1 ^= key.k121;
        this.x2 ^= key.k122;
        this.x4 ^= key.k123;
        this.sboxI5();
        this.x1 ^= key.k116;
        this.x3 ^= key.k117;
        this.x4 ^= key.k118;
        this.x2 ^= key.k119;
        this.sboxI4();
        this.x1 ^= key.k112;
        this.x2 ^= key.k113;
        this.x4 ^= key.k114;
        this.x0 ^= key.k115;
        this.sboxI3();
        this.x0 ^= key.k108;
        this.x1 ^= key.k109;
        this.x4 ^= key.k110;
        this.x2 ^= key.k111;
        this.sboxI2();
        this.x1 ^= key.k104;
        this.x3 ^= key.k105;
        this.x4 ^= key.k106;
        this.x2 ^= key.k107;
        this.sboxI1();
        this.x0 ^= key.k100;
        this.x1 ^= key.k101;
        this.x2 ^= key.k102;
        this.x4 ^= key.k103;
        this.sboxI0();
        this.x0 ^= key.k96;
        this.x3 ^= key.k97;
        this.x1 ^= key.k98;
        this.x4 ^= key.k99;
        this.sboxI7();
        this.x1 = this.x3;
        this.x3 = this.x4;
        this.x4 = this.x2;
        this.x3 ^= key.k92;
        this.x0 ^= key.k93;
        this.x1 ^= key.k94;
        this.x4 ^= key.k95;
        this.sboxI6();
        this.x0 ^= key.k88;
        this.x1 ^= key.k89;
        this.x2 ^= key.k90;
        this.x4 ^= key.k91;
        this.sboxI5();
        this.x1 ^= key.k84;
        this.x3 ^= key.k85;
        this.x4 ^= key.k86;
        this.x2 ^= key.k87;
        this.sboxI4();
        this.x1 ^= key.k80;
        this.x2 ^= key.k81;
        this.x4 ^= key.k82;
        this.x0 ^= key.k83;
        this.sboxI3();
        this.x0 ^= key.k76;
        this.x1 ^= key.k77;
        this.x4 ^= key.k78;
        this.x2 ^= key.k79;
        this.sboxI2();
        this.x1 ^= key.k72;
        this.x3 ^= key.k73;
        this.x4 ^= key.k74;
        this.x2 ^= key.k75;
        this.sboxI1();
        this.x0 ^= key.k68;
        this.x1 ^= key.k69;
        this.x2 ^= key.k70;
        this.x4 ^= key.k71;
        this.sboxI0();
        this.x0 ^= key.k64;
        this.x3 ^= key.k65;
        this.x1 ^= key.k66;
        this.x4 ^= key.k67;
        this.sboxI7();
        this.x1 = this.x3;
        this.x3 = this.x4;
        this.x4 = this.x2;
        this.x3 ^= key.k60;
        this.x0 ^= key.k61;
        this.x1 ^= key.k62;
        this.x4 ^= key.k63;
        this.sboxI6();
        this.x0 ^= key.k56;
        this.x1 ^= key.k57;
        this.x2 ^= key.k58;
        this.x4 ^= key.k59;
        this.sboxI5();
        this.x1 ^= key.k52;
        this.x3 ^= key.k53;
        this.x4 ^= key.k54;
        this.x2 ^= key.k55;
        this.sboxI4();
        this.x1 ^= key.k48;
        this.x2 ^= key.k49;
        this.x4 ^= key.k50;
        this.x0 ^= key.k51;
        this.sboxI3();
        this.x0 ^= key.k44;
        this.x1 ^= key.k45;
        this.x4 ^= key.k46;
        this.x2 ^= key.k47;
        this.sboxI2();
        this.x1 ^= key.k40;
        this.x3 ^= key.k41;
        this.x4 ^= key.k42;
        this.x2 ^= key.k43;
        this.sboxI1();
        this.x0 ^= key.k36;
        this.x1 ^= key.k37;
        this.x2 ^= key.k38;
        this.x4 ^= key.k39;
        this.sboxI0();
        this.x0 ^= key.k32;
        this.x3 ^= key.k33;
        this.x1 ^= key.k34;
        this.x4 ^= key.k35;
        this.sboxI7();
        this.x1 = this.x3;
        this.x3 = this.x4;
        this.x4 = this.x2;
        this.x3 ^= key.k28;
        this.x0 ^= key.k29;
        this.x1 ^= key.k30;
        this.x4 ^= key.k31;
        this.sboxI6();
        this.x0 ^= key.k24;
        this.x1 ^= key.k25;
        this.x2 ^= key.k26;
        this.x4 ^= key.k27;
        this.sboxI5();
        this.x1 ^= key.k20;
        this.x3 ^= key.k21;
        this.x4 ^= key.k22;
        this.x2 ^= key.k23;
        this.sboxI4();
        this.x1 ^= key.k16;
        this.x2 ^= key.k17;
        this.x4 ^= key.k18;
        this.x0 ^= key.k19;
        this.sboxI3();
        this.x0 ^= key.k12;
        this.x1 ^= key.k13;
        this.x4 ^= key.k14;
        this.x2 ^= key.k15;
        this.sboxI2();
        this.x1 ^= key.k8;
        this.x3 ^= key.k9;
        this.x4 ^= key.k10;
        this.x2 ^= key.k11;
        this.sboxI1();
        this.x0 ^= key.k4;
        this.x1 ^= key.k5;
        this.x2 ^= key.k6;
        this.x4 ^= key.k7;
        this.sboxI0();
        this.x2 = this.x1;
        this.x1 = this.x3;
        this.x3 = this.x4;
        this.x0 ^= key.k0;
        this.x1 ^= key.k1;
        this.x2 ^= key.k2;
        this.x3 ^= key.k3;
        byArray2[n2] = (byte)this.x0;
        byArray2[n2 + 1] = (byte)(this.x0 >>> 8);
        byArray2[n2 + 2] = (byte)(this.x0 >>> 16);
        byArray2[n2 + 3] = (byte)(this.x0 >>> 24);
        byArray2[n2 + 4] = (byte)this.x1;
        byArray2[n2 + 5] = (byte)(this.x1 >>> 8);
        byArray2[n2 + 6] = (byte)(this.x1 >>> 16);
        byArray2[n2 + 7] = (byte)(this.x1 >>> 24);
        byArray2[n2 + 8] = (byte)this.x2;
        byArray2[n2 + 9] = (byte)(this.x2 >>> 8);
        byArray2[n2 + 10] = (byte)(this.x2 >>> 16);
        byArray2[n2 + 11] = (byte)(this.x2 >>> 24);
        byArray2[n2 + 12] = (byte)this.x3;
        byArray2[n2 + 13] = (byte)(this.x3 >>> 8);
        byArray2[n2 + 14] = (byte)(this.x3 >>> 16);
        byArray2[n2 + 15] = (byte)(this.x3 >>> 24);
    }

    public boolean selfTest() {
        if (valid == null) {
            boolean bl = super.selfTest();
            if (bl) {
                bl = this.testKat(KAT_KEY, KAT_CT);
            }
            valid = new Boolean(bl);
        }
        return valid;
    }

    private final void sbox0() {
        this.x3 ^= this.x0;
        this.x4 = this.x1;
        this.x1 &= this.x3;
        this.x4 ^= this.x2;
        this.x1 ^= this.x0;
        this.x0 |= this.x3;
        this.x0 ^= this.x4;
        this.x4 ^= this.x3;
        this.x3 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 ^= this.x4;
        this.x4 ^= 0xFFFFFFFF;
        this.x4 |= this.x1;
        this.x1 ^= this.x3;
        this.x1 ^= this.x4;
        this.x3 |= this.x0;
        this.x1 ^= this.x3;
        this.x4 ^= this.x3;
        this.x1 = this.x1 << 13 | this.x1 >>> 19;
        this.x4 ^= this.x1;
        this.x3 = this.x1 << 3;
        this.x2 = this.x2 << 3 | this.x2 >>> 29;
        this.x4 ^= this.x2;
        this.x0 ^= this.x2;
        this.x4 = this.x4 << 1 | this.x4 >>> 31;
        this.x0 ^= this.x3;
        this.x0 = this.x0 << 7 | this.x0 >>> 25;
        this.x3 = this.x4;
        this.x1 ^= this.x4;
        this.x3 <<= 7;
        this.x1 ^= this.x0;
        this.x2 ^= this.x0;
        this.x2 ^= this.x3;
        this.x1 = this.x1 << 5 | this.x1 >>> 27;
        this.x2 = this.x2 << 22 | this.x2 >>> 10;
    }

    private final void sbox1() {
        this.x4 ^= 0xFFFFFFFF;
        this.x3 = this.x1;
        this.x1 ^= this.x4;
        this.x3 |= this.x4;
        this.x3 ^= this.x0;
        this.x0 &= this.x1;
        this.x2 ^= this.x3;
        this.x0 ^= this.x4;
        this.x0 |= this.x2;
        this.x1 ^= this.x3;
        this.x0 ^= this.x1;
        this.x4 &= this.x2;
        this.x1 |= this.x4;
        this.x4 ^= this.x3;
        this.x1 ^= this.x2;
        this.x3 |= this.x0;
        this.x1 ^= this.x3;
        this.x3 ^= 0xFFFFFFFF;
        this.x4 ^= this.x0;
        this.x3 &= this.x2;
        this.x4 ^= 0xFFFFFFFF;
        this.x3 ^= this.x1;
        this.x4 ^= this.x3;
        this.x0 = this.x0 << 13 | this.x0 >>> 19;
        this.x4 ^= this.x0;
        this.x3 = this.x0 << 3;
        this.x2 = this.x2 << 3 | this.x2 >>> 29;
        this.x4 ^= this.x2;
        this.x1 ^= this.x2;
        this.x4 = this.x4 << 1 | this.x4 >>> 31;
        this.x1 ^= this.x3;
        this.x1 = this.x1 << 7 | this.x1 >>> 25;
        this.x3 = this.x4;
        this.x0 ^= this.x4;
        this.x3 <<= 7;
        this.x0 ^= this.x1;
        this.x2 ^= this.x1;
        this.x2 ^= this.x3;
        this.x0 = this.x0 << 5 | this.x0 >>> 27;
        this.x2 = this.x2 << 22 | this.x2 >>> 10;
    }

    private final void sbox2() {
        this.x3 = this.x0;
        this.x0 &= this.x2;
        this.x0 ^= this.x1;
        this.x2 ^= this.x4;
        this.x2 ^= this.x0;
        this.x1 |= this.x3;
        this.x1 ^= this.x4;
        this.x3 ^= this.x2;
        this.x4 = this.x1;
        this.x1 |= this.x3;
        this.x1 ^= this.x0;
        this.x0 &= this.x4;
        this.x3 ^= this.x0;
        this.x4 ^= this.x1;
        this.x4 ^= this.x3;
        this.x3 ^= 0xFFFFFFFF;
        this.x2 = this.x2 << 13 | this.x2 >>> 19;
        this.x1 ^= this.x2;
        this.x0 = this.x2 << 3;
        this.x4 = this.x4 << 3 | this.x4 >>> 29;
        this.x1 ^= this.x4;
        this.x3 ^= this.x4;
        this.x1 = this.x1 << 1 | this.x1 >>> 31;
        this.x3 ^= this.x0;
        this.x3 = this.x3 << 7 | this.x3 >>> 25;
        this.x0 = this.x1;
        this.x2 ^= this.x1;
        this.x0 <<= 7;
        this.x2 ^= this.x3;
        this.x4 ^= this.x3;
        this.x4 ^= this.x0;
        this.x2 = this.x2 << 5 | this.x2 >>> 27;
        this.x4 = this.x4 << 22 | this.x4 >>> 10;
    }

    private final void sbox3() {
        this.x0 = this.x2;
        this.x2 |= this.x3;
        this.x3 ^= this.x1;
        this.x1 &= this.x0;
        this.x0 ^= this.x4;
        this.x4 ^= this.x3;
        this.x3 &= this.x2;
        this.x0 |= this.x1;
        this.x3 ^= this.x0;
        this.x2 ^= this.x1;
        this.x0 &= this.x2;
        this.x1 ^= this.x3;
        this.x0 ^= this.x4;
        this.x1 |= this.x2;
        this.x1 ^= this.x4;
        this.x2 ^= this.x3;
        this.x4 = this.x1;
        this.x1 |= this.x3;
        this.x1 ^= this.x2;
        this.x1 = this.x1 << 13 | this.x1 >>> 19;
        this.x4 ^= this.x1;
        this.x2 = this.x1 << 3;
        this.x3 = this.x3 << 3 | this.x3 >>> 29;
        this.x4 ^= this.x3;
        this.x0 ^= this.x3;
        this.x4 = this.x4 << 1 | this.x4 >>> 31;
        this.x0 ^= this.x2;
        this.x0 = this.x0 << 7 | this.x0 >>> 25;
        this.x2 = this.x4;
        this.x1 ^= this.x4;
        this.x2 <<= 7;
        this.x1 ^= this.x0;
        this.x3 ^= this.x0;
        this.x3 ^= this.x2;
        this.x1 = this.x1 << 5 | this.x1 >>> 27;
        this.x3 = this.x3 << 22 | this.x3 >>> 10;
    }

    private final void sbox4() {
        this.x4 ^= this.x0;
        this.x0 ^= 0xFFFFFFFF;
        this.x3 ^= this.x0;
        this.x0 ^= this.x1;
        this.x2 = this.x4;
        this.x4 &= this.x0;
        this.x4 ^= this.x3;
        this.x2 ^= this.x0;
        this.x1 ^= this.x2;
        this.x3 &= this.x2;
        this.x3 ^= this.x1;
        this.x1 &= this.x4;
        this.x0 ^= this.x1;
        this.x2 |= this.x4;
        this.x2 ^= this.x1;
        this.x1 |= this.x0;
        this.x1 ^= this.x3;
        this.x3 &= this.x0;
        this.x1 ^= 0xFFFFFFFF;
        this.x2 ^= this.x3;
        this.x4 = this.x4 << 13 | this.x4 >>> 19;
        this.x2 ^= this.x4;
        this.x3 = this.x4 << 3;
        this.x1 = this.x1 << 3 | this.x1 >>> 29;
        this.x2 ^= this.x1;
        this.x0 ^= this.x1;
        this.x2 = this.x2 << 1 | this.x2 >>> 31;
        this.x0 ^= this.x3;
        this.x0 = this.x0 << 7 | this.x0 >>> 25;
        this.x3 = this.x2;
        this.x4 ^= this.x2;
        this.x3 <<= 7;
        this.x4 ^= this.x0;
        this.x1 ^= this.x0;
        this.x1 ^= this.x3;
        this.x4 = this.x4 << 5 | this.x4 >>> 27;
        this.x1 = this.x1 << 22 | this.x1 >>> 10;
    }

    private final void sbox5() {
        this.x4 ^= this.x2;
        this.x2 ^= this.x0;
        this.x0 ^= 0xFFFFFFFF;
        this.x3 = this.x2;
        this.x2 &= this.x4;
        this.x1 ^= this.x0;
        this.x2 ^= this.x1;
        this.x1 |= this.x3;
        this.x3 ^= this.x0;
        this.x0 &= this.x2;
        this.x0 ^= this.x4;
        this.x3 ^= this.x2;
        this.x3 ^= this.x1;
        this.x1 ^= this.x4;
        this.x4 &= this.x0;
        this.x1 ^= 0xFFFFFFFF;
        this.x4 ^= this.x3;
        this.x3 |= this.x0;
        this.x1 ^= this.x3;
        this.x2 = this.x2 << 13 | this.x2 >>> 19;
        this.x0 ^= this.x2;
        this.x3 = this.x2 << 3;
        this.x4 = this.x4 << 3 | this.x4 >>> 29;
        this.x0 ^= this.x4;
        this.x1 ^= this.x4;
        this.x0 = this.x0 << 1 | this.x0 >>> 31;
        this.x1 ^= this.x3;
        this.x1 = this.x1 << 7 | this.x1 >>> 25;
        this.x3 = this.x0;
        this.x2 ^= this.x0;
        this.x3 <<= 7;
        this.x2 ^= this.x1;
        this.x4 ^= this.x1;
        this.x4 ^= this.x3;
        this.x2 = this.x2 << 5 | this.x2 >>> 27;
        this.x4 = this.x4 << 22 | this.x4 >>> 10;
    }

    private final void sbox6() {
        this.x4 ^= 0xFFFFFFFF;
        this.x3 = this.x1;
        this.x1 &= this.x2;
        this.x2 ^= this.x3;
        this.x1 ^= this.x4;
        this.x4 |= this.x3;
        this.x0 ^= this.x1;
        this.x4 ^= this.x2;
        this.x2 |= this.x0;
        this.x4 ^= this.x0;
        this.x3 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 ^= this.x4;
        this.x3 ^= this.x1;
        this.x3 ^= this.x2;
        this.x1 ^= 0xFFFFFFFF;
        this.x4 &= this.x3;
        this.x4 ^= this.x1;
        this.x2 = this.x2 << 13 | this.x2 >>> 19;
        this.x0 ^= this.x2;
        this.x1 = this.x2 << 3;
        this.x3 = this.x3 << 3 | this.x3 >>> 29;
        this.x0 ^= this.x3;
        this.x4 ^= this.x3;
        this.x0 = this.x0 << 1 | this.x0 >>> 31;
        this.x4 ^= this.x1;
        this.x4 = this.x4 << 7 | this.x4 >>> 25;
        this.x1 = this.x0;
        this.x2 ^= this.x0;
        this.x1 <<= 7;
        this.x2 ^= this.x4;
        this.x3 ^= this.x4;
        this.x3 ^= this.x1;
        this.x2 = this.x2 << 5 | this.x2 >>> 27;
        this.x3 = this.x3 << 22 | this.x3 >>> 10;
    }

    private final void sbox7() {
        this.x1 = this.x3;
        this.x3 &= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x0;
        this.x1 ^= this.x3;
        this.x3 ^= this.x0;
        this.x0 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 ^= this.x3;
        this.x4 ^= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x2;
        this.x4 ^= this.x1;
        this.x1 ^= this.x3;
        this.x3 &= this.x2;
        this.x1 ^= 0xFFFFFFFF;
        this.x3 ^= this.x1;
        this.x1 &= this.x2;
        this.x0 ^= this.x4;
        this.x1 ^= this.x0;
        this.x3 = this.x3 << 13 | this.x3 >>> 19;
        this.x1 ^= this.x3;
        this.x0 = this.x3 << 3;
        this.x4 = this.x4 << 3 | this.x4 >>> 29;
        this.x1 ^= this.x4;
        this.x2 ^= this.x4;
        this.x1 = this.x1 << 1 | this.x1 >>> 31;
        this.x2 ^= this.x0;
        this.x2 = this.x2 << 7 | this.x2 >>> 25;
        this.x0 = this.x1;
        this.x3 ^= this.x1;
        this.x0 <<= 7;
        this.x3 ^= this.x2;
        this.x4 ^= this.x2;
        this.x4 ^= this.x0;
        this.x3 = this.x3 << 5 | this.x3 >>> 27;
        this.x4 = this.x4 << 22 | this.x4 >>> 10;
    }

    private final void sbox7noLT() {
        this.x1 = this.x3;
        this.x3 &= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x0;
        this.x1 ^= this.x3;
        this.x3 ^= this.x0;
        this.x0 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 ^= this.x3;
        this.x4 ^= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x2;
        this.x4 ^= this.x1;
        this.x1 ^= this.x3;
        this.x3 &= this.x2;
        this.x1 ^= 0xFFFFFFFF;
        this.x3 ^= this.x1;
        this.x1 &= this.x2;
        this.x0 ^= this.x4;
        this.x1 ^= this.x0;
    }

    private final void sboxI7noLT() {
        this.x4 = this.x2;
        this.x2 ^= this.x0;
        this.x0 &= this.x3;
        this.x2 ^= 0xFFFFFFFF;
        this.x4 |= this.x3;
        this.x3 ^= this.x1;
        this.x1 |= this.x0;
        this.x0 ^= this.x2;
        this.x2 &= this.x4;
        this.x1 ^= this.x2;
        this.x2 ^= this.x0;
        this.x0 |= this.x2;
        this.x3 &= this.x4;
        this.x0 ^= this.x3;
        this.x4 ^= this.x1;
        this.x3 ^= this.x4;
        this.x4 |= this.x0;
        this.x3 ^= this.x2;
        this.x4 ^= this.x2;
    }

    private final void sboxI6() {
        this.x1 = this.x1 >>> 22 | this.x1 << 10;
        this.x3 = this.x3 >>> 5 | this.x3 << 27;
        this.x2 = this.x0;
        this.x1 ^= this.x4;
        this.x2 <<= 7;
        this.x3 ^= this.x4;
        this.x1 ^= this.x2;
        this.x3 ^= this.x0;
        this.x4 = this.x4 >>> 7 | this.x4 << 25;
        this.x0 = this.x0 >>> 1 | this.x0 << 31;
        this.x0 ^= this.x3;
        this.x2 = this.x3 << 3;
        this.x4 ^= this.x2;
        this.x3 = this.x3 >>> 13 | this.x3 << 19;
        this.x0 ^= this.x1;
        this.x4 ^= this.x1;
        this.x1 = this.x1 >>> 3 | this.x1 << 29;
        this.x3 ^= this.x1;
        this.x2 = this.x1;
        this.x1 &= this.x3;
        this.x2 ^= this.x4;
        this.x1 ^= 0xFFFFFFFF;
        this.x4 ^= this.x0;
        this.x1 ^= this.x4;
        this.x2 |= this.x3;
        this.x3 ^= this.x1;
        this.x4 ^= this.x2;
        this.x2 ^= this.x0;
        this.x0 &= this.x4;
        this.x0 ^= this.x3;
        this.x3 ^= this.x4;
        this.x3 |= this.x1;
        this.x4 ^= this.x0;
        this.x2 ^= this.x3;
    }

    private final void sboxI5() {
        this.x2 = this.x2 >>> 22 | this.x2 << 10;
        this.x0 = this.x0 >>> 5 | this.x0 << 27;
        this.x3 = this.x1;
        this.x2 ^= this.x4;
        this.x3 <<= 7;
        this.x0 ^= this.x4;
        this.x2 ^= this.x3;
        this.x0 ^= this.x1;
        this.x4 = this.x4 >>> 7 | this.x4 << 25;
        this.x1 = this.x1 >>> 1 | this.x1 << 31;
        this.x1 ^= this.x0;
        this.x3 = this.x0 << 3;
        this.x4 ^= this.x3;
        this.x0 = this.x0 >>> 13 | this.x0 << 19;
        this.x1 ^= this.x2;
        this.x4 ^= this.x2;
        this.x2 = this.x2 >>> 3 | this.x2 << 29;
        this.x1 ^= 0xFFFFFFFF;
        this.x3 = this.x4;
        this.x2 ^= this.x1;
        this.x4 |= this.x0;
        this.x4 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 &= this.x0;
        this.x3 ^= this.x4;
        this.x2 ^= this.x3;
        this.x3 |= this.x0;
        this.x3 ^= this.x1;
        this.x1 &= this.x2;
        this.x1 ^= this.x4;
        this.x3 ^= this.x2;
        this.x4 &= this.x3;
        this.x3 ^= this.x1;
        this.x4 ^= this.x0;
        this.x4 ^= this.x3;
        this.x3 ^= 0xFFFFFFFF;
    }

    private final void sboxI4() {
        this.x4 = this.x4 >>> 22 | this.x4 << 10;
        this.x1 = this.x1 >>> 5 | this.x1 << 27;
        this.x0 = this.x3;
        this.x4 ^= this.x2;
        this.x0 <<= 7;
        this.x1 ^= this.x2;
        this.x4 ^= this.x0;
        this.x1 ^= this.x3;
        this.x2 = this.x2 >>> 7 | this.x2 << 25;
        this.x3 = this.x3 >>> 1 | this.x3 << 31;
        this.x3 ^= this.x1;
        this.x0 = this.x1 << 3;
        this.x2 ^= this.x0;
        this.x1 = this.x1 >>> 13 | this.x1 << 19;
        this.x3 ^= this.x4;
        this.x2 ^= this.x4;
        this.x0 = this.x4 = this.x4 >>> 3 | this.x4 << 29;
        this.x4 &= this.x2;
        this.x4 ^= this.x3;
        this.x3 |= this.x2;
        this.x3 &= this.x1;
        this.x0 ^= this.x4;
        this.x0 ^= this.x3;
        this.x3 &= this.x4;
        this.x1 ^= 0xFFFFFFFF;
        this.x2 ^= this.x0;
        this.x3 ^= this.x2;
        this.x2 &= this.x1;
        this.x2 ^= this.x4;
        this.x1 ^= this.x3;
        this.x4 &= this.x1;
        this.x2 ^= this.x1;
        this.x4 ^= this.x0;
        this.x4 |= this.x2;
        this.x2 ^= this.x1;
        this.x4 ^= this.x3;
    }

    private final void sboxI3() {
        this.x4 = this.x4 >>> 22 | this.x4 << 10;
        this.x1 = this.x1 >>> 5 | this.x1 << 27;
        this.x3 = this.x2;
        this.x4 ^= this.x0;
        this.x3 <<= 7;
        this.x1 ^= this.x0;
        this.x4 ^= this.x3;
        this.x1 ^= this.x2;
        this.x0 = this.x0 >>> 7 | this.x0 << 25;
        this.x2 = this.x2 >>> 1 | this.x2 << 31;
        this.x2 ^= this.x1;
        this.x3 = this.x1 << 3;
        this.x0 ^= this.x3;
        this.x1 = this.x1 >>> 13 | this.x1 << 19;
        this.x2 ^= this.x4;
        this.x0 ^= this.x4;
        this.x3 = this.x4 = this.x4 >>> 3 | this.x4 << 29;
        this.x4 ^= this.x2;
        this.x2 &= this.x4;
        this.x2 ^= this.x1;
        this.x1 &= this.x3;
        this.x3 ^= this.x0;
        this.x0 |= this.x2;
        this.x0 ^= this.x4;
        this.x1 ^= this.x3;
        this.x4 ^= this.x1;
        this.x1 |= this.x0;
        this.x1 ^= this.x2;
        this.x3 ^= this.x4;
        this.x4 &= this.x0;
        this.x2 |= this.x0;
        this.x2 ^= this.x4;
        this.x3 ^= this.x1;
        this.x4 ^= this.x3;
    }

    private final void sboxI2() {
        this.x4 = this.x4 >>> 22 | this.x4 << 10;
        this.x0 = this.x0 >>> 5 | this.x0 << 27;
        this.x3 = this.x1;
        this.x4 ^= this.x2;
        this.x3 <<= 7;
        this.x0 ^= this.x2;
        this.x4 ^= this.x3;
        this.x0 ^= this.x1;
        this.x2 = this.x2 >>> 7 | this.x2 << 25;
        this.x1 = this.x1 >>> 1 | this.x1 << 31;
        this.x1 ^= this.x0;
        this.x3 = this.x0 << 3;
        this.x2 ^= this.x3;
        this.x0 = this.x0 >>> 13 | this.x0 << 19;
        this.x1 ^= this.x4;
        this.x2 ^= this.x4;
        this.x4 = this.x4 >>> 3 | this.x4 << 29;
        this.x4 ^= this.x2;
        this.x2 ^= this.x0;
        this.x3 = this.x2;
        this.x2 &= this.x4;
        this.x2 ^= this.x1;
        this.x1 |= this.x4;
        this.x1 ^= this.x3;
        this.x3 &= this.x2;
        this.x4 ^= this.x2;
        this.x3 &= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x1;
        this.x4 |= this.x0;
        this.x2 ^= 0xFFFFFFFF;
        this.x4 ^= this.x2;
        this.x0 ^= this.x2;
        this.x0 &= this.x1;
        this.x2 ^= this.x3;
        this.x2 ^= this.x0;
    }

    private final void sboxI1() {
        this.x4 = this.x4 >>> 22 | this.x4 << 10;
        this.x1 = this.x1 >>> 5 | this.x1 << 27;
        this.x0 = this.x3;
        this.x4 ^= this.x2;
        this.x0 <<= 7;
        this.x1 ^= this.x2;
        this.x4 ^= this.x0;
        this.x1 ^= this.x3;
        this.x2 = this.x2 >>> 7 | this.x2 << 25;
        this.x3 = this.x3 >>> 1 | this.x3 << 31;
        this.x3 ^= this.x1;
        this.x0 = this.x1 << 3;
        this.x2 ^= this.x0;
        this.x1 = this.x1 >>> 13 | this.x1 << 19;
        this.x3 ^= this.x4;
        this.x2 ^= this.x4;
        this.x4 = this.x4 >>> 3 | this.x4 << 29;
        this.x0 = this.x3;
        this.x3 ^= this.x2;
        this.x2 &= this.x3;
        this.x0 ^= this.x4;
        this.x2 ^= this.x1;
        this.x1 |= this.x3;
        this.x4 ^= this.x2;
        this.x1 ^= this.x0;
        this.x1 |= this.x4;
        this.x3 ^= this.x2;
        this.x1 ^= this.x3;
        this.x3 |= this.x2;
        this.x3 ^= this.x1;
        this.x0 ^= 0xFFFFFFFF;
        this.x0 ^= this.x3;
        this.x3 |= this.x1;
        this.x3 ^= this.x1;
        this.x3 |= this.x0;
        this.x2 ^= this.x3;
    }

    private final void sboxI0() {
        this.x2 = this.x2 >>> 22 | this.x2 << 10;
        this.x0 = this.x0 >>> 5 | this.x0 << 27;
        this.x3 = this.x1;
        this.x2 ^= this.x4;
        this.x3 <<= 7;
        this.x0 ^= this.x4;
        this.x2 ^= this.x3;
        this.x0 ^= this.x1;
        this.x4 = this.x4 >>> 7 | this.x4 << 25;
        this.x1 = this.x1 >>> 1 | this.x1 << 31;
        this.x1 ^= this.x0;
        this.x3 = this.x0 << 3;
        this.x4 ^= this.x3;
        this.x0 = this.x0 >>> 13 | this.x0 << 19;
        this.x1 ^= this.x2;
        this.x4 ^= this.x2;
        this.x2 = this.x2 >>> 3 | this.x2 << 29;
        this.x2 ^= 0xFFFFFFFF;
        this.x3 = this.x1;
        this.x1 |= this.x0;
        this.x3 ^= 0xFFFFFFFF;
        this.x1 ^= this.x2;
        this.x2 |= this.x3;
        this.x1 ^= this.x4;
        this.x0 ^= this.x3;
        this.x2 ^= this.x0;
        this.x0 &= this.x4;
        this.x3 ^= this.x0;
        this.x0 |= this.x1;
        this.x0 ^= this.x2;
        this.x4 ^= this.x3;
        this.x2 ^= this.x1;
        this.x4 ^= this.x0;
        this.x4 ^= this.x1;
        this.x2 &= this.x4;
        this.x3 ^= this.x2;
    }

    private final void sboxI7() {
        this.x1 = this.x1 >>> 22 | this.x1 << 10;
        this.x0 = this.x0 >>> 5 | this.x0 << 27;
        this.x2 = this.x3;
        this.x1 ^= this.x4;
        this.x2 <<= 7;
        this.x0 ^= this.x4;
        this.x1 ^= this.x2;
        this.x0 ^= this.x3;
        this.x4 = this.x4 >>> 7 | this.x4 << 25;
        this.x3 = this.x3 >>> 1 | this.x3 << 31;
        this.x3 ^= this.x0;
        this.x2 = this.x0 << 3;
        this.x4 ^= this.x2;
        this.x0 = this.x0 >>> 13 | this.x0 << 19;
        this.x3 ^= this.x1;
        this.x4 ^= this.x1;
        this.x2 = this.x1 = this.x1 >>> 3 | this.x1 << 29;
        this.x1 ^= this.x0;
        this.x0 &= this.x4;
        this.x1 ^= 0xFFFFFFFF;
        this.x2 |= this.x4;
        this.x4 ^= this.x3;
        this.x3 |= this.x0;
        this.x0 ^= this.x1;
        this.x1 &= this.x2;
        this.x3 ^= this.x1;
        this.x1 ^= this.x0;
        this.x0 |= this.x1;
        this.x4 &= this.x2;
        this.x0 ^= this.x4;
        this.x2 ^= this.x3;
        this.x4 ^= this.x2;
        this.x2 |= this.x0;
        this.x4 ^= this.x1;
        this.x2 ^= this.x1;
    }

    private final void sbox0(int n, int n2, int n3, int n4) {
        int n5 = n2 ^ n3;
        n2 = n2 & (n4 ^= n) ^ n;
        n = (n | n4) ^ n5;
        n5 ^= n4;
        n4 ^= n3;
        n3 = (n3 | n2) ^ n5;
        n5 = ~n5 | n2;
        n2 ^= n4 ^ n5;
        this.x0 = n2 ^ (n4 |= n);
        this.x1 = n5 ^ n4;
        this.x2 = n3;
        this.x3 = n;
    }

    private final void sbox1(int n, int n2, int n3, int n4) {
        int n5 = n ^= 0xFFFFFFFF;
        n3 ^= 0xFFFFFFFF;
        n |= n4;
        n4 ^= (n3 ^= (n &= n2));
        n2 ^= n;
        n ^= n5;
        n5 |= n2;
        n3 = (n3 | n) & n5;
        this.x0 = n3;
        this.x1 = (n ^= (n2 ^= n4)) & n3 ^ n5;
        this.x2 = n4;
        this.x3 = n2 & n3 ^ n;
    }

    private final void sbox2(int n, int n2, int n3, int n4) {
        int n5 = n;
        n = n & n3 ^ n4;
        n3 = n3 ^ n2 ^ n;
        n4 = (n4 | n5) ^ n2;
        n2 = n4;
        n4 = (n4 | (n5 ^= n3)) ^ n;
        this.x0 = n3;
        this.x1 = n4;
        this.x2 = n2 ^ n4 ^ (n5 ^= (n &= n2));
        this.x3 = ~n5;
    }

    private final void sbox3(int n, int n2, int n3, int n4) {
        int n5 = n;
        n |= n4;
        n4 ^= n2;
        n2 &= n5;
        n5 = n5 ^ n3 | n2;
        n3 ^= n4;
        n4 = n4 & n ^ n5;
        n5 = n5 & (n ^= n2) ^ n3;
        n2 = (n2 ^ n4 | n) ^ n3;
        this.x0 = (n2 | n4) ^ (n ^= n4);
        this.x1 = n2;
        this.x2 = n4;
        this.x3 = n5;
    }

    private final void sbox4(int n, int n2, int n3, int n4) {
        int n5 = n2 ^= n4;
        n2 = n2 & (n4 ^= n) ^ (n3 ^= (n4 ^= 0xFFFFFFFF));
        n3 = n3 & n5 ^ (n ^= (n5 ^= n4));
        n5 = (n5 | n2) ^ n;
        this.x0 = n2;
        this.x1 = n5 ^ n3 & (n4 ^= (n &= n2));
        this.x2 = ~((n | n4) ^ n3);
        this.x3 = n4;
    }

    private final void sbox5(int n, int n2, int n3, int n4) {
        n ^= n2;
        int n5 = n2 ^= n4;
        n2 &= n;
        n3 |= n5;
        n5 ^= n4;
        n4 = n4 & (n2 ^= (n3 ^= (n4 ^= 0xFFFFFFFF))) ^ n;
        n5 = n5 ^ n2 ^ n3;
        this.x0 = n2;
        this.x1 = n4;
        this.x2 = n & n4 ^ n5;
        this.x3 = ~(n3 ^ n) ^ (n5 | n4);
    }

    private final void sbox6(int n, int n2, int n3, int n4) {
        int n5 = n4;
        n4 = n4 & n ^ (n3 ^= 0xFFFFFFFF);
        n3 = (n3 | n5) ^ (n ^= n5);
        n5 ^= (n |= (n2 ^= n4));
        n = (n | n4) ^ (n3 ^= n2);
        n5 = n5 ^ n4 ^ n;
        this.x0 = n;
        this.x1 = n2;
        this.x2 = n5;
        this.x3 = n3 & n5 ^ ~n4;
    }

    private final void sbox7(int n, int n2, int n3, int n4) {
        int n5 = n2;
        n2 = (n2 | n3) ^ n4;
        n5 ^= n3;
        n4 = (n4 | n5) & n;
        n5 ^= (n3 ^= n2);
        n4 ^= n2;
        n2 = (n2 | n5) ^ n;
        n = (n | n5) ^ n3;
        this.x0 = n5 ^ (~(n3 ^= (n2 ^= n5)) | n);
        this.x1 = n4;
        this.x2 = n2 & n ^ n5;
        this.x3 = n;
    }

    public Serpent() {
        super("serpent", 16, 16);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Key
    implements Cloneable {
        int k0;
        int k1;
        int k2;
        int k3;
        int k4;
        int k5;
        int k6;
        int k7;
        int k8;
        int k9;
        int k10;
        int k11;
        int k12;
        int k13;
        int k14;
        int k15;
        int k16;
        int k17;
        int k18;
        int k19;
        int k20;
        int k21;
        int k22;
        int k23;
        int k24;
        int k25;
        int k26;
        int k27;
        int k28;
        int k29;
        int k30;
        int k31;
        int k32;
        int k33;
        int k34;
        int k35;
        int k36;
        int k37;
        int k38;
        int k39;
        int k40;
        int k41;
        int k42;
        int k43;
        int k44;
        int k45;
        int k46;
        int k47;
        int k48;
        int k49;
        int k50;
        int k51;
        int k52;
        int k53;
        int k54;
        int k55;
        int k56;
        int k57;
        int k58;
        int k59;
        int k60;
        int k61;
        int k62;
        int k63;
        int k64;
        int k65;
        int k66;
        int k67;
        int k68;
        int k69;
        int k70;
        int k71;
        int k72;
        int k73;
        int k74;
        int k75;
        int k76;
        int k77;
        int k78;
        int k79;
        int k80;
        int k81;
        int k82;
        int k83;
        int k84;
        int k85;
        int k86;
        int k87;
        int k88;
        int k89;
        int k90;
        int k91;
        int k92;
        int k93;
        int k94;
        int k95;
        int k96;
        int k97;
        int k98;
        int k99;
        int k100;
        int k101;
        int k102;
        int k103;
        int k104;
        int k105;
        int k106;
        int k107;
        int k108;
        int k109;
        int k110;
        int k111;
        int k112;
        int k113;
        int k114;
        int k115;
        int k116;
        int k117;
        int k118;
        int k119;
        int k120;
        int k121;
        int k122;
        int k123;
        int k124;
        int k125;
        int k126;
        int k127;
        int k128;
        int k129;
        int k130;
        int k131;

        public Object clone() {
            return new Key(this);
        }

        Key() {
        }

        private Key(Key key) {
            this.k0 = key.k0;
            this.k1 = key.k1;
            this.k2 = key.k2;
            this.k3 = key.k3;
            this.k4 = key.k4;
            this.k5 = key.k5;
            this.k6 = key.k6;
            this.k7 = key.k7;
            this.k8 = key.k8;
            this.k9 = key.k9;
            this.k10 = key.k10;
            this.k11 = key.k11;
            this.k12 = key.k12;
            this.k13 = key.k13;
            this.k14 = key.k14;
            this.k15 = key.k15;
            this.k16 = key.k16;
            this.k17 = key.k17;
            this.k18 = key.k18;
            this.k19 = key.k19;
            this.k20 = key.k20;
            this.k21 = key.k21;
            this.k22 = key.k22;
            this.k23 = key.k23;
            this.k24 = key.k24;
            this.k25 = key.k25;
            this.k26 = key.k26;
            this.k27 = key.k27;
            this.k28 = key.k28;
            this.k29 = key.k29;
            this.k30 = key.k30;
            this.k31 = key.k31;
            this.k32 = key.k32;
            this.k33 = key.k33;
            this.k34 = key.k34;
            this.k35 = key.k35;
            this.k36 = key.k36;
            this.k37 = key.k37;
            this.k38 = key.k38;
            this.k39 = key.k39;
            this.k40 = key.k40;
            this.k41 = key.k41;
            this.k42 = key.k42;
            this.k43 = key.k43;
            this.k44 = key.k44;
            this.k45 = key.k45;
            this.k46 = key.k46;
            this.k47 = key.k47;
            this.k48 = key.k48;
            this.k49 = key.k49;
            this.k50 = key.k50;
            this.k51 = key.k51;
            this.k52 = key.k52;
            this.k53 = key.k53;
            this.k54 = key.k54;
            this.k55 = key.k55;
            this.k56 = key.k56;
            this.k57 = key.k57;
            this.k58 = key.k58;
            this.k59 = key.k59;
            this.k60 = key.k60;
            this.k61 = key.k61;
            this.k62 = key.k62;
            this.k63 = key.k63;
            this.k64 = key.k64;
            this.k65 = key.k65;
            this.k66 = key.k66;
            this.k67 = key.k67;
            this.k68 = key.k68;
            this.k69 = key.k69;
            this.k70 = key.k70;
            this.k71 = key.k71;
            this.k72 = key.k72;
            this.k73 = key.k73;
            this.k74 = key.k74;
            this.k75 = key.k75;
            this.k76 = key.k76;
            this.k77 = key.k77;
            this.k78 = key.k78;
            this.k79 = key.k79;
            this.k80 = key.k80;
            this.k81 = key.k81;
            this.k82 = key.k82;
            this.k83 = key.k83;
            this.k84 = key.k84;
            this.k85 = key.k85;
            this.k86 = key.k86;
            this.k87 = key.k87;
            this.k88 = key.k88;
            this.k89 = key.k89;
            this.k90 = key.k90;
            this.k91 = key.k91;
            this.k92 = key.k92;
            this.k93 = key.k93;
            this.k94 = key.k94;
            this.k95 = key.k95;
            this.k96 = key.k96;
            this.k97 = key.k97;
            this.k98 = key.k98;
            this.k99 = key.k99;
            this.k100 = key.k100;
            this.k101 = key.k101;
            this.k102 = key.k102;
            this.k103 = key.k103;
            this.k104 = key.k104;
            this.k105 = key.k105;
            this.k106 = key.k106;
            this.k107 = key.k107;
            this.k108 = key.k108;
            this.k109 = key.k109;
            this.k110 = key.k110;
            this.k111 = key.k111;
            this.k112 = key.k112;
            this.k113 = key.k113;
            this.k114 = key.k114;
            this.k115 = key.k115;
            this.k116 = key.k116;
            this.k117 = key.k117;
            this.k118 = key.k118;
            this.k119 = key.k119;
            this.k120 = key.k120;
            this.k121 = key.k121;
            this.k122 = key.k122;
            this.k123 = key.k123;
            this.k124 = key.k124;
            this.k125 = key.k125;
            this.k126 = key.k126;
            this.k127 = key.k127;
            this.k128 = key.k128;
            this.k129 = key.k129;
            this.k130 = key.k130;
            this.k131 = key.k131;
        }
    }
}

