/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.BacktrackStack;
import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class RETokenRepeated
extends REToken {
    private REToken token;
    private int min;
    private int max;
    private boolean stingy;
    private boolean possessive;
    private int tokenFixedLength;

    final void makeStingy() {
        this.stingy = true;
    }

    final boolean isStingy() {
        return this.stingy;
    }

    final void makePossessive() {
        this.possessive = true;
    }

    final boolean isPossessive() {
        return this.possessive;
    }

    final int getMinimumLength() {
        return this.min * this.token.getMinimumLength();
    }

    final int getMaximumLength() {
        if (this.max == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int n = this.token.getMaximumLength();
        if (n == Integer.MAX_VALUE) {
            return n;
        }
        return this.max * n;
    }

    final REMatch findMatch(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.tokenFixedLength >= 0) {
            return this.findMatchFixedLength(charIndexed, rEMatch);
        }
        BacktrackStack backtrackStack = new BacktrackStack();
        backtrackStack.push(new StackedInfo(charIndexed, 0, rEMatch, null, null));
        return this.findMatch(backtrackStack);
    }

    final REMatch backtrack(CharIndexed charIndexed, REMatch rEMatch, Object object) {
        if (this.tokenFixedLength >= 0) {
            return this.backtrackFixedLength(charIndexed, rEMatch, object);
        }
        return this.findMatch((BacktrackStack)object);
    }

    private final REMatch findMatch(BacktrackStack backtrackStack) {
        REMatch rEMatch;
        REMatch rEMatch2;
        CharIndexed charIndexed;
        while (true) {
            REMatch rEMatch3;
            if (backtrackStack.empty()) {
                return null;
            }
            StackedInfo stackedInfo = (StackedInfo)backtrackStack.peek();
            charIndexed = stackedInfo.input;
            int n = stackedInfo.numRepeats;
            rEMatch2 = stackedInfo.match;
            int[] nArray = stackedInfo.visited;
            DoablesFinder doablesFinder = stackedInfo.finder;
            if (rEMatch2.backtrackStack == null) {
                rEMatch2.backtrackStack = new BacktrackStack();
            }
            if (n >= this.max) {
                backtrackStack.pop();
                rEMatch = this.matchRest(charIndexed, rEMatch2);
                if (rEMatch != null) {
                    if (!backtrackStack.empty()) {
                        rEMatch.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch2, backtrackStack));
                    }
                    return rEMatch;
                }
                if (this.stingy) continue;
                return null;
            }
            if (doablesFinder == null) {
                stackedInfo.finder = doablesFinder = new DoablesFinder(this.token, charIndexed, rEMatch2);
            }
            if (n < this.min) {
                rEMatch = doablesFinder.find();
                if (rEMatch == null) {
                    if (backtrackStack.empty()) {
                        return null;
                    }
                    backtrackStack.pop();
                    continue;
                }
                if (doablesFinder.noMore()) {
                    backtrackStack.pop();
                }
                int n2 = rEMatch.empty ? this.min : n + 1;
                backtrackStack.push(new StackedInfo(charIndexed, n2, rEMatch, nArray, null));
                continue;
            }
            if (nArray == null) {
                nArray = RETokenRepeated.initVisited();
            }
            if (this.stingy) {
                REMatch rEMatch4;
                rEMatch = doablesFinder.find();
                if (rEMatch != null && !rEMatch.empty) {
                    backtrackStack.push(new StackedInfo(charIndexed, n + 1, rEMatch, nArray, null));
                } else {
                    backtrackStack.pop();
                }
                if ((rEMatch4 = this.matchRest(charIndexed, rEMatch2)) == null) continue;
                if (!backtrackStack.empty()) {
                    rEMatch4.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch2, backtrackStack));
                }
                return rEMatch4;
            }
            nArray = RETokenRepeated.addVisited(rEMatch2.index, nArray);
            boolean bl = false;
            while ((rEMatch3 = doablesFinder.find()) != null) {
                if (rEMatch3.empty) {
                    bl = true;
                }
                if (!bl) {
                    int n3 = rEMatch3.index;
                    if (RETokenRepeated.visitedContains(n3, nArray)) continue;
                    nArray = RETokenRepeated.addVisited(n3, nArray);
                    backtrackStack.push(new StackedInfo(charIndexed, n + 1, rEMatch3, nArray, null));
                    REMatch rEMatch5 = this.findMatch(backtrackStack);
                    if (this.possessive) {
                        return rEMatch5;
                    }
                    if (rEMatch5 == null) continue;
                    rEMatch5.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch2, backtrackStack));
                    return rEMatch5;
                }
                REMatch rEMatch6 = this.matchRest(charIndexed, rEMatch3);
                if (this.possessive) {
                    return rEMatch6;
                }
                if (rEMatch6 == null) continue;
                if (!backtrackStack.empty()) {
                    rEMatch6.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch2, backtrackStack));
                }
                return rEMatch6;
            }
            if (!backtrackStack.empty()) {
                backtrackStack.pop();
            }
            if (this.possessive) {
                backtrackStack.clear();
            }
            if ((rEMatch = this.matchRest(charIndexed, rEMatch2)) != null) break;
        }
        if (!backtrackStack.empty()) {
            rEMatch.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch2, backtrackStack));
        }
        return rEMatch;
    }

    final boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        REMatch rEMatch2 = this.findMatch(charIndexed, rEMatch);
        if (rEMatch2 != null) {
            rEMatch.assignFrom(rEMatch2);
            return true;
        }
        return false;
    }

    private static final int[] initVisited() {
        int[] nArray = new int[32];
        nArray[0] = 0;
        return nArray;
    }

    private static final boolean visitedContains(int n, int[] nArray) {
        int n2 = 1;
        while (n2 < nArray[0]) {
            if (n == nArray[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static final int[] addVisited(int n, int[] nArray) {
        if (RETokenRepeated.visitedContains(n, nArray)) {
            return nArray;
        }
        if (nArray[0] >= nArray.length - 1) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        nArray[0] = nArray[0] + 1;
        nArray[nArray[0]] = n;
        return nArray;
    }

    private final REMatch matchRest(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.next(charIndexed, rEMatch)) {
            return rEMatch;
        }
        return null;
    }

    private final REMatch findMatchFixedLength(CharIndexed charIndexed, REMatch rEMatch) {
        int n;
        int n2;
        if (rEMatch.backtrackStack == null) {
            rEMatch.backtrackStack = new BacktrackStack();
        }
        if ((n2 = this.token.findFixedLengthMatches(charIndexed, (REMatch)rEMatch.clone(), this.max)) == Integer.MAX_VALUE) {
            n2 = this.min;
        }
        if ((n = n2 - this.min + 1) <= 0) {
            return null;
        }
        int n3 = 0;
        n3 = !this.stingy ? rEMatch.index + this.tokenFixedLength * n2 : rEMatch.index + this.tokenFixedLength * this.min;
        return this.findMatchFixedLength(charIndexed, rEMatch, n3, n);
    }

    private final REMatch backtrackFixedLength(CharIndexed charIndexed, REMatch rEMatch, Object object) {
        int[] nArray = (int[])object;
        int n = nArray[0];
        int n2 = nArray[1];
        return this.findMatchFixedLength(charIndexed, rEMatch, n, n2);
    }

    private final REMatch findMatchFixedLength(CharIndexed charIndexed, REMatch rEMatch, int n, int n2) {
        REMatch rEMatch2 = (REMatch)rEMatch.clone();
        do {
            rEMatch2.index = n;
            REMatch rEMatch3 = this.matchRest(charIndexed, rEMatch2);
            --n2;
            n = this.stingy ? (n += this.tokenFixedLength) : (n -= this.tokenFixedLength);
            if (this.possessive) {
                return rEMatch3;
            }
            if (rEMatch3 == null) continue;
            if (n2 > 0) {
                rEMatch3.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch, new int[]{n, n2}));
            }
            return rEMatch3;
        } while (n2 > 0);
        return null;
    }

    final void dump(StringBuffer stringBuffer) {
        stringBuffer.append("(?:");
        this.token.dumpAll(stringBuffer);
        stringBuffer.append(')');
        if (this.max == Integer.MAX_VALUE && this.min <= 1) {
            int n = 0;
            if (this.min == 0) {
                n = 1;
            }
            stringBuffer.append(43 - n);
        } else if (this.min == 0 && this.max == 1) {
            stringBuffer.append('?');
        } else {
            stringBuffer.append('{').append(this.min);
            if (this.max > this.min) {
                stringBuffer.append(',');
                if (this.max != Integer.MAX_VALUE) {
                    stringBuffer.append(this.max);
                }
            }
            stringBuffer.append('}');
        }
        if (this.stingy) {
            stringBuffer.append('?');
        }
    }

    RETokenRepeated(int n, REToken rEToken, int n2, int n3) {
        super(n);
        this.token = rEToken;
        this.min = n2;
        this.max = n3;
        this.tokenFixedLength = rEToken.returnsFixedLengthMatches() ? rEToken.getMaximumLength() : -1;
    }

    private static class StackedInfo
    extends BacktrackStack.Backtrack {
        int numRepeats;
        int[] visited;
        DoablesFinder finder;

        StackedInfo(CharIndexed charIndexed, int n, REMatch rEMatch, int[] nArray, DoablesFinder doablesFinder) {
            super(null, charIndexed, rEMatch, null);
            this.numRepeats = n;
            this.visited = nArray;
            this.finder = doablesFinder;
        }
    }

    private static class DoablesFinder {
        private REToken tk;
        private CharIndexed input;
        private REMatch rematch;
        private boolean findFirst;

        private final REMatch find() {
            REMatch rEMatch;
            int n = this.rematch.index;
            if (this.findFirst) {
                rEMatch = this.tk.findMatch(this.input, this.rematch);
                this.findFirst = false;
            } else {
                BacktrackStack.Backtrack backtrack;
                do {
                    if (this.rematch.backtrackStack.empty()) {
                        rEMatch = null;
                        break;
                    }
                    backtrack = this.rematch.backtrackStack.pop();
                } while ((rEMatch = backtrack.token.backtrack(backtrack.input, backtrack.match, backtrack.param)) == null);
            }
            if (rEMatch == null) {
                return null;
            }
            if (rEMatch.index == n) {
                rEMatch.empty = true;
            }
            this.rematch = rEMatch;
            return (REMatch)rEMatch.clone();
        }

        boolean noMore() {
            return this.rematch.backtrackStack.empty();
        }

        private DoablesFinder(REToken rEToken, CharIndexed charIndexed, REMatch rEMatch) {
            this.tk = rEToken;
            this.input = charIndexed;
            this.rematch = (REMatch)rEMatch.clone();
            this.rematch.backtrackStack = new BacktrackStack();
            this.findFirst = true;
        }
    }
}

