/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.NullOutputStream;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.action.SetAccessibleAction;
import gnu.java.security.provider.Gnu;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.VMObjectStreamClass;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectStreamClass
implements Serializable {
    static final ObjectStreamField[] INVALID_FIELDS = new ObjectStreamField[0];
    static final Class[] noArgs = new Class[0];
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static Hashtable classLookupTable = new Hashtable();
    private static final NullOutputStream nullOutputStream = new NullOutputStream();
    private static final Comparator interfaceComparator = new InterfaceComparator();
    private static final Comparator memberComparator = new MemberComparator();
    private static final Class[] writeMethodArgTypes;
    private static final long serialVersionUID = -6120832682080437368L;
    private ObjectStreamClass superClass;
    private Class clazz;
    private String name;
    private long uid;
    private byte flags;
    ObjectStreamField[] fields;
    int primFieldSize;
    int objectFieldCount;
    Method readObjectMethod;
    Method readResolveMethod;
    Method writeReplaceMethod;
    Method writeObjectMethod;
    boolean realClassIsSerializable;
    boolean realClassIsExternalizable;
    ObjectStreamField[] fieldMapping;
    Constructor firstNonSerializableParentConstructor;
    private Constructor constructor;
    boolean isProxyClass;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$io$Externalizable;

    public static ObjectStreamClass lookup(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Class clazz2 = class$java$io$Serializable;
        if (clazz2 == null) {
            clazz2 = class$java$io$Serializable = ObjectStreamClass.class("[Ljava.io.Serializable;", false);
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            return null;
        }
        return ObjectStreamClass.lookupForClassObject(clazz);
    }

    static ObjectStreamClass lookupForClassObject(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)classLookupTable.get(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass;
        }
        objectStreamClass = new ObjectStreamClass(clazz);
        classLookupTable.put(clazz, objectStreamClass);
        return objectStreamClass;
    }

    public String getName() {
        return this.name;
    }

    public Class forClass() {
        return this.clazz;
    }

    public long getSerialVersionUID() {
        return this.uid;
    }

    public ObjectStreamField[] getFields() {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
        System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
        return objectStreamFieldArray;
    }

    public ObjectStreamField getField(String string) {
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n].getName().equals(string)) {
                return this.fields[n];
            }
            ++n;
        }
        return null;
    }

    public String toString() {
        return "java.io.ObjectStreamClass< " + this.name + ", " + this.uid + " >";
    }

    boolean hasWriteMethod() {
        boolean bl = false;
        if ((this.flags & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    boolean isSerializable() {
        boolean bl = false;
        if ((this.flags & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    boolean isExternalizable() {
        boolean bl = false;
        if ((this.flags & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    ObjectStreamClass getSuper() {
        return this.superClass;
    }

    static ObjectStreamClass[] getObjectStreamClasses(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass == null) {
            return new ObjectStreamClass[0];
        }
        Vector vector = new Vector();
        while (objectStreamClass != null) {
            vector.addElement(objectStreamClass);
            objectStreamClass = objectStreamClass.getSuper();
        }
        int n = vector.size();
        ObjectStreamClass[] objectStreamClassArray = new ObjectStreamClass[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            objectStreamClassArray[n - n2 - 1] = (ObjectStreamClass)vector.elementAt(n2);
            --n2;
        }
        return objectStreamClassArray;
    }

    int getFlags() {
        return this.flags;
    }

    void setClass(Class clazz, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        this.clazz = clazz;
        this.cacheMethods();
        long l = this.getClassUID(clazz);
        if (this.uid == 0L) {
            this.uid = l;
        } else if (this.uid != l) {
            String string = clazz + ": Local class not compatible: stream serialVersionUID=" + this.uid + ", local serialVersionUID=" + l;
            throw new InvalidClassException(string);
        }
        boolean bl = false;
        if (this.clazz != null && Proxy.isProxyClass(this.clazz)) {
            bl = true;
        }
        this.isProxyClass = bl;
        this.superClass = objectStreamClass;
        this.calculateOffsets();
        try {
            Object[] objectArray = this.getSerialPersistentFields(this.clazz);
            if (objectArray == null) {
                return;
            }
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[objectArray.length + this.fields.length];
            Arrays.sort(objectArray);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < this.fields.length && n2 < objectArray.length) {
                int n4 = this.fields[n].compareTo(objectArray[n2]);
                if (n4 < 0) {
                    objectStreamFieldArray[n3] = this.fields[n];
                    this.fields[n].setPersistent(false);
                    this.fields[n].setToSet(false);
                    ++n;
                } else if (n4 > 0) {
                    objectStreamFieldArray[n3] = objectArray[n2];
                    objectStreamFieldArray[n3].setPersistent(true);
                    objectStreamFieldArray[n3].setToSet(false);
                    try {
                        objectStreamFieldArray[n3].lookupField(this.clazz);
                        objectStreamFieldArray[n3].checkFieldType();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                    ++n2;
                } else {
                    try {
                        ((ObjectStreamField)objectArray[n2]).lookupField(this.clazz);
                        ((ObjectStreamField)objectArray[n2]).checkFieldType();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                    if (!this.fields[n].getType().equals(((ObjectStreamField)objectArray[n2]).getType())) {
                        throw new InvalidClassException("serialPersistentFields must be compatible with imported fields (about " + this.fields[n].getName() + ')');
                    }
                    objectStreamFieldArray[n3] = this.fields[n];
                    this.fields[n].setPersistent(true);
                    ++n;
                    ++n2;
                }
                ++n3;
            }
            if (n < this.fields.length) {
                while (n < this.fields.length) {
                    this.fields[n].setPersistent(false);
                    this.fields[n].setToSet(false);
                    objectStreamFieldArray[n3] = this.fields[n];
                    ++n;
                    ++n3;
                }
            } else if (n2 < objectArray.length) {
                while (n2 < objectArray.length) {
                    ((ObjectStreamField)objectArray[n2]).setPersistent(true);
                    ((ObjectStreamField)objectArray[n2]).setToSet(false);
                    objectStreamFieldArray[n3] = objectArray[n2];
                    ++n2;
                    ++n3;
                }
            }
            this.fields = new ObjectStreamField[n3];
            System.arraycopy(objectStreamFieldArray, 0, this.fields, 0, n3);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
    }

    void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superClass = objectStreamClass;
    }

    void calculateOffsets() {
        this.primFieldSize = 0;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectStreamField objectStreamField = this.fields[n2];
            if (!objectStreamField.isPrimitive()) break;
            objectStreamField.setOffset(this.primFieldSize);
            switch (objectStreamField.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primFieldSize;
                    break;
                }
                case 'C': 
                case 'S': {
                    this.primFieldSize += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    this.primFieldSize += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.primFieldSize += 8;
                    break;
                }
            }
            ++n2;
        }
        this.objectFieldCount = 0;
        while (n2 < n) {
            this.fields[n2].setOffset(this.objectFieldCount++);
            ++n2;
        }
    }

    private final Method findMethod(Method[] methodArray, String string, Class[] classArray, Class clazz, boolean bl) {
        int n = 0;
        while (n < methodArray.length) {
            block4: {
                Class[] classArray2;
                Method method = methodArray[n];
                int n2 = method.getModifiers();
                if (!Modifier.isStatic(n2) && (!bl || Modifier.isPrivate(n2)) && method.getName().equals(string) && method.getReturnType() == clazz && (classArray2 = method.getParameterTypes()).length == classArray.length) {
                    int n3 = 0;
                    while (n3 < classArray2.length) {
                        if (classArray2[n3] == classArray[n3]) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    AccessController.doPrivileged(new SetAccessibleAction(method));
                    return method;
                }
            }
            ++n;
        }
        return null;
    }

    private static final boolean inSamePackage(Class clazz, Class clazz2) {
        String string = clazz.getName();
        String string2 = clazz2.getName();
        int n = string.lastIndexOf(46);
        int n2 = string2.lastIndexOf(46);
        if (n == -1 || n2 == -1) {
            boolean bl = false;
            if (n == n2) {
                bl = true;
            }
            return bl;
        }
        String string3 = string.substring(0, n);
        String string4 = string2.substring(0, n2);
        return string3.equals(string4);
    }

    private static final Method findAccessibleMethod(String string, Class clazz) {
        Class clazz2 = clazz;
        while (clazz2 != null) {
            try {
                Method method = clazz2.getDeclaredMethod(string, noArgs);
                int n = method.getModifiers();
                if (clazz2 == clazz || Modifier.isProtected(n) || Modifier.isPublic(n) || !Modifier.isPrivate(n) && ObjectStreamClass.inSamePackage(clazz2, clazz)) {
                    AccessController.doPrivileged(new SetAccessibleAction(method));
                    return method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    private final void cacheMethods() {
        Method[] methodArray = this.forClass().getDeclaredMethods();
        Class[] classArray = new Class[1];
        Class clazz = class$java$io$ObjectInputStream;
        if (clazz == null) {
            clazz = class$java$io$ObjectInputStream = ObjectStreamClass.class("[Ljava.io.ObjectInputStream;", false);
        }
        classArray[0] = clazz;
        this.readObjectMethod = this.findMethod(methodArray, "readObject", classArray, Void.TYPE, true);
        Class[] classArray2 = new Class[1];
        Class clazz2 = class$java$io$ObjectOutputStream;
        if (clazz2 == null) {
            clazz2 = class$java$io$ObjectOutputStream = ObjectStreamClass.class("[Ljava.io.ObjectOutputStream;", false);
        }
        classArray2[0] = clazz2;
        this.writeObjectMethod = this.findMethod(methodArray, "writeObject", classArray2, Void.TYPE, true);
        this.readResolveMethod = ObjectStreamClass.findAccessibleMethod("readResolve", this.forClass());
        this.writeReplaceMethod = ObjectStreamClass.findAccessibleMethod("writeReplace", this.forClass());
    }

    private final void setFlags(Class clazz) {
        Class clazz2 = class$java$io$Externalizable;
        if (clazz2 == null) {
            clazz2 = class$java$io$Externalizable = ObjectStreamClass.class("[Ljava.io.Externalizable;", false);
        }
        if (clazz2.isAssignableFrom(clazz)) {
            this.flags = (byte)(this.flags | 4);
        } else {
            Class clazz3 = class$java$io$Serializable;
            if (clazz3 == null) {
                clazz3 = class$java$io$Serializable = ObjectStreamClass.class("[Ljava.io.Serializable;", false);
            }
            if (clazz3.isAssignableFrom(clazz)) {
                this.flags = (byte)(this.flags | 2);
            }
        }
        if (this.writeObjectMethod != null) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    private final void setFields(Class clazz) {
        SetAccessibleAction setAccessibleAction;
        block16: {
            setAccessibleAction = new SetAccessibleAction();
            if (!this.isSerializable() || this.isExternalizable()) {
                this.fields = NO_FIELDS;
                return;
            }
            try {
                Field field = clazz.getDeclaredField("serialPersistentFields");
                setAccessibleAction.setMember(field);
                AccessController.doPrivileged(setAccessibleAction);
                int n = field.getModifiers();
                if (!Modifier.isStatic(n) || !Modifier.isFinal(n) || !Modifier.isPrivate(n)) break block16;
                this.fields = this.getSerialPersistentFields(clazz);
                if (this.fields == null) break block16;
                Object[] objectArray = new ObjectStreamField[this.fields.length];
                System.arraycopy(this.fields, 0, objectArray, 0, this.fields.length);
                Arrays.sort(objectArray, new Comparator(){

                    public final int compare(Object object, Object object2) {
                        ObjectStreamField objectStreamField = (ObjectStreamField)object;
                        ObjectStreamField objectStreamField2 = (ObjectStreamField)object2;
                        return objectStreamField.getName().compareTo(objectStreamField2.getName());
                    }
                });
                int n2 = 1;
                while (n2 < this.fields.length) {
                    if (((ObjectStreamField)objectArray[n2 - 1]).getName().equals(((ObjectStreamField)objectArray[n2]).getName())) {
                        this.fields = INVALID_FIELDS;
                        return;
                    }
                    ++n2;
                }
                Arrays.sort(this.fields);
                n2 = 0;
                while (n2 < this.fields.length) {
                    try {
                        this.fields[n2].lookupField(clazz);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        this.fields[n2].setToSet(false);
                    }
                    ++n2;
                }
                this.calculateOffsets();
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        int n = 0;
        Field[] fieldArray = clazz.getDeclaredFields();
        int n3 = 0;
        while (n3 < fieldArray.length) {
            int n4 = fieldArray[n3].getModifiers();
            if (Modifier.isTransient(n4) || Modifier.isStatic(n4)) {
                fieldArray[n3] = null;
            } else {
                ++n;
            }
            ++n3;
        }
        this.fields = new ObjectStreamField[n];
        n3 = 0;
        int n5 = 0;
        while (n3 < fieldArray.length) {
            if (fieldArray[n3] != null) {
                Field field = fieldArray[n3];
                setAccessibleAction.setMember(field);
                AccessController.doPrivileged(setAccessibleAction);
                this.fields[n5] = new ObjectStreamField(fieldArray[n3]);
                ++n5;
            }
            ++n3;
        }
        Arrays.sort(this.fields);
        n3 = 1;
        while (n3 < this.fields.length) {
            if (this.fields[n3 - 1].getName().equals(this.fields[n3].getName())) {
                throw new InternalError("Duplicate field " + this.fields[n3].getName() + " in class " + clazz.getName());
            }
            ++n3;
        }
        this.calculateOffsets();
    }

    private final long getClassUID(Class clazz) {
        Object object;
        Object object2;
        try {
            object2 = clazz.getDeclaredField("serialVersionUID");
            object = new SetAccessibleAction((AccessibleObject)object2);
            AccessController.doPrivileged((PrivilegedAction)object);
            int n = ((Field)object2).getModifiers();
            if (Modifier.isStatic(n) && Modifier.isFinal(n) && ((Field)object2).getType() == Long.TYPE) {
                return ((Field)object2).getLong(null);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        try {
            Object object3;
            try {
                object2 = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Gnu gnu = new Gnu();
                Security.addProvider(gnu);
                object2 = MessageDigest.getInstance("SHA");
            }
            object = new DigestOutputStream(nullOutputStream, (MessageDigest)object2);
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            dataOutputStream.writeUTF(clazz.getName());
            int n = clazz.getModifiers();
            dataOutputStream.writeInt(n &= 0x611);
            if (!clazz.isArray()) {
                object3 = clazz.getInterfaces();
                Arrays.sort((Object[])object3, interfaceComparator);
                int n2 = 0;
                while (n2 < ((Object[])object3).length) {
                    dataOutputStream.writeUTF(((Class)object3[n2]).getName());
                    ++n2;
                }
            }
            Object[] objectArray = clazz.getDeclaredFields();
            Arrays.sort(objectArray, memberComparator);
            int n3 = 0;
            while (n3 < objectArray.length) {
                object3 = objectArray[n3];
                n = ((Field)object3).getModifiers();
                if (!Modifier.isPrivate(n) || !Modifier.isStatic(n) && !Modifier.isTransient(n)) {
                    dataOutputStream.writeUTF(((Field)object3).getName());
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(TypeSignature.getEncodingOfClass(((Field)object3).getType()));
                }
                ++n3;
            }
            if (VMObjectStreamClass.hasClassInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            Object[] objectArray2 = clazz.getDeclaredConstructors();
            Arrays.sort(objectArray2, memberComparator);
            int n4 = 0;
            while (n4 < objectArray2.length) {
                Object object4 = objectArray2[n4];
                n = ((Constructor)object4).getModifiers();
                if (!Modifier.isPrivate(n)) {
                    dataOutputStream.writeUTF("<init>");
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(TypeSignature.getEncodingOfConstructor((Constructor)object4).replace('/', '.'));
                }
                ++n4;
            }
            Object[] objectArray3 = clazz.getDeclaredMethods();
            Arrays.sort(objectArray3, memberComparator);
            int n5 = 0;
            while (n5 < objectArray3.length) {
                Object object5 = objectArray3[n5];
                n = ((Method)object5).getModifiers();
                if (!Modifier.isPrivate(n)) {
                    dataOutputStream.writeUTF(((Method)object5).getName());
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(TypeSignature.getEncodingOfMethod((Method)object5).replace('/', '.'));
                }
                ++n5;
            }
            dataOutputStream.close();
            byte[] byArray = ((MessageDigest)object2).digest();
            long l = 0L;
            int n6 = byArray.length < 8 ? byArray.length : 8;
            int n7 = 0;
            while (n7 < n6) {
                l += (long)(byArray[n7] & 0xFF) << 8 * n7;
                ++n7;
            }
            return l;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("The SHA algorithm was not found to use in computing the Serial Version UID for class " + clazz.getName(), noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private final ObjectStreamField[] getSerialPersistentFields(Class clazz) throws NoSuchFieldException, IllegalAccessException {
        ObjectStreamField[] objectStreamFieldArray = null;
        Field field = clazz.getDeclaredField("serialPersistentFields");
        field.setAccessible(true);
        int n = field.getModifiers();
        if (!(Modifier.isStatic(n) && Modifier.isFinal(n) && Modifier.isPrivate(n))) {
            return null;
        }
        ObjectStreamField[] objectStreamFieldArray2 = (ObjectStreamField[])field.get(null);
        if (objectStreamFieldArray2 == null) {
            return null;
        }
        objectStreamFieldArray = new ObjectStreamField[objectStreamFieldArray2.length];
        System.arraycopy(objectStreamFieldArray2, 0, objectStreamFieldArray, 0, objectStreamFieldArray2.length);
        return objectStreamFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Externalizable newInstance() throws InvalidClassException {
        block7: {
            ObjectStreamClass objectStreamClass = this;
            synchronized (objectStreamClass) {
                if (this.constructor != null) break block7;
                try {
                    final Constructor constructor = this.clazz.getConstructor(new Class[0]);
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public final Object run() {
                            constructor.setAccessible(true);
                            return null;
                        }
                    });
                    this.constructor = constructor;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InvalidClassException(this.clazz.getName(), "No public zero-argument constructor");
                }
            }
        }
        try {
            return (Externalizable)this.constructor.newInstance(null);
        }
        catch (Exception exception) {
            throw (InvalidClassException)new InvalidClassException(this.clazz.getName(), "Unable to instantiate").initCause(exception);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.primFieldSize = -1;
        this.isProxyClass = false;
    }

    ObjectStreamClass(String string, long l, byte by, ObjectStreamField[] objectStreamFieldArray) {
        this.this();
        this.name = string;
        this.uid = l;
        this.flags = by;
        this.fields = objectStreamFieldArray;
    }

    private ObjectStreamClass(Class clazz) {
        this.this();
        this.uid = 0L;
        this.flags = 0;
        this.isProxyClass = Proxy.isProxyClass(clazz);
        this.clazz = clazz;
        this.cacheMethods();
        this.name = clazz.getName();
        this.setFlags(clazz);
        this.setFields(clazz);
        Class clazz2 = class$java$io$Serializable;
        if (clazz2 == null) {
            clazz2 = class$java$io$Serializable = ObjectStreamClass.class("[Ljava.io.Serializable;", false);
        }
        if (clazz2.isAssignableFrom(clazz) && !this.isProxyClass) {
            this.uid = this.getClassUID(clazz);
        }
        this.superClass = ObjectStreamClass.lookup(clazz.getSuperclass());
    }

    static {
        Class[] classArray = new Class[1];
        Class clazz = class$java$io$ObjectOutputStream;
        if (clazz == null) {
            clazz = class$java$io$ObjectOutputStream = ObjectStreamClass.class("[Ljava.io.ObjectOutputStream;", false);
        }
        classArray[0] = clazz;
        writeMethodArgTypes = classArray;
    }

    private static final class InterfaceComparator
    implements Comparator {
        public final int compare(Object object, Object object2) {
            return ((Class)object).getName().compareTo(((Class)object2).getName());
        }

        private InterfaceComparator() {
        }
    }

    private static final class MemberComparator
    implements Comparator {
        public final int compare(Object object, Object object2) {
            Member member = (Member)object;
            Member member2 = (Member)object2;
            int n = member.getName().compareTo(member2.getName());
            if (n == 0) {
                return TypeSignature.getEncodingOfMember(member).compareTo(TypeSignature.getEncodingOfMember(member2));
            }
            return n;
        }

        private MemberComparator() {
        }
    }
}

