/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.FileIt;
import blbutil.MultiThreadUtils;
import blbutil.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class BlockLineReader
implements FileIt<String[]> {
    public static String[] SENTINAL = new String[0];
    private final FileIt<String> it;
    private final LinkedBlockingDeque<String[]> q;
    private final int blockSize;
    private final ExecutorService fileReaderService;
    private final CountDownLatch latch;
    private volatile boolean shutDownNow;

    public static BlockLineReader create(FileIt<String> fileIt, int n, int n2) {
        BlockLineReader blockLineReader = new BlockLineReader(fileIt, n, n2);
        blockLineReader.startFileReadingThread();
        return blockLineReader;
    }

    private BlockLineReader(FileIt<String> fileIt, int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        this.it = fileIt;
        this.q = new LinkedBlockingDeque(n2);
        this.blockSize = n;
        this.fileReaderService = Executors.newSingleThreadExecutor();
        this.latch = new CountDownLatch(1);
        this.shutDownNow = false;
    }

    private void startFileReadingThread() {
        this.fileReaderService.submit(() -> {
            try {
                ArrayList<String> arrayList = new ArrayList<String>(this.blockSize);
                while (this.it.hasNext()) {
                    arrayList.add((String)this.it.next());
                    if (arrayList.size() != this.blockSize) continue;
                    this.flushBuffer(arrayList);
                    if (!this.shutDownNow) continue;
                }
                if (arrayList.size() > 0) {
                    this.flushBuffer(arrayList);
                }
                this.latch.countDown();
                MultiThreadUtils.putInBlockingQ(this.q, SENTINAL);
            }
            catch (Throwable throwable) {
                Utilities.exit(throwable);
            }
        });
    }

    private void flushBuffer(List<String> list) {
        String[] stringArray = list.toArray(new String[0]);
        list.clear();
        boolean bl = false;
        while (!bl && !this.shutDownNow) {
            bl = MultiThreadUtils.putInBlockingQ(this.q, stringArray, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public File file() {
        return this.it.file();
    }

    @Override
    public void close() {
        this.shutDownNow = true;
        MultiThreadUtils.await(this.latch);
        this.it.close();
        String[] stringArray = this.q.pollLast();
        while (stringArray != null && stringArray != SENTINAL) {
            stringArray = this.q.pollLast();
        }
        if (stringArray == SENTINAL) {
            boolean bl = this.q.offer(SENTINAL);
            assert (bl);
        }
        MultiThreadUtils.shutdownExecService(this.fileReaderService);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public String[] next() {
        assert (this.hasNext());
        String[] stringArray = MultiThreadUtils.takeFromBlockingQ(this.q);
        if (stringArray == SENTINAL) {
            boolean bl = this.q.offer(SENTINAL);
            assert (bl);
        }
        return stringArray;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }
}

