/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbItem;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gpdb.GpdbItemResultData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbItemChangeTurnFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbItemChangeTurnFormData.class.getName());
    private ALStringField positions;
    private String[] gpdbItemIds = null;
    private List<GpdbItemResultData> gpdbItemList = null;
    private List<EipTGpdbItem> rawGpdbItemList = null;
    private String gpdbId = null;
    private EipTGpdb gpdb = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.gpdbItemList = new ArrayList<GpdbItemResultData>();
        this.rawGpdbItemList = new ArrayList<EipTGpdbItem>();
        this.gpdbId = rundata.getParameters().getString("gpdb_id");
        this.gpdb = GpdbUtils.getEipTGpdb(this.gpdbId);
    }

    public void initField() {
        this.positions = new ALStringField();
        this.positions.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_DEFINED_ITEM_LIST"));
        this.positions.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = true;
        try {
            res = super.setFormData(rundata, context, msgList);
            if (res) {
                if (this.positions.getValue() == null || this.positions.getValue().equals("")) {
                    SelectQuery query = Database.query(EipTGpdbItem.class);
                    query.andQualifier(ExpressionFactory.matchExp((String)"gpdb", (Object)this.gpdb));
                    query.orderAscending("orderNo");
                    this.gpdbItemList = GpdbUtils.getGpdbItemResultList(query.fetchList());
                } else {
                    StringTokenizer st = new StringTokenizer(this.positions.getValue(), ",");
                    this.gpdbItemIds = new String[st.countTokens()];
                    int count = 0;
                    while (st.hasMoreTokens()) {
                        this.gpdbItemIds[count] = st.nextToken();
                        ++count;
                    }
                    SelectQuery query = Database.query(EipTGpdbItem.class);
                    List list = query.fetchList();
                    for (int i = 0; i < this.gpdbItemIds.length; ++i) {
                        EipTGpdbItem gpdbItem = this.getEipTGpdbItemFromGpdbItemId(list, this.gpdbItemIds[i]);
                        this.gpdbItemList.add(GpdbUtils.getGpdbItemResultData(gpdbItem));
                        this.rawGpdbItemList.add(gpdbItem);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = true;
        try {
            int newPosition = 1;
            for (EipTGpdbItem gpdbItem : this.rawGpdbItemList) {
                gpdbItem.setOrderNo(Integer.valueOf(newPosition));
                ++newPosition;
            }
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean isSymbol(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return chars != null && chars.length != 2 && !Character.isDigit(ch) && !Character.isLetter(ch);
    }

    private EipTGpdbItem getEipTGpdbItemFromGpdbItemId(List<EipTGpdbItem> gpdbItemList, String gpdbItemId) {
        for (int i = 0; i < gpdbItemList.size(); ++i) {
            EipTGpdbItem gpdbItem = gpdbItemList.get(i);
            if (!gpdbItem.getGpdbItemId().toString().equals(gpdbItemId)) continue;
            return gpdbItem;
        }
        return null;
    }

    public List<GpdbItemResultData> getGpdbItemList() {
        return this.gpdbItemList;
    }

    public String getGpdbId() {
        return this.gpdbId;
    }
}

