/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.eip.cayenne.om.portlet.EipMGpdbKubunValue;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gpdb.GpdbKubunResultData;
import com.aimluck.eip.gpdb.GpdbKubunValueResultData;
import com.aimluck.eip.gpdb.GpdbResultData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbKubunSelectData
extends ALAbstractSelectData<EipMGpdbKubunValue, EipMGpdbKubunValue>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbKubunSelectData.class.getName());
    private int gpdbKubunSum;
    private List<GpdbKubunResultData> allGpdbKubun;
    private List<GpdbKubunValueResultData> allGpdbKubunValue;
    private List<GpdbResultData> gpdbAllList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"sort");
        }
        this.allGpdbKubun = GpdbUtils.getGpdbKubunAllList();
        this.allGpdbKubunValue = GpdbUtils.getGpdbKubunValueAllList();
        this.gpdbAllList = GpdbUtils.getGpdbAllList();
        super.init(action, rundata, context);
    }

    protected ResultList<EipMGpdbKubunValue> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipMGpdbKubunValue> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            query.orderAscending("gpdbKubun");
            query.orderAscending("orderNo");
            query.orderAscending("gpdbKubunValue");
            ResultList list = query.getResultList();
            this.gpdbKubunSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipMGpdbKubunValue> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipMGpdbKubunValue.class);
        return this.buildSelectQueryForFilter((SelectQuery<EipMGpdbKubunValue>)query, rundata, context);
    }

    protected SelectQuery<EipMGpdbKubunValue> buildSelectQueryForFilter(SelectQuery<EipMGpdbKubunValue> query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        if ("gpdb_kubun_id".equals(filter_type) && (filter == null || "".equals(filter) || GpdbUtils.getEipMGpdbKubun(Integer.valueOf(filter)) == null)) {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        }
        return super.buildSelectQueryForFilter(query, rundata, context);
    }

    protected EipMGpdbKubunValue selectDetail(RunData rundata, Context context) {
        return GpdbUtils.getEipMGpdbKubunValue(rundata, context);
    }

    protected Object getResultData(EipMGpdbKubunValue record) {
        return GpdbUtils.getGpdbKubunValueResultData(record);
    }

    protected Object getResultDataDetail(EipMGpdbKubunValue record) {
        return GpdbUtils.getGpdbKubunValueResultData(record);
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("gpdb_kubun_id", "GPDB_KUBUN_ID");
        map.putValue("gpdb_kubun_name", "gpdbKubunName");
        return map;
    }

    public int getGpdbKubunValueSum() {
        return this.gpdbKubunSum;
    }

    public String getViewtype() {
        return "gpdb_kubun";
    }

    public List<GpdbKubunResultData> getAllGpdbKubun() {
        return this.allGpdbKubun;
    }

    public int getAllGpdbKubunValueSum() {
        return this.allGpdbKubunValue.size();
    }

    public List<GpdbResultData> getGpdbAllList() {
        return this.gpdbAllList;
    }
}

